/*
Navicat MySQL Data Transfer
Version 3.5.1.0510


*/

CREATE DATABASE if not exists `bda` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
use bda;

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for bda_color_palettes
-- ----------------------------
DROP TABLE IF EXISTS `bda_color_palettes`;
CREATE TABLE `bda_color_palettes` (
  `palette_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `preseted` int(11) NOT NULL DEFAULT '0',
  `palette_name` varchar(32) NOT NULL,
  `color_sequence` varchar(255) NOT NULL,
  `create_user_id` varchar(36) NOT NULL,
  `create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`palette_id`),
  UNIQUE KEY `uk_palette` (`organization_id`,`palette_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bda_color_palettes
-- ----------------------------
INSERT INTO `bda_color_palettes` VALUES ('238ecbdb-86aa-11e9-be0d-f8bc125d47d9', '1', '1', '经典', '[-8604180,-12369080,-7279235,-548004,-8354327,-959360,-1780908,-8354328,-7518637,-7214879]', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '2019-06-04 20:14:49', null, null);

-- ----------------------------
-- Table structure for bda_functions
-- ----------------------------
DROP TABLE IF EXISTS `bda_functions`;
CREATE TABLE `bda_functions` (
  `function_name` varchar(64) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `function_type_id` int(11) NOT NULL,
  `return_data_type` int(11) NOT NULL,
  `sample_url` varchar(64) NOT NULL,
  `sql_supported` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`function_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bda_functions
-- ----------------------------
INSERT INTO `bda_functions` VALUES ('Abs', '返回一个数的绝对值', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Avg', '平均值', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('CaseWhen', '根据表达式的结果真假返回相应的值', '4', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Ceiling', '返回一个数的向上取整', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Concat', '拼接两个字符串', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Cos', '返回一个数的余弦值', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Count', '个数', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('CurDate', '返回当前日期', '2', '1', '1', '0');
INSERT INTO `bda_functions` VALUES ('CurTime', '返回当前时间', '2', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('DateDiff', '返回两日期之间的天数', '2', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Date_Add', '返回输入日期加上一定天数后的日期', '2', '1', '1', '0');
INSERT INTO `bda_functions` VALUES ('DayName', '返回日期的星期几名称', '2', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('DayOfMonth', '返回日期的月份中天的号数', '2', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('DayOfWeek', '返回日期的周中天的号数', '2', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('DayOfYear', '返回日期的年中的天的号数', '2', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Exp', '返回e的n次幂', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Floor', '返回一个数的向下取整', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('FormatDate', '按照提供的格式设置日期格式', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('FormatNumber', '按照指定的格式设置数字格式', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('IsBoolean', '确定对象是否具有布尔值数据类型', '4', '3', '1', '0');
INSERT INTO `bda_functions` VALUES ('IsDate', '确定变量是否为日期时间类型', '4', '3', '1', '0');
INSERT INTO `bda_functions` VALUES ('IsNull', '确定变量是否为null', '4', '3', '1', '0');
INSERT INTO `bda_functions` VALUES ('IsNumeric', '确定变量是否为数值', '4', '3', '1', '0');
INSERT INTO `bda_functions` VALUES ('IsString', '确定变量是否为字符串', '4', '3', '1', '0');
INSERT INTO `bda_functions` VALUES ('Last_Day', '返回日期所在月份的最后一天', '2', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Left', '返回字符串左边n个字符组成的字符串', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Length', '返回字符串的长度', '1', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Ln', '返回一个正数的自然对数', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Log', '返回指定底数的一个正数的对数', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Log10', '返回以10为底的一个正数的对数', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Lookup', '查找指定值', '4', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Lower', '将字符串转换为小写', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('LTrim', '删除字符串左侧的前导空格', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Max', '最大值', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Median', '中位数', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Min', '最小值', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Month', '返回日期所在年的月份的号数', '2', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('MonthName', '返回日期的月份的名称', '2', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Percentage', '百分比', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Power', '返回一个数的n次方', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Quarter', '返回某日期所在季度数', '2', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Rank', '排列度量的名次', '5', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Replace', '将字符串的某一部分替换为其他字符串', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Right', '返回字符串右边n个字符组成的字符串', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Round', '将一个数四舍五入到指定的小数位数', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('RowIndex', '返回行号', '5', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('RTrim', '删除字符串右侧的后缀空格', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('RunningSum', '运行总和', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Sign', '返回一个数的符号', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Sin', '返回一个数的正弦值', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Sqrt', '返回一个数的平方根', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('StdDev_Pop', '总体标准差', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('StdDev_Samp', '样本标准差', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Substring', '从字符串中提取子字符串', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Sum', '总和', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Tan', '返回一个数的正切值', '3', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Trim', '删除字符串两边的空格', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Upper', '将字符串转换为大写', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('URLCode', '对字符串应用URL编码规则', '1', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('UserResponse', '返回在响应提示的过程中输入的数据', '5', '0', '1', '0');
INSERT INTO `bda_functions` VALUES ('Var_Pop', '总体方差', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Var_Samp', '样本方差', '0', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Week', '返回某日期的周数', '2', '2', '1', '0');
INSERT INTO `bda_functions` VALUES ('Year', '返回某日期的年数', '2', '2', '1', '0');

-- ----------------------------
-- Table structure for bda_function_types
-- ----------------------------
DROP TABLE IF EXISTS `bda_function_types`;
CREATE TABLE `bda_function_types` (
  `function_type_id` int(11) NOT NULL,
  `function_type_name` varchar(64) NOT NULL,
  PRIMARY KEY (`function_type_id`),
  UNIQUE KEY `uk_functionTypeName` (`function_type_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bda_function_types
-- ----------------------------
INSERT INTO `bda_function_types` VALUES ('5', '其它');
INSERT INTO `bda_function_types` VALUES ('1', '字符');
INSERT INTO `bda_function_types` VALUES ('3', '数字');
INSERT INTO `bda_function_types` VALUES ('2', '日期和时间');
INSERT INTO `bda_function_types` VALUES ('0', '聚合');
INSERT INTO `bda_function_types` VALUES ('4', '逻辑');


-- ----------------------------
-- Table structure for bda_jobs
-- ----------------------------
DROP TABLE IF EXISTS `bda_jobs`;
CREATE TABLE `bda_jobs` (
  `job_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `job_name` varchar(32) NOT NULL,
  `frequency` int(11) NOT NULL COMMENT '频率：0：每天；1：每周；2：每月',
  `frequency_type` int(11) NOT NULL COMMENT '频率类别：0：执行一次；1：间隔执行',
  `one_time_start_date` time DEFAULT NULL,
  `interval` int(11) DEFAULT NULL COMMENT '执行间隔（分钟）',
  `interval_start_time` time DEFAULT NULL,
  `interval_end_time` time DEFAULT NULL,
  `email_address` varchar(128) DEFAULT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '0',
  `job_status` int(11) NOT NULL DEFAULT '0' COMMENT '作业状态：0：空闲；1：正在执行中',
  `create_user_id` varchar(36) NOT NULL,
  `create_date` datetime NOT NULL,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  UNIQUE KEY `uk_job_name` (`organization_id`,`job_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for bda_operators
-- ----------------------------
DROP TABLE IF EXISTS `bda_operators`;
CREATE TABLE `bda_operators` (
  `operator_symbol` varchar(16) NOT NULL,
  `description` varchar(32) NOT NULL,
  `operator_order` int(11) NOT NULL,
  PRIMARY KEY (`operator_symbol`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bda_operators
-- ----------------------------
INSERT INTO `bda_operators` VALUES ('!', '非', '15');
INSERT INTO `bda_operators` VALUES ('!=', '不等于', '8');
INSERT INTO `bda_operators` VALUES ('%', '求余', '4');
INSERT INTO `bda_operators` VALUES ('&&', '与', '13');
INSERT INTO `bda_operators` VALUES ('(', '左括号', '5');
INSERT INTO `bda_operators` VALUES (')', '右括号', '6');
INSERT INTO `bda_operators` VALUES ('*', '乘', '2');
INSERT INTO `bda_operators` VALUES ('+', '加', '0');
INSERT INTO `bda_operators` VALUES ('-', '减', '1');
INSERT INTO `bda_operators` VALUES ('/', '除', '3');
INSERT INTO `bda_operators` VALUES ('<', '小于', '11');
INSERT INTO `bda_operators` VALUES ('<=', '小于等于', '12');
INSERT INTO `bda_operators` VALUES ('==', '等于', '7');
INSERT INTO `bda_operators` VALUES ('>', '大于', '9');
INSERT INTO `bda_operators` VALUES ('>=', '大于等于', '10');
INSERT INTO `bda_operators` VALUES ('||', '或', '14');

-- ----------------------------
-- Table structure for bda_themes
-- ----------------------------
DROP TABLE IF EXISTS `bda_themes`;
CREATE TABLE `bda_themes` (
  `theme_id` int(11) NOT NULL,
  `theme_code` varchar(64) NOT NULL,
  `theme_name` varchar(32) NOT NULL,
  `navigation_color` varchar(16) NOT NULL,
  `pad_menu_color` varchar(16) NOT NULL,
  `phone_menu_color` varchar(16) NOT NULL,
  `pad_sub_menu_color` varchar(16) NOT NULL,
  `phone_sub_menu_color` varchar(16) NOT NULL,
  `report_header_color` varchar(16) NOT NULL,
  `report_toolbar_color` varchar(16) NOT NULL,
  `user_background_image` varchar(64) NOT NULL,
  PRIMARY KEY (`theme_id`),
  UNIQUE KEY `uk_themeName` (`theme_name`),
  UNIQUE KEY `uk_themeShowName` (`theme_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bda_themes
-- ----------------------------
INSERT INTO `bda_themes` VALUES ('0', 'elegantWhite', '经典', '#266CA8', '#3278B4', '#266CA8', '#387EBA', '#387EBA', '#fafafa', '#f9f9f9', 'headBackground_white');
INSERT INTO `bda_themes` VALUES ('1', 'darkBlue', '深邃蓝', '#0A2D64', '#003271', '#0A2D5A', '#1C3F76', '#1C3F6C', '#0d3c78', '#0A2D5A', 'headBackground_blue');
INSERT INTO `bda_themes` VALUES ('2', 'pearlBlack', '珍珠黑', '#151515', '#212121', '#151515', '#272727', '#272727', '#2d2d2d', '#151515', 'headBackground_dark');

-- ----------------------------
-- Table structure for biz_db_settings
-- ----------------------------
DROP TABLE IF EXISTS `biz_db_settings`;
CREATE TABLE `biz_db_settings` (
  `database_setting_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `biz_system_name` varchar(64) NOT NULL,
  `database_ip` varchar(64) NOT NULL,
  `database_port` varchar(8) NOT NULL,
  `database_type_name` varchar(32) NOT NULL,
  `database_name` varchar(64) NOT NULL,
  `user_name` varchar(32) NOT NULL,
  `password` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`database_setting_id`),
  UNIQUE KEY `uk_biz_system_name` (`organization_id`,`biz_system_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bm_publishes`;
CREATE TABLE `bm_publishes`  (
  `business_model_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '业务模型ID',
  `organization_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '组织ID',
  `publish_type` int(11) NOT NULL COMMENT '发布类型；0所有组织可订阅，1指定可订阅组织',
  `publish_status` int(11) NOT NULL COMMENT '-1：订阅；0：未发布；1：已发布；2：发布且停止',
  `create_user_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `create_date` datetime(0) NOT NULL,
  `last_modify_user_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `last_modify_date` datetime(0) NULL DEFAULT NULL,
  PRIMARY KEY (`business_model_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


DROP TABLE IF EXISTS `bmp_destination_organizations`;
CREATE TABLE `bmp_destination_organizations`  (
  `business_model_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '业务模型ID',
  `destination_organization_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模型发布目标组织ID',
  PRIMARY KEY (`business_model_id`, `destination_organization_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for bor_apply_groups
-- ----------------------------
DROP TABLE IF EXISTS `bor_apply_groups`;
CREATE TABLE `bor_apply_groups` (
  `business_object_restriction_id` varchar(36) NOT NULL,
  `apply_group_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`business_object_restriction_id`,`apply_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bor_apply_groups
-- ----------------------------

-- ----------------------------
-- Table structure for bor_apply_users
-- ----------------------------
DROP TABLE IF EXISTS `bor_apply_users`;
CREATE TABLE `bor_apply_users` (
  `business_object_restriction_id` varchar(36) NOT NULL,
  `apply_user_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`business_object_restriction_id`,`apply_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bor_apply_users
-- ----------------------------

-- ----------------------------
-- Table structure for bor_business_objects
-- ----------------------------
DROP TABLE IF EXISTS `bor_business_objects`;
CREATE TABLE `bor_business_objects` (
  `business_object_restriction_id` varchar(36) NOT NULL,
  `business_object_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`business_object_restriction_id`,`business_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bor_business_objects
-- ----------------------------

DROP TABLE IF EXISTS `business_model_folders`;
CREATE TABLE `business_model_folders`  (
  `folder_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '文件夹ID',
  `organization_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '组织ID',
  `folder_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '文件夹名称',
  `folder_parent_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '父文件夹ID',
  `business_model_type` int(11) NOT NULL COMMENT '业务模型类型',
  `create_user_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '创建者ID',
  `create_date` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `last_modify_user_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '最后修改者ID',
  `last_modify_date` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后修改时间',
  PRIMARY KEY (`folder_id`) USING BTREE,
  UNIQUE INDEX `unique_key`(`organization_id`, `folder_name`, `folder_parent_id`, `business_model_type`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for business_models
-- ----------------------------
DROP TABLE IF EXISTS `business_models`;
CREATE TABLE `business_models` (
  `business_model_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `business_model_name` varchar(32) NOT NULL,
  `folder_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '-1',
  `description` varchar(128) DEFAULT NULL,
  `data_source_id` varchar(36) NOT NULL,
  `business_model_type` int(11) NOT NULL,
  `source_type` int(11) NOT NULL DEFAULT 0 COMMENT '来源类型；0本组织创建，1从其它组织订阅',
  `source_business_model_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源业务模型ID，本组织创建为本组织业务模型ID',
  `source_organization_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源组织，本组织创建为本组织ID',
  `publish_status` int(11) NOT NULL DEFAULT 0 COMMENT '-1：订阅；0：未发布；1：已发布；2：发布且停止',
  `create_user_id` varchar(36) NOT NULL,
  `create_date` datetime NOT NULL,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`business_model_id`,`organization_id`),
  UNIQUE INDEX `uk_business_model_name`(`organization_id`, `business_model_name`, `business_model_type`, `folder_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for business_object_restrictions
-- ----------------------------
DROP TABLE IF EXISTS `business_object_restrictions`;
CREATE TABLE `business_object_restrictions` (
  `business_object_restriction_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `business_model_id` varchar(36) NOT NULL,
  `business_model_type` int(11) NOT NULL,
  PRIMARY KEY (`business_object_restriction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_object_restrictions
-- ----------------------------

-- ----------------------------
-- Table structure for relation_models
-- ----------------------------
DROP TABLE IF EXISTS `relation_models`;
CREATE TABLE `relation_models` (
  `business_model_id` varchar(36) NOT NULL,
  `relation_diagram_folders_json` longtext,
  `relation_diagrams_json` longtext,
  `business_object_folders_json` longtext,
  `business_objects_json` longtext,
  `query_table_restrictions_json` longtext,
  PRIMARY KEY (`business_model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- ----------------------------
-- Records of relation_models
-- ----------------------------

-- ----------------------------
-- Table structure for chart_folders
-- ----------------------------
DROP TABLE IF EXISTS `chart_folders`;
CREATE TABLE `chart_folders` (
  `folder_id` int(11) NOT NULL,
  `folder_name` varchar(32) NOT NULL,
  `folder_image` varchar(128) DEFAULT NULL,
  `folder_parent_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`folder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of chart_folders
-- ----------------------------
INSERT INTO `chart_folders` VALUES ('0', '表格', 'folder', '-1');
INSERT INTO `chart_folders` VALUES ('1', '统计图', 'folder', '-1');
INSERT INTO `chart_folders` VALUES ('2', '柱状图', 'histogram', '1');
INSERT INTO `chart_folders` VALUES ('3', '条形图', 'barChart', '1');
INSERT INTO `chart_folders` VALUES ('4', '折线图', 'lineGraph', '1');
INSERT INTO `chart_folders` VALUES ('5', '柱线图', 'histogramline', '1');
INSERT INTO `chart_folders` VALUES ('6', '饼图', 'pieChart', '1');
INSERT INTO `chart_folders` VALUES ('7', '散点图', 'scatterPlot', '1');
INSERT INTO `chart_folders` VALUES ('8', '更多', 'radarMap', '1');
INSERT INTO `chart_folders` VALUES ('9', '仪表图', 'folder', '-1');
INSERT INTO `chart_folders` VALUES ('10', '地图', 'folder', '-1');
INSERT INTO `chart_folders` VALUES ('11', '工业生产', 'folder', '-1');
INSERT INTO `chart_folders` VALUES ('12', '容器', 'folder', '-1');
INSERT INTO `chart_folders` VALUES ('13', '其他', 'folder', '-1');

-- ----------------------------
-- Table structure for charts
-- ----------------------------
DROP TABLE IF EXISTS `charts`;
CREATE TABLE `charts` (
  `chart_id` int(11) NOT NULL,
  `chart_code` varchar(32) NOT NULL,
  `chart_image` varchar(128) NOT NULL,
  `chart_name` varchar(32) NOT NULL,
  `chart_url` varchar(128) DEFAULT NULL,
  `enabled` int(11) NOT NULL DEFAULT '1',
  `chart_order` int(11) NOT NULL,
  `chart_folder_id` int(11) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`chart_id`)
) ENGINE=MyISAM AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COMMENT='图表样例记录表';

-- ----------------------------
-- Records of charts
-- ----------------------------
INSERT INTO `charts` VALUES ('16', 'scatterPlot', 'resource/chart/scatterPlot.png', '散点图', 'chart_sample_front_end/html/scatterPlot.html', '1', '1', '7');
INSERT INTO `charts` VALUES ('15', 'gauge', 'resource/chart/instrument.png', '仪表盘', 'chart_sample_front_end/html/instrument.html', '1', '1', '9');
INSERT INTO `charts` VALUES ('0', 'tile', 'resource/chart/tile.png', '磁贴', 'chart_sample_front_end/html/tile.html', '1', '2', '9');
INSERT INTO `charts` VALUES ('14', 'doughnut', 'resource/chart/doughnut.png', '圆环图', 'chart_sample_front_end/html/doughnut.html', '1', '2', '6');
INSERT INTO `charts` VALUES ('13', 'pieChart', 'resource/chart/pieChart.png', '饼图', 'chart_sample_front_end/html/pieChart.html', '1', '1', '6');
INSERT INTO `charts` VALUES ('25', 'percentHistogramLine', 'resource/chart/percent-histogram-line.png', '百分比堆积柱线图', 'chart_sample_front_end/html/percentHistogramLine.html', '1', '3', '5');
INSERT INTO `charts` VALUES ('24', 'accumulateHistogramLine', 'resource/chart/accumulate-histogram-line.png', '堆积柱线图', 'chart_sample_front_end/html/accumulateHistogramLine.html', '1', '2', '5');
INSERT INTO `charts` VALUES ('12', 'histogramLine', 'resource/chart/histogram-line.png', '柱线图', 'chart_sample_front_end/html/histogramLine.html', '1', '1', '5');
INSERT INTO `charts` VALUES ('11', 'areaGraph', 'resource/chart/areaGraph.png', '面积图', 'chart_sample_front_end/html/areaGraph.html', '1', '2', '4');
INSERT INTO `charts` VALUES ('10', 'lineGraph', 'resource/chart/lineGraph.png', '折线图', 'chart_sample_front_end/html/lineGraph.html', '1', '1', '4');
INSERT INTO `charts` VALUES ('9', 'percentBarChart', 'resource/chart/percentBarChart.png', '百分比堆积条形图', 'chart_sample_front_end/html/percentBarChart.html', '1', '5', '3');
INSERT INTO `charts` VALUES ('8', 'accumulateBarChart', 'resource/chart/accumulateBarChart.png', '堆积条形图', 'chart_sample_front_end/html/accumulateBarChart.html', '1', '4', '3');
INSERT INTO `charts` VALUES ('7', 'barChart', 'resource/chart/barChart.png', '条形图', 'chart_sample_front_end/html/barChart.html', '1', '1', '3');
INSERT INTO `charts` VALUES ('6', 'percentHistogram', 'resource/chart/percentHistogram.png', '百分比堆积柱状图', 'chart_sample_front_end/html/percentHistogram.html', '1', '3', '2');
INSERT INTO `charts` VALUES ('5', 'accumulateHistogram', 'resource/chart/accumulateHistogram.png', '堆积柱状图', 'chart_sample_front_end/html/accumulateHistogram.html', '1', '2', '2');
INSERT INTO `charts` VALUES ('4', 'histogram', 'resource/chart/histogram.png', '柱状图', 'chart_sample_front_end/html/histogram.html', '1', '1', '2');
INSERT INTO `charts` VALUES ('3', 'pivotTable', 'resource/chart/crossTable.png', '透视表', 'chart_sample_front_end/html/pivotTable.html', '1', '3', '0');
INSERT INTO `charts` VALUES ('1', 'verticalTable', 'resource/chart/verticalTable.png', '垂直表', 'chart_sample_front_end/html/verticalTable.html', '1', '1', '0');
INSERT INTO `charts` VALUES ('22', 'polarMap', 'resource/chart/polarMap.png', '极地图', 'chart_sample_front_end/html/polarMap.html', '0', '0', '-1');
INSERT INTO `charts` VALUES ('20', 'boxPlot', 'resource/chart/boxPlot.png', '箱线图', 'chart_sample_front_end/html/boxPlot.html', '0', '0', '-1');
INSERT INTO `charts` VALUES ('26', 'label', 'resource/chart/histogram-line.png', '标签', '', '1', '3', '13');
INSERT INTO `charts` VALUES ('2', 'horizontalTable', 'resource/chart/horizontalTable.png', '水平表', 'chart_sample_front_end/html/horizontalTable.html', '1', '2', '0');
INSERT INTO `charts` VALUES ('17', 'bubbleChart', 'resource/chart/bubbleChart.png', '气泡图', 'chart_sample_front_end/html/bubbleChart.html', '1', '2', '7');
INSERT INTO `charts` VALUES ('18', 'waterfallPlot', 'resource/chart/waterfallPlot.png', '瀑布图', 'chart_sample_front_end/html/waterfallPlot.html', '1', '2', '8');
INSERT INTO `charts` VALUES ('19', 'radarMap', 'resource/chart/radarMap.png', '雷达图', 'chart_sample_front_end/html/radarMap.html', '1', '1', '8');
INSERT INTO `charts` VALUES ('21', 'funnelPlot', 'resource/chart/funnelPlot.png', '漏斗图', 'chart_sample_front_end/html/funnelPlot.html', '1', '3', '8');
INSERT INTO `charts` VALUES ('23', 'map', 'resource/chart/map.png', '地图', 'chart_sample_front_end/html/map.html', '1', '1', '10');
INSERT INTO `charts` VALUES ('27', 'scalableLineGraph', 'resource/chart/scalableLineGraph.png', '可缩放时间轴的折线图', 'chart_sample_front_end/html/scalableLineGraph.html', '1', '3', '4');
INSERT INTO `charts` VALUES ('28', 'adjustableLineGraph', 'resource/chart/adjustableLineGraph.png', '可调整数据范围折线图', 'chart_sample_front_end/html/adjustableLineGraph.html', '1', '4', '4');
INSERT INTO `charts` VALUES ('29', 'variablePie', 'resource/chart/variablePie.png', '可变宽度的环形图', 'chart_sample_front_end/html/variablePie.html', '1', '3', '6');
INSERT INTO `charts` VALUES ('30', 'percentDoughnut', 'resource/chart/percentDoughnut.png', '百分比环形图', 'chart_sample_front_end/html/percentDoughnut.html', '1', '3', '9');
INSERT INTO `charts` VALUES ('31', 'bulletChart', 'resource/chart/bulletChart.png', '子弹图', 'chart_sample_front_end/html/bulletChart.html', '1', '4', '9');
INSERT INTO `charts` VALUES ('32', 'foldingTable', 'resource/chart/foldingTable.png', '折叠表格', 'chart_sample_front_end/html/foldingTable.html', '1', '4', '0');
INSERT INTO `charts` VALUES ('33', 'listTable', 'resource/chart/listTable.png', '列表', '', '0', '0', '-1');
INSERT INTO `charts` VALUES ('34', 'wheelFrame', 'resource/chart/wheelFrame.png', '轮播框', '', '1', '2', '13');
INSERT INTO `charts` VALUES ('35', 'wordCloud', 'resource/chart/wordCloud.png', '词云', 'chart_sample_front_end/html/wordCloud.html', '1', '4', '8');
INSERT INTO `charts` VALUES ('36', 'waterWaveChart', 'resource/chart/waterWaveChart.png', '水波图', 'chart_sample_front_end/html/waterWaveChart.html', '1', '5', '9');
INSERT INTO `charts` VALUES ('37', 'totalTable', 'resource/chart/totalTable.png', '合计表', 'chart_sample_front_end/html/totalTable.html', '1', '5', '0');
INSERT INTO `charts` VALUES ('38', 'sparklines', 'resource/chart/sparklines.png', '迷你图', 'chart_sample_front_end/html/sparklines.html', '1', '6', '0');
INSERT INTO `charts` VALUES ('39', 'scatterMap', 'resource/chart/scatterMap.png', '散点地图', 'chart_sample_front_end/html/scatterMap.html', '1', '2', '10');
INSERT INTO `charts` VALUES ('40', 'freeCell', 'resource/chart/freeCell.png', '自由单元格', '', '1', '4', '13');
INSERT INTO `charts` VALUES ('41', 'dateTimeControl', 'resource/chart/dateTimeControl.png', '日期控件', '', '1', '5', '13');
INSERT INTO `charts` VALUES ('42', 'treeMap', 'resource/chart/treeMap.png', '矩形树图', 'chart_sample_front_end/html/treeMap.html', '1', '5', '8');
INSERT INTO `charts` VALUES ('43', 'reportContainer', 'resource/chart/reportContainer.png', '报表容器', '', '1', '1', '12');
INSERT INTO `charts` VALUES ('44', 'BDAButton', 'resource/chart/BDAButton.png', '按钮', '', '1', '6', '13');
INSERT INTO `charts` VALUES ('45', 'pictureBox', 'resource/chart/pictureBox.png', '图片框', '', '1', '1', '13');
INSERT INTO `charts` VALUES ('46', 'simpleBarChart', 'resource/chart/simpleBarChart.png', '简单条形图', '', '1', '2', '3');
INSERT INTO `charts` VALUES ('47', 'equipmentRealTimeStatusChart', 'resource/chart/equipmentRealTimeStatusChart.png', '设备实时状态图', '', '1', '1', '11');
INSERT INTO `charts` VALUES ('48', 'simpleGanttChart', 'resource/chart/simpleGanttChart.png', '简单甘特图', '', '1', '3', '11');
INSERT INTO `charts` VALUES ('49', 'pictorialBar', 'resource/chart/pictorialBar.png', '象形柱图', '', '1', '3', '3');
INSERT INTO `charts` VALUES ('50', 'equipmentRunningStatusChart', 'resource/chart/equipmentRunningStatusChart.png', '设备运行状态图', '', '1', '2', '11');
INSERT INTO `charts` VALUES ('51', 'tabControl', 'resource/chart/tabControl.png', '页签容器', '', '1', '2', '12');
INSERT INTO `charts` VALUES ('52', 'freeTable', 'resource/chart/freeTable.png', '自由表格', '', '1', '7', '0');
INSERT INTO `charts` VALUES ('53', 'progressBar', 'resource/chart/freeTable.png', '进度条', ' ', 1, 4, 9);


-- ----------------------------
-- Table structure for cities
-- ----------------------------
DROP TABLE IF EXISTS `cities`;
CREATE TABLE `cities` (
  `city_id` int(11) NOT NULL COMMENT '城市ID',
  `city_code` varchar(32) NOT NULL COMMENT '城市编码',
  `city_name` varchar(32) NOT NULL COMMENT '城市名称',
  `province_id` int(11) NOT NULL COMMENT '省份ID',
  `have_map` int(11) NOT NULL DEFAULT '1',
  `have_child_map` int(11) NOT NULL DEFAULT '0',
  `longitude` varchar(16) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(16) DEFAULT NULL COMMENT '纬度',
  PRIMARY KEY (`city_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of cities
-- ----------------------------
INSERT INTO `cities` VALUES ('5', '130100', '石家庄市', '3', '1', '0', '114.502461', '38.045474');
INSERT INTO `cities` VALUES ('6', '130200', '唐山市', '3', '1', '0', '118.175393', '39.635113');
INSERT INTO `cities` VALUES ('7', '130300', '秦皇岛市', '3', '1', '0', '119.586579', '39.942531');
INSERT INTO `cities` VALUES ('8', '130400', '邯郸市', '3', '1', '0', '114.490686', '36.612273');
INSERT INTO `cities` VALUES ('9', '130500', '邢台市', '3', '1', '0', '114.508851', '37.0682');
INSERT INTO `cities` VALUES ('10', '130600', '保定市', '3', '1', '0', '115.482331', '38.867657');
INSERT INTO `cities` VALUES ('11', '130700', '张家口市', '3', '1', '0', '114.884091', '40.811901');
INSERT INTO `cities` VALUES ('12', '130800', '承德市', '3', '1', '0', '117.939152', '40.976204');
INSERT INTO `cities` VALUES ('13', '130900', '沧州市', '3', '1', '0', '116.857461', '38.310582');
INSERT INTO `cities` VALUES ('14', '131000', '廊坊市', '3', '1', '0', '116.713873', '39.529244');
INSERT INTO `cities` VALUES ('15', '131100', '衡水市', '3', '1', '0', '115.665993', '37.735097');
INSERT INTO `cities` VALUES ('16', '140100', '太原市', '4', '1', '0', '112.549248', '37.857014');
INSERT INTO `cities` VALUES ('17', '140200', '大同市', '4', '1', '0', '113.295259', '40.09031');
INSERT INTO `cities` VALUES ('18', '140300', '阳泉市', '4', '1', '0', '113.583285', '37.861188');
INSERT INTO `cities` VALUES ('19', '140400', '长治市', '4', '1', '0', '113.113556', '36.191112');
INSERT INTO `cities` VALUES ('20', '140500', '晋城市', '4', '1', '0', '112.851274', '35.497553');
INSERT INTO `cities` VALUES ('21', '140600', '朔州市', '4', '1', '0', '112.433387', '39.331261');
INSERT INTO `cities` VALUES ('22', '140700', '晋中市', '4', '1', '0', '112.736465', '37.696495');
INSERT INTO `cities` VALUES ('23', '140800', '运城市', '4', '1', '0', '111.003957', '35.022778');
INSERT INTO `cities` VALUES ('24', '140900', '忻州市', '4', '1', '0', '112.733538', '38.41769');
INSERT INTO `cities` VALUES ('25', '141000', '临汾市', '4', '1', '0', '111.517973', '36.08415');
INSERT INTO `cities` VALUES ('26', '141100', '吕梁市', '4', '1', '0', '111.134335', '37.524366');
INSERT INTO `cities` VALUES ('27', '150100', '呼和浩特市', '5', '1', '0', '111.670801', '40.818311');
INSERT INTO `cities` VALUES ('28', '150200', '包头市', '5', '1', '0', '109.840405', '40.658168');
INSERT INTO `cities` VALUES ('29', '150300', '乌海市', '5', '1', '0', '106.825563', '39.673734');
INSERT INTO `cities` VALUES ('30', '150400', '赤峰市', '5', '1', '0', '118.956806', '42.275317');
INSERT INTO `cities` VALUES ('31', '150500', '通辽市', '5', '1', '0', '122.263119', '43.617429');
INSERT INTO `cities` VALUES ('32', '150600', '鄂尔多斯市', '5', '1', '0', '109.99029', '39.817179');
INSERT INTO `cities` VALUES ('33', '150700', '呼伦贝尔市', '5', '1', '0', '119.758168', '49.215333');
INSERT INTO `cities` VALUES ('34', '150800', '巴彦淖尔市', '5', '1', '0', '107.416959', '40.757402');
INSERT INTO `cities` VALUES ('35', '150900', '乌兰察布市', '5', '1', '0', '113.114543', '41.034126');
INSERT INTO `cities` VALUES ('36', '152200', '兴安盟', '5', '1', '0', '122.070317', '46.076268');
INSERT INTO `cities` VALUES ('37', '152500', '锡林郭勒盟', '5', '1', '0', '116.090996', '43.944018');
INSERT INTO `cities` VALUES ('38', '152900', '阿拉善盟', '5', '1', '0', '105.706422', '38.844814');
INSERT INTO `cities` VALUES ('39', '210100', '沈阳市', '6', '1', '0', '123.429096', '41.796767');
INSERT INTO `cities` VALUES ('40', '210200', '大连市', '6', '1', '0', '121.618622', '38.91459');
INSERT INTO `cities` VALUES ('41', '210300', '鞍山市', '6', '1', '0', '122.995632', '41.110626');
INSERT INTO `cities` VALUES ('42', '210400', '抚顺市', '6', '1', '0', '123.921109', '41.875956');
INSERT INTO `cities` VALUES ('43', '210500', '本溪市', '6', '1', '0', '123.770519', '41.297909');
INSERT INTO `cities` VALUES ('44', '210600', '丹东市', '6', '1', '0', '124.383044', '40.124296');
INSERT INTO `cities` VALUES ('45', '210700', '锦州市', '6', '1', '0', '121.135742', '41.119269');
INSERT INTO `cities` VALUES ('46', '210800', '营口市', '6', '1', '0', '122.235151', '40.667432');
INSERT INTO `cities` VALUES ('47', '210900', '阜新市', '6', '1', '0', '121.648962', '42.011796');
INSERT INTO `cities` VALUES ('48', '211000', '辽阳市', '6', '1', '0', '123.18152', '41.269402');
INSERT INTO `cities` VALUES ('49', '211100', '盘锦市', '6', '1', '0', '122.06957', '41.124484');
INSERT INTO `cities` VALUES ('50', '211200', '铁岭市', '6', '1', '0', '123.844279', '42.290585');
INSERT INTO `cities` VALUES ('51', '211300', '朝阳市', '6', '1', '0', '120.451176', '41.576758');
INSERT INTO `cities` VALUES ('52', '211400', '葫芦岛市', '6', '1', '0', '120.856394', '40.755572');
INSERT INTO `cities` VALUES ('53', '220100', '长春市', '7', '1', '0', '125.3245', '43.886841');
INSERT INTO `cities` VALUES ('54', '220200', '吉林市', '7', '1', '0', '126.55302', '43.843577');
INSERT INTO `cities` VALUES ('55', '220300', '四平市', '7', '1', '0', '124.370785', '43.170344');
INSERT INTO `cities` VALUES ('56', '220400', '辽源市', '7', '1', '0', '125.145349', '42.902692');
INSERT INTO `cities` VALUES ('57', '220500', '通化市', '7', '1', '0', '125.936501', '41.721177');
INSERT INTO `cities` VALUES ('58', '220600', '白山市', '7', '1', '0', '126.427839', '41.942505');
INSERT INTO `cities` VALUES ('59', '220700', '松原市', '7', '1', '0', '124.823608', '45.118243');
INSERT INTO `cities` VALUES ('60', '220800', '白城市', '7', '1', '0', '122.841114', '45.619026');
INSERT INTO `cities` VALUES ('61', '222400', '延边朝鲜族自治州', '7', '1', '0', '129.513228', '42.904823');
INSERT INTO `cities` VALUES ('62', '230100', '哈尔滨市', '8', '1', '0', '126.642464', '45.756967');
INSERT INTO `cities` VALUES ('63', '230200', '齐齐哈尔市', '8', '1', '0', '123.953486', '47.348079');
INSERT INTO `cities` VALUES ('64', '230300', '鸡西市', '8', '1', '0', '130.975966', '45.300046');
INSERT INTO `cities` VALUES ('65', '230400', '鹤岗市', '8', '1', '0', '130.277487', '47.332085');
INSERT INTO `cities` VALUES ('66', '230500', '双鸭山市', '8', '1', '0', '131.157304', '46.643442');
INSERT INTO `cities` VALUES ('67', '230600', '大庆市', '8', '1', '0', '125.11272', '46.590734');
INSERT INTO `cities` VALUES ('68', '230700', '伊春市', '8', '1', '0', '128.899396', '47.724775');
INSERT INTO `cities` VALUES ('69', '230800', '佳木斯市', '8', '1', '0', '130.361634', '46.809606');
INSERT INTO `cities` VALUES ('70', '230900', '七台河市', '8', '1', '0', '131.015584', '45.771266');
INSERT INTO `cities` VALUES ('71', '231000', '牡丹江市', '8', '1', '0', '129.618602', '44.582962');
INSERT INTO `cities` VALUES ('72', '231100', '黑河市', '8', '1', '0', '127.499023', '50.249585');
INSERT INTO `cities` VALUES ('73', '231200', '绥化市', '8', '1', '0', '126.99293', '46.637393');
INSERT INTO `cities` VALUES ('74', '232700', '大兴安岭地区', '8', '1', '0', '124.711526', '52.335262');
INSERT INTO `cities` VALUES ('77', '320100', '南京市', '10', '1', '0', '118.767413', '32.041544');
INSERT INTO `cities` VALUES ('78', '320200', '无锡市', '10', '1', '0', '120.301663', '31.574729');
INSERT INTO `cities` VALUES ('79', '320300', '徐州市', '10', '1', '0', '117.184811', '34.261792');
INSERT INTO `cities` VALUES ('80', '320400', '常州市', '10', '1', '0', '119.946973', '31.772752');
INSERT INTO `cities` VALUES ('81', '320500', '苏州市', '10', '1', '0', '120.619585', '31.299379');
INSERT INTO `cities` VALUES ('82', '320600', '南通市', '10', '1', '0', '120.864608', '32.016212');
INSERT INTO `cities` VALUES ('83', '320700', '连云港市', '10', '1', '0', '119.178821', '34.600018');
INSERT INTO `cities` VALUES ('84', '320800', '淮安市', '10', '1', '0', '119.021265', '33.597506');
INSERT INTO `cities` VALUES ('85', '320900', '盐城市', '10', '1', '0', '120.139998', '33.377631');
INSERT INTO `cities` VALUES ('86', '321000', '扬州市', '10', '1', '0', '119.421003', '32.393159');
INSERT INTO `cities` VALUES ('87', '321100', '镇江市', '10', '1', '0', '119.452753', '32.204402');
INSERT INTO `cities` VALUES ('88', '321200', '泰州市', '10', '1', '0', '119.915176', '32.484882');
INSERT INTO `cities` VALUES ('89', '321300', '宿迁市', '10', '1', '0', '118.293328', '33.945154');
INSERT INTO `cities` VALUES ('90', '330100', '杭州市', '11', '1', '0', '120.153576', '30.287459');
INSERT INTO `cities` VALUES ('91', '330200', '宁波市', '11', '1', '0', '121.549792', '29.868388');
INSERT INTO `cities` VALUES ('92', '330300', '温州市', '11', '1', '0', '120.672111', '28.000575');
INSERT INTO `cities` VALUES ('93', '330400', '嘉兴市', '11', '1', '0', '120.750865', '30.762653');
INSERT INTO `cities` VALUES ('94', '330500', '湖州市', '11', '1', '0', '120.102398', '30.867198');
INSERT INTO `cities` VALUES ('95', '330600', '绍兴市', '11', '1', '0', '120.582112', '29.997117');
INSERT INTO `cities` VALUES ('96', '330700', '金华市', '11', '1', '0', '119.649506', '29.089524');
INSERT INTO `cities` VALUES ('97', '330800', '衢州市', '11', '1', '0', '118.87263', '28.941708');
INSERT INTO `cities` VALUES ('98', '330900', '舟山市', '11', '1', '0', '122.106863', '30.016028');
INSERT INTO `cities` VALUES ('99', '331000', '台州市', '11', '1', '0', '121.428599', '28.661378');
INSERT INTO `cities` VALUES ('100', '331100', '丽水市', '11', '1', '0', '119.921786', '28.451993');
INSERT INTO `cities` VALUES ('101', '340100', '合肥市', '12', '1', '0', '117.283042', '31.86119');
INSERT INTO `cities` VALUES ('102', '340200', '芜湖市', '12', '1', '0', '118.376451', '31.326319');
INSERT INTO `cities` VALUES ('103', '340300', '蚌埠市', '12', '1', '0', '117.36237', '32.934037');
INSERT INTO `cities` VALUES ('104', '340400', '淮南市', '12', '1', '0', '117.025449', '32.645947');
INSERT INTO `cities` VALUES ('105', '340500', '马鞍山市', '12', '1', '0', '118.507906', '31.689362');
INSERT INTO `cities` VALUES ('106', '340600', '淮北市', '12', '1', '0', '116.794664', '33.971707');
INSERT INTO `cities` VALUES ('107', '340700', '铜陵市', '12', '1', '0', '117.816576', '30.929935');
INSERT INTO `cities` VALUES ('108', '340800', '安庆市', '12', '1', '0', '117.053571', '30.524816');
INSERT INTO `cities` VALUES ('109', '341000', '黄山市', '12', '1', '0', '118.317325', '29.709239');
INSERT INTO `cities` VALUES ('110', '341100', '滁州市', '12', '1', '0', '118.316264', '32.303627');
INSERT INTO `cities` VALUES ('111', '341200', '阜阳市', '12', '1', '0', '115.819729', '32.896969');
INSERT INTO `cities` VALUES ('112', '341300', '宿州市', '12', '1', '0', '116.984084', '33.633891');
INSERT INTO `cities` VALUES ('114', '341500', '六安市', '12', '1', '0', '116.507676', '31.752889');
INSERT INTO `cities` VALUES ('115', '341600', '亳州市', '12', '1', '0', '115.782939', '33.869338');
INSERT INTO `cities` VALUES ('116', '341700', '池州市', '12', '1', '0', '117.489157', '30.656037');
INSERT INTO `cities` VALUES ('117', '341800', '宣城市', '12', '1', '0', '118.757995', '30.945667');
INSERT INTO `cities` VALUES ('118', '350100', '福州市', '13', '1', '0', '119.306239', '26.075302');
INSERT INTO `cities` VALUES ('119', '350200', '厦门市', '13', '1', '0', '118.11022', '24.490474');
INSERT INTO `cities` VALUES ('120', '350300', '莆田市', '13', '1', '0', '119.007558', '25.431011');
INSERT INTO `cities` VALUES ('121', '350400', '三明市', '13', '1', '0', '117.635001', '26.265444');
INSERT INTO `cities` VALUES ('122', '350500', '泉州市', '13', '1', '0', '118.589421', '24.908853');
INSERT INTO `cities` VALUES ('123', '350600', '漳州市', '13', '1', '0', '117.661801', '24.510897');
INSERT INTO `cities` VALUES ('124', '350700', '南平市', '13', '1', '0', '118.178459', '26.635627');
INSERT INTO `cities` VALUES ('125', '350800', '龙岩市', '13', '1', '0', '117.02978', '25.091603');
INSERT INTO `cities` VALUES ('126', '350900', '宁德市', '13', '1', '0', '119.527082', '26.65924');
INSERT INTO `cities` VALUES ('127', '360100', '南昌市', '14', '1', '0', '115.892151', '28.676493');
INSERT INTO `cities` VALUES ('128', '360200', '景德镇市', '14', '1', '0', '117.214664', '29.29256');
INSERT INTO `cities` VALUES ('129', '360300', '萍乡市', '14', '1', '0', '113.852186', '27.622946');
INSERT INTO `cities` VALUES ('130', '360400', '九江市', '14', '1', '0', '115.992811', '29.712034');
INSERT INTO `cities` VALUES ('131', '360500', '新余市', '14', '1', '0', '114.930835', '27.810834');
INSERT INTO `cities` VALUES ('132', '360600', '鹰潭市', '14', '1', '0', '117.033838', '28.238638');
INSERT INTO `cities` VALUES ('133', '360700', '赣州市', '14', '1', '0', '114.940278', '25.85097');
INSERT INTO `cities` VALUES ('134', '360800', '吉安市', '14', '1', '0', '114.986373', '27.111699');
INSERT INTO `cities` VALUES ('135', '360900', '宜春市', '14', '1', '0', '114.391136', '27.8043');
INSERT INTO `cities` VALUES ('136', '361000', '抚州市', '14', '1', '0', '116.358351', '27.98385');
INSERT INTO `cities` VALUES ('137', '361100', '上饶市', '14', '1', '0', '117.971185', '28.44442');
INSERT INTO `cities` VALUES ('138', '370100', '济南市', '15', '1', '0', '117.000923', '36.675807');
INSERT INTO `cities` VALUES ('139', '370200', '青岛市', '15', '1', '0', '120.369557', '36.094406');
INSERT INTO `cities` VALUES ('140', '370300', '淄博市', '15', '1', '0', '118.047648', '36.814939');
INSERT INTO `cities` VALUES ('141', '370400', '枣庄市', '15', '1', '0', '117.557964', '34.856424');
INSERT INTO `cities` VALUES ('142', '370500', '东营市', '15', '1', '0', '118.4963', '37.461266');
INSERT INTO `cities` VALUES ('143', '370600', '烟台市', '15', '1', '0', '121.391382', '37.539297');
INSERT INTO `cities` VALUES ('144', '370700', '潍坊市', '15', '1', '0', '119.107078', '36.70925');
INSERT INTO `cities` VALUES ('145', '370800', '济宁市', '15', '1', '0', '116.587245', '35.415393');
INSERT INTO `cities` VALUES ('146', '370900', '泰安市', '15', '1', '0', '117.129063', '36.194968');
INSERT INTO `cities` VALUES ('147', '371000', '威海市', '15', '1', '0', '122.116394', '37.509691');
INSERT INTO `cities` VALUES ('148', '371100', '日照市', '15', '1', '0', '119.461208', '35.428588');
INSERT INTO `cities` VALUES ('149', '371200', '莱芜市', '15', '1', '0', '117.677736', '36.214397');
INSERT INTO `cities` VALUES ('150', '371300', '临沂市', '15', '1', '0', '118.326443', '35.065282');
INSERT INTO `cities` VALUES ('151', '371400', '德州市', '15', '1', '0', '116.307428', '37.453968');
INSERT INTO `cities` VALUES ('152', '371500', '聊城市', '15', '1', '0', '115.980367', '36.456013');
INSERT INTO `cities` VALUES ('153', '371600', '滨州市', '15', '1', '0', '118.016974', '37.383542');
INSERT INTO `cities` VALUES ('154', '371700', '荷泽市', '15', '1', '0', null, null);
INSERT INTO `cities` VALUES ('155', '410100', '郑州市', '16', '1', '0', '113.665412', '34.757975');
INSERT INTO `cities` VALUES ('156', '410200', '开封市', '16', '1', '0', '114.341447', '34.797049');
INSERT INTO `cities` VALUES ('157', '410300', '洛阳市', '16', '1', '0', '112.434468', '34.663041');
INSERT INTO `cities` VALUES ('158', '410400', '平顶山市', '16', '1', '0', '113.307718', '33.735241');
INSERT INTO `cities` VALUES ('159', '410500', '安阳市', '16', '1', '0', '114.352482', '36.103442');
INSERT INTO `cities` VALUES ('160', '410600', '鹤壁市', '16', '1', '0', '114.295444', '35.748236');
INSERT INTO `cities` VALUES ('161', '410700', '新乡市', '16', '1', '0', '113.883991', '35.302616');
INSERT INTO `cities` VALUES ('162', '410800', '焦作市', '16', '1', '0', '113.238266', '35.23904');
INSERT INTO `cities` VALUES ('163', '410900', '濮阳市', '16', '1', '0', '115.041299', '35.768234');
INSERT INTO `cities` VALUES ('164', '411000', '许昌市', '16', '1', '0', '113.826063', '34.022956');
INSERT INTO `cities` VALUES ('165', '411100', '漯河市', '16', '1', '0', '114.026405', '33.575855');
INSERT INTO `cities` VALUES ('166', '411200', '三门峡市', '16', '1', '0', '111.194099', '34.777338');
INSERT INTO `cities` VALUES ('167', '411300', '南阳市', '16', '1', '0', '112.540918', '32.999082');
INSERT INTO `cities` VALUES ('168', '411400', '商丘市', '16', '1', '0', '115.650497', '34.437054');
INSERT INTO `cities` VALUES ('169', '411500', '信阳市', '16', '1', '0', '114.075031', '32.123274');
INSERT INTO `cities` VALUES ('170', '411600', '周口市', '16', '1', '0', '114.649653', '33.620357');
INSERT INTO `cities` VALUES ('171', '411700', '驻马店市', '16', '1', '0', '114.024736', '32.980169');
INSERT INTO `cities` VALUES ('172', '420100', '武汉市', '17', '1', '0', '114.298572', '30.584355');
INSERT INTO `cities` VALUES ('173', '420200', '黄石市', '17', '1', '0', '115.077048', '30.220074');
INSERT INTO `cities` VALUES ('174', '420300', '十堰市', '17', '1', '0', '110.785239', '32.647017');
INSERT INTO `cities` VALUES ('175', '420500', '宜昌市', '17', '1', '0', '111.290843', '30.702636');
INSERT INTO `cities` VALUES ('176', '420600', '襄阳市', '17', '1', '0', '112.144146', '32.042426');
INSERT INTO `cities` VALUES ('177', '420700', '鄂州市', '17', '1', '0', '114.890593', '30.396536');
INSERT INTO `cities` VALUES ('178', '420800', '荆门市', '17', '1', '0', '112.204251', '31.03542');
INSERT INTO `cities` VALUES ('179', '420900', '孝感市', '17', '1', '0', '113.926655', '30.926423');
INSERT INTO `cities` VALUES ('180', '421000', '荆州市', '17', '1', '0', '112.23813', '30.326857');
INSERT INTO `cities` VALUES ('181', '421100', '黄冈市', '17', '1', '0', '114.879365', '30.447711');
INSERT INTO `cities` VALUES ('182', '421200', '咸宁市', '17', '1', '0', '114.328963', '29.832798');
INSERT INTO `cities` VALUES ('183', '421300', '随州市', '17', '1', '0', '113.37377', '31.717497');
INSERT INTO `cities` VALUES ('184', '422800', '恩施土家族苗族自治州', '17', '1', '0', '109.48699', '30.283114');
INSERT INTO `cities` VALUES ('185', '429000', '湖北省直辖行政单位', '17', '1', '0', null, null);
INSERT INTO `cities` VALUES ('186', '430100', '长沙市', '18', '1', '0', '112.982279', '28.19409');
INSERT INTO `cities` VALUES ('187', '430200', '株洲市', '18', '1', '0', '113.151737', '27.835806');
INSERT INTO `cities` VALUES ('188', '430300', '湘潭市', '18', '1', '0', '112.925083', '27.846725');
INSERT INTO `cities` VALUES ('189', '430400', '衡阳市', '18', '1', '0', '112.607693', '26.900358');
INSERT INTO `cities` VALUES ('190', '430500', '邵阳市', '18', '1', '0', '111.46923', '27.237842');
INSERT INTO `cities` VALUES ('191', '430600', '岳阳市', '18', '1', '0', '113.132855', '29.37029');
INSERT INTO `cities` VALUES ('192', '430700', '常德市', '18', '1', '0', '111.691347', '29.040225');
INSERT INTO `cities` VALUES ('193', '430800', '张家界市', '18', '1', '0', '110.479921', '29.127401');
INSERT INTO `cities` VALUES ('194', '430900', '益阳市', '18', '1', '0', '112.355042', '28.570066');
INSERT INTO `cities` VALUES ('195', '431000', '郴州市', '18', '1', '0', '113.032067', '25.793589');
INSERT INTO `cities` VALUES ('196', '431100', '永州市', '18', '1', '0', '111.608019', '26.434516');
INSERT INTO `cities` VALUES ('197', '431200', '怀化市', '18', '1', '0', '109.97824', '27.550082');
INSERT INTO `cities` VALUES ('198', '431300', '娄底市', '18', '1', '0', '112.008497', '27.728136');
INSERT INTO `cities` VALUES ('199', '433100', '湘西土家族苗族自治州', '18', '1', '0', '109.739735', '28.314296');
INSERT INTO `cities` VALUES ('200', '440100', '广州市', '19', '1', '0', '113.280637', '23.125178');
INSERT INTO `cities` VALUES ('201', '440200', '韶关市', '19', '1', '0', '113.591544', '24.801322');
INSERT INTO `cities` VALUES ('202', '440300', '深圳市', '19', '1', '0', '114.085947', '22.547');
INSERT INTO `cities` VALUES ('203', '440400', '珠海市', '19', '1', '0', '113.552724', '22.255899');
INSERT INTO `cities` VALUES ('204', '440500', '汕头市', '19', '1', '0', '116.708463', '23.37102');
INSERT INTO `cities` VALUES ('205', '440600', '佛山市', '19', '1', '0', '113.122717', '23.028762');
INSERT INTO `cities` VALUES ('206', '440700', '江门市', '19', '1', '0', '113.094942', '22.590431');
INSERT INTO `cities` VALUES ('207', '440800', '湛江市', '19', '1', '0', '110.405529', '21.195338');
INSERT INTO `cities` VALUES ('208', '440900', '茂名市', '19', '1', '0', '110.919229', '21.659751');
INSERT INTO `cities` VALUES ('209', '441200', '肇庆市', '19', '1', '0', '112.472529', '23.051546');
INSERT INTO `cities` VALUES ('210', '441300', '惠州市', '19', '1', '0', '114.412599', '23.079404');
INSERT INTO `cities` VALUES ('211', '441400', '梅州市', '19', '1', '0', '116.117582', '24.299112');
INSERT INTO `cities` VALUES ('212', '441500', '汕尾市', '19', '1', '0', '115.364238', '22.774485');
INSERT INTO `cities` VALUES ('213', '441600', '河源市', '19', '1', '0', '114.697802', '23.746266');
INSERT INTO `cities` VALUES ('214', '441700', '阳江市', '19', '1', '0', '111.975107', '21.859222');
INSERT INTO `cities` VALUES ('215', '441800', '清远市', '19', '1', '0', '113.036779', '23.704188');
INSERT INTO `cities` VALUES ('216', '441900', '东莞市', '19', '1', '0', '113.760234', '23.048884');
INSERT INTO `cities` VALUES ('217', '442000', '中山市', '19', '1', '0', '113.382391', '22.521113');
INSERT INTO `cities` VALUES ('218', '445100', '潮州市', '19', '1', '0', '116.632301', '23.661701');
INSERT INTO `cities` VALUES ('219', '445200', '揭阳市', '19', '1', '0', '116.355733', '23.543778');
INSERT INTO `cities` VALUES ('220', '445300', '云浮市', '19', '1', '0', '112.044439', '22.929801');
INSERT INTO `cities` VALUES ('221', '450100', '南宁市', '20', '1', '0', '108.320004', '22.82402');
INSERT INTO `cities` VALUES ('222', '450200', '柳州市', '20', '1', '0', '109.411703', '24.314617');
INSERT INTO `cities` VALUES ('223', '450300', '桂林市', '20', '1', '0', '110.299121', '25.274215');
INSERT INTO `cities` VALUES ('224', '450400', '梧州市', '20', '1', '0', '111.316229', '23.472309');
INSERT INTO `cities` VALUES ('225', '450500', '北海市', '20', '1', '0', '109.119254', '21.473343');
INSERT INTO `cities` VALUES ('226', '450600', '防城港市', '20', '1', '0', '108.345478', '21.614631');
INSERT INTO `cities` VALUES ('227', '450700', '钦州市', '20', '1', '0', '108.624175', '21.967127');
INSERT INTO `cities` VALUES ('228', '450800', '贵港市', '20', '1', '0', '109.602146', '23.0936');
INSERT INTO `cities` VALUES ('229', '450900', '玉林市', '20', '1', '0', '110.154393', '22.63136');
INSERT INTO `cities` VALUES ('230', '451000', '百色市', '20', '1', '0', '106.616285', '23.897742');
INSERT INTO `cities` VALUES ('231', '451100', '贺州市', '20', '1', '0', '111.552056', '24.414141');
INSERT INTO `cities` VALUES ('232', '451200', '河池市', '20', '1', '0', '108.062105', '24.695899');
INSERT INTO `cities` VALUES ('233', '451300', '来宾市', '20', '1', '0', '109.229772', '23.733766');
INSERT INTO `cities` VALUES ('234', '451400', '崇左市', '20', '1', '0', '107.353926', '22.404108');
INSERT INTO `cities` VALUES ('235', '460100', '海口市', '21', '1', '0', '110.33119', '20.031971');
INSERT INTO `cities` VALUES ('236', '460200', '三亚市', '21', '1', '0', '109.508268', '18.247872');
INSERT INTO `cities` VALUES ('237', '469000', '海南省直辖县级行政单位', '21', '1', '0', null, null);
INSERT INTO `cities` VALUES ('241', '510100', '成都市', '23', '1', '0', '104.065735', '30.659462');
INSERT INTO `cities` VALUES ('242', '510300', '自贡市', '23', '1', '0', '104.773447', '29.352765');
INSERT INTO `cities` VALUES ('243', '510400', '攀枝花市', '23', '1', '0', '101.716007', '26.580446');
INSERT INTO `cities` VALUES ('244', '510500', '泸州市', '23', '1', '0', '105.443348', '28.889138');
INSERT INTO `cities` VALUES ('245', '510600', '德阳市', '23', '1', '0', '104.398651', '31.127991');
INSERT INTO `cities` VALUES ('246', '510700', '绵阳市', '23', '1', '0', '104.741722', '31.46402');
INSERT INTO `cities` VALUES ('247', '510800', '广元市', '23', '1', '0', '105.829757', '32.433668');
INSERT INTO `cities` VALUES ('248', '510900', '遂宁市', '23', '1', '0', '105.571331', '30.513311');
INSERT INTO `cities` VALUES ('249', '511000', '内江市', '23', '1', '0', '105.066138', '29.58708');
INSERT INTO `cities` VALUES ('250', '511100', '乐山市', '23', '1', '0', '103.761263', '29.582024');
INSERT INTO `cities` VALUES ('251', '511300', '南充市', '23', '1', '0', '106.082974', '30.795281');
INSERT INTO `cities` VALUES ('252', '511400', '眉山市', '23', '1', '0', '103.831788', '30.048318');
INSERT INTO `cities` VALUES ('253', '511500', '宜宾市', '23', '1', '0', '104.630825', '28.760189');
INSERT INTO `cities` VALUES ('254', '511600', '广安市', '23', '1', '0', '106.633369', '30.456398');
INSERT INTO `cities` VALUES ('255', '511700', '达州市', '23', '1', '0', '107.502262', '31.209484');
INSERT INTO `cities` VALUES ('256', '511800', '雅安市', '23', '1', '0', '103.001033', '29.987722');
INSERT INTO `cities` VALUES ('257', '511900', '巴中市', '23', '1', '0', '106.753669', '31.858809');
INSERT INTO `cities` VALUES ('258', '512000', '资阳市', '23', '1', '0', '104.641917', '30.122211');
INSERT INTO `cities` VALUES ('259', '513200', '阿坝藏族羌族自治州', '23', '1', '0', '102.221374', '31.899792');
INSERT INTO `cities` VALUES ('260', '513300', '甘孜藏族自治州', '23', '1', '0', '101.963815', '30.050663');
INSERT INTO `cities` VALUES ('261', '513400', '凉山彝族自治州', '23', '1', '0', '102.258746', '27.886762');
INSERT INTO `cities` VALUES ('262', '520100', '贵阳市', '24', '1', '0', '106.713478', '26.578343');
INSERT INTO `cities` VALUES ('263', '520200', '六盘水市', '24', '1', '0', '104.846743', '26.584643');
INSERT INTO `cities` VALUES ('264', '520300', '遵义市', '24', '1', '0', '106.937265', '27.706626');
INSERT INTO `cities` VALUES ('265', '520400', '安顺市', '24', '1', '0', '105.932188', '26.245544');
INSERT INTO `cities` VALUES ('266', '522200', '铜仁市', '24', '1', '0', '109.191555', '27.718346');
INSERT INTO `cities` VALUES ('267', '522300', '黔西南布依族苗族自治州', '24', '1', '0', '104.897971', '25.08812');
INSERT INTO `cities` VALUES ('268', '522400', '毕节市', '24', '1', '0', '105.28501', '27.301693');
INSERT INTO `cities` VALUES ('269', '522600', '黔东南苗族侗族自治州', '24', '1', '0', '107.977488', '26.583352');
INSERT INTO `cities` VALUES ('270', '522700', '黔南布依族苗族自治州', '24', '1', '0', '107.517156', '26.258219');
INSERT INTO `cities` VALUES ('271', '530100', '昆明市', '25', '1', '0', '102.712251', '25.040609');
INSERT INTO `cities` VALUES ('272', '530300', '曲靖市', '25', '1', '0', '103.797851', '25.501557');
INSERT INTO `cities` VALUES ('273', '530400', '玉溪市', '25', '1', '0', '102.543907', '24.350461');
INSERT INTO `cities` VALUES ('274', '530500', '保山市', '25', '1', '0', '99.167133', '25.111802');
INSERT INTO `cities` VALUES ('275', '530600', '昭通市', '25', '1', '0', '103.717216', '27.336999');
INSERT INTO `cities` VALUES ('276', '530700', '丽江市', '25', '1', '0', '100.233026', '26.872108');
INSERT INTO `cities` VALUES ('277', '530800', '思茅区', '25', '1', '0', '100.97716', '22.78691');
INSERT INTO `cities` VALUES ('278', '530900', '临沧市', '25', '1', '0', '100.08697', '23.886567');
INSERT INTO `cities` VALUES ('279', '532300', '楚雄彝族自治州', '25', '1', '0', '101.546046', '25.041988');
INSERT INTO `cities` VALUES ('280', '532500', '红河哈尼族彝族自治州', '25', '1', '0', '103.384182', '23.366775');
INSERT INTO `cities` VALUES ('281', '532600', '文山壮族苗族自治州', '25', '1', '0', '104.24401', '23.36951');
INSERT INTO `cities` VALUES ('282', '532800', '西双版纳傣族自治州', '25', '1', '0', '100.797941', '22.001724');
INSERT INTO `cities` VALUES ('283', '532900', '大理白族自治州', '25', '1', '0', '100.240037', '25.592765');
INSERT INTO `cities` VALUES ('284', '533100', '德宏傣族景颇族自治州', '25', '1', '0', '98.578363', '24.436694');
INSERT INTO `cities` VALUES ('285', '533300', '怒江傈僳族自治州', '25', '1', '0', '98.854304', '25.850949');
INSERT INTO `cities` VALUES ('286', '533400', '迪庆藏族自治州', '25', '1', '0', '99.706463', '27.826853');
INSERT INTO `cities` VALUES ('287', '540100', '拉萨市', '26', '1', '0', '91.132212', '29.660361');
INSERT INTO `cities` VALUES ('288', '542100', '昌都市', '26', '1', '0', '97.178452', '31.136875');
INSERT INTO `cities` VALUES ('289', '542200', '山南地区', '26', '1', '0', '91.766529', '29.236023');
INSERT INTO `cities` VALUES ('290', '542300', '日喀则市', '26', '1', '0', '88.884874', '29.263792');
INSERT INTO `cities` VALUES ('291', '542400', '那曲地区', '26', '1', '0', '92.060214', '31.476004');
INSERT INTO `cities` VALUES ('292', '542500', '阿里地区', '26', '1', '0', '80.105498', '32.503187');
INSERT INTO `cities` VALUES ('293', '542600', '林芝地区', '26', '1', '0', '94.362348', '29.654693');
INSERT INTO `cities` VALUES ('294', '610100', '西安市', '27', '1', '0', '108.948024', '34.263161');
INSERT INTO `cities` VALUES ('295', '610200', '铜川市', '27', '1', '0', '108.963122', '34.90892');
INSERT INTO `cities` VALUES ('296', '610300', '宝鸡市', '27', '1', '0', '107.14487', '34.369315');
INSERT INTO `cities` VALUES ('297', '610400', '咸阳市', '27', '1', '0', '108.705117', '34.333439');
INSERT INTO `cities` VALUES ('298', '610500', '渭南市', '27', '1', '0', '109.502882', '34.499381');
INSERT INTO `cities` VALUES ('299', '610600', '延安市', '27', '1', '0', '109.49081', '36.596537');
INSERT INTO `cities` VALUES ('300', '610700', '汉中市', '27', '1', '0', '107.028621', '33.077668');
INSERT INTO `cities` VALUES ('301', '610800', '榆林市', '27', '1', '0', '109.741193', '38.290162');
INSERT INTO `cities` VALUES ('302', '610900', '安康市', '27', '1', '0', '109.029273', '32.6903');
INSERT INTO `cities` VALUES ('303', '611000', '商洛市', '27', '1', '0', '109.939776', '33.868319');
INSERT INTO `cities` VALUES ('304', '620100', '兰州市', '28', '1', '0', '103.823557', '36.058039');
INSERT INTO `cities` VALUES ('305', '620200', '嘉峪关市', '28', '1', '0', '98.277304', '39.786529');
INSERT INTO `cities` VALUES ('306', '620300', '金昌市', '28', '1', '0', '102.187888', '38.514238');
INSERT INTO `cities` VALUES ('307', '620400', '白银市', '28', '1', '0', '104.173606', '36.54568');
INSERT INTO `cities` VALUES ('308', '620500', '天水市', '28', '1', '0', '105.724998', '34.578529');
INSERT INTO `cities` VALUES ('309', '620600', '武威市', '28', '1', '0', '102.634697', '37.929996');
INSERT INTO `cities` VALUES ('310', '620700', '张掖市', '28', '1', '0', '100.455472', '38.932897');
INSERT INTO `cities` VALUES ('311', '620800', '平凉市', '28', '1', '0', '106.684691', '35.54279');
INSERT INTO `cities` VALUES ('312', '620900', '酒泉市', '28', '1', '0', '98.510795', '39.744023');
INSERT INTO `cities` VALUES ('313', '621000', '庆阳市', '28', '1', '0', '107.638372', '35.734218');
INSERT INTO `cities` VALUES ('314', '621100', '定西市', '28', '1', '0', '104.626294', '35.579578');
INSERT INTO `cities` VALUES ('315', '621200', '陇南市', '28', '1', '0', '104.929379', '33.388598');
INSERT INTO `cities` VALUES ('316', '622900', '临夏回族自治州', '28', '1', '0', '103.212006', '35.599446');
INSERT INTO `cities` VALUES ('317', '623000', '甘南藏族自治州', '28', '1', '0', '102.911008', '34.986354');
INSERT INTO `cities` VALUES ('318', '630100', '西宁市', '29', '1', '0', '101.778916', '36.623178');
INSERT INTO `cities` VALUES ('319', '632100', '海东地区', '29', '1', '0', '102.12', '36.50');
INSERT INTO `cities` VALUES ('320', '632200', '海北藏族自治州', '29', '1', '0', '100.901059', '36.959435');
INSERT INTO `cities` VALUES ('321', '632300', '黄南藏族自治州', '29', '1', '0', '102.019988', '35.517744');
INSERT INTO `cities` VALUES ('322', '632500', '海南藏族自治州', '29', '1', '0', '100.619542', '36.280353');
INSERT INTO `cities` VALUES ('323', '632600', '果洛藏族自治州', '29', '1', '0', '100.242143', '34.4736');
INSERT INTO `cities` VALUES ('324', '632700', '玉树藏族自治州', '29', '1', '0', '97.008522', '33.004049');
INSERT INTO `cities` VALUES ('325', '632800', '海西蒙古族藏族自治州', '29', '1', '0', '97.370785', '37.374663');
INSERT INTO `cities` VALUES ('326', '640100', '银川市', '30', '1', '0', '106.278179', '38.46637');
INSERT INTO `cities` VALUES ('327', '640200', '石嘴山市', '30', '1', '0', '106.376173', '39.01333');
INSERT INTO `cities` VALUES ('328', '640300', '吴忠市', '30', '1', '0', '106.199409', '37.986165');
INSERT INTO `cities` VALUES ('329', '640400', '固原市', '30', '1', '0', '106.285241', '36.004561');
INSERT INTO `cities` VALUES ('330', '640500', '中卫市', '30', '1', '0', '105.189568', '37.514951');
INSERT INTO `cities` VALUES ('331', '650100', '乌鲁木齐市', '31', '1', '0', '87.617733', '43.792818');
INSERT INTO `cities` VALUES ('332', '650200', '克拉玛依市', '31', '1', '0', '84.873946', '45.595886');
INSERT INTO `cities` VALUES ('333', '652100', '吐鲁番地区', '31', '1', '0', '89.184078', '42.947613');
INSERT INTO `cities` VALUES ('334', '652200', '哈密地区', '31', '1', '0', '93.51316', '42.833248');
INSERT INTO `cities` VALUES ('335', '652300', '昌吉回族自治州', '31', '1', '0', '87.304012', '44.014577');
INSERT INTO `cities` VALUES ('336', '652700', '博尔塔拉蒙古自治州', '31', '1', '0', '82.074778', '44.903258');
INSERT INTO `cities` VALUES ('337', '652800', '巴音郭楞蒙古自治州', '31', '1', '0', '86.150969', '41.768552');
INSERT INTO `cities` VALUES ('338', '652900', '阿克苏地区', '31', '1', '0', '80.265068', '41.170712');
INSERT INTO `cities` VALUES ('339', '653000', '克孜勒苏柯尔克孜自治州', '31', '1', '0', '76.172825', '39.713431');
INSERT INTO `cities` VALUES ('340', '653100', '喀什地区', '31', '1', '0', '75.989138', '39.467664');
INSERT INTO `cities` VALUES ('341', '653200', '和田地区', '31', '1', '0', '79.92533', '37.110687');
INSERT INTO `cities` VALUES ('342', '654000', '伊犁哈萨克自治州', '31', '1', '0', '81.317946', '43.92186');
INSERT INTO `cities` VALUES ('343', '654200', '塔城地区', '31', '1', '0', '82.985732', '46.746301');
INSERT INTO `cities` VALUES ('344', '654300', '阿勒泰地区', '31', '1', '0', '88.13963', '47.848393');
INSERT INTO `cities` VALUES ('345', '659000', '新疆维吾尔自治区直辖行政单位', '31', '1', '0', null, null);
INSERT INTO `cities` VALUES ('346', '110228', '密云县', '1', '0', '0', '116.84295', '40.37618');
INSERT INTO `cities` VALUES ('347', '110116', '怀柔区', '1', '0', '0', '116.63168', '40.31602');
INSERT INTO `cities` VALUES ('348', '110111', '房山区', '1', '0', '0', '116.14257', '39.74786');
INSERT INTO `cities` VALUES ('349', '110229', '延庆县', '1', '0', '0', '115.97494', '40.45672');
INSERT INTO `cities` VALUES ('350', '110109', '门头沟区', '1', '0', '0', '116.10137', '39.94043');
INSERT INTO `cities` VALUES ('351', '110114', '昌平区', '1', '0', '0', '116.2312', '40.22072');
INSERT INTO `cities` VALUES ('352', '110115', '大兴区', '1', '0', '0', '116.34149', '39.72668');
INSERT INTO `cities` VALUES ('353', '110113', '顺义区', '1', '0', '0', '116.65417', '40.1302');
INSERT INTO `cities` VALUES ('354', '110117', '平谷区', '1', '0', '0', '117.12133', '40.14056');
INSERT INTO `cities` VALUES ('355', '110112', '通州区', '1', '0', '0', '116.65716', '39.90966');
INSERT INTO `cities` VALUES ('356', '110105', '朝阳区', '1', '0', '0', '116.48548', '39.9484');
INSERT INTO `cities` VALUES ('357', '110108', '海淀区', '1', '0', '0', '116.29812', '39.95931');
INSERT INTO `cities` VALUES ('358', '110106', '丰台区', '1', '0', '0', '116.28625', '39.8585');
INSERT INTO `cities` VALUES ('359', '110107', '石景山区', '1', '0', '0', '116.2229', '39.90564');
INSERT INTO `cities` VALUES ('360', '110102', '西城区', '1', '0', '0', '116.36003', '39.9305');
INSERT INTO `cities` VALUES ('361', '110101', '东城区', '1', '0', '0', '116.41005', '39.93157');
INSERT INTO `cities` VALUES ('362', '110104', '宣武区', '1', '0', '0', '116.35', '39.87');
INSERT INTO `cities` VALUES ('363', '110103', '崇文区', '1', '0', '0', '116.43', '39.88');
INSERT INTO `cities` VALUES ('364', '120225', '蓟县', '2', '0', '0', '117.40799', '40.04567');
INSERT INTO `cities` VALUES ('365', '120114', '武清区', '2', '0', '0', '117.04443', '39.38415');
INSERT INTO `cities` VALUES ('366', '120115', '宝坻区', '2', '0', '0', '117.3103', '39.71761');
INSERT INTO `cities` VALUES ('367', '120223', '静海县', '2', '0', '0', '116.97436', '38.94582');
INSERT INTO `cities` VALUES ('368', '120221', '宁河县', '2', '0', '0', '117.8255', '39.33048');
INSERT INTO `cities` VALUES ('369', '120109', '大港区', '2', '0', '0', '117.45', '38.83');
INSERT INTO `cities` VALUES ('370', '120107', '塘沽区', '2', '0', '0', '117.65', '39.02');
INSERT INTO `cities` VALUES ('371', '120111', '西青区', '2', '0', '0', '117.00927', '39.14123');
INSERT INTO `cities` VALUES ('372', '120113', '北辰区', '2', '0', '0', '117.13217', '39.22131');
INSERT INTO `cities` VALUES ('373', '120110', '东丽区', '2', '0', '0', '117.31436', '39.0863');
INSERT INTO `cities` VALUES ('374', '120108', '汉沽区', '2', '0', '0', '117.80', '39.25');
INSERT INTO `cities` VALUES ('375', '120112', '津南区', '2', '0', '0', '117.38537', '38.99139');
INSERT INTO `cities` VALUES ('376', '120103', '河西区', '2', '0', '0', '117.22327', '39.10959');
INSERT INTO `cities` VALUES ('377', '120102', '河东区', '2', '0', '0', '117.22562', '39.12318');
INSERT INTO `cities` VALUES ('378', '120104', '南开区', '2', '0', '0', '117.15074', '39.13821');
INSERT INTO `cities` VALUES ('379', '120105', '河北区', '2', '0', '0', '117.19697', '39.14816');
INSERT INTO `cities` VALUES ('380', '120106', '红桥区', '2', '0', '0', '117.15145', '39.16715');
INSERT INTO `cities` VALUES ('381', '120101', '和平区', '2', '0', '0', '117.21456', '39.11718');
INSERT INTO `cities` VALUES ('382', '310119', '南汇区', '9', '0', '0', '121.75', '31.05');
INSERT INTO `cities` VALUES ('383', '310120', '奉贤区', '9', '0', '0', '121.47412', '30.9179');
INSERT INTO `cities` VALUES ('384', '310115', '浦东新区', '9', '0', '0', '121.5447', '31.22249');
INSERT INTO `cities` VALUES ('385', '310116', '金山区', '9', '0', '0', '121.34164', '30.74163');
INSERT INTO `cities` VALUES ('386', '310118', '青浦区', '9', '0', '0', '121.12417', '31.14974');
INSERT INTO `cities` VALUES ('387', '310117', '松江区', '9', '0', '0', '121.22879', '31.03222');
INSERT INTO `cities` VALUES ('388', '310114', '嘉定区', '9', '0', '0', '121.2655', '31.37473');
INSERT INTO `cities` VALUES ('389', '310113', '宝山区', '9', '0', '0', '131.4016', '46.57718');
INSERT INTO `cities` VALUES ('390', '310112', '闵行区', '9', '0', '0', '121.38162', '31.11246');
INSERT INTO `cities` VALUES ('391', '310110', '杨浦区', '9', '0', '0', '121.526', '31.2595');
INSERT INTO `cities` VALUES ('392', '310107', '普陀区', '9', '0', '0', '121.39703', '31.24951');
INSERT INTO `cities` VALUES ('393', '310104', '徐汇区', '9', '0', '0', '121.43676', '31.18831');
INSERT INTO `cities` VALUES ('394', '310105', '长宁区', '9', '0', '0', '121.42462', '31.22036');
INSERT INTO `cities` VALUES ('395', '310108', '闸北区', '9', '0', '0', '121.44636', '31.28075');
INSERT INTO `cities` VALUES ('396', '310109', '虹口区', '9', '0', '0', '121.48162', '31.27788');
INSERT INTO `cities` VALUES ('397', '310101', '黄浦区', '9', '0', '0', '121.49295', '31.22337');
INSERT INTO `cities` VALUES ('398', '310103', '卢湾区', '9', '0', '0', '121.47', '31.22');
INSERT INTO `cities` VALUES ('399', '310106', '静安区', '9', '0', '0', '121.4444', '31.22884');
INSERT INTO `cities` VALUES ('400', '500242', '酉阳土家族苗族自治县', '22', '0', '0', '108.77212', '28.8446');
INSERT INTO `cities` VALUES ('401', '500236', '奉节县', '22', '0', '0', '109.46478', '31.01825');
INSERT INTO `cities` VALUES ('402', '500238', '巫溪县', '22', '0', '0', '109.63128', '31.39756');
INSERT INTO `cities` VALUES ('403', '500234', '开县', '22', '0', '0', '108.39306', '31.16095');
INSERT INTO `cities` VALUES ('404', '500243', '彭水苗族土家族自治县', '22', '0', '0', '108.16638', '29.29516');
INSERT INTO `cities` VALUES ('405', '500235', '云阳县', '22', '0', '0', '108.69726', '30.93062');
INSERT INTO `cities` VALUES ('406', '500101', '万州区', '22', '0', '0', '108.40869', '30.80788');
INSERT INTO `cities` VALUES ('407', '500229', '城口县', '22', '0', '0', '108.66513', '31.94801');
INSERT INTO `cities` VALUES ('408', '500116', '江津区', '22', '0', '0', '106.25912', '29.29008');
INSERT INTO `cities` VALUES ('409', '500240', '石柱土家族自治县', '22', '0', '0', '108.11389', '30.00054');
INSERT INTO `cities` VALUES ('410', '500237', '巫山县', '22', '0', '0', '109.87814', '31.07458');
INSERT INTO `cities` VALUES ('411', '500102', '涪陵区', '22', '0', '0', '107.39007', '29.70292');
INSERT INTO `cities` VALUES ('412', '500230', '丰都县', '22', '0', '0', '107.73098', '29.86348');
INSERT INTO `cities` VALUES ('413', '500232', '武隆县', '22', '0', '0', '107.7601', '29.32548');
INSERT INTO `cities` VALUES ('414', '500119', '南川区', '22', '0', '0', '107.09936', '29.15751');
INSERT INTO `cities` VALUES ('415', '500241', '秀山土家族苗族自治县', '22', '0', '0', '108.98861', '28.45062');
INSERT INTO `cities` VALUES ('416', '500114 ', '黔江区', '22', '0', '0', '108.7709', '29.5332');
INSERT INTO `cities` VALUES ('417', '500117', '合川区', '22', '0', '0', '106.27633', '29.97227');
INSERT INTO `cities` VALUES ('418', '500233', '忠县', '22', '0', '0', '108.03689', '30.28898');
INSERT INTO `cities` VALUES ('419', '500228', '梁平县', '22', '0', '0', '107.79998', '30.67545');
INSERT INTO `cities` VALUES ('420', '500113', '巴南区', '22', '0', '0', '106.52365', '29.38311');
INSERT INTO `cities` VALUES ('421', '500118', '永川区', '22', '0', '0', '105.927', '29.35593');
INSERT INTO `cities` VALUES ('422', '500231', '垫江县', '22', '0', '0', '107.35446', '30.33359');
INSERT INTO `cities` VALUES ('423', '500112', '渝北区', '22', '0', '0', '106.6307', '29.7182');
INSERT INTO `cities` VALUES ('424', '500115', '长寿区', '22', '0', '0', '107.08166', '29.85359');
INSERT INTO `cities` VALUES ('425', '500109', '北碚区', '22', '0', '0', '106.39614', '29.80574');
INSERT INTO `cities` VALUES ('426', '500110', '万盛区', '22', '0', '0', '106.92', '28.97');
INSERT INTO `cities` VALUES ('427', '500107', '九龙坡区', '22', '0', '0', '106.51107', '29.50197');
INSERT INTO `cities` VALUES ('428', '500106', '沙坪坝区', '22', '0', '0', '106.45752', '29.54113');
INSERT INTO `cities` VALUES ('429', '500108', '南岸区', '22', '0', '0', '106.56347', '29.52311');
INSERT INTO `cities` VALUES ('430', '500105', '江北区', '22', '0', '0', '121.55681', '29.88776');
INSERT INTO `cities` VALUES ('431', '500104', '大渡口区', '22', '0', '0', '106.48262', '29.48447');
INSERT INTO `cities` VALUES ('432', '500111', '双桥区', '22', '0', '0', '117.9432', '40.97466');
INSERT INTO `cities` VALUES ('433', '500103', '渝中区', '22', '0', '0', '106.56901', '29.55279');
INSERT INTO `cities` VALUES ('434', '500110', '綦江县', '22', '0', '0', '106.65', '29.03');
INSERT INTO `cities` VALUES ('435', '500152', '潼南县', '22', '0', '0', '105.84005', '30.1912');
INSERT INTO `cities` VALUES ('436', '500111', '大足县', '22', '0', '0', '105.72', '29.70');
INSERT INTO `cities` VALUES ('437', '500224', '铜梁县', '22', '0', '0', '106.05', '29.85');
INSERT INTO `cities` VALUES ('438', '500153', '荣昌县', '22', '0', '0', '105.59442', '29.40488');
INSERT INTO `cities` VALUES ('439', '500227', '璧山县', '22', '0', '0', '106.22', '29.60');

-- ----------------------------
-- Table structure for comments
-- ----------------------------
DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `comment_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `report_id` varchar(36) NOT NULL,
  `user_id` varchar(36) NOT NULL,
  `topic_id` varchar(36) NOT NULL,
  `content` varchar(256) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='报表评论记录表';

-- ----------------------------
-- Records of comments
-- ----------------------------

-- ----------------------------
-- Table structure for counties
-- ----------------------------
DROP TABLE IF EXISTS `counties`;
CREATE TABLE `counties` (
  `county_id` int(11) NOT NULL,
  `county_name` varchar(64) NOT NULL,
  `city_id` int(11) NOT NULL,
  `have_map` int(11) NOT NULL DEFAULT '0',
  `have_child_map` int(11) NOT NULL DEFAULT '0',
  `longitude` varchar(16) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(16) DEFAULT NULL COMMENT '纬度',
  PRIMARY KEY (`county_id`),
  UNIQUE KEY `uk_county` (`county_name`,`city_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of counties
-- ----------------------------
INSERT INTO `counties` VALUES ('1', '路北区', '6', '0', '0', '118.20079', '39.62436');
INSERT INTO `counties` VALUES ('2', '路南区', '6', '0', '0', '118.15431', '39.62505');
INSERT INTO `counties` VALUES ('3', '丰润区', '6', '0', '0', '118.12976', '39.8244');
INSERT INTO `counties` VALUES ('4', '古冶区', '6', '0', '0', '118.45803', '39.71993');
INSERT INTO `counties` VALUES ('5', '开平区', '6', '0', '0', '118.26171', '39.67128');
INSERT INTO `counties` VALUES ('6', '乐亭县', '6', '0', '0', '118.9125', '39.42561');
INSERT INTO `counties` VALUES ('7', '滦县', '6', '0', '0', '118.70346', '39.74056');
INSERT INTO `counties` VALUES ('8', '迁安市', '6', '0', '0', '118.70068', '39.99833');
INSERT INTO `counties` VALUES ('9', '迁西县', '6', '0', '0', '118.31616', '40.14587');
INSERT INTO `counties` VALUES ('10', '玉田县', '6', '0', '0', '117.7388', '39.90049');
INSERT INTO `counties` VALUES ('11', '遵化市', '6', '0', '0', '117.96444', '40.18741');
INSERT INTO `counties` VALUES ('12', '丰南区', '6', '0', '0', '118.11282', '39.56483');
INSERT INTO `counties` VALUES ('13', '滦南县', '6', '0', '0', '118.6741', '39.5039');
INSERT INTO `counties` VALUES ('14', '曹妃甸区', '6', '0', '0', '118.460379', '39.273070');
INSERT INTO `counties` VALUES ('15', '高邑县', '5', '0', '0', '114.61142', '37.61556');
INSERT INTO `counties` VALUES ('16', '长安区', '5', '0', '0', '114.53906', '38.03665');
INSERT INTO `counties` VALUES ('17', '晋州市', '5', '0', '0', '115.04348', '38.03135');
INSERT INTO `counties` VALUES ('18', '井陉矿区', '5', '0', '0', '114.06518', '38.06705');
INSERT INTO `counties` VALUES ('19', '井陉县', '5', '0', '0', '114.14257', '38.03688');
INSERT INTO `counties` VALUES ('20', '灵寿县', '5', '0', '0', '114.38259', '38.30845');
INSERT INTO `counties` VALUES ('21', '鹿泉市', '5', '0', '0', '114.30', '38.08');
INSERT INTO `counties` VALUES ('22', '平山县', '5', '0', '0', '114.186', '38.25994');
INSERT INTO `counties` VALUES ('23', '桥东区', '5', '0', '0', '114.50725', '37.06801');
INSERT INTO `counties` VALUES ('24', '桥西区', '5', '0', '0', '114.46977', '38.03221');
INSERT INTO `counties` VALUES ('25', '深泽县', '5', '0', '0', '115.20358', '38.18353');
INSERT INTO `counties` VALUES ('26', '无极县', '5', '0', '0', '114.97509', '38.17653');
INSERT INTO `counties` VALUES ('27', '辛集市', '5', '0', '0', '115.20626', '37.94079');
INSERT INTO `counties` VALUES ('28', '新华区', '5', '0', '0', '114.46326', '38.05088');
INSERT INTO `counties` VALUES ('29', '新乐市', '5', '0', '0', '114.68985', '38.34417');
INSERT INTO `counties` VALUES ('30', '行唐县', '5', '0', '0', '114.55316', '38.43654');
INSERT INTO `counties` VALUES ('31', '裕华区', '5', '0', '0', '114.53115', '38.00604');
INSERT INTO `counties` VALUES ('32', '元氏县', '5', '0', '0', '114.52539', '37.76668');
INSERT INTO `counties` VALUES ('33', '赞皇县', '5', '0', '0', '114.38775', '37.66135');
INSERT INTO `counties` VALUES ('34', '赵县', '5', '0', '0', '114.77612', '37.75628');
INSERT INTO `counties` VALUES ('35', '正定县', '5', '0', '0', '114.57296', '38.14445');
INSERT INTO `counties` VALUES ('36', '藁城市', '5', '0', '0', '114.83', '38.03');
INSERT INTO `counties` VALUES ('37', '栾城县', '5', '0', '0', '114.65', '37.88');
INSERT INTO `counties` VALUES ('38', '肥乡县', '8', '0', '0', '114.79998', '36.54807');
INSERT INTO `counties` VALUES ('39', '峰峰矿区', '8', '0', '0', '114.21148', '36.41937');
INSERT INTO `counties` VALUES ('40', '成安县', '8', '0', '0', '114.66995', '36.44411');
INSERT INTO `counties` VALUES ('41', '磁县', '8', '0', '0', '114.37387', '36.37392');
INSERT INTO `counties` VALUES ('42', '丛台区', '8', '0', '0', '114.49343', '36.61847');
INSERT INTO `counties` VALUES ('43', '大名县', '8', '0', '0', '115.15362', '36.27994');
INSERT INTO `counties` VALUES ('44', '复兴区', '8', '0', '0', '114.45928', '36.61134');
INSERT INTO `counties` VALUES ('45', '馆陶县', '8', '0', '0', '115.29913', '36.53719');
INSERT INTO `counties` VALUES ('46', '广平县', '8', '0', '0', '114.94653', '36.48046');
INSERT INTO `counties` VALUES ('47', '邯郸县', '8', '0', '0', '114.53103', '36.59385');
INSERT INTO `counties` VALUES ('48', '邯山区', '8', '0', '0', '114.48375', '36.60006');
INSERT INTO `counties` VALUES ('49', '鸡泽县', '8', '0', '0', '114.8742', '36.92374');
INSERT INTO `counties` VALUES ('50', '临漳县', '8', '0', '0', '114.6195', '36.33461');
INSERT INTO `counties` VALUES ('51', '邱县', '8', '0', '0', '115.17407', '36.82082');
INSERT INTO `counties` VALUES ('52', '曲周县', '8', '0', '0', '114.95196', '36.77671');
INSERT INTO `counties` VALUES ('53', '涉县', '8', '0', '0', '113.69183', '36.58072');
INSERT INTO `counties` VALUES ('54', '魏县', '8', '0', '0', '114.93518', '36.36171');
INSERT INTO `counties` VALUES ('55', '武安市', '8', '0', '0', '114.20153', '36.69281');
INSERT INTO `counties` VALUES ('56', '永年县', '8', '0', '0', '114.48925', '36.78356');
INSERT INTO `counties` VALUES ('57', '北戴河区', '7', '0', '0', '119.48388', '39.83408');
INSERT INTO `counties` VALUES ('58', '昌黎县', '7', '0', '0', '119.16595', '39.70884');
INSERT INTO `counties` VALUES ('59', '抚宁县', '7', '0', '0', '119.24487', '39.87538');
INSERT INTO `counties` VALUES ('60', '海港区', '7', '0', '0', '119.61046', '39.9345');
INSERT INTO `counties` VALUES ('61', '卢龙县', '7', '0', '0', '118.89288', '39.89176');
INSERT INTO `counties` VALUES ('62', '青龙满族自治县', '7', '0', '0', '118.95242', '40.40743');
INSERT INTO `counties` VALUES ('63', '山海关区', '7', '0', '0', '119.77563', '39.97869');
INSERT INTO `counties` VALUES ('64', '崇礼县', '11', '0', '0', '115.27993', '40.97519');
INSERT INTO `counties` VALUES ('65', '赤城县', '11', '0', '0', '115.83187', '40.91438');
INSERT INTO `counties` VALUES ('66', '沽源县', '11', '0', '0', '115.68859', '41.66959');
INSERT INTO `counties` VALUES ('67', '怀安县', '11', '0', '0', '114.38559', '40.67425');
INSERT INTO `counties` VALUES ('68', '怀来县', '11', '0', '0', '115.51773', '40.41536');
INSERT INTO `counties` VALUES ('69', '康保县', '11', '0', '0', '114.60031', '41.85225');
INSERT INTO `counties` VALUES ('70', '桥东区', '11', '0', '0', '114.50725', '37.06801');
INSERT INTO `counties` VALUES ('71', '桥西区', '11', '0', '0', '114.46977', '38.03221');
INSERT INTO `counties` VALUES ('72', '尚义县', '11', '0', '0', '113.97134', '41.07782');
INSERT INTO `counties` VALUES ('73', '万全县', '11', '0', '0', '114.7405', '40.76694');
INSERT INTO `counties` VALUES ('74', '蔚县', '11', '0', '0', '114.58892', '39.84067');
INSERT INTO `counties` VALUES ('75', '下花园区', '11', '0', '0', '115.28744', '40.50236');
INSERT INTO `counties` VALUES ('76', '宣化区', '11', '0', '0', '115.06543', '40.60957');
INSERT INTO `counties` VALUES ('77', '宣化县', '11', '0', '0', '115.15497', '40.56618');
INSERT INTO `counties` VALUES ('78', '阳原县', '11', '0', '0', '114.15051', '40.10361');
INSERT INTO `counties` VALUES ('79', '张北县', '11', '0', '0', '114.71432', '41.15977');
INSERT INTO `counties` VALUES ('80', '涿鹿县', '11', '0', '0', '115.22403', '40.37636');
INSERT INTO `counties` VALUES ('81', '桥西区', '9', '0', '0', '114.46977', '38.03221');
INSERT INTO `counties` VALUES ('82', '柏乡县', '9', '0', '0', '114.69332', '37.48242');
INSERT INTO `counties` VALUES ('83', '广宗县', '9', '0', '0', '115.14254', '37.0746');
INSERT INTO `counties` VALUES ('84', '巨鹿县', '9', '0', '0', '115.03524', '37.21801');
INSERT INTO `counties` VALUES ('85', '临城县', '9', '0', '0', '114.50387', '37.43977');
INSERT INTO `counties` VALUES ('86', '临西县', '9', '0', '0', '115.50097', '36.87078');
INSERT INTO `counties` VALUES ('87', '隆尧县', '9', '0', '0', '114.77615', '37.35351');
INSERT INTO `counties` VALUES ('88', '清河县', '9', '0', '0', '115.66479', '37.07122');
INSERT INTO `counties` VALUES ('89', '南宫市', '9', '0', '0', '115.39068', '37.35799');
INSERT INTO `counties` VALUES ('90', '南和县', '9', '0', '0', '114.68371', '37.00488');
INSERT INTO `counties` VALUES ('91', '内丘县', '9', '0', '0', '114.51212', '37.28671');
INSERT INTO `counties` VALUES ('92', '宁晋县', '9', '0', '0', '114.92117', '37.61696');
INSERT INTO `counties` VALUES ('93', '平乡县', '9', '0', '0', '115.03002', '37.06317');
INSERT INTO `counties` VALUES ('94', '桥东区', '9', '0', '0', '114.50725', '37.06801');
INSERT INTO `counties` VALUES ('95', '任县', '9', '0', '0', '114.6842', '37.12575');
INSERT INTO `counties` VALUES ('96', '沙河市', '9', '0', '0', '114.4981', '36.8577');
INSERT INTO `counties` VALUES ('97', '威县', '9', '0', '0', '115.2637', '36.9768');
INSERT INTO `counties` VALUES ('98', '新河县', '9', '0', '0', '115.24987', '37.52718');
INSERT INTO `counties` VALUES ('99', '邢台县', '9', '0', '0', '114.56575', '37.0456');
INSERT INTO `counties` VALUES ('100', '鹰手营子矿区', '12', '0', '0', '117.65985', '40.54744');
INSERT INTO `counties` VALUES ('101', '双桥区', '12', '0', '0', '117.9432', '40.97466');
INSERT INTO `counties` VALUES ('102', '围场满族蒙古族自治县', '12', '0', '0', '117.7601', '41.94368');
INSERT INTO `counties` VALUES ('103', '承德县', '12', '0', '0', '118.17639', '40.76985');
INSERT INTO `counties` VALUES ('104', '丰宁满族自治县', '12', '0', '0', '116.6492', '41.20481');
INSERT INTO `counties` VALUES ('105', '宽城满族自治县', '12', '0', '0', '118.49176', '40.60829');
INSERT INTO `counties` VALUES ('106', '隆化县', '12', '0', '0', '117.7297', '41.31412');
INSERT INTO `counties` VALUES ('107', '滦平县', '12', '0', '0', '117.33276', '40.94148');
INSERT INTO `counties` VALUES ('108', '平泉县', '12', '0', '0', '118.70196', '41.01839');
INSERT INTO `counties` VALUES ('109', '双滦区', '12', '0', '0', '117.74487', '40.95375');
INSERT INTO `counties` VALUES ('110', '兴隆县', '12', '0', '0', '117.50073', '40.41709');
INSERT INTO `counties` VALUES ('111', '阜平县', '10', '0', '0', '114.19683', '38.84763');
INSERT INTO `counties` VALUES ('112', '高碑店市', '10', '0', '0', '115.87368', '39.32655');
INSERT INTO `counties` VALUES ('113', '安国市', '10', '0', '0', '115.32321', '38.41391');
INSERT INTO `counties` VALUES ('114', '安新县', '10', '0', '0', '115.93557', '38.93532');
INSERT INTO `counties` VALUES ('115', '北市区', '10', '0', '0', '115.48', '38.87');
INSERT INTO `counties` VALUES ('116', '博野县', '10', '0', '0', '115.47033', '38.4564');
INSERT INTO `counties` VALUES ('117', '定兴县', '10', '0', '0', '115.80786', '39.26312');
INSERT INTO `counties` VALUES ('118', '定州市', '10', '0', '0', '114.9902', '38.51623');
INSERT INTO `counties` VALUES ('119', '高阳县', '10', '0', '0', '115.7788', '38.70003');
INSERT INTO `counties` VALUES ('120', '满城县', '10', '0', '0', '115.32', '38.95');
INSERT INTO `counties` VALUES ('121', '南市区', '10', '0', '0', '115.50', '38.85');
INSERT INTO `counties` VALUES ('122', '清苑县', '10', '0', '0', '115.48', '38.77');
INSERT INTO `counties` VALUES ('123', '曲阳县', '10', '0', '0', '114.70123', '38.62154');
INSERT INTO `counties` VALUES ('124', '容城县', '10', '0', '0', '115.87158', '39.0535');
INSERT INTO `counties` VALUES ('125', '顺平县', '10', '0', '0', '115.1347', '38.83854');
INSERT INTO `counties` VALUES ('126', '唐县', '10', '0', '0', '114.98516', '38.74513');
INSERT INTO `counties` VALUES ('127', '望都县', '10', '0', '0', '115.1567', '38.70996');
INSERT INTO `counties` VALUES ('128', '新市区', '10', '0', '0', '87.57406', '43.84348');
INSERT INTO `counties` VALUES ('129', '雄县', '10', '0', '0', '116.10873', '38.99442');
INSERT INTO `counties` VALUES ('130', '徐水县', '10', '0', '0', '115.65', '39.02');
INSERT INTO `counties` VALUES ('131', '易县', '10', '0', '0', '115.4981', '39.34885');
INSERT INTO `counties` VALUES ('132', '涞水县', '10', '0', '0', '115.71517', '39.39404');
INSERT INTO `counties` VALUES ('133', '涞源县', '10', '0', '0', '114.69128', '39.35388');
INSERT INTO `counties` VALUES ('134', '涿州市', '10', '0', '0', '115.98062', '39.48622');
INSERT INTO `counties` VALUES ('135', '蠡县', '10', '0', '0', '115.57717', '38.48974');
INSERT INTO `counties` VALUES ('136', '安次区', '14', '0', '0', '116.70308', '39.52057');
INSERT INTO `counties` VALUES ('137', '霸州市', '14', '0', '0', '116.39154', '39.12569');
INSERT INTO `counties` VALUES ('138', '大厂回族自治县', '14', '0', '0', '116.98916', '39.88649');
INSERT INTO `counties` VALUES ('139', '大城县', '14', '0', '0', '116.65353', '38.70534');
INSERT INTO `counties` VALUES ('140', '固安县', '14', '0', '0', '116.29916', '39.43833');
INSERT INTO `counties` VALUES ('141', '广阳区', '14', '0', '0', '116.71069', '39.52278');
INSERT INTO `counties` VALUES ('142', '三河市', '14', '0', '0', '117.07229', '39.98358');
INSERT INTO `counties` VALUES ('143', '文安县', '14', '0', '0', '116.45846', '38.87325');
INSERT INTO `counties` VALUES ('144', '香河县', '14', '0', '0', '117.00634', '39.76133');
INSERT INTO `counties` VALUES ('145', '永清县', '14', '0', '0', '116.50091', '39.32069');
INSERT INTO `counties` VALUES ('146', '小店区', '16', '0', '0', '112.56878', '37.73565');
INSERT INTO `counties` VALUES ('147', '杏花岭区', '16', '0', '0', '112.56237', '37.88429');
INSERT INTO `counties` VALUES ('148', '万柏林区', '16', '0', '0', '112.51553', '37.85923');
INSERT INTO `counties` VALUES ('149', '古交市', '16', '0', '0', '112.16918', '37.90983');
INSERT INTO `counties` VALUES ('150', '尖草坪区', '16', '0', '0', '112.48709', '37.94193');
INSERT INTO `counties` VALUES ('151', '晋源区', '16', '0', '0', '112.47985', '37.72479');
INSERT INTO `counties` VALUES ('152', '娄烦县', '16', '0', '0', '111.79473', '38.06689');
INSERT INTO `counties` VALUES ('153', '清徐县', '16', '0', '0', '112.35888', '37.60758');
INSERT INTO `counties` VALUES ('154', '阳曲县', '16', '0', '0', '112.67861', '38.05989');
INSERT INTO `counties` VALUES ('155', '迎泽区', '16', '0', '0', '112.56338', '37.86326');
INSERT INTO `counties` VALUES ('156', '景县', '15', '0', '0', '116.26904', '37.6926');
INSERT INTO `counties` VALUES ('157', '安平县', '15', '0', '0', '115.51876', '38.23388');
INSERT INTO `counties` VALUES ('158', '阜城县', '15', '0', '0', '116.14431', '37.86881');
INSERT INTO `counties` VALUES ('159', '故城县', '15', '0', '0', '115.97076', '37.34773');
INSERT INTO `counties` VALUES ('160', '冀州市', '15', '0', '0', '115.57934', '37.55082');
INSERT INTO `counties` VALUES ('161', '饶阳县', '15', '0', '0', '115.72558', '38.23529');
INSERT INTO `counties` VALUES ('162', '深州市', '15', '0', '0', '115.55993', '38.00109');
INSERT INTO `counties` VALUES ('163', '桃城区', '15', '0', '0', '115.67529', '37.73499');
INSERT INTO `counties` VALUES ('164', '武强县', '15', '0', '0', '115.98226', '38.04138');
INSERT INTO `counties` VALUES ('165', '武邑县', '15', '0', '0', '115.88748', '37.80181');
INSERT INTO `counties` VALUES ('166', '枣强县', '15', '0', '0', '115.72576', '37.51027');
INSERT INTO `counties` VALUES ('167', '泊头市', '13', '0', '0', '116.57824', '38.08359');
INSERT INTO `counties` VALUES ('168', '沧县', '13', '0', '0', '116.87817', '38.29361');
INSERT INTO `counties` VALUES ('169', '东光县', '13', '0', '0', '116.53668', '37.8857');
INSERT INTO `counties` VALUES ('170', '海兴县', '13', '0', '0', '117.49758', '38.13958');
INSERT INTO `counties` VALUES ('171', '河间市', '13', '0', '0', '116.0993', '38.44549');
INSERT INTO `counties` VALUES ('172', '黄骅市', '13', '0', '0', '117.33883', '38.3706');
INSERT INTO `counties` VALUES ('173', '孟村回族自治县', '13', '0', '0', '117.10412', '38.05338');
INSERT INTO `counties` VALUES ('174', '南皮县', '13', '0', '0', '116.70224', '38.04109');
INSERT INTO `counties` VALUES ('175', '青县', '13', '0', '0', '116.80316', '38.58345');
INSERT INTO `counties` VALUES ('176', '任丘市', '13', '0', '0', '116.1033', '38.71124');
INSERT INTO `counties` VALUES ('177', '肃宁县', '13', '0', '0', '115.82971', '38.42272');
INSERT INTO `counties` VALUES ('178', '吴桥县', '13', '0', '0', '116.3847', '37.62546');
INSERT INTO `counties` VALUES ('179', '献县', '13', '0', '0', '116.12695', '38.19228');
INSERT INTO `counties` VALUES ('180', '新华区', '13', '0', '0', '114.46326', '38.05088');
INSERT INTO `counties` VALUES ('181', '盐山县', '13', '0', '0', '117.23092', '38.05647');
INSERT INTO `counties` VALUES ('182', '运河区', '13', '0', '0', '116.85706', '38.31352');
INSERT INTO `counties` VALUES ('183', '浑源县', '17', '0', '0', '113.69552', '39.69962');
INSERT INTO `counties` VALUES ('184', '灵丘县', '17', '0', '0', '114.23672', '39.44043');
INSERT INTO `counties` VALUES ('185', '大同县', '17', '0', '0', '113.61212', '40.04012');
INSERT INTO `counties` VALUES ('186', '广灵县', '17', '0', '0', '114.28204', '39.76082');
INSERT INTO `counties` VALUES ('187', '天镇县', '17', '0', '0', '114.0931', '40.42299');
INSERT INTO `counties` VALUES ('188', '新荣区', '17', '0', '0', '113.13504', '40.25618');
INSERT INTO `counties` VALUES ('189', '阳高县', '17', '0', '0', '113.75012', '40.36256');
INSERT INTO `counties` VALUES ('190', '左云县', '17', '0', '0', '112.70266', '40.01336');
INSERT INTO `counties` VALUES ('191', '南郊区', '17', '0', '0', '113.14947', '40.00539');
INSERT INTO `counties` VALUES ('192', '城区', '17', '0', '0', '113.298', '40.07566');
INSERT INTO `counties` VALUES ('193', '城区', '18', '0', '0', '113.298', '40.07566');
INSERT INTO `counties` VALUES ('194', '郊区', '18', '0', '0', '113.58539', '37.94139');
INSERT INTO `counties` VALUES ('195', '矿区', '18', '0', '0', '113.1772', '40.03685');
INSERT INTO `counties` VALUES ('196', '平定县', '18', '0', '0', '113.65789', '37.78601');
INSERT INTO `counties` VALUES ('197', '盂县', '18', '0', '0', '113.41235', '38.08579');
INSERT INTO `counties` VALUES ('198', '长治县', '19', '0', '0', '113.04791', '36.04722');
INSERT INTO `counties` VALUES ('199', '长子县', '19', '0', '0', '112.87731', '36.12125');
INSERT INTO `counties` VALUES ('200', '城区', '19', '0', '0', '113.298', '40.07566');
INSERT INTO `counties` VALUES ('201', '壶关县', '19', '0', '0', '113.207', '36.11301');
INSERT INTO `counties` VALUES ('202', '郊区', '19', '0', '0', '113.58539', '37.94139');
INSERT INTO `counties` VALUES ('203', '黎城县', '19', '0', '0', '113.38766', '36.50301');
INSERT INTO `counties` VALUES ('204', '潞城市', '19', '0', '0', '113.22888', '36.33414');
INSERT INTO `counties` VALUES ('205', '平顺县', '19', '0', '0', '113.43603', '36.20005');
INSERT INTO `counties` VALUES ('206', '沁县', '19', '0', '0', '112.69863', '36.75628');
INSERT INTO `counties` VALUES ('207', '沁源县', '19', '0', '0', '112.33758', '36.50008');
INSERT INTO `counties` VALUES ('208', '屯留县', '19', '0', '0', '112.89196', '36.31579');
INSERT INTO `counties` VALUES ('209', '武乡县', '19', '0', '0', '112.86343', '36.83687');
INSERT INTO `counties` VALUES ('210', '襄垣县', '19', '0', '0', '113.05157', '36.53527');
INSERT INTO `counties` VALUES ('211', '城区', '20', '0', '0', '113.298', '40.07566');
INSERT INTO `counties` VALUES ('212', '高平市', '20', '0', '0', '112.92288', '35.79705');
INSERT INTO `counties` VALUES ('213', '陵川县', '20', '0', '0', '113.2806', '35.77532');
INSERT INTO `counties` VALUES ('214', '沁水县', '20', '0', '0', '112.1871', '35.69102');
INSERT INTO `counties` VALUES ('215', '阳城县', '20', '0', '0', '112.41485', '35.48614');
INSERT INTO `counties` VALUES ('216', '泽州县', '20', '0', '0', '112.83947', '35.50789');
INSERT INTO `counties` VALUES ('217', '和顺县', '22', '0', '0', '113.56988', '37.32963');
INSERT INTO `counties` VALUES ('218', '介休市', '22', '0', '0', '111.91824', '37.02771');
INSERT INTO `counties` VALUES ('219', '灵石县', '22', '0', '0', '111.7774', '36.84814');
INSERT INTO `counties` VALUES ('220', '平遥县', '22', '0', '0', '112.17553', '37.1892');
INSERT INTO `counties` VALUES ('221', '祁县', '22', '0', '0', '112.33358', '37.3579');
INSERT INTO `counties` VALUES ('222', '寿阳县', '22', '0', '0', '113.17495', '37.88899');
INSERT INTO `counties` VALUES ('223', '太谷县', '22', '0', '0', '112.55246', '37.42161');
INSERT INTO `counties` VALUES ('224', '昔阳县', '22', '0', '0', '113.70517', '37.61863');
INSERT INTO `counties` VALUES ('225', '榆次区', '22', '0', '0', '112.70788', '37.6978');
INSERT INTO `counties` VALUES ('226', '榆社县', '22', '0', '0', '112.97558', '37.0721');
INSERT INTO `counties` VALUES ('227', '左权县', '22', '0', '0', '113.37918', '37.08235');
INSERT INTO `counties` VALUES ('228', '新绛县', '23', '0', '0', '111.22509', '35.61566');
INSERT INTO `counties` VALUES ('229', '河津市', '23', '0', '0', '110.7116', '35.59478');
INSERT INTO `counties` VALUES ('230', '临猗县', '23', '0', '0', '110.77432', '35.14455');
INSERT INTO `counties` VALUES ('231', '平陆县', '23', '0', '0', '111.21704', '34.83772');
INSERT INTO `counties` VALUES ('232', '万荣县', '23', '0', '0', '110.83657', '35.41556');
INSERT INTO `counties` VALUES ('233', '闻喜县', '23', '0', '0', '111.22265', '35.35553');
INSERT INTO `counties` VALUES ('234', '夏县', '23', '0', '0', '111.21966', '35.14121');
INSERT INTO `counties` VALUES ('235', '盐湖区', '23', '0', '0', '110.99827', '35.0151');
INSERT INTO `counties` VALUES ('236', '永济市', '23', '0', '0', '110.44537', '34.86556');
INSERT INTO `counties` VALUES ('237', '垣曲县', '23', '0', '0', '111.67166', '35.29923');
INSERT INTO `counties` VALUES ('238', '芮城县', '23', '0', '0', '110.69455', '34.69384');
INSERT INTO `counties` VALUES ('239', '绛县', '23', '0', '0', '111.56668', '35.49096');
INSERT INTO `counties` VALUES ('240', '稷山县', '23', '0', '0', '110.97924', '35.59993');
INSERT INTO `counties` VALUES ('241', '怀仁县', '21', '0', '0', '113.10009', '39.82806');
INSERT INTO `counties` VALUES ('242', '平鲁区', '21', '0', '0', '112.28833', '39.51155');
INSERT INTO `counties` VALUES ('243', '山阴县', '21', '0', '0', '112.81662', '39.52697');
INSERT INTO `counties` VALUES ('244', '朔城区', '21', '0', '0', '112.43189', '39.31982');
INSERT INTO `counties` VALUES ('245', '应县', '21', '0', '0', '113.19052', '39.55279');
INSERT INTO `counties` VALUES ('246', '右玉县', '21', '0', '0', '112.46902', '39.99011');
INSERT INTO `counties` VALUES ('247', '保德县', '24', '0', '0', '111.08656', '39.02248');
INSERT INTO `counties` VALUES ('248', '静乐县', '24', '0', '0', '111.94158', '38.3602');
INSERT INTO `counties` VALUES ('249', '代县', '24', '0', '0', '112.95913', '39.06717');
INSERT INTO `counties` VALUES ('250', '定襄县', '24', '0', '0', '112.95733', '38.47387');
INSERT INTO `counties` VALUES ('251', '繁峙县', '24', '0', '0', '113.26303', '39.18886');
INSERT INTO `counties` VALUES ('252', '河曲县', '24', '0', '0', '111.13821', '39.38439');
INSERT INTO `counties` VALUES ('253', '宁武县', '24', '0', '0', '112.30423', '39.00211');
INSERT INTO `counties` VALUES ('254', '偏关县', '24', '0', '0', '111.50863', '39.43609');
INSERT INTO `counties` VALUES ('255', '神池县', '24', '0', '0', '112.20541', '39.09');
INSERT INTO `counties` VALUES ('256', '五台县', '24', '0', '0', '113.25256', '38.72774');
INSERT INTO `counties` VALUES ('257', '五寨县', '24', '0', '0', '111.8489', '38.90757');
INSERT INTO `counties` VALUES ('258', '忻府区', '24', '0', '0', '112.74603', '38.40414');
INSERT INTO `counties` VALUES ('259', '原平市', '24', '0', '0', '112.70584', '38.73181');
INSERT INTO `counties` VALUES ('260', '岢岚县', '24', '0', '0', '111.57388', '38.70452');
INSERT INTO `counties` VALUES ('261', '侯马市', '25', '0', '0', '111.37207', '35.61903');
INSERT INTO `counties` VALUES ('262', '洪洞县', '25', '0', '0', '111.67501', '36.25425');
INSERT INTO `counties` VALUES ('263', '安泽县', '25', '0', '0', '112.24981', '36.14803');
INSERT INTO `counties` VALUES ('264', '大宁县', '25', '0', '0', '110.75216', '36.46624');
INSERT INTO `counties` VALUES ('265', '汾西县', '25', '0', '0', '111.56811', '36.65063');
INSERT INTO `counties` VALUES ('266', '浮山县', '25', '0', '0', '111.84744', '35.96854');
INSERT INTO `counties` VALUES ('267', '古县', '25', '0', '0', '111.92041', '36.26688');
INSERT INTO `counties` VALUES ('268', '霍州市', '25', '0', '0', '111.755', '36.5638');
INSERT INTO `counties` VALUES ('269', '吉县', '25', '0', '0', '110.68148', '36.09873');
INSERT INTO `counties` VALUES ('270', '蒲县', '25', '0', '0', '111.09674', '36.41243');
INSERT INTO `counties` VALUES ('271', '曲沃县', '25', '0', '0', '111.47525', '35.64119');
INSERT INTO `counties` VALUES ('272', '襄汾县', '25', '0', '0', '111.44204', '35.87711');
INSERT INTO `counties` VALUES ('273', '乡宁县', '25', '0', '0', '110.84652', '35.97072');
INSERT INTO `counties` VALUES ('274', '尧都区', '25', '0', '0', '111.5787', '36.08298');
INSERT INTO `counties` VALUES ('275', '翼城县', '25', '0', '0', '111.7181', '35.73881');
INSERT INTO `counties` VALUES ('276', '永和县', '25', '0', '0', '110.63168', '36.7584');
INSERT INTO `counties` VALUES ('277', '隰县', '25', '0', '0', '110.93881', '36.69258');
INSERT INTO `counties` VALUES ('278', '和林格尔县', '27', '0', '0', '111.82205', '40.37892');
INSERT INTO `counties` VALUES ('279', '回民区', '27', '0', '0', '111.62402', '40.80827');
INSERT INTO `counties` VALUES ('280', '清水河县', '27', '0', '0', '111.68316', '39.9097');
INSERT INTO `counties` VALUES ('281', '赛罕区', '27', '0', '0', '111.70224', '40.79207');
INSERT INTO `counties` VALUES ('282', '土默特左旗', '27', '0', '0', '111.14898', '40.72229');
INSERT INTO `counties` VALUES ('283', '托克托县', '27', '0', '0', '111.19101', '40.27492');
INSERT INTO `counties` VALUES ('284', '武川县', '27', '0', '0', '111.45785', '41.09289');
INSERT INTO `counties` VALUES ('285', '新城区', '27', '0', '0', '111.66554', '40.85828');
INSERT INTO `counties` VALUES ('286', '玉泉区', '27', '0', '0', '111.67456', '40.75227');
INSERT INTO `counties` VALUES ('287', '交城县', '26', '0', '0', '112.1585', '37.5512');
INSERT INTO `counties` VALUES ('288', '方山县', '26', '0', '0', '111.24011', '37.88979');
INSERT INTO `counties` VALUES ('289', '汾阳市', '26', '0', '0', '111.7882', '37.26605');
INSERT INTO `counties` VALUES ('290', '文水县', '26', '0', '0', '112.02829', '37.43841');
INSERT INTO `counties` VALUES ('291', '交口县', '26', '0', '0', '111.18103', '36.98213');
INSERT INTO `counties` VALUES ('292', '离石区', '26', '0', '0', '111.15059', '37.5177');
INSERT INTO `counties` VALUES ('293', '临县', '26', '0', '0', '110.99282', '37.95271');
INSERT INTO `counties` VALUES ('294', '柳林县', '26', '0', '0', '110.88922', '37.42932');
INSERT INTO `counties` VALUES ('295', '石楼县', '26', '0', '0', '110.8352', '36.99731');
INSERT INTO `counties` VALUES ('296', '孝义市', '26', '0', '0', '111.77362', '37.14414');
INSERT INTO `counties` VALUES ('297', '兴县', '26', '0', '0', '111.12692', '38.46321');
INSERT INTO `counties` VALUES ('298', '中阳县', '26', '0', '0', '111.1795', '37.35715');
INSERT INTO `counties` VALUES ('299', '岚县', '26', '0', '0', '111.67627', '38.27874');
INSERT INTO `counties` VALUES ('300', '东河区', '28', '0', '0', '110.0462', '40.58237');
INSERT INTO `counties` VALUES ('301', '白云鄂博矿区', '28', '0', '0', '109.97367', '41.76968');
INSERT INTO `counties` VALUES ('302', '达尔罕茂明安联合旗', '28', '0', '0', '110.43258', '41.69875');
INSERT INTO `counties` VALUES ('303', '固阳县', '28', '0', '0', '110.06372', '41.01851');
INSERT INTO `counties` VALUES ('304', '九原区', '28', '0', '0', '109.96496', '40.60554');
INSERT INTO `counties` VALUES ('305', '昆都仑区', '28', '0', '0', '109.83862', '40.64175');
INSERT INTO `counties` VALUES ('306', '青山区', '28', '0', '0', '109.90131', '40.64329');
INSERT INTO `counties` VALUES ('307', '石拐区', '28', '0', '0', '110.27322', '40.67297');
INSERT INTO `counties` VALUES ('308', '土默特右旗', '28', '0', '0', '110.52417', '40.5688');
INSERT INTO `counties` VALUES ('309', '林西县', '30', '0', '0', '118.04733', '43.61165');
INSERT INTO `counties` VALUES ('310', '阿鲁科尔沁旗', '30', '0', '0', '120.06527', '43.87988');
INSERT INTO `counties` VALUES ('311', '敖汉旗', '30', '0', '0', '119.92163', '42.29071');
INSERT INTO `counties` VALUES ('312', '巴林右旗', '30', '0', '0', '118.66461', '43.53387');
INSERT INTO `counties` VALUES ('313', '巴林左旗', '30', '0', '0', '119.38012', '43.97031');
INSERT INTO `counties` VALUES ('314', '红山区', '30', '0', '0', '118.95755', '42.24312');
INSERT INTO `counties` VALUES ('315', '喀喇沁旗', '30', '0', '0', '118.70144', '41.92917');
INSERT INTO `counties` VALUES ('316', '克什克腾旗', '30', '0', '0', '117.54562', '43.26501');
INSERT INTO `counties` VALUES ('317', '宁城县', '30', '0', '0', '119.34375', '41.59661');
INSERT INTO `counties` VALUES ('318', '松山区', '30', '0', '0', '118.9328', '42.28613');
INSERT INTO `counties` VALUES ('319', '翁牛特旗', '30', '0', '0', '119.03042', '42.93147');
INSERT INTO `counties` VALUES ('320', '元宝山区', '30', '0', '0', '119.28921', '42.04005');
INSERT INTO `counties` VALUES ('321', '海勃湾区', '29', '0', '0', '106.8222', '39.66955');
INSERT INTO `counties` VALUES ('322', '海南区', '29', '0', '0', '106.88656', '39.44128');
INSERT INTO `counties` VALUES ('323', '乌达区', '29', '0', '0', '106.72723', '39.505');
INSERT INTO `counties` VALUES ('324', '霍林郭勒市', '31', '0', '0', '119.65429', '45.53454');
INSERT INTO `counties` VALUES ('325', '开鲁县', '31', '0', '0', '121.31884', '43.60003');
INSERT INTO `counties` VALUES ('326', '科尔沁区', '31', '0', '0', '122.25573', '43.62257');
INSERT INTO `counties` VALUES ('327', '科尔沁左翼后旗', '31', '0', '0', '122.35745', '42.94897');
INSERT INTO `counties` VALUES ('328', '科尔沁左翼中旗', '31', '0', '0', '123.31912', '44.13014');
INSERT INTO `counties` VALUES ('329', '库伦旗', '31', '0', '0', '121.776', '42.72998');
INSERT INTO `counties` VALUES ('330', '奈曼旗', '31', '0', '0', '120.66348', '42.84527');
INSERT INTO `counties` VALUES ('331', '扎鲁特旗', '31', '0', '0', '120.91507', '44.55592');
INSERT INTO `counties` VALUES ('332', '东胜区', '32', '0', '0', '109.96289', '39.82236');
INSERT INTO `counties` VALUES ('333', '鄂托克旗', '32', '0', '0', '107.98226', '39.09456');
INSERT INTO `counties` VALUES ('334', '达拉特旗', '32', '0', '0', '110.03317', '40.4001');
INSERT INTO `counties` VALUES ('335', '鄂托克前旗', '32', '0', '0', '107.48403', '38.18396');
INSERT INTO `counties` VALUES ('336', '杭锦旗', '32', '0', '0', '108.72934', '39.84023');
INSERT INTO `counties` VALUES ('337', '乌审旗', '32', '0', '0', '108.8461', '38.59092');
INSERT INTO `counties` VALUES ('338', '伊金霍洛旗', '32', '0', '0', '109.74908', '39.57393');
INSERT INTO `counties` VALUES ('339', '准格尔旗', '32', '0', '0', '111.23645', '39.86783');
INSERT INTO `counties` VALUES ('340', '阿荣旗', '33', '0', '0', '123.45941', '48.12581');
INSERT INTO `counties` VALUES ('341', '陈巴尔虎旗', '33', '0', '0', '119.42434', '49.32684');
INSERT INTO `counties` VALUES ('342', '额尔古纳市', '33', '0', '0', '120.19094', '50.24249');
INSERT INTO `counties` VALUES ('343', '鄂伦春自治旗', '33', '0', '0', '123.72604', '50.59777');
INSERT INTO `counties` VALUES ('344', '鄂温克族自治旗', '33', '0', '0', '119.7565', '49.14284');
INSERT INTO `counties` VALUES ('345', '根河市', '33', '0', '0', '121.52197', '50.77996');
INSERT INTO `counties` VALUES ('346', '海拉尔区', '33', '0', '0', '119.7364', '49.2122');
INSERT INTO `counties` VALUES ('347', '满洲里市', '33', '0', '0', '117.47946', '49.58272');
INSERT INTO `counties` VALUES ('348', '莫力达瓦达斡尔族自治旗', '33', '0', '0', '124.51498', '48.48055');
INSERT INTO `counties` VALUES ('349', '新巴尔虎右旗', '33', '0', '0', '116.82366', '48.66473');
INSERT INTO `counties` VALUES ('350', '新巴尔虎左旗', '33', '0', '0', '118.26989', '48.21842');
INSERT INTO `counties` VALUES ('351', '牙克石市', '33', '0', '0', '120.7117', '49.2856');
INSERT INTO `counties` VALUES ('352', '扎兰屯市', '33', '0', '0', '122.73757', '48.01363');
INSERT INTO `counties` VALUES ('353', '杭锦后旗', '34', '0', '0', '107.15133', '40.88627');
INSERT INTO `counties` VALUES ('354', '临河区', '34', '0', '0', '107.42668', '40.75827');
INSERT INTO `counties` VALUES ('355', '乌拉特后旗', '34', '0', '0', '106.98971', '41.43151');
INSERT INTO `counties` VALUES ('356', '乌拉特前旗', '34', '0', '0', '108.65219', '40.73649');
INSERT INTO `counties` VALUES ('357', '乌拉特中旗', '34', '0', '0', '108.52587', '41.56789');
INSERT INTO `counties` VALUES ('358', '五原县', '34', '0', '0', '108.26916', '41.09631');
INSERT INTO `counties` VALUES ('359', '磴口县', '34', '0', '0', '107.00936', '40.33062');
INSERT INTO `counties` VALUES ('360', '阿尔山市', '36', '0', '0', '119.94317', '47.17716');
INSERT INTO `counties` VALUES ('361', '科尔沁右翼前旗', '36', '0', '0', '121.95269', '46.0795');
INSERT INTO `counties` VALUES ('362', '科尔沁右翼中旗', '36', '0', '0', '121.46807', '45.05605');
INSERT INTO `counties` VALUES ('363', '突泉县', '36', '0', '0', '121.59396', '45.38187');
INSERT INTO `counties` VALUES ('364', '乌兰浩特市', '36', '0', '0', '122.06378', '46.06235');
INSERT INTO `counties` VALUES ('365', '扎赉特旗', '36', '0', '0', '122.91229', '46.7267');
INSERT INTO `counties` VALUES ('366', '阿巴嘎旗', '37', '0', '0', '114.96826', '44.02174');
INSERT INTO `counties` VALUES ('367', '东乌珠穆沁旗', '37', '0', '0', '116.97293', '45.51108');
INSERT INTO `counties` VALUES ('368', '多伦县', '37', '0', '0', '116.48565', '42.203');
INSERT INTO `counties` VALUES ('369', '二连浩特市', '37', '0', '0', '111.98297', '43.65303');
INSERT INTO `counties` VALUES ('370', '苏尼特右旗', '37', '0', '0', '112.65741', '42.7469');
INSERT INTO `counties` VALUES ('371', '苏尼特左旗', '37', '0', '0', '113.6506', '43.85687');
INSERT INTO `counties` VALUES ('372', '太仆寺旗', '37', '0', '0', '115.28302', '41.87727');
INSERT INTO `counties` VALUES ('373', '西乌珠穆沁旗', '37', '0', '0', '117.60983', '44.59623');
INSERT INTO `counties` VALUES ('374', '锡林浩特市', '37', '0', '0', '116.08603', '43.93341');
INSERT INTO `counties` VALUES ('375', '镶黄旗', '37', '0', '0', '113.84472', '42.23927');
INSERT INTO `counties` VALUES ('376', '正蓝旗', '37', '0', '0', '116.00363', '42.25229');
INSERT INTO `counties` VALUES ('377', '正镶白旗', '37', '0', '0', '115.00067', '42.30712');
INSERT INTO `counties` VALUES ('378', '四子王旗', '35', '0', '0', '111.70654', '41.53312');
INSERT INTO `counties` VALUES ('379', '兴和县', '35', '0', '0', '113.83395', '40.87186');
INSERT INTO `counties` VALUES ('380', '卓资县', '35', '0', '0', '112.57757', '40.89414');
INSERT INTO `counties` VALUES ('381', '察哈尔右翼后旗', '35', '0', '0', '113.19216', '41.43554');
INSERT INTO `counties` VALUES ('382', '察哈尔右翼前旗', '35', '0', '0', '113.22131', '40.7788');
INSERT INTO `counties` VALUES ('383', '察哈尔右翼中旗', '35', '0', '0', '112.63537', '41.27742');
INSERT INTO `counties` VALUES ('384', '丰镇市', '35', '0', '0', '113.10983', '40.4369');
INSERT INTO `counties` VALUES ('385', '化德县', '35', '0', '0', '114.01071', '41.90433');
INSERT INTO `counties` VALUES ('386', '集宁区', '35', '0', '0', '113.11452', '41.0353');
INSERT INTO `counties` VALUES ('387', '凉城县', '35', '0', '0', '112.49569', '40.53346');
INSERT INTO `counties` VALUES ('388', '商都县', '35', '0', '0', '113.57772', '41.56213');
INSERT INTO `counties` VALUES ('389', '皇姑区', '39', '0', '0', '123.42527', '41.82035');
INSERT INTO `counties` VALUES ('390', '大东区', '39', '0', '0', '123.46997', '41.80539');
INSERT INTO `counties` VALUES ('391', '东陵区', '39', '0', '0', '123.47', '41.77');
INSERT INTO `counties` VALUES ('392', '法库县', '39', '0', '0', '123.41214', '42.50608');
INSERT INTO `counties` VALUES ('393', '和平区', '39', '0', '0', '117.21456', '39.11718');
INSERT INTO `counties` VALUES ('394', '康平县', '39', '0', '0', '123.35446', '42.75081');
INSERT INTO `counties` VALUES ('395', '辽中县', '39', '0', '0', '122.72659', '41.51302');
INSERT INTO `counties` VALUES ('396', '沈北新区', '39', '0', '0', '123.52658', '42.05297');
INSERT INTO `counties` VALUES ('397', '沈河区', '39', '0', '0', '123.45871', '41.79625');
INSERT INTO `counties` VALUES ('398', '苏家屯区', '39', '0', '0', '123.34405', '41.66475');
INSERT INTO `counties` VALUES ('399', '铁西区', '39', '0', '0', '123.37675', '41.80269');
INSERT INTO `counties` VALUES ('400', '新民市', '39', '0', '0', '122.82867', '41.99847');
INSERT INTO `counties` VALUES ('401', '于洪区', '39', '0', '0', '123.30807', '41.794');
INSERT INTO `counties` VALUES ('402', '阿拉善左旗', '38', '0', '0', '105.67532', '38.8293');
INSERT INTO `counties` VALUES ('403', '阿拉善右旗', '38', '0', '0', '101.66705', '39.21533');
INSERT INTO `counties` VALUES ('404', '额济纳旗', '38', '0', '0', '101.06887', '41.96755');
INSERT INTO `counties` VALUES ('405', '望花区', '42', '0', '0', '123.78283', '41.85532');
INSERT INTO `counties` VALUES ('406', '新宾满族自治县', '42', '0', '0', '125.04049', '41.73409');
INSERT INTO `counties` VALUES ('407', '新抚区', '42', '0', '0', '123.91264', '41.86205');
INSERT INTO `counties` VALUES ('408', '东洲区', '42', '0', '0', '124.03759', '41.8519');
INSERT INTO `counties` VALUES ('409', '抚顺县', '42', '0', '0', '124.17755', '41.71217');
INSERT INTO `counties` VALUES ('410', '清原满族自治县', '42', '0', '0', '124.92807', '42.10221');
INSERT INTO `counties` VALUES ('411', '顺城区', '42', '0', '0', '123.94506', '41.88321');
INSERT INTO `counties` VALUES ('412', '海城市', '41', '0', '0', '122.68457', '40.88142');
INSERT INTO `counties` VALUES ('413', '立山区', '41', '0', '0', '123.02948', '41.15008');
INSERT INTO `counties` VALUES ('414', '千山区', '41', '0', '0', '122.96048', '41.07507');
INSERT INTO `counties` VALUES ('415', '台安县', '41', '0', '0', '122.43585', '41.41265');
INSERT INTO `counties` VALUES ('416', '铁东区', '41', '0', '0', '122.99085', '41.08975');
INSERT INTO `counties` VALUES ('417', '铁西区', '41', '0', '0', '123.37675', '41.80269');
INSERT INTO `counties` VALUES ('418', '岫岩满族自治县', '41', '0', '0', '123.28875', '40.27996');
INSERT INTO `counties` VALUES ('419', '西岗区', '40', '0', '0', '121.61238', '38.91469');
INSERT INTO `counties` VALUES ('420', '中山区', '40', '0', '0', '121.64465', '38.91859');
INSERT INTO `counties` VALUES ('421', '庄河市', '40', '0', '0', '122.96725', '39.68815');
INSERT INTO `counties` VALUES ('422', '长海县', '40', '0', '0', '122.58859', '39.27274');
INSERT INTO `counties` VALUES ('423', '甘井子区', '40', '0', '0', '121.56567', '38.95017');
INSERT INTO `counties` VALUES ('424', '金州区', '40', '0', '0', '121.71893', '39.1004');
INSERT INTO `counties` VALUES ('425', '旅顺口区', '40', '0', '0', '121.26202', '38.85125');
INSERT INTO `counties` VALUES ('426', '普兰店市', '40', '0', '0', '121.96316', '39.39465');
INSERT INTO `counties` VALUES ('427', '沙河口区', '40', '0', '0', '121.58017', '38.90536');
INSERT INTO `counties` VALUES ('428', '瓦房店市', '40', '0', '0', '121.98104', '39.62843');
INSERT INTO `counties` VALUES ('429', '本溪满族自治县', '43', '0', '0', '124.12741', '41.30059');
INSERT INTO `counties` VALUES ('430', '桓仁满族自治县', '43', '0', '0', '125.36062', '41.26798');
INSERT INTO `counties` VALUES ('431', '明山区', '43', '0', '0', '123.81746', '41.30827');
INSERT INTO `counties` VALUES ('432', '南芬区', '43', '0', '0', '123.74523', '41.1006');
INSERT INTO `counties` VALUES ('433', '平山区', '43', '0', '0', '123.76892', '41.2997');
INSERT INTO `counties` VALUES ('434', '溪湖区', '43', '0', '0', '123.76764', '41.32921');
INSERT INTO `counties` VALUES ('435', '东港市', '44', '0', '0', '124.16287', '39.86256');
INSERT INTO `counties` VALUES ('436', '凤城市', '44', '0', '0', '124.06671', '40.45302');
INSERT INTO `counties` VALUES ('437', '宽甸满族自治县', '44', '0', '0', '124.78247', '40.73187');
INSERT INTO `counties` VALUES ('438', '元宝区', '44', '0', '0', '124.39575', '40.13651');
INSERT INTO `counties` VALUES ('439', '振安区', '44', '0', '0', '124.42816', '40.15826');
INSERT INTO `counties` VALUES ('440', '振兴区', '44', '0', '0', '124.36035', '40.10489');
INSERT INTO `counties` VALUES ('441', '凌河区', '45', '0', '0', '121.15089', '41.11496');
INSERT INTO `counties` VALUES ('442', '古塔区', '45', '0', '0', '121.12832', '41.11725');
INSERT INTO `counties` VALUES ('443', '太和区', '45', '0', '0', '121.10354', '41.10929');
INSERT INTO `counties` VALUES ('444', '黑山县', '45', '0', '0', '122.12081', '41.69417');
INSERT INTO `counties` VALUES ('445', '凌海市', '45', '0', '0', '121.35705', '41.1737');
INSERT INTO `counties` VALUES ('446', '北镇市', '45', '0', '0', '121.79858', '41.59537');
INSERT INTO `counties` VALUES ('447', '义县', '45', '0', '0', '121.24035', '41.53458');
INSERT INTO `counties` VALUES ('448', '大石桥市', '46', '0', '0', '122.50927', '40.64567');
INSERT INTO `counties` VALUES ('449', '盖州市', '46', '0', '0', '122.35464', '40.40446');
INSERT INTO `counties` VALUES ('450', '老边区', '46', '0', '0', '122.37996', '40.6803');
INSERT INTO `counties` VALUES ('451', '西市区', '46', '0', '0', '122.20641', '40.6664');
INSERT INTO `counties` VALUES ('452', '站前区', '46', '0', '0', '122.25896', '40.67266');
INSERT INTO `counties` VALUES ('453', '鲅鱼圈区', '46', '0', '0', '122.13266', '40.26865');
INSERT INTO `counties` VALUES ('454', '海州区', '47', '0', '0', '121.65626', '42.01336');
INSERT INTO `counties` VALUES ('455', '清河门区', '47', '0', '0', '121.4161', '41.78309');
INSERT INTO `counties` VALUES ('456', '太平区', '47', '0', '0', '121.67865', '42.01065');
INSERT INTO `counties` VALUES ('457', '阜新蒙古族自治县', '47', '0', '0', '121.75787', '42.0651');
INSERT INTO `counties` VALUES ('458', '细河区', '47', '0', '0', '121.68013', '42.02533');
INSERT INTO `counties` VALUES ('459', '新邱区', '47', '0', '0', '121.79251', '42.09181');
INSERT INTO `counties` VALUES ('460', '彰武县', '47', '0', '0', '122.54022', '42.38625');
INSERT INTO `counties` VALUES ('461', '宏伟区', '48', '0', '0', '123.1929', '41.21852');
INSERT INTO `counties` VALUES ('462', '辽阳县', '48', '0', '0', '123.10574', '41.20542');
INSERT INTO `counties` VALUES ('463', '白塔区', '48', '0', '0', '123.1747', '41.27025');
INSERT INTO `counties` VALUES ('464', '灯塔市', '48', '0', '0', '123.33926', '41.42612');
INSERT INTO `counties` VALUES ('465', '弓长岭区', '48', '0', '0', '123.41963', '41.15181');
INSERT INTO `counties` VALUES ('466', '太子河区', '48', '0', '0', '123.18182', '41.25337');
INSERT INTO `counties` VALUES ('467', '文圣区', '48', '0', '0', '123.18521', '41.26267');
INSERT INTO `counties` VALUES ('468', '大洼县', '49', '0', '0', '122.08239', '41.00244');
INSERT INTO `counties` VALUES ('469', '盘山县', '49', '0', '0', '121.99777', '41.23805');
INSERT INTO `counties` VALUES ('470', '双台子区', '49', '0', '0', '122.06011', '41.1906');
INSERT INTO `counties` VALUES ('471', '兴隆台区', '49', '0', '0', '122.07529', '41.12402');
INSERT INTO `counties` VALUES ('472', '昌图县', '50', '0', '0', '124.11206', '42.78428');
INSERT INTO `counties` VALUES ('473', '调兵山市', '50', '0', '0', '123.56689', '42.4675');
INSERT INTO `counties` VALUES ('474', '开原市', '50', '0', '0', '124.03945', '42.54585');
INSERT INTO `counties` VALUES ('475', '清河区', '50', '0', '0', '124.15911', '42.54679');
INSERT INTO `counties` VALUES ('476', '铁岭县', '50', '0', '0', '123.77325', '42.22498');
INSERT INTO `counties` VALUES ('477', '西丰县', '50', '0', '0', '124.7304', '42.73756');
INSERT INTO `counties` VALUES ('478', '银州区', '50', '0', '0', '123.8573', '42.29507');
INSERT INTO `counties` VALUES ('479', '宽城区', '53', '0', '0', '125.32635', '43.90182');
INSERT INTO `counties` VALUES ('480', '绿园区', '53', '0', '0', '125.25582', '43.88045');
INSERT INTO `counties` VALUES ('481', '朝阳区', '53', '0', '0', '116.48548', '39.9484');
INSERT INTO `counties` VALUES ('482', '德惠市', '53', '0', '0', '125.70538', '44.53719');
INSERT INTO `counties` VALUES ('483', '二道区', '53', '0', '0', '125.37429', '43.86501');
INSERT INTO `counties` VALUES ('484', '九台市', '53', '0', '0', '125.83', '44.15');
INSERT INTO `counties` VALUES ('485', '南关区', '53', '0', '0', '125.35035', '43.86401');
INSERT INTO `counties` VALUES ('486', '农安县', '53', '0', '0', '125.18481', '44.43265');
INSERT INTO `counties` VALUES ('487', '双阳区', '53', '0', '0', '125.65631', '43.52803');
INSERT INTO `counties` VALUES ('488', '榆树市', '53', '0', '0', '126.55688', '44.82523');
INSERT INTO `counties` VALUES ('489', '双塔区', '51', '0', '0', '120.45385', '41.566');
INSERT INTO `counties` VALUES ('490', '龙城区', '51', '0', '0', '120.43719', '41.59264');
INSERT INTO `counties` VALUES ('491', '北票市', '51', '0', '0', '120.76977', '41.80196');
INSERT INTO `counties` VALUES ('492', '朝阳县', '51', '0', '0', '120.17401', '41.4324');
INSERT INTO `counties` VALUES ('493', '建平县', '51', '0', '0', '119.64392', '41.40315');
INSERT INTO `counties` VALUES ('494', '喀喇沁左翼蒙古族自治县', '51', '0', '0', '119.74185', '41.12801');
INSERT INTO `counties` VALUES ('495', '凌源市', '51', '0', '0', '119.40148', '41.24558');
INSERT INTO `counties` VALUES ('496', '建昌县', '52', '0', '0', '119.8377', '40.82448');
INSERT INTO `counties` VALUES ('497', '连山区', '52', '0', '0', '120.86393', '40.75554');
INSERT INTO `counties` VALUES ('498', '龙港区', '52', '0', '0', '120.94866', '40.71919');
INSERT INTO `counties` VALUES ('499', '南票区', '52', '0', '0', '120.74978', '41.10707');
INSERT INTO `counties` VALUES ('500', '绥中县', '52', '0', '0', '120.34451', '40.32552');
INSERT INTO `counties` VALUES ('501', '兴城市', '52', '0', '0', '120.72537', '40.61492');
INSERT INTO `counties` VALUES ('502', '东丰县', '56', '0', '0', '125.53244', '42.6783');
INSERT INTO `counties` VALUES ('503', '东辽县', '56', '0', '0', '124.98596', '42.92492');
INSERT INTO `counties` VALUES ('504', '龙山区', '56', '0', '0', '125.13641', '42.89714');
INSERT INTO `counties` VALUES ('505', '西安区', '56', '0', '0', '125.14904', '42.927');
INSERT INTO `counties` VALUES ('506', '昌邑区', '54', '0', '0', '126.57424', '43.88183');
INSERT INTO `counties` VALUES ('507', '船营区', '54', '0', '0', '126.54096', '43.83344');
INSERT INTO `counties` VALUES ('508', '丰满区', '54', '0', '0', '126.56237', '43.82236');
INSERT INTO `counties` VALUES ('509', '龙潭区', '54', '0', '0', '126.56213', '43.91054');
INSERT INTO `counties` VALUES ('510', '磐石市', '54', '0', '0', '126.0625', '42.94628');
INSERT INTO `counties` VALUES ('511', '舒兰市', '54', '0', '0', '126.9653', '44.40582');
INSERT INTO `counties` VALUES ('512', '永吉县', '54', '0', '0', '126.4963', '43.67197');
INSERT INTO `counties` VALUES ('513', '桦甸市', '54', '0', '0', '126.74624', '42.97206');
INSERT INTO `counties` VALUES ('514', '蛟河市', '54', '0', '0', '127.34426', '43.72696');
INSERT INTO `counties` VALUES ('515', '公主岭市', '55', '0', '0', '124.82266', '43.50453');
INSERT INTO `counties` VALUES ('516', '梨树县', '55', '0', '0', '124.33563', '43.30717');
INSERT INTO `counties` VALUES ('517', '双辽市', '55', '0', '0', '123.50106', '43.52099');
INSERT INTO `counties` VALUES ('518', '铁东区', '55', '0', '0', '122.99085', '41.08975');
INSERT INTO `counties` VALUES ('519', '铁西区', '55', '0', '0', '123.37675', '41.80269');
INSERT INTO `counties` VALUES ('520', '伊通满族自治县', '55', '0', '0', '125.30596', '43.34434');
INSERT INTO `counties` VALUES ('521', '东昌区', '57', '0', '0', '125.9551', '41.72849');
INSERT INTO `counties` VALUES ('522', '二道江区', '57', '0', '0', '126.04257', '41.7741');
INSERT INTO `counties` VALUES ('523', '辉南县', '57', '0', '0', '126.04684', '42.68497');
INSERT INTO `counties` VALUES ('524', '集安市', '57', '0', '0', '126.18829', '41.12268');
INSERT INTO `counties` VALUES ('525', '柳河县', '57', '0', '0', '125.74475', '42.28468');
INSERT INTO `counties` VALUES ('526', '梅河口市', '57', '0', '0', '125.71041', '42.53828');
INSERT INTO `counties` VALUES ('527', '通化县', '57', '0', '0', '125.75936', '41.67928');
INSERT INTO `counties` VALUES ('528', '长岭县', '59', '0', '0', '123.96725', '44.27581');
INSERT INTO `counties` VALUES ('529', '扶余县', '59', '0', '0', '126.02', '44.98');
INSERT INTO `counties` VALUES ('530', '宁江区', '59', '0', '0', '124.81689', '45.17175');
INSERT INTO `counties` VALUES ('531', '乾安县', '59', '0', '0', '124.02737', '45.01068');
INSERT INTO `counties` VALUES ('532', '前郭尔罗斯蒙古族自治县', '59', '0', '0', '124.82351', '45.11726');
INSERT INTO `counties` VALUES ('533', '浑江区', '58', '0', '0', '126.422342', '41.945656');
INSERT INTO `counties` VALUES ('534', '长白朝鲜族自治县', '58', '0', '0', '128.20047', '41.41996');
INSERT INTO `counties` VALUES ('535', '抚松县', '58', '0', '0', '127.2803', '42.34198');
INSERT INTO `counties` VALUES ('536', '江源区', '58', '0', '0', '126.59079', '42.05664');
INSERT INTO `counties` VALUES ('537', '靖宇县', '58', '0', '0', '126.81308', '42.38863');
INSERT INTO `counties` VALUES ('538', '临江市', '58', '0', '0', '126.91751', '41.81142');
INSERT INTO `counties` VALUES ('539', '安图县', '61', '0', '0', '128.90625', '43.11533');
INSERT INTO `counties` VALUES ('540', '敦化市', '61', '0', '0', '128.23242', '43.37304');
INSERT INTO `counties` VALUES ('541', '和龙市', '61', '0', '0', '129.01077', '42.5464');
INSERT INTO `counties` VALUES ('542', '龙井市', '61', '0', '0', '129.42584', '42.76804');
INSERT INTO `counties` VALUES ('543', '图们市', '61', '0', '0', '129.84381', '42.96801');
INSERT INTO `counties` VALUES ('544', '汪清县', '61', '0', '0', '129.77121', '43.31278');
INSERT INTO `counties` VALUES ('545', '延吉市', '61', '0', '0', '129.51357', '42.90682');
INSERT INTO `counties` VALUES ('546', '珲春市', '61', '0', '0', '130.36572', '42.86242');
INSERT INTO `counties` VALUES ('547', '大安市', '60', '0', '0', '124.29519', '45.50846');
INSERT INTO `counties` VALUES ('548', '通榆县', '60', '0', '0', '123.08761', '44.81388');
INSERT INTO `counties` VALUES ('549', '镇赉县', '60', '0', '0', '123.19924', '45.84779');
INSERT INTO `counties` VALUES ('550', '洮北区', '60', '0', '0', '122.85104', '45.62167');
INSERT INTO `counties` VALUES ('551', '洮南市', '60', '0', '0', '122.78772', '45.33502');
INSERT INTO `counties` VALUES ('552', '城子河区', '64', '0', '0', '131.01132', '45.33689');
INSERT INTO `counties` VALUES ('553', '滴道区', '64', '0', '0', '130.84841', '45.35109');
INSERT INTO `counties` VALUES ('554', '恒山区', '64', '0', '0', '130.90493', '45.21071');
INSERT INTO `counties` VALUES ('555', '虎林市', '64', '0', '0', '132.93679', '45.76291');
INSERT INTO `counties` VALUES ('556', '鸡东县', '64', '0', '0', '131.12423', '45.26025');
INSERT INTO `counties` VALUES ('557', '鸡冠区', '64', '0', '0', '130.98139', '45.30396');
INSERT INTO `counties` VALUES ('558', '梨树区', '64', '0', '0', '130.69848', '45.09037');
INSERT INTO `counties` VALUES ('559', '麻山区', '64', '0', '0', '130.47811', '45.21209');
INSERT INTO `counties` VALUES ('560', '密山市', '64', '0', '0', '131.84625', '45.5297');
INSERT INTO `counties` VALUES ('561', '东山区', '65', '0', '0', '130.31706', '47.33853');
INSERT INTO `counties` VALUES ('562', '工农区', '65', '0', '0', '130.27468', '47.31869');
INSERT INTO `counties` VALUES ('563', '萝北县', '65', '0', '0', '130.83346', '47.57959');
INSERT INTO `counties` VALUES ('564', '南山区', '65', '0', '0', '130.27676', '47.31404');
INSERT INTO `counties` VALUES ('565', '绥滨县', '65', '0', '0', '131.86029', '47.2903');
INSERT INTO `counties` VALUES ('566', '向阳区', '65', '0', '0', '130.2943', '47.34247');
INSERT INTO `counties` VALUES ('567', '兴安区', '65', '0', '0', '130.23965', '47.2526');
INSERT INTO `counties` VALUES ('568', '兴山区', '65', '0', '0', '130.29271', '47.35776');
INSERT INTO `counties` VALUES ('569', '道外区', '62', '0', '0', '126.64938', '45.79187');
INSERT INTO `counties` VALUES ('570', '阿城区', '62', '0', '0', '126.97525', '45.54144');
INSERT INTO `counties` VALUES ('571', '巴彦县', '62', '0', '0', '127.40799', '46.08148');
INSERT INTO `counties` VALUES ('572', '宾县', '62', '0', '0', '127.48675', '45.75504');
INSERT INTO `counties` VALUES ('573', '道里区', '62', '0', '0', '126.61705', '45.75586');
INSERT INTO `counties` VALUES ('574', '方正县', '62', '0', '0', '128.82952', '45.85162');
INSERT INTO `counties` VALUES ('575', '呼兰区', '62', '0', '0', '126.58792', '45.88895');
INSERT INTO `counties` VALUES ('576', '木兰县', '62', '0', '0', '128.0448', '45.94944');
INSERT INTO `counties` VALUES ('577', '南岗区', '62', '0', '0', '126.66854', '45.75996');
INSERT INTO `counties` VALUES ('578', '平房区', '62', '0', '0', '126.63729', '45.59777');
INSERT INTO `counties` VALUES ('579', '尚志市', '62', '0', '0', '127.96191', '45.21736');
INSERT INTO `counties` VALUES ('580', '双城市', '62', '0', '0', '126.32', '45.37');
INSERT INTO `counties` VALUES ('581', '松北区', '62', '0', '0', '126.56276', '45.80831');
INSERT INTO `counties` VALUES ('582', '通河县', '62', '0', '0', '128.74603', '45.99007');
INSERT INTO `counties` VALUES ('583', '五常市', '62', '0', '0', '127.16751', '44.93184');
INSERT INTO `counties` VALUES ('584', '香坊区', '62', '0', '0', '126.67968', '45.72383');
INSERT INTO `counties` VALUES ('585', '延寿县', '62', '0', '0', '128.33419', '45.4554');
INSERT INTO `counties` VALUES ('586', '依兰县', '62', '0', '0', '129.56817', '46.3247');
INSERT INTO `counties` VALUES ('587', '昂昂溪区', '63', '0', '0', '123.82229', '47.15513');
INSERT INTO `counties` VALUES ('588', '拜泉县', '63', '0', '0', '126.09167', '47.60817');
INSERT INTO `counties` VALUES ('589', '富拉尔基区', '63', '0', '0', '123.62918', '47.20884');
INSERT INTO `counties` VALUES ('590', '富裕县', '63', '0', '0', '124.47457', '47.77431');
INSERT INTO `counties` VALUES ('591', '甘南县', '63', '0', '0', '123.50317', '47.92437');
INSERT INTO `counties` VALUES ('592', '建华区', '63', '0', '0', '124.0133', '47.36718');
INSERT INTO `counties` VALUES ('593', '克东县', '63', '0', '0', '126.24917', '48.03828');
INSERT INTO `counties` VALUES ('594', '克山县', '63', '0', '0', '125.87396', '48.03265');
INSERT INTO `counties` VALUES ('595', '龙江县', '63', '0', '0', '123.20532', '47.33868');
INSERT INTO `counties` VALUES ('596', '龙沙区', '63', '0', '0', '123.95752', '47.31776');
INSERT INTO `counties` VALUES ('597', '梅里斯达斡尔族区', '63', '0', '0', '123.75274', '47.30946');
INSERT INTO `counties` VALUES ('598', '碾子山区', '63', '0', '0', '122.88183', '47.51662');
INSERT INTO `counties` VALUES ('599', '泰来县', '63', '0', '0', '123.42285', '46.39386');
INSERT INTO `counties` VALUES ('600', '铁锋区', '63', '0', '0', '123.97821', '47.34075');
INSERT INTO `counties` VALUES ('601', '依安县', '63', '0', '0', '125.30896', '47.8931');
INSERT INTO `counties` VALUES ('602', '讷河市', '63', '0', '0', '124.87713', '48.48388');
INSERT INTO `counties` VALUES ('603', '大同区', '67', '0', '0', '124.81591', '46.03295');
INSERT INTO `counties` VALUES ('604', '杜尔伯特蒙古族自治县', '67', '0', '0', '124.44937', '46.86507');
INSERT INTO `counties` VALUES ('605', '红岗区', '67', '0', '0', '124.89248', '46.40128');
INSERT INTO `counties` VALUES ('606', '林甸县', '67', '0', '0', '124.87564', '47.18601');
INSERT INTO `counties` VALUES ('607', '龙凤区', '67', '0', '0', '125.11657', '46.53273');
INSERT INTO `counties` VALUES ('608', '让胡路区', '67', '0', '0', '124.87075', '46.6522');
INSERT INTO `counties` VALUES ('609', '萨尔图区', '67', '0', '0', '125.08792', '46.59359');
INSERT INTO `counties` VALUES ('610', '肇源县', '67', '0', '0', '125.08456', '45.52032');
INSERT INTO `counties` VALUES ('611', '肇州县', '67', '0', '0', '125.27059', '45.70414');
INSERT INTO `counties` VALUES ('612', '宝清县', '66', '0', '0', '132.19695', '46.32716');
INSERT INTO `counties` VALUES ('613', '宝山区', '66', '0', '0', '131.4016', '46.57718');
INSERT INTO `counties` VALUES ('614', '集贤县', '66', '0', '0', '131.14053', '46.72678');
INSERT INTO `counties` VALUES ('615', '尖山区', '66', '0', '0', '131.15841', '46.64635');
INSERT INTO `counties` VALUES ('616', '岭东区', '66', '0', '0', '131.16473', '46.59043');
INSERT INTO `counties` VALUES ('617', '饶河县', '66', '0', '0', '134.01986', '46.79899');
INSERT INTO `counties` VALUES ('618', '四方台区', '66', '0', '0', '131.33593', '46.59499');
INSERT INTO `counties` VALUES ('619', '友谊县', '66', '0', '0', '131.80789', '46.76739');
INSERT INTO `counties` VALUES ('620', '嘉荫县', '68', '0', '0', '130.39825', '48.8917');
INSERT INTO `counties` VALUES ('621', '铁力市', '68', '0', '0', '128.0317', '46.98571');
INSERT INTO `counties` VALUES ('622', '乌伊岭区', '68', '0', '0', '129.43981', '48.59602');
INSERT INTO `counties` VALUES ('623', '汤旺河区', '68', '0', '0', '129.57226', '48.45182');
INSERT INTO `counties` VALUES ('624', '带岭区', '68', '0', '0', '129.02352', '47.02553');
INSERT INTO `counties` VALUES ('625', '新青区', '68', '0', '0', '129.53653', '48.29067');
INSERT INTO `counties` VALUES ('626', '红星区', '68', '0', '0', '129.3887', '48.23944');
INSERT INTO `counties` VALUES ('627', '五营区', '68', '0', '0', '129.24545', '48.10791');
INSERT INTO `counties` VALUES ('628', '伊春区', '68', '0', '0', '128.90752', '47.728');
INSERT INTO `counties` VALUES ('629', '翠峦区', '68', '0', '0', '128.66729', '47.72503');
INSERT INTO `counties` VALUES ('630', '金山屯区', '68', '0', '0', '129.43768', '47.41349');
INSERT INTO `counties` VALUES ('631', '西林区', '68', '0', '0', '129.31201', '47.48103');
INSERT INTO `counties` VALUES ('632', '南岔区', '68', '0', '0', '129.28362', '47.13897');
INSERT INTO `counties` VALUES ('633', '乌马河区', '68', '0', '0', '128.79672', '47.728');
INSERT INTO `counties` VALUES ('634', '美溪区', '68', '0', '0', '129.13708', '47.63513');
INSERT INTO `counties` VALUES ('635', '上甘岭区', '68', '0', '0', '129.02447', '47.97522');
INSERT INTO `counties` VALUES ('636', '友好区', '68', '0', '0', '128.84039', '47.85371');
INSERT INTO `counties` VALUES ('637', '东风区', '69', '0', '0', '130.40366', '46.82257');
INSERT INTO `counties` VALUES ('638', '抚远县', '69', '0', '0', '134.29595', '48.36794');
INSERT INTO `counties` VALUES ('639', '富锦市', '69', '0', '0', '132.03707', '47.25132');
INSERT INTO `counties` VALUES ('640', '郊区', '69', '0', '0', '113.58539', '37.94139');
INSERT INTO `counties` VALUES ('641', '前进区', '69', '0', '0', '130.37497', '46.81401');
INSERT INTO `counties` VALUES ('642', '汤原县', '69', '0', '0', '129.90966', '46.72755');
INSERT INTO `counties` VALUES ('643', '同江市', '69', '0', '0', '132.51095', '47.64211');
INSERT INTO `counties` VALUES ('644', '向阳区', '69', '0', '0', '130.2943', '47.34247');
INSERT INTO `counties` VALUES ('645', '桦川县', '69', '0', '0', '130.71893', '47.02297');
INSERT INTO `counties` VALUES ('646', '桦南县', '69', '0', '0', '130.55361', '46.23921');
INSERT INTO `counties` VALUES ('647', '爱辉区', '72', '0', '0', '127.50074', '50.25202');
INSERT INTO `counties` VALUES ('648', '北安市', '72', '0', '0', '126.48193', '48.23872');
INSERT INTO `counties` VALUES ('649', '嫩江县', '72', '0', '0', '125.22607', '49.17844');
INSERT INTO `counties` VALUES ('650', '孙吴县', '72', '0', '0', '127.33599', '49.42539');
INSERT INTO `counties` VALUES ('651', '五大连池市', '72', '0', '0', '126.20294', '48.51507');
INSERT INTO `counties` VALUES ('652', '逊克县', '72', '0', '0', '128.47882', '49.57983');
INSERT INTO `counties` VALUES ('653', '勃利县', '70', '0', '0', '130.59179', '45.755');
INSERT INTO `counties` VALUES ('654', '茄子河区', '70', '0', '0', '131.06807', '45.78519');
INSERT INTO `counties` VALUES ('655', '桃山区', '70', '0', '0', '131.01786', '45.76782');
INSERT INTO `counties` VALUES ('656', '新兴区', '70', '0', '0', '130.93212', '45.81624');
INSERT INTO `counties` VALUES ('657', '西安区', '71', '0', '0', '125.14904', '42.927');
INSERT INTO `counties` VALUES ('658', '绥芬河市', '71', '0', '0', '131.15139', '44.41249');
INSERT INTO `counties` VALUES ('659', '爱民区', '71', '0', '0', '129.59077', '44.59648');
INSERT INTO `counties` VALUES ('660', '东安区', '71', '0', '0', '129.62665', '44.58133');
INSERT INTO `counties` VALUES ('661', '东宁县', '71', '0', '0', '131.12793', '44.0661');
INSERT INTO `counties` VALUES ('662', '海林市', '71', '0', '0', '129.38156', '44.59');
INSERT INTO `counties` VALUES ('663', '林口县', '71', '0', '0', '130.28393', '45.27809');
INSERT INTO `counties` VALUES ('664', '穆棱市', '71', '0', '0', '130.52465', '44.919');
INSERT INTO `counties` VALUES ('665', '宁安市', '71', '0', '0', '129.48303', '44.34016');
INSERT INTO `counties` VALUES ('666', '阳明区', '71', '0', '0', '129.63547', '44.59603');
INSERT INTO `counties` VALUES ('667', '秦淮区', '77', '0', '0', '118.79815', '32.01112');
INSERT INTO `counties` VALUES ('668', '下关区', '77', '0', '0', '118.73', '32.08');
INSERT INTO `counties` VALUES ('669', '玄武区', '77', '0', '0', '118.79772', '32.04856');
INSERT INTO `counties` VALUES ('670', '雨花台区', '77', '0', '0', '118.7799', '31.99202');
INSERT INTO `counties` VALUES ('671', '溧水县', '77', '0', '0', '119.02', '31.65');
INSERT INTO `counties` VALUES ('672', '白下区', '77', '0', '0', '118.78', '32.03');
INSERT INTO `counties` VALUES ('673', '高淳县', '77', '0', '0', '118.88', '31.33');
INSERT INTO `counties` VALUES ('674', '鼓楼区', '77', '0', '0', '118.76974', '32.06632');
INSERT INTO `counties` VALUES ('675', '建邺区', '77', '0', '0', '118.76641', '32.03096');
INSERT INTO `counties` VALUES ('676', '江宁区', '77', '0', '0', '118.8399', '31.95263');
INSERT INTO `counties` VALUES ('677', '六合区', '77', '0', '0', '118.8413', '32.34222');
INSERT INTO `counties` VALUES ('678', '浦口区', '77', '0', '0', '118.62802', '32.05881');
INSERT INTO `counties` VALUES ('679', '栖霞区', '77', '0', '0', '118.88064', '32.11352');
INSERT INTO `counties` VALUES ('680', '安达市', '73', '0', '0', '125.34375', '46.4177');
INSERT INTO `counties` VALUES ('681', '北林区', '73', '0', '0', '126.98564', '46.63735');
INSERT INTO `counties` VALUES ('682', '海伦市', '73', '0', '0', '126.9682', '47.46093');
INSERT INTO `counties` VALUES ('683', '兰西县', '73', '0', '0', '126.28994', '46.2525');
INSERT INTO `counties` VALUES ('684', '明水县', '73', '0', '0', '125.90594', '47.17327');
INSERT INTO `counties` VALUES ('685', '青冈县', '73', '0', '0', '126.11325', '46.68534');
INSERT INTO `counties` VALUES ('686', '庆安县', '73', '0', '0', '127.50753', '46.88016');
INSERT INTO `counties` VALUES ('687', '绥棱县', '73', '0', '0', '127.11584', '47.24267');
INSERT INTO `counties` VALUES ('688', '望奎县', '73', '0', '0', '126.48187', '46.83079');
INSERT INTO `counties` VALUES ('689', '肇东市', '73', '0', '0', '125.96243', '46.05131');
INSERT INTO `counties` VALUES ('690', '北塘区', '78', '0', '0', '120.29405', '31.60592');
INSERT INTO `counties` VALUES ('691', '滨湖区', '78', '0', '0', '120.29461', '31.52162');
INSERT INTO `counties` VALUES ('692', '崇安区', '78', '0', '0', '120.29975', '31.58002');
INSERT INTO `counties` VALUES ('693', '惠山区', '78', '0', '0', '120.29849', '31.68088');
INSERT INTO `counties` VALUES ('694', '江阴市', '78', '0', '0', '120.2853', '31.91996');
INSERT INTO `counties` VALUES ('695', '南长区', '78', '0', '0', '120.30873', '31.56359');
INSERT INTO `counties` VALUES ('696', '锡山区', '78', '0', '0', '120.35699', '31.5886');
INSERT INTO `counties` VALUES ('697', '宜兴市', '78', '0', '0', '119.82357', '31.33978');
INSERT INTO `counties` VALUES ('698', '呼玛县', '74', '0', '0', '126.66174', '51.73112');
INSERT INTO `counties` VALUES ('699', '漠河县', '74', '0', '0', '122.53759', '52.97003');
INSERT INTO `counties` VALUES ('700', '塔河县', '74', '0', '0', '124.70999', '52.33431');
INSERT INTO `counties` VALUES ('701', '钟楼区', '80', '0', '0', '119.90178', '31.80221');
INSERT INTO `counties` VALUES ('702', '溧阳市', '80', '0', '0', '119.4837', '31.41538');
INSERT INTO `counties` VALUES ('703', '金坛市', '80', '0', '0', '119.57757', '31.74043');
INSERT INTO `counties` VALUES ('704', '戚墅堰区', '80', '0', '0', '120.06106', '31.71956');
INSERT INTO `counties` VALUES ('705', '天宁区', '80', '0', '0', '119.95132', '31.75211');
INSERT INTO `counties` VALUES ('706', '武进区', '80', '0', '0', '119.94244', '31.70086');
INSERT INTO `counties` VALUES ('707', '新北区', '80', '0', '0', '119.97131', '31.83046');
INSERT INTO `counties` VALUES ('708', '丰县', '79', '0', '0', '116.59957', '34.69972');
INSERT INTO `counties` VALUES ('709', '贾汪区', '79', '0', '0', '117.45346', '34.44264');
INSERT INTO `counties` VALUES ('710', '沛县', '79', '0', '0', '116.93743', '34.72163');
INSERT INTO `counties` VALUES ('711', '泉山区', '79', '0', '0', '117.19378', '34.24418');
INSERT INTO `counties` VALUES ('712', '铜山区', '79', '0', '0', '117.183894', '34.19288');
INSERT INTO `counties` VALUES ('713', '新沂市', '79', '0', '0', '118.35452', '34.36942');
INSERT INTO `counties` VALUES ('714', '云龙区', '79', '0', '0', '117.23053', '34.24895');
INSERT INTO `counties` VALUES ('715', '邳州市', '79', '0', '0', '117.95858', '34.33329');
INSERT INTO `counties` VALUES ('716', '睢宁县', '79', '0', '0', '117.94104', '33.91269');
INSERT INTO `counties` VALUES ('717', '鼓楼区', '79', '0', '0', '118.76974', '32.06632');
INSERT INTO `counties` VALUES ('718', '常熟市', '81', '0', '0', '120.75225', '31.65374');
INSERT INTO `counties` VALUES ('719', '虎丘区', '81', '0', '0', '120.57345', '31.2953');
INSERT INTO `counties` VALUES ('720', '昆山市', '81', '0', '0', '120.98074', '31.38464');
INSERT INTO `counties` VALUES ('721', '太仓市', '81', '0', '0', '121.10891', '31.4497');
INSERT INTO `counties` VALUES ('722', '吴江区', '81', '0', '0', '120.638317', '31.159815');
INSERT INTO `counties` VALUES ('723', '相城区', '81', '0', '0', '120.64239', '31.36889');
INSERT INTO `counties` VALUES ('724', '张家港市', '81', '0', '0', '120.55538', '31.87532');
INSERT INTO `counties` VALUES ('725', '吴中区', '81', '0', '0', '120.63211', '31.26226');
INSERT INTO `counties` VALUES ('726', '姑苏区', '81', '0', '0', '120.619585', '31.299379');
INSERT INTO `counties` VALUES ('727', '灌南县', '83', '0', '0', '119.35632', '34.09');
INSERT INTO `counties` VALUES ('728', '灌云县', '83', '0', '0', '119.23925', '34.28391');
INSERT INTO `counties` VALUES ('729', '连云区', '83', '0', '0', '119.37304', '34.75293');
INSERT INTO `counties` VALUES ('730', '新浦区', '83', '0', '0', '119.17', '34.60');
INSERT INTO `counties` VALUES ('731', '赣榆县', '83', '0', '0', '119.12', '34.83');
INSERT INTO `counties` VALUES ('732', '东海县', '83', '0', '0', '118.77145', '34.54215');
INSERT INTO `counties` VALUES ('733', '海州区', '83', '0', '0', '121.65626', '42.01336');
INSERT INTO `counties` VALUES ('734', '崇川区', '82', '0', '0', '120.8573', '32.0098');
INSERT INTO `counties` VALUES ('735', '港闸区', '82', '0', '0', '120.81778', '32.03163');
INSERT INTO `counties` VALUES ('736', '海安县', '82', '0', '0', '120.45852', '32.54514');
INSERT INTO `counties` VALUES ('737', '海门市', '82', '0', '0', '121.16995', '31.89422');
INSERT INTO `counties` VALUES ('738', '启东市', '82', '0', '0', '121.65985', '31.81083');
INSERT INTO `counties` VALUES ('739', '如东县', '82', '0', '0', '121.18942', '32.31439');
INSERT INTO `counties` VALUES ('740', '如皋市', '82', '0', '0', '120.55969', '32.37597');
INSERT INTO `counties` VALUES ('741', '通州区', '82', '0', '0', '116.65716', '39.90966');
INSERT INTO `counties` VALUES ('742', '滨海县', '85', '0', '0', '119.82058', '33.98972');
INSERT INTO `counties` VALUES ('743', '大丰市', '85', '0', '0', '120.46594', '33.19893');
INSERT INTO `counties` VALUES ('744', '东台市', '85', '0', '0', '120.32376', '32.85078');
INSERT INTO `counties` VALUES ('745', '阜宁县', '85', '0', '0', '119.80175', '33.78228');
INSERT INTO `counties` VALUES ('746', '建湖县', '85', '0', '0', '119.79852', '33.47241');
INSERT INTO `counties` VALUES ('747', '射阳县', '85', '0', '0', '120.26043', '33.77636');
INSERT INTO `counties` VALUES ('748', '亭湖区', '85', '0', '0', '120.16583', '33.37825');
INSERT INTO `counties` VALUES ('749', '响水县', '85', '0', '0', '119.56985', '34.20513');
INSERT INTO `counties` VALUES ('750', '盐都区', '85', '0', '0', '120.15441', '33.3373');
INSERT INTO `counties` VALUES ('751', '淮安区', '84', '0', '0', '119.021265', '33.597506');
INSERT INTO `counties` VALUES ('752', '盱眙县', '84', '0', '0', '118.54495', '33.01086');
INSERT INTO `counties` VALUES ('753', '洪泽县', '84', '0', '0', '118.87344', '33.29429');
INSERT INTO `counties` VALUES ('754', '淮阴区', '84', '0', '0', '119.03485', '33.63171');
INSERT INTO `counties` VALUES ('755', '金湖县', '84', '0', '0', '119.02307', '33.02219');
INSERT INTO `counties` VALUES ('756', '涟水县', '84', '0', '0', '119.26083', '33.78094');
INSERT INTO `counties` VALUES ('757', '清河区', '84', '0', '0', '124.15911', '42.54679');
INSERT INTO `counties` VALUES ('758', '清浦区', '84', '0', '0', '119.02648', '33.55232');
INSERT INTO `counties` VALUES ('759', '宝应县', '86', '0', '0', '119.31213', '33.23549');
INSERT INTO `counties` VALUES ('760', '高邮市', '86', '0', '0', '119.45965', '32.78135');
INSERT INTO `counties` VALUES ('761', '广陵区', '86', '0', '0', '119.43186', '32.39472');
INSERT INTO `counties` VALUES ('762', '江都区', '86', '0', '0', '119.567481', '32.426564');
INSERT INTO `counties` VALUES ('763', '仪征市', '86', '0', '0', '119.18432', '32.27197');
INSERT INTO `counties` VALUES ('764', '邗江区', '86', '0', '0', '119.39816', '32.3765');
INSERT INTO `counties` VALUES ('765', '兴化市', '88', '0', '0', '119.85238', '32.90944');
INSERT INTO `counties` VALUES ('766', '高港区', '88', '0', '0', '119.88089', '32.31833');
INSERT INTO `counties` VALUES ('767', '海陵区', '88', '0', '0', '119.91942', '32.49101');
INSERT INTO `counties` VALUES ('768', '姜堰市', '88', '0', '0', '120.15', '32.52');
INSERT INTO `counties` VALUES ('769', '靖江市', '88', '0', '0', '120.27291', '32.01595');
INSERT INTO `counties` VALUES ('770', '泰兴市', '88', '0', '0', '120.05194', '32.17187');
INSERT INTO `counties` VALUES ('771', '宿城区', '89', '0', '0', '118.29141', '33.94219');
INSERT INTO `counties` VALUES ('772', '宿豫区', '89', '0', '0', '118.32922', '33.94673');
INSERT INTO `counties` VALUES ('773', '沭阳县', '89', '0', '0', '118.76873', '34.11446');
INSERT INTO `counties` VALUES ('774', '泗洪县', '89', '0', '0', '118.21716', '33.45996');
INSERT INTO `counties` VALUES ('775', '泗阳县', '89', '0', '0', '118.7033', '33.72096');
INSERT INTO `counties` VALUES ('776', '丹徒区', '87', '0', '0', '119.43383', '32.13183');
INSERT INTO `counties` VALUES ('777', '丹阳市', '87', '0', '0', '119.57525', '31.99121');
INSERT INTO `counties` VALUES ('778', '京口区', '87', '0', '0', '119.46947', '32.19809');
INSERT INTO `counties` VALUES ('779', '句容市', '87', '0', '0', '119.16482', '31.95591');
INSERT INTO `counties` VALUES ('780', '润州区', '87', '0', '0', '119.41134', '32.19523');
INSERT INTO `counties` VALUES ('781', '扬中市', '87', '0', '0', '119.79718', '32.2363');
INSERT INTO `counties` VALUES ('782', '海曙区', '91', '0', '0', '121.55106', '29.85977');
INSERT INTO `counties` VALUES ('783', '北仑区', '91', '0', '0', '121.84408', '29.90069');
INSERT INTO `counties` VALUES ('784', '慈溪市', '91', '0', '0', '121.26641', '30.16959');
INSERT INTO `counties` VALUES ('785', '奉化市', '91', '0', '0', '121.41003', '29.65537');
INSERT INTO `counties` VALUES ('786', '江北区', '91', '0', '0', '121.55681', '29.88776');
INSERT INTO `counties` VALUES ('787', '江东区', '91', '0', '0', '121.57028', '29.86701');
INSERT INTO `counties` VALUES ('788', '宁海县', '91', '0', '0', '121.43072', '29.2889');
INSERT INTO `counties` VALUES ('789', '象山县', '91', '0', '0', '121.86917', '29.47758');
INSERT INTO `counties` VALUES ('790', '余姚市', '91', '0', '0', '121.15341', '30.03867');
INSERT INTO `counties` VALUES ('791', '镇海区', '91', '0', '0', '121.71615', '29.94893');
INSERT INTO `counties` VALUES ('792', '鄞州区', '91', '0', '0', '121.54754', '29.81614');
INSERT INTO `counties` VALUES ('793', '富阳市', '90', '0', '0', '119.95', '30.05');
INSERT INTO `counties` VALUES ('794', '拱墅区', '90', '0', '0', '120.14209', '30.31968');
INSERT INTO `counties` VALUES ('795', '滨江区', '90', '0', '0', '120.21194', '30.20835');
INSERT INTO `counties` VALUES ('796', '淳安县', '90', '0', '0', '119.04257', '29.60988');
INSERT INTO `counties` VALUES ('797', '建德市', '90', '0', '0', '119.28158', '29.47603');
INSERT INTO `counties` VALUES ('798', '江干区', '90', '0', '0', '120.20517', '30.2572');
INSERT INTO `counties` VALUES ('799', '临安市', '90', '0', '0', '119.72473', '30.23447');
INSERT INTO `counties` VALUES ('800', '上城区', '90', '0', '0', '120.16922', '30.24255');
INSERT INTO `counties` VALUES ('801', '桐庐县', '90', '0', '0', '119.68853', '29.79779');
INSERT INTO `counties` VALUES ('802', '西湖区', '90', '0', '0', '120.12979', '30.25949');
INSERT INTO `counties` VALUES ('803', '下城区', '90', '0', '0', '120.18096', '30.28153');
INSERT INTO `counties` VALUES ('804', '萧山区', '90', '0', '0', '120.26452', '30.18505');
INSERT INTO `counties` VALUES ('805', '余杭区', '90', '0', '0', '120.29986', '30.41829');
INSERT INTO `counties` VALUES ('806', '苍南县', '92', '0', '0', '120.42608', '27.51739');
INSERT INTO `counties` VALUES ('807', '洞头县', '92', '0', '0', '121.15606', '27.83634');
INSERT INTO `counties` VALUES ('808', '龙湾区', '92', '0', '0', '120.83053', '27.91284');
INSERT INTO `counties` VALUES ('809', '鹿城区', '92', '0', '0', '120.65505', '28.01489');
INSERT INTO `counties` VALUES ('810', '平阳县', '92', '0', '0', '120.56506', '27.66245');
INSERT INTO `counties` VALUES ('811', '瑞安市', '92', '0', '0', '120.65466', '27.78041');
INSERT INTO `counties` VALUES ('812', '泰顺县', '92', '0', '0', '119.7182', '27.55694');
INSERT INTO `counties` VALUES ('813', '文成县', '92', '0', '0', '120.09063', '27.78678');
INSERT INTO `counties` VALUES ('814', '永嘉县', '92', '0', '0', '120.69317', '28.15456');
INSERT INTO `counties` VALUES ('815', '瓯海区', '92', '0', '0', '120.63751', '28.00714');
INSERT INTO `counties` VALUES ('816', '乐清市', '92', '0', '0', '120.9617', '28.12404');
INSERT INTO `counties` VALUES ('817', '安吉县', '94', '0', '0', '119.68158', '30.63798');
INSERT INTO `counties` VALUES ('818', '长兴县', '94', '0', '0', '119.90783', '31.00606');
INSERT INTO `counties` VALUES ('819', '德清县', '94', '0', '0', '119.97836', '30.53369');
INSERT INTO `counties` VALUES ('820', '南浔区', '94', '0', '0', '120.42038', '30.86686');
INSERT INTO `counties` VALUES ('821', '吴兴区', '94', '0', '0', '120.12548', '30.85752');
INSERT INTO `counties` VALUES ('822', '海宁市', '93', '0', '0', '120.6813', '30.5097');
INSERT INTO `counties` VALUES ('823', '海盐县', '93', '0', '0', '120.9457', '30.52547');
INSERT INTO `counties` VALUES ('824', '嘉善县', '93', '0', '0', '120.92559', '30.82993');
INSERT INTO `counties` VALUES ('825', '南湖区', '93', '0', '0', '120.78524', '30.74865');
INSERT INTO `counties` VALUES ('826', '平湖市', '93', '0', '0', '121.02166', '30.69618');
INSERT INTO `counties` VALUES ('827', '桐乡市', '93', '0', '0', '120.56485', '30.6302');
INSERT INTO `counties` VALUES ('828', '秀洲区', '93', '0', '0', '120.70867', '30.76454');
INSERT INTO `counties` VALUES ('829', '上虞市', '95', '0', '0', '120.87', '30.03');
INSERT INTO `counties` VALUES ('830', '绍兴县', '95', '0', '0', '120.47', '30.08');
INSERT INTO `counties` VALUES ('831', '新昌县', '95', '0', '0', '120.90435', '29.49991');
INSERT INTO `counties` VALUES ('832', '越城区', '95', '0', '0', '120.5819', '29.98895');
INSERT INTO `counties` VALUES ('833', '诸暨市', '95', '0', '0', '120.23629', '29.71358');
INSERT INTO `counties` VALUES ('834', '嵊州市', '95', '0', '0', '120.82174', '29.58854');
INSERT INTO `counties` VALUES ('835', '江山市', '97', '0', '0', '118.62674', '28.7386');
INSERT INTO `counties` VALUES ('836', '常山县', '97', '0', '0', '118.51025', '28.90191');
INSERT INTO `counties` VALUES ('837', '开化县', '97', '0', '0', '118.41616', '29.13785');
INSERT INTO `counties` VALUES ('838', '柯城区', '97', '0', '0', '118.87109', '28.96858');
INSERT INTO `counties` VALUES ('839', '龙游县', '97', '0', '0', '119.17221', '29.02823');
INSERT INTO `counties` VALUES ('840', '衢江区', '97', '0', '0', '118.9598', '28.97977');
INSERT INTO `counties` VALUES ('841', '东阳市', '96', '0', '0', '120.24185', '29.28942');
INSERT INTO `counties` VALUES ('842', '金东区', '96', '0', '0', '119.69302', '29.0991');
INSERT INTO `counties` VALUES ('843', '兰溪市', '96', '0', '0', '119.45965', '29.20841');
INSERT INTO `counties` VALUES ('844', '浦江县', '96', '0', '0', '119.89181', '29.45353');
INSERT INTO `counties` VALUES ('845', '义乌市', '96', '0', '0', '120.0744', '29.30558');
INSERT INTO `counties` VALUES ('846', '婺城区', '96', '0', '0', '119.57135', '29.09521');
INSERT INTO `counties` VALUES ('847', '磐安县', '96', '0', '0', '120.45022', '29.05733');
INSERT INTO `counties` VALUES ('848', '武义县', '96', '0', '0', '119.8164', '28.89331');
INSERT INTO `counties` VALUES ('849', '永康市', '96', '0', '0', '120.04727', '28.88844');
INSERT INTO `counties` VALUES ('850', '定海区', '98', '0', '0', '122.10677', '30.01985');
INSERT INTO `counties` VALUES ('851', '普陀区', '98', '0', '0', '121.39703', '31.24951');
INSERT INTO `counties` VALUES ('852', '岱山县', '98', '0', '0', '122.20486', '30.24385');
INSERT INTO `counties` VALUES ('853', '嵊泗县', '98', '0', '0', '122.45129', '30.72678');
INSERT INTO `counties` VALUES ('854', '景宁畲族自治县', '100', '0', '0', '119.63839', '27.97393');
INSERT INTO `counties` VALUES ('855', '莲都区', '100', '0', '0', '119.9127', '28.44583');
INSERT INTO `counties` VALUES ('856', '龙泉市', '100', '0', '0', '119.14163', '28.0743');
INSERT INTO `counties` VALUES ('857', '青田县', '100', '0', '0', '120.29028', '28.13897');
INSERT INTO `counties` VALUES ('858', '庆元县', '100', '0', '0', '119.06256', '27.61842');
INSERT INTO `counties` VALUES ('859', '松阳县', '100', '0', '0', '119.48199', '28.4494');
INSERT INTO `counties` VALUES ('860', '遂昌县', '100', '0', '0', '119.27606', '28.59291');
INSERT INTO `counties` VALUES ('861', '云和县', '100', '0', '0', '119.57287', '28.11643');
INSERT INTO `counties` VALUES ('862', '缙云县', '100', '0', '0', '120.09036', '28.65944');
INSERT INTO `counties` VALUES ('863', '包河区', '101', '0', '0', '117.30984', '31.79502');
INSERT INTO `counties` VALUES ('864', '长丰县', '101', '0', '0', '117.16549', '32.47959');
INSERT INTO `counties` VALUES ('865', '巢湖市', '101', '0', '0', '117.874155', '31.600518');
INSERT INTO `counties` VALUES ('866', '肥东县', '101', '0', '0', '117.47128', '31.88525');
INSERT INTO `counties` VALUES ('867', '肥西县', '101', '0', '0', '117.16845', '31.72143');
INSERT INTO `counties` VALUES ('868', '庐江县', '101', '0', '0', '117.289844', '31.251488');
INSERT INTO `counties` VALUES ('869', '庐阳区', '101', '0', '0', '117.26452', '31.87874');
INSERT INTO `counties` VALUES ('870', '蜀山区', '101', '0', '0', '117.26104', '31.85117');
INSERT INTO `counties` VALUES ('871', '瑶海区', '101', '0', '0', '117.30947', '31.85809');
INSERT INTO `counties` VALUES ('872', '黄岩区', '99', '0', '0', '121.25891', '28.65077');
INSERT INTO `counties` VALUES ('873', '路桥区', '99', '0', '0', '121.37381', '28.58016');
INSERT INTO `counties` VALUES ('874', '温岭市', '99', '0', '0', '121.38595', '28.37176');
INSERT INTO `counties` VALUES ('875', '玉环县', '99', '0', '0', '121.23242', '28.13637');
INSERT INTO `counties` VALUES ('876', '三门县', '99', '0', '0', '121.3937', '29.1051');
INSERT INTO `counties` VALUES ('877', '天台县', '99', '0', '0', '121.00848', '29.1429');
INSERT INTO `counties` VALUES ('878', '椒江区', '99', '0', '0', '121.44287', '28.67301');
INSERT INTO `counties` VALUES ('879', '临海市', '99', '0', '0', '121.13885', '28.85603');
INSERT INTO `counties` VALUES ('880', '仙居县', '99', '0', '0', '120.72872', '28.84672');
INSERT INTO `counties` VALUES ('881', '蚌山区', '103', '0', '0', '117.36767', '32.94411');
INSERT INTO `counties` VALUES ('882', '固镇县', '103', '0', '0', '117.31558', '33.31803');
INSERT INTO `counties` VALUES ('883', '怀远县', '103', '0', '0', '117.20507', '32.97007');
INSERT INTO `counties` VALUES ('884', '淮上区', '103', '0', '0', '117.35983', '32.96423');
INSERT INTO `counties` VALUES ('885', '龙子湖区', '103', '0', '0', '117.39379', '32.94301');
INSERT INTO `counties` VALUES ('886', '五河县', '103', '0', '0', '117.89144', '33.14457');
INSERT INTO `counties` VALUES ('887', '禹会区', '103', '0', '0', '117.35315', '32.93336');
INSERT INTO `counties` VALUES ('888', '繁昌县', '102', '0', '0', '118.19982', '31.08319');
INSERT INTO `counties` VALUES ('889', '镜湖区', '102', '0', '0', '118.38525', '31.34038');
INSERT INTO `counties` VALUES ('890', '南陵县', '102', '0', '0', '118.33688', '30.91969');
INSERT INTO `counties` VALUES ('891', '三山区', '102', '0', '0', '118.22509', '31.20703');
INSERT INTO `counties` VALUES ('892', '无为县', '102', '0', '0', '117.911432', '31.303075');
INSERT INTO `counties` VALUES ('893', '芜湖县', '102', '0', '0', '118.57525', '31.13476');
INSERT INTO `counties` VALUES ('894', '弋江区', '102', '0', '0', '118.37265', '31.31178');
INSERT INTO `counties` VALUES ('895', '鸠江区', '102', '0', '0', '118.39215', '31.36928');
INSERT INTO `counties` VALUES ('896', '当涂县', '105', '0', '0', '118.49786', '31.57098');
INSERT INTO `counties` VALUES ('897', '含山县', '105', '0', '0', '118.105545', '31.727758');
INSERT INTO `counties` VALUES ('898', '和县', '105', '0', '0', '118.351405', '31.741794');
INSERT INTO `counties` VALUES ('899', '雨山区', '105', '0', '0', '118.49869', '31.68219');
INSERT INTO `counties` VALUES ('900', '花山区', '105', '0', '0', '118.51231', '31.7001');
INSERT INTO `counties` VALUES ('901', '八公山区', '104', '0', '0', '116.83694', '32.62941');
INSERT INTO `counties` VALUES ('902', '大通区', '104', '0', '0', '117.05255', '32.63265');
INSERT INTO `counties` VALUES ('903', '凤台县', '104', '0', '0', '116.71569', '32.70752');
INSERT INTO `counties` VALUES ('904', '潘集区', '104', '0', '0', '116.81622', '32.78287');
INSERT INTO `counties` VALUES ('905', '田家庵区', '104', '0', '0', '117.01739', '32.64697');
INSERT INTO `counties` VALUES ('906', '谢家集区', '104', '0', '0', '116.86377', '32.59818');
INSERT INTO `counties` VALUES ('907', '杜集区', '106', '0', '0', '116.82998', '33.99363');
INSERT INTO `counties` VALUES ('908', '烈山区', '106', '0', '0', '116.81448', '33.89355');
INSERT INTO `counties` VALUES ('909', '相山区', '106', '0', '0', '116.79464', '33.95979');
INSERT INTO `counties` VALUES ('910', '濉溪县', '106', '0', '0', '116.76785', '33.91455');
INSERT INTO `counties` VALUES ('911', '大观区', '108', '0', '0', '117.03426', '30.51216');
INSERT INTO `counties` VALUES ('912', '怀宁县', '108', '0', '0', '116.82968', '30.73376');
INSERT INTO `counties` VALUES ('913', '潜山县', '108', '0', '0', '116.57574', '30.63037');
INSERT INTO `counties` VALUES ('914', '宿松县', '108', '0', '0', '116.12915', '30.1536');
INSERT INTO `counties` VALUES ('915', '太湖县', '108', '0', '0', '116.3088', '30.4541');
INSERT INTO `counties` VALUES ('916', '桐城市', '108', '0', '0', '116.95071', '31.05216');
INSERT INTO `counties` VALUES ('917', '望江县', '108', '0', '0', '116.68814', '30.12585');
INSERT INTO `counties` VALUES ('918', '宜秀区', '108', '0', '0', '117.06127', '30.50783');
INSERT INTO `counties` VALUES ('919', '迎江区', '108', '0', '0', '117.0493', '30.50421');
INSERT INTO `counties` VALUES ('920', '岳西县', '108', '0', '0', '116.35995', '30.84983');
INSERT INTO `counties` VALUES ('921', '枞阳县', '108', '0', '0', '117.22015', '30.69956');
INSERT INTO `counties` VALUES ('922', '铜陵县', '107', '0', '0', '117.79113', '30.95365');
INSERT INTO `counties` VALUES ('923', '狮子山区', '107', '0', '0', '117.89178', '30.92631');
INSERT INTO `counties` VALUES ('924', '铜官山区', '107', '0', '0', '117.81525', '30.93423');
INSERT INTO `counties` VALUES ('925', '郊区', '107', '0', '0', '113.58539', '37.94139');
INSERT INTO `counties` VALUES ('926', '黄山区', '109', '0', '0', '118.1416', '30.2729');
INSERT INTO `counties` VALUES ('927', '徽州区', '109', '0', '0', '118.33654', '29.82784');
INSERT INTO `counties` VALUES ('928', '祁门县', '109', '0', '0', '117.71847', '29.85723');
INSERT INTO `counties` VALUES ('929', '屯溪区', '109', '0', '0', '118.33368', '29.71138');
INSERT INTO `counties` VALUES ('930', '休宁县', '109', '0', '0', '118.18136', '29.78607');
INSERT INTO `counties` VALUES ('931', '歙县', '109', '0', '0', '118.43676', '29.86745');
INSERT INTO `counties` VALUES ('932', '黟县', '109', '0', '0', '117.94137', '29.92588');
INSERT INTO `counties` VALUES ('933', '琅琊区', '110', '0', '0', '118.30538', '32.29521');
INSERT INTO `counties` VALUES ('934', '定远县', '110', '0', '0', '117.68035', '32.52488');
INSERT INTO `counties` VALUES ('935', '凤阳县', '110', '0', '0', '117.56454', '32.86507');
INSERT INTO `counties` VALUES ('936', '来安县', '110', '0', '0', '118.43438', '32.45176');
INSERT INTO `counties` VALUES ('937', '明光市', '110', '0', '0', '117.99093', '32.77819');
INSERT INTO `counties` VALUES ('938', '南谯区', '110', '0', '0', '118.31222', '32.31861');
INSERT INTO `counties` VALUES ('939', '全椒县', '110', '0', '0', '118.27291', '32.08524');
INSERT INTO `counties` VALUES ('940', '天长市', '110', '0', '0', '118.99868', '32.69124');
INSERT INTO `counties` VALUES ('941', '埇桥区', '112', '0', '0', '116.97731', '33.64058');
INSERT INTO `counties` VALUES ('942', '灵璧县', '112', '0', '0', '117.55813', '33.54339');
INSERT INTO `counties` VALUES ('943', '萧县', '112', '0', '0', '116.94546', '34.1879');
INSERT INTO `counties` VALUES ('944', '泗县', '112', '0', '0', '117.91033', '33.48295');
INSERT INTO `counties` VALUES ('945', '砀山县', '112', '0', '0', '116.35363', '34.42356');
INSERT INTO `counties` VALUES ('946', '阜南县', '111', '0', '0', '115.58563', '32.63551');
INSERT INTO `counties` VALUES ('947', '界首市', '111', '0', '0', '115.37445', '33.25714');
INSERT INTO `counties` VALUES ('948', '临泉县', '111', '0', '0', '115.26232', '33.06758');
INSERT INTO `counties` VALUES ('949', '太和县', '111', '0', '0', '115.62191', '33.16025');
INSERT INTO `counties` VALUES ('950', '颍东区', '111', '0', '0', '115.85659', '32.91296');
INSERT INTO `counties` VALUES ('951', '颍泉区', '111', '0', '0', '115.80712', '32.9249');
INSERT INTO `counties` VALUES ('952', '颍上县', '111', '0', '0', '116.26458', '32.62998');
INSERT INTO `counties` VALUES ('953', '颍州区', '111', '0', '0', '115.80694', '32.88346');
INSERT INTO `counties` VALUES ('954', '东至县', '116', '0', '0', '117.02719', '30.0969');
INSERT INTO `counties` VALUES ('955', '贵池区', '116', '0', '0', '117.48722', '30.65283');
INSERT INTO `counties` VALUES ('956', '青阳县', '116', '0', '0', '117.84744', '30.63932');
INSERT INTO `counties` VALUES ('957', '石台县', '116', '0', '0', '117.48666', '30.21042');
INSERT INTO `counties` VALUES ('958', '霍邱县', '114', '0', '0', '116.27795', '32.353');
INSERT INTO `counties` VALUES ('959', '霍山县', '114', '0', '0', '116.33291', '31.3929');
INSERT INTO `counties` VALUES ('960', '金安区', '114', '0', '0', '116.50912', '31.75573');
INSERT INTO `counties` VALUES ('961', '金寨县', '114', '0', '0', '115.93463', '31.7351');
INSERT INTO `counties` VALUES ('962', '寿县', '114', '0', '0', '116.78466', '32.57653');
INSERT INTO `counties` VALUES ('963', '舒城县', '114', '0', '0', '116.94491', '31.46413');
INSERT INTO `counties` VALUES ('964', '裕安区', '114', '0', '0', '116.47985', '31.73787');
INSERT INTO `counties` VALUES ('965', '利辛县', '115', '0', '0', '116.208', '33.14198');
INSERT INTO `counties` VALUES ('966', '蒙城县', '115', '0', '0', '116.5646', '33.26477');
INSERT INTO `counties` VALUES ('967', '涡阳县', '115', '0', '0', '116.21682', '33.50911');
INSERT INTO `counties` VALUES ('968', '谯城区', '115', '0', '0', '115.77941', '33.87532');
INSERT INTO `counties` VALUES ('969', '广德县', '117', '0', '0', '119.41769', '30.89371');
INSERT INTO `counties` VALUES ('970', '绩溪县', '117', '0', '0', '118.59765', '30.07069');
INSERT INTO `counties` VALUES ('971', '郎溪县', '117', '0', '0', '119.17923', '31.12599');
INSERT INTO `counties` VALUES ('972', '宁国市', '117', '0', '0', '118.98349', '30.6238');
INSERT INTO `counties` VALUES ('973', '宣州区', '117', '0', '0', '118.75462', '30.94439');
INSERT INTO `counties` VALUES ('974', '泾县', '117', '0', '0', '118.41964', '30.69498');
INSERT INTO `counties` VALUES ('975', '旌德县', '117', '0', '0', '118.54299', '30.28898');
INSERT INTO `counties` VALUES ('976', '鼓楼区', '118', '0', '0', '118.76974', '32.06632');
INSERT INTO `counties` VALUES ('977', '仓山区', '118', '0', '0', '119.31543', '26.04335');
INSERT INTO `counties` VALUES ('978', '长乐市', '118', '0', '0', '119.52313', '25.96276');
INSERT INTO `counties` VALUES ('979', '福清市', '118', '0', '0', '119.38507', '25.72086');
INSERT INTO `counties` VALUES ('980', '晋安区', '118', '0', '0', '119.32828', '26.0818');
INSERT INTO `counties` VALUES ('981', '连江县', '118', '0', '0', '119.53433', '26.19466');
INSERT INTO `counties` VALUES ('982', '罗源县', '118', '0', '0', '119.5509', '26.48752');
INSERT INTO `counties` VALUES ('983', '马尾区', '118', '0', '0', '119.4555', '25.98942');
INSERT INTO `counties` VALUES ('984', '闽侯县', '118', '0', '0', '119.13388', '26.15014');
INSERT INTO `counties` VALUES ('985', '闽清县', '118', '0', '0', '118.8623', '26.21901');
INSERT INTO `counties` VALUES ('986', '平潭县', '118', '0', '0', '119.791197', '25.503672');
INSERT INTO `counties` VALUES ('987', '台江区', '118', '0', '0', '119.30899', '26.06204');
INSERT INTO `counties` VALUES ('988', '永泰县', '118', '0', '0', '118.936', '25.86816');
INSERT INTO `counties` VALUES ('989', '城厢区', '120', '0', '0', '118.99462', '25.41872');
INSERT INTO `counties` VALUES ('990', '涵江区', '120', '0', '0', '119.11621', '25.45876');
INSERT INTO `counties` VALUES ('991', '荔城区', '120', '0', '0', '119.01339', '25.43369');
INSERT INTO `counties` VALUES ('992', '仙游县', '120', '0', '0', '118.69177', '25.36214');
INSERT INTO `counties` VALUES ('993', '秀屿区', '120', '0', '0', '119.10553', '25.31831');
INSERT INTO `counties` VALUES ('994', '泉港区', '122', '0', '0', '118.91586', '25.12005');
INSERT INTO `counties` VALUES ('995', '石狮市', '122', '0', '0', '118.64779', '24.73242');
INSERT INTO `counties` VALUES ('996', '安溪县', '122', '0', '0', '118.18719', '25.05627');
INSERT INTO `counties` VALUES ('997', '德化县', '122', '0', '0', '118.24176', '25.49224');
INSERT INTO `counties` VALUES ('998', '丰泽区', '122', '0', '0', '118.61328', '24.89119');
INSERT INTO `counties` VALUES ('999', '惠安县', '122', '0', '0', '118.79687', '25.03059');
INSERT INTO `counties` VALUES ('1000', '金门县', '122', '0', '0', '118.32263', '24.42922');
INSERT INTO `counties` VALUES ('1001', '晋江市', '122', '0', '0', '118.55194', '24.78141');
INSERT INTO `counties` VALUES ('1002', '鲤城区', '122', '0', '0', '118.56591', '24.88741');
INSERT INTO `counties` VALUES ('1003', '洛江区', '122', '0', '0', '118.67111', '24.93984');
INSERT INTO `counties` VALUES ('1004', '南安市', '122', '0', '0', '118.38589', '24.96055');
INSERT INTO `counties` VALUES ('1005', '永春县', '122', '0', '0', '118.29437', '25.32183');
INSERT INTO `counties` VALUES ('1006', '大田县', '121', '0', '0', '117.8471', '25.6926');
INSERT INTO `counties` VALUES ('1007', '建宁县', '121', '0', '0', '116.84603', '26.83091');
INSERT INTO `counties` VALUES ('1008', '将乐县', '121', '0', '0', '117.47317', '26.72837');
INSERT INTO `counties` VALUES ('1009', '梅列区', '121', '0', '0', '117.64585', '26.27171');
INSERT INTO `counties` VALUES ('1010', '明溪县', '121', '0', '0', '117.20498', '26.35294');
INSERT INTO `counties` VALUES ('1011', '宁化县', '121', '0', '0', '116.66101', '26.25874');
INSERT INTO `counties` VALUES ('1012', '清流县', '121', '0', '0', '116.8146', '26.17144');
INSERT INTO `counties` VALUES ('1013', '三元区', '121', '0', '0', '117.60788', '26.23372');
INSERT INTO `counties` VALUES ('1014', '沙县', '121', '0', '0', '117.79266', '26.39615');
INSERT INTO `counties` VALUES ('1015', '泰宁县', '121', '0', '0', '117.17578', '26.9001');
INSERT INTO `counties` VALUES ('1016', '永安市', '121', '0', '0', '117.36517', '25.94136');
INSERT INTO `counties` VALUES ('1017', '尤溪县', '121', '0', '0', '118.19049', '26.17002');
INSERT INTO `counties` VALUES ('1018', '云霄县', '123', '0', '0', '117.34051', '23.95534');
INSERT INTO `counties` VALUES ('1019', '长泰县', '123', '0', '0', '117.75924', '24.62526');
INSERT INTO `counties` VALUES ('1020', '东山县', '123', '0', '0', '117.42822', '23.70109');
INSERT INTO `counties` VALUES ('1021', '华安县', '123', '0', '0', '117.54077', '25.00563');
INSERT INTO `counties` VALUES ('1022', '龙海市', '123', '0', '0', '117.81802', '24.44655');
INSERT INTO `counties` VALUES ('1023', '龙文区', '123', '0', '0', '117.70971', '24.50323');
INSERT INTO `counties` VALUES ('1024', '南靖县', '123', '0', '0', '117.35736', '24.51448');
INSERT INTO `counties` VALUES ('1025', '平和县', '123', '0', '0', '117.3124', '24.36395');
INSERT INTO `counties` VALUES ('1026', '漳浦县', '123', '0', '0', '117.61367', '24.11706');
INSERT INTO `counties` VALUES ('1027', '诏安县', '123', '0', '0', '117.17501', '23.71148');
INSERT INTO `counties` VALUES ('1028', '芗城区', '123', '0', '0', '117.65402', '24.51081');
INSERT INTO `counties` VALUES ('1029', '长汀县', '125', '0', '0', '116.35888', '25.82773');
INSERT INTO `counties` VALUES ('1030', '连城县', '125', '0', '0', '116.75454', '25.7103');
INSERT INTO `counties` VALUES ('1031', '上杭县', '125', '0', '0', '116.42022', '25.04943');
INSERT INTO `counties` VALUES ('1032', '武平县', '125', '0', '0', '116.10229', '25.09244');
INSERT INTO `counties` VALUES ('1033', '新罗区', '125', '0', '0', '117.03693', '25.09834');
INSERT INTO `counties` VALUES ('1034', '永定县', '125', '0', '0', '116.73', '24.72');
INSERT INTO `counties` VALUES ('1035', '漳平市', '125', '0', '0', '117.41992', '25.29109');
INSERT INTO `counties` VALUES ('1036', '光泽县', '124', '0', '0', '117.33346', '27.54231');
INSERT INTO `counties` VALUES ('1037', '建阳市', '124', '0', '0', '118.12', '27.33');
INSERT INTO `counties` VALUES ('1038', '建瓯市', '124', '0', '0', '118.29766', '27.02301');
INSERT INTO `counties` VALUES ('1039', '浦城县', '124', '0', '0', '118.54007', '27.91888');
INSERT INTO `counties` VALUES ('1040', '邵武市', '124', '0', '0', '117.4924', '27.34033');
INSERT INTO `counties` VALUES ('1041', '顺昌县', '124', '0', '0', '117.8103', '26.79298');
INSERT INTO `counties` VALUES ('1042', '松溪县', '124', '0', '0', '118.78533', '27.52624');
INSERT INTO `counties` VALUES ('1043', '武夷山市', '124', '0', '0', '118.03665', '27.75543');
INSERT INTO `counties` VALUES ('1044', '延平区', '124', '0', '0', '118.18189', '26.63745');
INSERT INTO `counties` VALUES ('1045', '政和县', '124', '0', '0', '118.85571', '27.36769');
INSERT INTO `counties` VALUES ('1046', '安义县', '127', '0', '0', '115.54879', '28.84602');
INSERT INTO `counties` VALUES ('1047', '东湖区', '127', '0', '0', '115.8988', '28.68505');
INSERT INTO `counties` VALUES ('1048', '进贤县', '127', '0', '0', '116.24087', '28.37679');
INSERT INTO `counties` VALUES ('1049', '南昌县', '127', '0', '0', '115.94393', '28.54559');
INSERT INTO `counties` VALUES ('1050', '青山湖区', '127', '0', '0', '115.9617', '28.68206');
INSERT INTO `counties` VALUES ('1051', '青云谱区', '127', '0', '0', '115.915', '28.63199');
INSERT INTO `counties` VALUES ('1052', '湾里区', '127', '0', '0', '115.73104', '28.71529');
INSERT INTO `counties` VALUES ('1053', '西湖区', '127', '0', '0', '120.12979', '30.25949');
INSERT INTO `counties` VALUES ('1054', '新建县', '127', '0', '0', '115.81546', '28.69248');
INSERT INTO `counties` VALUES ('1055', '乐平市', '128', '0', '0', '117.12887', '28.96295');
INSERT INTO `counties` VALUES ('1056', '昌江区', '128', '0', '0', '117.18359', '29.27321');
INSERT INTO `counties` VALUES ('1057', '浮梁县', '128', '0', '0', '117.21517', '29.35156');
INSERT INTO `counties` VALUES ('1058', '珠山区', '128', '0', '0', '117.20233', '29.30127');
INSERT INTO `counties` VALUES ('1059', '安源区', '129', '0', '0', '113.89135', '27.61653');
INSERT INTO `counties` VALUES ('1060', '莲花县', '129', '0', '0', '113.96142', '27.12866');
INSERT INTO `counties` VALUES ('1061', '芦溪县', '129', '0', '0', '114.02951', '27.63063');
INSERT INTO `counties` VALUES ('1062', '上栗县', '129', '0', '0', '113.79403', '27.87467');
INSERT INTO `counties` VALUES ('1063', '湘东区', '129', '0', '0', '113.73294', '27.64007');
INSERT INTO `counties` VALUES ('1064', '福安市', '126', '0', '0', '119.6495', '27.08673');
INSERT INTO `counties` VALUES ('1065', '福鼎市', '126', '0', '0', '120.21664', '27.3243');
INSERT INTO `counties` VALUES ('1066', '古田县', '126', '0', '0', '118.74688', '26.57682');
INSERT INTO `counties` VALUES ('1067', '蕉城区', '126', '0', '0', '119.52643', '26.66048');
INSERT INTO `counties` VALUES ('1068', '屏南县', '126', '0', '0', '118.98861', '26.91099');
INSERT INTO `counties` VALUES ('1069', '寿宁县', '126', '0', '0', '119.5039', '27.45996');
INSERT INTO `counties` VALUES ('1070', '霞浦县', '126', '0', '0', '119.99893', '26.88578');
INSERT INTO `counties` VALUES ('1071', '周宁县', '126', '0', '0', '119.33837', '27.10664');
INSERT INTO `counties` VALUES ('1072', '柘荣县', '126', '0', '0', '119.89971', '27.23543');
INSERT INTO `counties` VALUES ('1073', '修水县', '130', '0', '0', '114.54684', '29.02539');
INSERT INTO `counties` VALUES ('1074', '永修县', '130', '0', '0', '115.80911', '29.02093');
INSERT INTO `counties` VALUES ('1075', '湖口县', '130', '0', '0', '116.21853', '29.73818');
INSERT INTO `counties` VALUES ('1076', '庐山区', '130', '0', '0', '115.98904', '29.67177');
INSERT INTO `counties` VALUES ('1077', '彭泽县', '130', '0', '0', '116.55011', '29.89589');
INSERT INTO `counties` VALUES ('1078', '浔阳区', '130', '0', '0', '115.98986', '29.72786');
INSERT INTO `counties` VALUES ('1079', '德安县', '130', '0', '0', '115.75601', '29.31341');
INSERT INTO `counties` VALUES ('1080', '都昌县', '130', '0', '0', '116.20401', '29.27327');
INSERT INTO `counties` VALUES ('1081', '九江县', '130', '0', '0', '115.91128', '29.60852');
INSERT INTO `counties` VALUES ('1082', '瑞昌市', '130', '0', '0', '115.66705', '29.67183');
INSERT INTO `counties` VALUES ('1083', '武宁县', '130', '0', '0', '115.10061', '29.2584');
INSERT INTO `counties` VALUES ('1084', '星子县', '130', '0', '0', '116.04492', '29.44608');
INSERT INTO `counties` VALUES ('1085', '分宜县', '131', '0', '0', '114.69189', '27.81475');
INSERT INTO `counties` VALUES ('1086', '渝水区', '131', '0', '0', '114.944', '27.80098');
INSERT INTO `counties` VALUES ('1087', '贵溪市', '132', '0', '0', '117.24246', '28.2926');
INSERT INTO `counties` VALUES ('1088', '余江县', '132', '0', '0', '116.81851', '28.21034');
INSERT INTO `counties` VALUES ('1089', '月湖区', '132', '0', '0', '117.03732', '28.23913');
INSERT INTO `counties` VALUES ('1090', '安福县', '134', '0', '0', '114.61956', '27.39276');
INSERT INTO `counties` VALUES ('1091', '吉安县', '134', '0', '0', '114.90695', '27.04048');
INSERT INTO `counties` VALUES ('1092', '吉水县', '134', '0', '0', '115.1343', '27.21071');
INSERT INTO `counties` VALUES ('1093', '吉州区', '134', '0', '0', '114.97598', '27.10669');
INSERT INTO `counties` VALUES ('1094', '井冈山市', '134', '0', '0', '114.28949', '26.74804');
INSERT INTO `counties` VALUES ('1095', '青原区', '134', '0', '0', '115.01747', '27.10577');
INSERT INTO `counties` VALUES ('1096', '遂川县', '134', '0', '0', '114.51629', '26.32598');
INSERT INTO `counties` VALUES ('1097', '泰和县', '134', '0', '0', '114.90789', '26.79113');
INSERT INTO `counties` VALUES ('1098', '万安县', '134', '0', '0', '114.78659', '26.45931');
INSERT INTO `counties` VALUES ('1099', '峡江县', '134', '0', '0', '115.31723', '27.576');
INSERT INTO `counties` VALUES ('1100', '新干县', '134', '0', '0', '115.39306', '27.74092');
INSERT INTO `counties` VALUES ('1101', '永丰县', '134', '0', '0', '115.44238', '27.31785');
INSERT INTO `counties` VALUES ('1102', '永新县', '134', '0', '0', '114.24246', '26.94488');
INSERT INTO `counties` VALUES ('1103', '定南县', '133', '0', '0', '115.02713', '24.78395');
INSERT INTO `counties` VALUES ('1104', '全南县', '133', '0', '0', '114.5292', '24.74324');
INSERT INTO `counties` VALUES ('1105', '安远县', '133', '0', '0', '115.39483', '25.1371');
INSERT INTO `counties` VALUES ('1106', '崇义县', '133', '0', '0', '114.30835', '25.68186');
INSERT INTO `counties` VALUES ('1107', '大余县', '133', '0', '0', '114.35757', '25.39561');
INSERT INTO `counties` VALUES ('1108', '赣县', '133', '0', '0', '115.01171', '25.86149');
INSERT INTO `counties` VALUES ('1109', '会昌县', '133', '0', '0', '115.78555', '25.60068');
INSERT INTO `counties` VALUES ('1110', '龙南县', '133', '0', '0', '114.78994', '24.91086');
INSERT INTO `counties` VALUES ('1111', '南康市', '133', '0', '0', '114.75', '25.65');
INSERT INTO `counties` VALUES ('1112', '宁都县', '133', '0', '0', '116.01565', '26.47227');
INSERT INTO `counties` VALUES ('1113', '瑞金市', '133', '0', '0', '116.02703', '25.88557');
INSERT INTO `counties` VALUES ('1114', '上犹县', '133', '0', '0', '114.54138', '25.79567');
INSERT INTO `counties` VALUES ('1115', '石城县', '133', '0', '0', '116.3442', '26.32617');
INSERT INTO `counties` VALUES ('1116', '信丰县', '133', '0', '0', '114.92279', '25.38612');
INSERT INTO `counties` VALUES ('1117', '兴国县', '133', '0', '0', '115.36309', '26.33776');
INSERT INTO `counties` VALUES ('1118', '寻乌县', '133', '0', '0', '115.64852', '24.95513');
INSERT INTO `counties` VALUES ('1119', '于都县', '133', '0', '0', '115.41415', '25.95257');
INSERT INTO `counties` VALUES ('1120', '章贡区', '133', '0', '0', '114.94284', '25.8624');
INSERT INTO `counties` VALUES ('1121', '丰城市', '135', '0', '0', '115.77114', '28.15918');
INSERT INTO `counties` VALUES ('1122', '奉新县', '135', '0', '0', '115.40036', '28.6879');
INSERT INTO `counties` VALUES ('1123', '高安市', '135', '0', '0', '115.3753', '28.4178');
INSERT INTO `counties` VALUES ('1124', '靖安县', '135', '0', '0', '115.36279', '28.86167');
INSERT INTO `counties` VALUES ('1125', '上高县', '135', '0', '0', '114.92459', '28.23423');
INSERT INTO `counties` VALUES ('1126', '铜鼓县', '135', '0', '0', '114.37036', '28.52311');
INSERT INTO `counties` VALUES ('1127', '万载县', '135', '0', '0', '114.4458', '28.10656');
INSERT INTO `counties` VALUES ('1128', '宜丰县', '135', '0', '0', '114.7803', '28.38555');
INSERT INTO `counties` VALUES ('1129', '袁州区', '135', '0', '0', '114.38246', '27.79649');
INSERT INTO `counties` VALUES ('1130', '樟树市', '135', '0', '0', '115.5465', '28.05332');
INSERT INTO `counties` VALUES ('1131', '玉山县', '137', '0', '0', '118.24462', '28.6818');
INSERT INTO `counties` VALUES ('1132', '广丰县', '137', '0', '0', '118.19158', '28.43766');
INSERT INTO `counties` VALUES ('1133', '横峰县', '137', '0', '0', '117.5964', '28.40716');
INSERT INTO `counties` VALUES ('1134', '铅山县', '137', '0', '0', '117.70996', '28.31549');
INSERT INTO `counties` VALUES ('1135', '上饶县', '137', '0', '0', '117.90884', '28.44856');
INSERT INTO `counties` VALUES ('1136', '万年县', '137', '0', '0', '117.06884', '28.69537');
INSERT INTO `counties` VALUES ('1137', '信州区', '137', '0', '0', '117.96682', '28.43121');
INSERT INTO `counties` VALUES ('1138', '余干县', '137', '0', '0', '116.69555', '28.70206');
INSERT INTO `counties` VALUES ('1139', '弋阳县', '137', '0', '0', '117.45929', '28.37451');
INSERT INTO `counties` VALUES ('1140', '德兴市', '137', '0', '0', '117.57919', '28.94736');
INSERT INTO `counties` VALUES ('1141', '鄱阳县', '137', '0', '0', '116.69967', '29.0118');
INSERT INTO `counties` VALUES ('1142', '婺源县', '137', '0', '0', '117.86105', '29.24841');
INSERT INTO `counties` VALUES ('1143', '金溪县', '136', '0', '0', '116.77392', '27.90753');
INSERT INTO `counties` VALUES ('1144', '崇仁县', '136', '0', '0', '116.06021', '27.75962');
INSERT INTO `counties` VALUES ('1145', '东乡县', '136', '0', '0', '116.59039', '28.23614');
INSERT INTO `counties` VALUES ('1146', '广昌县', '136', '0', '0', '116.32547', '26.8341');
INSERT INTO `counties` VALUES ('1147', '乐安县', '136', '0', '0', '115.83108', '27.42812');
INSERT INTO `counties` VALUES ('1148', '黎川县', '136', '0', '0', '116.90771', '27.28232');
INSERT INTO `counties` VALUES ('1149', '临川区', '136', '0', '0', '116.35919', '27.97721');
INSERT INTO `counties` VALUES ('1150', '南城县', '136', '0', '0', '116.64419', '27.55381');
INSERT INTO `counties` VALUES ('1151', '南丰县', '136', '0', '0', '116.5256', '27.21842');
INSERT INTO `counties` VALUES ('1152', '宜黄县', '136', '0', '0', '116.23626', '27.55487');
INSERT INTO `counties` VALUES ('1153', '资溪县', '136', '0', '0', '117.06939', '27.70493');
INSERT INTO `counties` VALUES ('1154', '城阳区', '139', '0', '0', '120.39621', '36.30735');
INSERT INTO `counties` VALUES ('1155', '黄岛区', '139', '0', '0', '120.19775', '35.96065');
INSERT INTO `counties` VALUES ('1156', '即墨市', '139', '0', '0', '120.44699', '36.38907');
INSERT INTO `counties` VALUES ('1157', '胶南市', '139', '0', '0', '120.03', '35.87');
INSERT INTO `counties` VALUES ('1158', '胶州市', '139', '0', '0', '120.0335', '36.26442');
INSERT INTO `counties` VALUES ('1159', '莱西市', '139', '0', '0', '120.51773', '36.88804');
INSERT INTO `counties` VALUES ('1160', '李沧区', '139', '0', '0', '120.43286', '36.14502');
INSERT INTO `counties` VALUES ('1161', '平度市', '139', '0', '0', '119.95996', '36.78688');
INSERT INTO `counties` VALUES ('1162', '市北区', '139', '0', '0', '120.37469', '36.08734');
INSERT INTO `counties` VALUES ('1163', '市南区', '139', '0', '0', '120.38773', '36.06671');
INSERT INTO `counties` VALUES ('1164', '四方区', '139', '0', '0', '120.35', '36.10');
INSERT INTO `counties` VALUES ('1165', '崂山区', '139', '0', '0', '120.46923', '36.10717');
INSERT INTO `counties` VALUES ('1166', '槐荫区', '138', '0', '0', '116.90075', '36.65136');
INSERT INTO `counties` VALUES ('1167', '长清区', '138', '0', '0', '116.75192', '36.55352');
INSERT INTO `counties` VALUES ('1168', '济阳县', '138', '0', '0', '117.17327', '36.97845');
INSERT INTO `counties` VALUES ('1169', '历城区', '138', '0', '0', '117.06509', '36.67995');
INSERT INTO `counties` VALUES ('1170', '历下区', '138', '0', '0', '117.0768', '36.66661');
INSERT INTO `counties` VALUES ('1171', '平阴县', '138', '0', '0', '116.45587', '36.28955');
INSERT INTO `counties` VALUES ('1172', '商河县', '138', '0', '0', '117.15722', '37.31119');
INSERT INTO `counties` VALUES ('1173', '市中区', '138', '0', '0', '116.99741', '36.65101');
INSERT INTO `counties` VALUES ('1174', '天桥区', '138', '0', '0', '116.98749', '36.67801');
INSERT INTO `counties` VALUES ('1175', '章丘市', '138', '0', '0', '117.53677', '36.71392');
INSERT INTO `counties` VALUES ('1176', '博山区', '140', '0', '0', '117.86166', '36.49469');
INSERT INTO `counties` VALUES ('1177', '高青县', '140', '0', '0', '117.82708', '37.17197');
INSERT INTO `counties` VALUES ('1178', '桓台县', '140', '0', '0', '118.09698', '36.96036');
INSERT INTO `counties` VALUES ('1179', '临淄区', '140', '0', '0', '118.30966', '36.8259');
INSERT INTO `counties` VALUES ('1180', '沂源县', '140', '0', '0', '118.17105', '36.18536');
INSERT INTO `counties` VALUES ('1181', '张店区', '140', '0', '0', '118.01788', '36.80676');
INSERT INTO `counties` VALUES ('1182', '周村区', '140', '0', '0', '117.86969', '36.80322');
INSERT INTO `counties` VALUES ('1183', '淄川区', '140', '0', '0', '117.96655', '36.64339');
INSERT INTO `counties` VALUES ('1184', '山亭区', '141', '0', '0', '117.4663', '35.09541');
INSERT INTO `counties` VALUES ('1185', '市中区', '141', '0', '0', '116.99741', '36.65101');
INSERT INTO `counties` VALUES ('1186', '台儿庄区', '141', '0', '0', '117.73452', '34.56363');
INSERT INTO `counties` VALUES ('1187', '薛城区', '141', '0', '0', '117.26318', '34.79498');
INSERT INTO `counties` VALUES ('1188', '峄城区', '141', '0', '0', '117.59057', '34.77225');
INSERT INTO `counties` VALUES ('1189', '滕州市', '141', '0', '0', '117.165', '35.10534');
INSERT INTO `counties` VALUES ('1190', '芝罘区', '143', '0', '0', '121.40023', '37.54064');
INSERT INTO `counties` VALUES ('1191', '长岛县', '143', '0', '0', '120.738', '37.91754');
INSERT INTO `counties` VALUES ('1192', '福山区', '143', '0', '0', '121.26812', '37.49841');
INSERT INTO `counties` VALUES ('1193', '海阳市', '143', '0', '0', '121.15976', '36.77622');
INSERT INTO `counties` VALUES ('1194', '莱山区', '143', '0', '0', '121.44512', '37.51165');
INSERT INTO `counties` VALUES ('1195', '莱阳市', '143', '0', '0', '120.71066', '36.98012');
INSERT INTO `counties` VALUES ('1196', '莱州市', '143', '0', '0', '119.94137', '37.17806');
INSERT INTO `counties` VALUES ('1197', '龙口市', '143', '0', '0', '120.50634', '37.64064');
INSERT INTO `counties` VALUES ('1198', '牟平区', '143', '0', '0', '121.60067', '37.38846');
INSERT INTO `counties` VALUES ('1199', '蓬莱市', '143', '0', '0', '120.75988', '37.81119');
INSERT INTO `counties` VALUES ('1200', '栖霞市', '143', '0', '0', '120.85025', '37.33571');
INSERT INTO `counties` VALUES ('1201', '招远市', '143', '0', '0', '120.40481', '37.36269');
INSERT INTO `counties` VALUES ('1202', '东营区', '142', '0', '0', '118.5816', '37.44875');
INSERT INTO `counties` VALUES ('1203', '广饶县', '142', '0', '0', '118.40704', '37.05381');
INSERT INTO `counties` VALUES ('1204', '河口区', '142', '0', '0', '118.5249', '37.88541');
INSERT INTO `counties` VALUES ('1205', '垦利县', '142', '0', '0', '118.54815', '37.58825');
INSERT INTO `counties` VALUES ('1206', '利津县', '142', '0', '0', '118.25637', '37.49157');
INSERT INTO `counties` VALUES ('1207', '嘉祥县', '145', '0', '0', '116.34249', '35.40836');
INSERT INTO `counties` VALUES ('1208', '金乡县', '145', '0', '0', '116.31146', '35.065');
INSERT INTO `counties` VALUES ('1209', '梁山县', '145', '0', '0', '116.09683', '35.80322');
INSERT INTO `counties` VALUES ('1210', '曲阜市', '145', '0', '0', '116.98645', '35.58091');
INSERT INTO `counties` VALUES ('1211', '任城区', '145', '0', '0', '116.59504', '35.40659');
INSERT INTO `counties` VALUES ('1212', '市中区', '145', '0', '0', '116.99741', '36.65101');
INSERT INTO `counties` VALUES ('1213', '微山县', '145', '0', '0', '117.12875', '34.80712');
INSERT INTO `counties` VALUES ('1214', '鱼台县', '145', '0', '0', '116.64761', '34.99674');
INSERT INTO `counties` VALUES ('1215', '邹城市', '145', '0', '0', '116.97335', '35.40531');
INSERT INTO `counties` VALUES ('1216', '兖州市', '145', '0', '0', '116.83', '35.55');
INSERT INTO `counties` VALUES ('1217', '汶上县', '145', '0', '0', '116.48742', '35.73295');
INSERT INTO `counties` VALUES ('1218', '泗水县', '145', '0', '0', '117.27948', '35.66113');
INSERT INTO `counties` VALUES ('1219', '新泰市', '146', '0', '0', '117.76959', '35.90887');
INSERT INTO `counties` VALUES ('1220', '东平县', '146', '0', '0', '116.47113', '35.93792');
INSERT INTO `counties` VALUES ('1221', '肥城市', '146', '0', '0', '116.76815', '36.18247');
INSERT INTO `counties` VALUES ('1222', '宁阳县', '146', '0', '0', '116.80542', '35.7599');
INSERT INTO `counties` VALUES ('1223', '泰山区', '146', '0', '0', '117.13446', '36.19411');
INSERT INTO `counties` VALUES ('1224', '岱岳区', '146', '0', '0', '117.04174', '36.1875');
INSERT INTO `counties` VALUES ('1225', '安丘市', '144', '0', '0', '119.2189', '36.47847');
INSERT INTO `counties` VALUES ('1226', '昌乐县', '144', '0', '0', '118.83017', '36.7078');
INSERT INTO `counties` VALUES ('1227', '昌邑市', '144', '0', '0', '119.39767', '36.86008');
INSERT INTO `counties` VALUES ('1228', '坊子区', '144', '0', '0', '119.16476', '36.65218');
INSERT INTO `counties` VALUES ('1229', '高密市', '144', '0', '0', '119.75701', '36.38397');
INSERT INTO `counties` VALUES ('1230', '寒亭区', '144', '0', '0', '119.21832', '36.77504');
INSERT INTO `counties` VALUES ('1231', '奎文区', '144', '0', '0', '119.12532', '36.70723');
INSERT INTO `counties` VALUES ('1232', '临朐县', '144', '0', '0', '118.544', '36.51216');
INSERT INTO `counties` VALUES ('1233', '青州市', '144', '0', '0', '118.47915', '36.68505');
INSERT INTO `counties` VALUES ('1234', '寿光市', '144', '0', '0', '118.74047', '36.88128');
INSERT INTO `counties` VALUES ('1235', '潍城区', '144', '0', '0', '119.10582', '36.7139');
INSERT INTO `counties` VALUES ('1236', '诸城市', '144', '0', '0', '119.40988', '35.99662');
INSERT INTO `counties` VALUES ('1237', '东港区', '148', '0', '0', '119.46237', '35.42541');
INSERT INTO `counties` VALUES ('1238', '五莲县', '148', '0', '0', '119.207', '35.75004');
INSERT INTO `counties` VALUES ('1239', '莒县', '148', '0', '0', '118.83789', '35.58054');
INSERT INTO `counties` VALUES ('1240', '岚山区', '148', '0', '0', '119.31884', '35.12203');
INSERT INTO `counties` VALUES ('1241', '钢城区', '149', '0', '0', '117.8049', '36.06319');
INSERT INTO `counties` VALUES ('1242', '莱城区', '149', '0', '0', '117.65986', '36.2032');
INSERT INTO `counties` VALUES ('1243', '环翠区', '147', '0', '0', '122.12344', '37.50199');
INSERT INTO `counties` VALUES ('1244', '荣成市', '147', '0', '0', '122.48773', '37.1652');
INSERT INTO `counties` VALUES ('1245', '乳山市', '147', '0', '0', '121.53814', '36.91918');
INSERT INTO `counties` VALUES ('1246', '文登市', '147', '0', '0', '122.05', '37.20');
INSERT INTO `counties` VALUES ('1247', '德城区', '151', '0', '0', '116.29943', '37.45126');
INSERT INTO `counties` VALUES ('1248', '乐陵市', '151', '0', '0', '117.23141', '37.73164');
INSERT INTO `counties` VALUES ('1249', '临邑县', '151', '0', '0', '116.86547', '37.19053');
INSERT INTO `counties` VALUES ('1250', '陵县', '151', '0', '0', '116.57', '37.33');
INSERT INTO `counties` VALUES ('1251', '宁津县', '151', '0', '0', '116.79702', '37.65301');
INSERT INTO `counties` VALUES ('1252', '平原县', '151', '0', '0', '116.43432', '37.16632');
INSERT INTO `counties` VALUES ('1253', '齐河县', '151', '0', '0', '116.75515', '36.79532');
INSERT INTO `counties` VALUES ('1254', '庆云县', '151', '0', '0', '117.38635', '37.77616');
INSERT INTO `counties` VALUES ('1255', '武城县', '151', '0', '0', '116.07009', '37.21403');
INSERT INTO `counties` VALUES ('1256', '夏津县', '151', '0', '0', '116.0017', '36.94852');
INSERT INTO `counties` VALUES ('1257', '禹城市', '151', '0', '0', '116.64309', '36.93444');
INSERT INTO `counties` VALUES ('1258', '苍山县', '150', '0', '0', '118.05', '34.85');
INSERT INTO `counties` VALUES ('1259', '费县', '150', '0', '0', '117.97836', '35.26562');
INSERT INTO `counties` VALUES ('1260', '河东区', '150', '0', '0', '117.22562', '39.12318');
INSERT INTO `counties` VALUES ('1261', '兰山区', '150', '0', '0', '118.34817', '35.06872');
INSERT INTO `counties` VALUES ('1262', '临沭县', '150', '0', '0', '118.65267', '34.92091');
INSERT INTO `counties` VALUES ('1263', '罗庄区', '150', '0', '0', '118.28466', '34.99627');
INSERT INTO `counties` VALUES ('1264', '蒙阴县', '150', '0', '0', '117.94592', '35.70996');
INSERT INTO `counties` VALUES ('1265', '平邑县', '150', '0', '0', '117.63867', '35.50573');
INSERT INTO `counties` VALUES ('1266', '沂南县', '150', '0', '0', '118.47061', '35.55131');
INSERT INTO `counties` VALUES ('1267', '沂水县', '150', '0', '0', '118.63009', '35.78731');
INSERT INTO `counties` VALUES ('1268', '郯城县', '150', '0', '0', '118.36712', '34.61354');
INSERT INTO `counties` VALUES ('1269', '莒南县', '150', '0', '0', '118.83227', '35.17539');
INSERT INTO `counties` VALUES ('1270', '东阿县', '152', '0', '0', '116.25012', '36.33209');
INSERT INTO `counties` VALUES ('1271', '东昌府区', '152', '0', '0', '115.97383', '36.44458');
INSERT INTO `counties` VALUES ('1272', '高唐县', '152', '0', '0', '116.23172', '36.86535');
INSERT INTO `counties` VALUES ('1273', '冠县', '152', '0', '0', '115.44195', '36.48429');
INSERT INTO `counties` VALUES ('1274', '临清市', '152', '0', '0', '115.70629', '36.83945');
INSERT INTO `counties` VALUES ('1275', '阳谷县', '152', '0', '0', '115.79126', '36.11444');
INSERT INTO `counties` VALUES ('1276', '茌平县', '152', '0', '0', '116.25491', '36.57969');
INSERT INTO `counties` VALUES ('1277', '莘县', '152', '0', '0', '115.6697', '36.23423');
INSERT INTO `counties` VALUES ('1278', '鄄城县', '154', '0', '0', '115.50997', '35.56412');
INSERT INTO `counties` VALUES ('1279', '曹县', '154', '0', '0', '115.54226', '34.82659');
INSERT INTO `counties` VALUES ('1280', '成武县', '154', '0', '0', '115.8897', '34.95332');
INSERT INTO `counties` VALUES ('1281', '单县', '154', '0', '0', '116.08703', '34.79514');
INSERT INTO `counties` VALUES ('1282', '定陶县', '154', '0', '0', '115.57287', '35.07118');
INSERT INTO `counties` VALUES ('1283', '东明县', '154', '0', '0', '115.09079', '35.28906');
INSERT INTO `counties` VALUES ('1284', '巨野县', '154', '0', '0', '116.09497', '35.39788');
INSERT INTO `counties` VALUES ('1285', '牡丹区', '154', '0', '0', '115.41662', '35.25091');
INSERT INTO `counties` VALUES ('1286', '郓城县', '154', '0', '0', '115.94439', '35.60044');
INSERT INTO `counties` VALUES ('1287', '滨城区', '153', '0', '0', '118.02026', '37.38524');
INSERT INTO `counties` VALUES ('1288', '博兴县', '153', '0', '0', '118.1336', '37.14316');
INSERT INTO `counties` VALUES ('1289', '惠民县', '153', '0', '0', '117.51113', '37.49013');
INSERT INTO `counties` VALUES ('1290', '无棣县', '153', '0', '0', '117.61395', '37.74009');
INSERT INTO `counties` VALUES ('1291', '阳信县', '153', '0', '0', '117.58139', '37.64198');
INSERT INTO `counties` VALUES ('1292', '沾化县', '153', '0', '0', '118.13', '37.70');
INSERT INTO `counties` VALUES ('1293', '邹平县', '153', '0', '0', '117.74307', '36.86295');
INSERT INTO `counties` VALUES ('1294', '鼓楼区', '156', '0', '0', '118.76974', '32.06632');
INSERT INTO `counties` VALUES ('1295', '金明区', '156', '0', '0', null, null);
INSERT INTO `counties` VALUES ('1296', '开封县', '156', '0', '0', '114.43', '34.77');
INSERT INTO `counties` VALUES ('1297', '兰考县', '156', '0', '0', '114.81961', '34.8235');
INSERT INTO `counties` VALUES ('1298', '龙亭区', '156', '0', '0', '114.35484', '34.79995');
INSERT INTO `counties` VALUES ('1299', '顺河回族区', '156', '0', '0', '114.36123', '34.79586');
INSERT INTO `counties` VALUES ('1300', '通许县', '156', '0', '0', '114.46716', '34.47522');
INSERT INTO `counties` VALUES ('1301', '尉氏县', '156', '0', '0', '114.19284', '34.41223');
INSERT INTO `counties` VALUES ('1302', '禹王台区', '156', '0', '0', '114.34787', '34.77693');
INSERT INTO `counties` VALUES ('1303', '杞县', '156', '0', '0', '114.7828', '34.55033');
INSERT INTO `counties` VALUES ('1304', '登封市', '155', '0', '0', '113.05023', '34.45345');
INSERT INTO `counties` VALUES ('1305', '二七区', '155', '0', '0', '113.63931', '34.72336');
INSERT INTO `counties` VALUES ('1306', '巩义市', '155', '0', '0', '113.022', '34.74794');
INSERT INTO `counties` VALUES ('1307', '管城回族区', '155', '0', '0', '113.67734', '34.75383');
INSERT INTO `counties` VALUES ('1308', '惠济区', '155', '0', '0', '113.61688', '34.86735');
INSERT INTO `counties` VALUES ('1309', '金水区', '155', '0', '0', '113.66057', '34.80028');
INSERT INTO `counties` VALUES ('1310', '上街区', '155', '0', '0', '113.30897', '34.80276');
INSERT INTO `counties` VALUES ('1311', '新密市', '155', '0', '0', '113.3869', '34.53704');
INSERT INTO `counties` VALUES ('1312', '新郑市', '155', '0', '0', '113.73645', '34.3955');
INSERT INTO `counties` VALUES ('1313', '中牟县', '155', '0', '0', '113.97619', '34.71899');
INSERT INTO `counties` VALUES ('1314', '中原区', '155', '0', '0', '113.61333', '34.74827');
INSERT INTO `counties` VALUES ('1315', '荥阳市', '155', '0', '0', '113.38345', '34.78759');
INSERT INTO `counties` VALUES ('1316', '吉利区', '157', '0', '0', '112.58905', '34.90088');
INSERT INTO `counties` VALUES ('1317', '洛宁县', '157', '0', '0', '111.65087', '34.38913');
INSERT INTO `counties` VALUES ('1318', '孟津县', '157', '0', '0', '112.44351', '34.826');
INSERT INTO `counties` VALUES ('1319', '汝阳县', '157', '0', '0', '112.47314', '34.15387');
INSERT INTO `counties` VALUES ('1320', '新安县', '157', '0', '0', '112.13238', '34.72814');
INSERT INTO `counties` VALUES ('1321', '伊川县', '157', '0', '0', '112.42947', '34.42205');
INSERT INTO `counties` VALUES ('1322', '宜阳县', '157', '0', '0', '112.17907', '34.51523');
INSERT INTO `counties` VALUES ('1323', '偃师市', '157', '0', '0', '112.7922', '34.7281');
INSERT INTO `counties` VALUES ('1324', '嵩县', '157', '0', '0', '112.08526', '34.13466');
INSERT INTO `counties` VALUES ('1325', '栾川县', '157', '0', '0', '111.61779', '33.78576');
INSERT INTO `counties` VALUES ('1326', '洛龙区', '157', '0', '0', '112.46412', '34.61866');
INSERT INTO `counties` VALUES ('1327', '瀍河回族区', '157', '0', '0', '112.50018', '34.67985');
INSERT INTO `counties` VALUES ('1328', '老城区', '157', '0', '0', '112.46902', '34.68364');
INSERT INTO `counties` VALUES ('1329', '西工区', '157', '0', '0', '112.4371', '34.67');
INSERT INTO `counties` VALUES ('1330', '涧西区', '157', '0', '0', '112.39588', '34.65823');
INSERT INTO `counties` VALUES ('1331', '宝丰县', '158', '0', '0', '113.05493', '33.86916');
INSERT INTO `counties` VALUES ('1332', '鲁山县', '158', '0', '0', '112.9057', '33.73879');
INSERT INTO `counties` VALUES ('1333', '汝州市', '158', '0', '0', '112.84301', '34.16135');
INSERT INTO `counties` VALUES ('1334', '石龙区', '158', '0', '0', '112.89879', '33.89878');
INSERT INTO `counties` VALUES ('1335', '舞钢市', '158', '0', '0', '113.52417', '33.2938');
INSERT INTO `counties` VALUES ('1336', '叶县', '158', '0', '0', '113.35104', '33.62225');
INSERT INTO `counties` VALUES ('1337', '郏县', '158', '0', '0', '113.21588', '33.97072');
INSERT INTO `counties` VALUES ('1338', '湛河区', '158', '0', '0', '113.29252', '33.7362');
INSERT INTO `counties` VALUES ('1339', '新华区', '158', '0', '0', '114.46326', '38.05088');
INSERT INTO `counties` VALUES ('1340', '卫东区', '158', '0', '0', '113.33511', '33.73472');
INSERT INTO `counties` VALUES ('1341', '安阳县', '159', '0', '0', '114.36605', '36.06695');
INSERT INTO `counties` VALUES ('1342', '北关区', '159', '0', '0', '114.35735', '36.11872');
INSERT INTO `counties` VALUES ('1343', '滑县', '159', '0', '0', '114.52066', '35.5807');
INSERT INTO `counties` VALUES ('1344', '林州市', '159', '0', '0', '113.81558', '36.07804');
INSERT INTO `counties` VALUES ('1345', '龙安区', '159', '0', '0', '114.34814', '36.11904');
INSERT INTO `counties` VALUES ('1346', '内黄县', '159', '0', '0', '114.90673', '35.95269');
INSERT INTO `counties` VALUES ('1347', '汤阴县', '159', '0', '0', '114.35839', '35.92152');
INSERT INTO `counties` VALUES ('1348', '文峰区', '159', '0', '0', '114.35708', '36.09046');
INSERT INTO `counties` VALUES ('1349', '殷都区', '159', '0', '0', '114.3034', '36.1099');
INSERT INTO `counties` VALUES ('1350', '温县', '162', '0', '0', '113.08065', '34.94022');
INSERT INTO `counties` VALUES ('1351', '博爱县', '162', '0', '0', '113.06698', '35.16943');
INSERT INTO `counties` VALUES ('1352', '解放区', '162', '0', '0', '113.22933', '35.24023');
INSERT INTO `counties` VALUES ('1353', '马村区', '162', '0', '0', '113.3187', '35.26908');
INSERT INTO `counties` VALUES ('1354', '孟州市', '162', '0', '0', '112.79138', '34.9071');
INSERT INTO `counties` VALUES ('1355', '沁阳市', '162', '0', '0', '112.94494', '35.08935');
INSERT INTO `counties` VALUES ('1356', '山阳区', '162', '0', '0', '113.25464', '35.21436');
INSERT INTO `counties` VALUES ('1357', '武陟县', '162', '0', '0', '113.39718', '35.09505');
INSERT INTO `counties` VALUES ('1358', '修武县', '162', '0', '0', '113.44775', '35.22357');
INSERT INTO `counties` VALUES ('1359', '中站区', '162', '0', '0', '113.18315', '35.23665');
INSERT INTO `counties` VALUES ('1360', '浚县', '160', '0', '0', '114.54879', '35.67085');
INSERT INTO `counties` VALUES ('1361', '淇县', '160', '0', '0', '114.1976', '35.60782');
INSERT INTO `counties` VALUES ('1362', '山城区', '160', '0', '0', '114.18443', '35.89773');
INSERT INTO `counties` VALUES ('1363', '淇滨区', '160', '0', '0', '114.29867', '35.74127');
INSERT INTO `counties` VALUES ('1364', '鹤山区', '160', '0', '0', '114.16336', '35.95458');
INSERT INTO `counties` VALUES ('1365', '牧野区', '161', '0', '0', '113.9086', '35.3149');
INSERT INTO `counties` VALUES ('1366', '卫滨区', '161', '0', '0', '113.86578', '35.30211');
INSERT INTO `counties` VALUES ('1367', '长垣县', '161', '0', '0', '114.66882', '35.20046');
INSERT INTO `counties` VALUES ('1368', '封丘县', '161', '0', '0', '114.41915', '35.04166');
INSERT INTO `counties` VALUES ('1369', '辉县市', '161', '0', '0', '113.8067', '35.46307');
INSERT INTO `counties` VALUES ('1370', '获嘉县', '161', '0', '0', '113.66159', '35.26521');
INSERT INTO `counties` VALUES ('1371', '卫辉市', '161', '0', '0', '114.06454', '35.39843');
INSERT INTO `counties` VALUES ('1372', '延津县', '161', '0', '0', '114.20266', '35.14327');
INSERT INTO `counties` VALUES ('1373', '原阳县', '161', '0', '0', '113.93994', '35.06565');
INSERT INTO `counties` VALUES ('1374', '红旗区', '161', '0', '0', '113.87523', '35.30367');
INSERT INTO `counties` VALUES ('1375', '凤泉区', '161', '0', '0', '113.91507', '35.38399');
INSERT INTO `counties` VALUES ('1376', '新乡县', '161', '0', '0', '113.80511', '35.19075');
INSERT INTO `counties` VALUES ('1377', '范县', '163', '0', '0', '115.50405', '35.85178');
INSERT INTO `counties` VALUES ('1378', '华龙区', '163', '0', '0', '115.07446', '35.77736');
INSERT INTO `counties` VALUES ('1379', '南乐县', '163', '0', '0', '115.20639', '36.07686');
INSERT INTO `counties` VALUES ('1380', '清丰县', '163', '0', '0', '115.10415', '35.88507');
INSERT INTO `counties` VALUES ('1381', '台前县', '163', '0', '0', '115.87158', '35.96923');
INSERT INTO `counties` VALUES ('1382', '濮阳县', '163', '0', '0', '115.03057', '35.70745');
INSERT INTO `counties` VALUES ('1383', '召陵区', '165', '0', '0', '114.09399', '33.58601');
INSERT INTO `counties` VALUES ('1384', '临颍县', '165', '0', '0', '113.93661', '33.81123');
INSERT INTO `counties` VALUES ('1385', '舞阳县', '165', '0', '0', '113.59848', '33.43243');
INSERT INTO `counties` VALUES ('1386', '郾城区', '165', '0', '0', '114.00694', '33.58723');
INSERT INTO `counties` VALUES ('1387', '源汇区', '165', '0', '0', '114.00647', '33.55627');
INSERT INTO `counties` VALUES ('1388', '长葛市', '164', '0', '0', '113.77328', '34.21846');
INSERT INTO `counties` VALUES ('1389', '魏都区', '164', '0', '0', '113.8227', '34.02544');
INSERT INTO `counties` VALUES ('1390', '襄城县', '164', '0', '0', '113.48196', '33.84928');
INSERT INTO `counties` VALUES ('1391', '许昌县', '164', '0', '0', '113.84707', '34.00406');
INSERT INTO `counties` VALUES ('1392', '禹州市', '164', '0', '0', '113.48803', '34.14054');
INSERT INTO `counties` VALUES ('1393', '鄢陵县', '164', '0', '0', '114.18795', '34.10317');
INSERT INTO `counties` VALUES ('1394', '湖滨区', '166', '0', '0', '111.20006', '34.77872');
INSERT INTO `counties` VALUES ('1395', '灵宝市', '166', '0', '0', '110.8945', '34.51682');
INSERT INTO `counties` VALUES ('1396', '卢氏县', '166', '0', '0', '111.04782', '34.05436');
INSERT INTO `counties` VALUES ('1397', '陕县', '166', '0', '0', '111.10333', '34.72052');
INSERT INTO `counties` VALUES ('1398', '义马市', '166', '0', '0', '111.87445', '34.74721');
INSERT INTO `counties` VALUES ('1399', '渑池县', '166', '0', '0', '111.76184', '34.76725');
INSERT INTO `counties` VALUES ('1400', '邓州市', '167', '0', '0', '112.0896', '32.68577');
INSERT INTO `counties` VALUES ('1401', '方城县', '167', '0', '0', '113.01269', '33.25453');
INSERT INTO `counties` VALUES ('1402', '南召县', '167', '0', '0', '112.43194', '33.49098');
INSERT INTO `counties` VALUES ('1403', '内乡县', '167', '0', '0', '111.84957', '33.04671');
INSERT INTO `counties` VALUES ('1404', '社旗县', '167', '0', '0', '112.94656', '33.05503');
INSERT INTO `counties` VALUES ('1405', '唐河县', '167', '0', '0', '112.83609', '32.69453');
INSERT INTO `counties` VALUES ('1406', '桐柏县', '167', '0', '0', '113.42886', '32.37917');
INSERT INTO `counties` VALUES ('1407', '西峡县', '167', '0', '0', '111.48187', '33.29772');
INSERT INTO `counties` VALUES ('1408', '新野县', '167', '0', '0', '112.36151', '32.51698');
INSERT INTO `counties` VALUES ('1409', '镇平县', '167', '0', '0', '112.2398', '33.03629');
INSERT INTO `counties` VALUES ('1410', '淅川县', '167', '0', '0', '111.48663', '33.13708');
INSERT INTO `counties` VALUES ('1411', '宛城区', '167', '0', '0', '112.53955', '33.00378');
INSERT INTO `counties` VALUES ('1412', '卧龙区', '167', '0', '0', '112.53479', '32.98615');
INSERT INTO `counties` VALUES ('1413', '民权县', '168', '0', '0', '115.14621', '34.64931');
INSERT INTO `counties` VALUES ('1414', '宁陵县', '168', '0', '0', '115.30511', '34.45463');
INSERT INTO `counties` VALUES ('1415', '夏邑县', '168', '0', '0', '116.13348', '34.23242');
INSERT INTO `counties` VALUES ('1416', '永城市', '168', '0', '0', '116.44943', '33.92911');
INSERT INTO `counties` VALUES ('1417', '虞城县', '168', '0', '0', '115.86337', '34.40189');
INSERT INTO `counties` VALUES ('1418', '柘城县', '168', '0', '0', '115.30538', '34.0911');
INSERT INTO `counties` VALUES ('1419', '睢县', '168', '0', '0', '115.07168', '34.44539');
INSERT INTO `counties` VALUES ('1420', '梁园区', '168', '0', '0', '115.64487', '34.44341');
INSERT INTO `counties` VALUES ('1421', '睢阳区', '168', '0', '0', '115.65338', '34.38804');
INSERT INTO `counties` VALUES ('1422', '固始县', '169', '0', '0', '115.68298', '32.18011');
INSERT INTO `counties` VALUES ('1423', '光山县', '169', '0', '0', '114.91873', '32.00992');
INSERT INTO `counties` VALUES ('1424', '淮滨县', '169', '0', '0', '115.4205', '32.46614');
INSERT INTO `counties` VALUES ('1425', '罗山县', '169', '0', '0', '114.5314', '32.20277');
INSERT INTO `counties` VALUES ('1426', '商城县', '169', '0', '0', '115.40856', '31.79986');
INSERT INTO `counties` VALUES ('1427', '息县', '169', '0', '0', '114.7402', '32.34279');
INSERT INTO `counties` VALUES ('1428', '新县', '169', '0', '0', '114.87924', '31.64386');
INSERT INTO `counties` VALUES ('1429', '潢川县', '169', '0', '0', '115.04696', '32.13763');
INSERT INTO `counties` VALUES ('1430', '平桥区', '169', '0', '0', '114.12435', '32.10095');
INSERT INTO `counties` VALUES ('1431', '浉河区', '169', '0', '0', '114.05871', '32.1168');
INSERT INTO `counties` VALUES ('1432', '川汇区', '170', '0', '0', '114.64202', '33.6256');
INSERT INTO `counties` VALUES ('1433', '郸城县', '170', '0', '0', '115.17715', '33.64485');
INSERT INTO `counties` VALUES ('1434', '扶沟县', '170', '0', '0', '114.39477', '34.05999');
INSERT INTO `counties` VALUES ('1435', '淮阳县', '170', '0', '0', '114.88848', '33.73211');
INSERT INTO `counties` VALUES ('1436', '鹿邑县', '170', '0', '0', '115.48553', '33.85931');
INSERT INTO `counties` VALUES ('1437', '商水县', '170', '0', '0', '114.60604', '33.53912');
INSERT INTO `counties` VALUES ('1438', '沈丘县', '170', '0', '0', '115.09851', '33.40936');
INSERT INTO `counties` VALUES ('1439', '太康县', '170', '0', '0', '114.83773', '34.06376');
INSERT INTO `counties` VALUES ('1440', '西华县', '170', '0', '0', '114.52279', '33.78548');
INSERT INTO `counties` VALUES ('1441', '项城市', '170', '0', '0', '114.87558', '33.4672');
INSERT INTO `counties` VALUES ('1442', '上蔡县', '171', '0', '0', '114.26825', '33.26825');
INSERT INTO `counties` VALUES ('1443', '泌阳县', '171', '0', '0', '113.32681', '32.71781');
INSERT INTO `counties` VALUES ('1444', '平舆县', '171', '0', '0', '114.63552', '32.95727');
INSERT INTO `counties` VALUES ('1445', '确山县', '171', '0', '0', '114.02917', '32.80281');
INSERT INTO `counties` VALUES ('1446', '汝南县', '171', '0', '0', '114.36138', '33.00461');
INSERT INTO `counties` VALUES ('1447', '遂平县', '171', '0', '0', '114.01297', '33.14571');
INSERT INTO `counties` VALUES ('1448', '西平县', '171', '0', '0', '114.02322', '33.3845');
INSERT INTO `counties` VALUES ('1449', '新蔡县', '171', '0', '0', '114.98199', '32.7502');
INSERT INTO `counties` VALUES ('1450', '正阳县', '171', '0', '0', '114.38952', '32.6039');
INSERT INTO `counties` VALUES ('1451', '驿城区', '171', '0', '0', '113.99377', '32.97316');
INSERT INTO `counties` VALUES ('1452', '下陆区', '173', '0', '0', '114.96112', '30.17368');
INSERT INTO `counties` VALUES ('1453', '大冶市', '173', '0', '0', '114.97174', '30.09438');
INSERT INTO `counties` VALUES ('1454', '黄石港区', '173', '0', '0', '115.06604', '30.22279');
INSERT INTO `counties` VALUES ('1455', '铁山区', '173', '0', '0', '114.90109', '30.20678');
INSERT INTO `counties` VALUES ('1456', '西塞山区', '173', '0', '0', '115.11016', '30.20487');
INSERT INTO `counties` VALUES ('1457', '阳新县', '173', '0', '0', '115.21527', '29.83038');
INSERT INTO `counties` VALUES ('1458', '丹江口市', '174', '0', '0', '111.51525', '32.54085');
INSERT INTO `counties` VALUES ('1459', '房县', '174', '0', '0', '110.74386', '32.05794');
INSERT INTO `counties` VALUES ('1460', '茅箭区', '174', '0', '0', '110.81341', '32.59153');
INSERT INTO `counties` VALUES ('1461', '郧西县', '174', '0', '0', '110.42556', '32.99349');
INSERT INTO `counties` VALUES ('1462', '郧县', '174', '0', '0', '110.82', '32.83');
INSERT INTO `counties` VALUES ('1463', '张湾区', '174', '0', '0', '110.77067', '32.65195');
INSERT INTO `counties` VALUES ('1464', '竹山县', '174', '0', '0', '110.23071', '32.22536');
INSERT INTO `counties` VALUES ('1465', '竹溪县', '174', '0', '0', '109.71798', '32.31901');
INSERT INTO `counties` VALUES ('1466', '保康县', '176', '0', '0', '111.26138', '31.87874');
INSERT INTO `counties` VALUES ('1467', '樊城区', '176', '0', '0', '112.13546', '32.04482');
INSERT INTO `counties` VALUES ('1468', '谷城县', '176', '0', '0', '111.65267', '32.26377');
INSERT INTO `counties` VALUES ('1469', '老河口市', '176', '0', '0', '111.67117', '32.38476');
INSERT INTO `counties` VALUES ('1470', '南漳县', '176', '0', '0', '111.84603', '31.77653');
INSERT INTO `counties` VALUES ('1471', '襄城区', '176', '0', '0', '112.13372', '32.01017');
INSERT INTO `counties` VALUES ('1472', '襄州区', '176', '0', '0', '112.150327', '32.015088');
INSERT INTO `counties` VALUES ('1473', '宜城市', '176', '0', '0', '112.25772', '31.71972');
INSERT INTO `counties` VALUES ('1474', '枣阳市', '176', '0', '0', '112.77444', '32.13142');
INSERT INTO `counties` VALUES ('1475', '鄂城区', '177', '0', '0', '114.89158', '30.40024');
INSERT INTO `counties` VALUES ('1476', '华容区', '177', '0', '0', '114.73568', '30.53328');
INSERT INTO `counties` VALUES ('1477', '梁子湖区', '177', '0', '0', '114.68463', '30.10003');
INSERT INTO `counties` VALUES ('1478', '枝江市', '175', '0', '0', '111.76855', '30.42612');
INSERT INTO `counties` VALUES ('1479', '秭归县', '175', '0', '0', '110.98156', '30.82702');
INSERT INTO `counties` VALUES ('1480', '猇亭区', '175', '0', '0', '111.44079', '30.52663');
INSERT INTO `counties` VALUES ('1481', '长阳土家族自治县', '175', '0', '0', '111.20105', '30.47052');
INSERT INTO `counties` VALUES ('1482', '当阳市', '175', '0', '0', '111.78912', '30.8208');
INSERT INTO `counties` VALUES ('1483', '点军区', '175', '0', '0', '111.26828', '30.6934');
INSERT INTO `counties` VALUES ('1484', '五峰土家族自治县', '175', '0', '0', '110.6748', '30.19856');
INSERT INTO `counties` VALUES ('1485', '伍家岗区', '175', '0', '0', '111.3609', '30.64434');
INSERT INTO `counties` VALUES ('1486', '西陵区', '175', '0', '0', '111.28573', '30.71077');
INSERT INTO `counties` VALUES ('1487', '兴山县', '175', '0', '0', '110.74951', '31.34686');
INSERT INTO `counties` VALUES ('1488', '夷陵区', '175', '0', '0', '111.3262', '30.76881');
INSERT INTO `counties` VALUES ('1489', '宜都市', '175', '0', '0', '111.45025', '30.37807');
INSERT INTO `counties` VALUES ('1490', '远安县', '175', '0', '0', '111.6416', '31.05989');
INSERT INTO `counties` VALUES ('1491', '安陆市', '179', '0', '0', '113.68557', '31.25693');
INSERT INTO `counties` VALUES ('1492', '大悟县', '179', '0', '0', '114.12564', '31.56176');
INSERT INTO `counties` VALUES ('1493', '汉川市', '179', '0', '0', '113.83898', '30.66117');
INSERT INTO `counties` VALUES ('1494', '孝昌县', '179', '0', '0', '113.99795', '31.25799');
INSERT INTO `counties` VALUES ('1495', '孝南区', '179', '0', '0', '113.91111', '30.9168');
INSERT INTO `counties` VALUES ('1496', '应城市', '179', '0', '0', '113.57287', '30.92834');
INSERT INTO `counties` VALUES ('1497', '云梦县', '179', '0', '0', '113.75289', '31.02093');
INSERT INTO `counties` VALUES ('1498', '东宝区', '178', '0', '0', '112.20147', '31.05192');
INSERT INTO `counties` VALUES ('1499', '掇刀区', '178', '0', '0', '112.208', '30.97316');
INSERT INTO `counties` VALUES ('1500', '京山县', '178', '0', '0', '113.11074', '31.0224');
INSERT INTO `counties` VALUES ('1501', '沙洋县', '178', '0', '0', '112.58853', '30.70916');
INSERT INTO `counties` VALUES ('1502', '钟祥市', '178', '0', '0', '112.58932', '31.1678');
INSERT INTO `counties` VALUES ('1503', '洪湖市', '180', '0', '0', '113.47598', '29.827');
INSERT INTO `counties` VALUES ('1504', '江陵县', '180', '0', '0', '112.42468', '30.04174');
INSERT INTO `counties` VALUES ('1505', '荆州区', '180', '0', '0', '112.19006', '30.35264');
INSERT INTO `counties` VALUES ('1506', '沙市区', '180', '0', '0', '112.25543', '30.31107');
INSERT INTO `counties` VALUES ('1507', '松滋市', '180', '0', '0', '111.76739', '30.16965');
INSERT INTO `counties` VALUES ('1508', '公安县', '180', '0', '0', '112.23242', '30.05902');
INSERT INTO `counties` VALUES ('1509', '监利县', '180', '0', '0', '112.89462', '29.81494');
INSERT INTO `counties` VALUES ('1510', '石首市', '180', '0', '0', '112.42636', '29.72127');
INSERT INTO `counties` VALUES ('1511', '通城县', '182', '0', '0', '113.81582', '29.24568');
INSERT INTO `counties` VALUES ('1512', '嘉鱼县', '182', '0', '0', '113.93927', '29.97054');
INSERT INTO `counties` VALUES ('1513', '咸安区', '182', '0', '0', '114.29872', '29.8529');
INSERT INTO `counties` VALUES ('1514', '赤壁市', '182', '0', '0', '113.90039', '29.72454');
INSERT INTO `counties` VALUES ('1515', '崇阳县', '182', '0', '0', '114.03982', '29.55564');
INSERT INTO `counties` VALUES ('1516', '通山县', '182', '0', '0', '114.48239', '29.6063');
INSERT INTO `counties` VALUES ('1517', '红安县', '181', '0', '0', '114.6224', '31.28668');
INSERT INTO `counties` VALUES ('1518', '黄梅县', '181', '0', '0', '115.94427', '30.07033');
INSERT INTO `counties` VALUES ('1519', '黄州区', '181', '0', '0', '114.88008', '30.43436');
INSERT INTO `counties` VALUES ('1520', '罗田县', '181', '0', '0', '115.39971', '30.78255');
INSERT INTO `counties` VALUES ('1521', '麻城市', '181', '0', '0', '115.00988', '31.17228');
INSERT INTO `counties` VALUES ('1522', '团风县', '181', '0', '0', '114.87228', '30.64359');
INSERT INTO `counties` VALUES ('1523', '武穴市', '181', '0', '0', '115.55975', '29.84446');
INSERT INTO `counties` VALUES ('1524', '英山县', '181', '0', '0', '115.68142', '30.73516');
INSERT INTO `counties` VALUES ('1525', '蕲春县', '181', '0', '0', '115.43615', '30.22613');
INSERT INTO `counties` VALUES ('1526', '浠水县', '181', '0', '0', '115.26913', '30.45265');
INSERT INTO `counties` VALUES ('1527', '广水市', '183', '0', '0', '113.82663', '31.6179');
INSERT INTO `counties` VALUES ('1528', '曾都区', '183', '0', '0', '113.37128', '31.71614');
INSERT INTO `counties` VALUES ('1529', '潜江市', '185', '0', '0', '112.896866', '30.421215');
INSERT INTO `counties` VALUES ('1530', '神农架林区', '185', '0', '0', '110.671525', '31.744449');
INSERT INTO `counties` VALUES ('1531', '天门市', '185', '0', '0', '113.165862', '30.653061');
INSERT INTO `counties` VALUES ('1532', '仙桃市', '185', '0', '0', '113.453974', '30.364953');
INSERT INTO `counties` VALUES ('1533', '长沙县', '186', '0', '0', '113.08071', '28.24595');
INSERT INTO `counties` VALUES ('1534', '开福区', '186', '0', '0', '112.98623', '28.25585');
INSERT INTO `counties` VALUES ('1535', '宁乡县', '186', '0', '0', '112.55749', '28.25358');
INSERT INTO `counties` VALUES ('1536', '天心区', '186', '0', '0', '112.98991', '28.1127');
INSERT INTO `counties` VALUES ('1537', '望城区', '186', '0', '0', '112.819549', '28.347458');
INSERT INTO `counties` VALUES ('1538', '雨花区', '186', '0', '0', '113.03567', '28.13541');
INSERT INTO `counties` VALUES ('1539', '岳麓区', '186', '0', '0', '112.93133', '28.2351');
INSERT INTO `counties` VALUES ('1540', '芙蓉区', '186', '0', '0', '113.03176', '28.1844');
INSERT INTO `counties` VALUES ('1541', '浏阳市', '186', '0', '0', '113.64312', '28.16375');
INSERT INTO `counties` VALUES ('1542', '来凤县', '184', '0', '0', '109.40716', '29.49373');
INSERT INTO `counties` VALUES ('1543', '巴东县', '184', '0', '0', '110.34066', '31.04233');
INSERT INTO `counties` VALUES ('1544', '建始县', '184', '0', '0', '109.72207', '30.60209');
INSERT INTO `counties` VALUES ('1545', '恩施市', '184', '0', '0', '109.47942', '30.29502');
INSERT INTO `counties` VALUES ('1546', '鹤峰县', '184', '0', '0', '110.03091', '29.89072');
INSERT INTO `counties` VALUES ('1547', '利川市', '184', '0', '0', '108.93591', '30.29117');
INSERT INTO `counties` VALUES ('1548', '咸丰县', '184', '0', '0', '109.152', '29.67983');
INSERT INTO `counties` VALUES ('1549', '宣恩县', '184', '0', '0', '109.49179', '29.98714');
INSERT INTO `counties` VALUES ('1550', '株洲县', '187', '0', '0', '113.14428', '27.69826');
INSERT INTO `counties` VALUES ('1551', '茶陵县', '187', '0', '0', '113.54364', '26.7915');
INSERT INTO `counties` VALUES ('1552', '荷塘区', '187', '0', '0', '113.17315', '27.85569');
INSERT INTO `counties` VALUES ('1553', '芦淞区', '187', '0', '0', '113.15562', '27.78525');
INSERT INTO `counties` VALUES ('1554', '石峰区', '187', '0', '0', '113.11776', '27.87552');
INSERT INTO `counties` VALUES ('1555', '天元区', '187', '0', '0', '113.12335', '27.83103');
INSERT INTO `counties` VALUES ('1556', '炎陵县', '187', '0', '0', '113.77163', '26.48818');
INSERT INTO `counties` VALUES ('1557', '攸县', '187', '0', '0', '113.34365', '27.00352');
INSERT INTO `counties` VALUES ('1558', '醴陵市', '187', '0', '0', '113.49704', '27.64615');
INSERT INTO `counties` VALUES ('1559', '韶山市', '188', '0', '0', '112.52655', '27.91503');
INSERT INTO `counties` VALUES ('1560', '湘潭县', '188', '0', '0', '112.9508', '27.77893');
INSERT INTO `counties` VALUES ('1561', '湘乡市', '188', '0', '0', '112.53512', '27.73543');
INSERT INTO `counties` VALUES ('1562', '雨湖区', '188', '0', '0', '112.90399', '27.86859');
INSERT INTO `counties` VALUES ('1563', '岳塘区', '188', '0', '0', '112.9606', '27.85784');
INSERT INTO `counties` VALUES ('1564', '北塔区', '190', '0', '0', '111.45219', '27.24648');
INSERT INTO `counties` VALUES ('1565', '城步苗族自治县', '190', '0', '0', '110.3222', '26.39048');
INSERT INTO `counties` VALUES ('1566', '大祥区', '190', '0', '0', '111.45412', '27.23332');
INSERT INTO `counties` VALUES ('1567', '武冈市', '190', '0', '0', '110.63281', '26.72817');
INSERT INTO `counties` VALUES ('1568', '洞口县', '190', '0', '0', '110.57388', '27.05462');
INSERT INTO `counties` VALUES ('1569', '隆回县', '190', '0', '0', '111.03216', '27.10937');
INSERT INTO `counties` VALUES ('1570', '邵东县', '190', '0', '0', '111.74441', '27.2584');
INSERT INTO `counties` VALUES ('1571', '邵阳县', '190', '0', '0', '111.27459', '26.99143');
INSERT INTO `counties` VALUES ('1572', '双清区', '190', '0', '0', '111.49715', '27.23291');
INSERT INTO `counties` VALUES ('1573', '绥宁县', '190', '0', '0', '110.15576', '26.58636');
INSERT INTO `counties` VALUES ('1574', '新宁县', '190', '0', '0', '110.85131', '26.42936');
INSERT INTO `counties` VALUES ('1575', '新邵县', '190', '0', '0', '111.46066', '27.32169');
INSERT INTO `counties` VALUES ('1576', '君山区', '191', '0', '0', '113.00439', '29.45941');
INSERT INTO `counties` VALUES ('1577', '平江县', '191', '0', '0', '113.58105', '28.70664');
INSERT INTO `counties` VALUES ('1578', '湘阴县', '191', '0', '0', '112.90911', '28.68922');
INSERT INTO `counties` VALUES ('1579', '岳阳楼区', '191', '0', '0', '113.12942', '29.3719');
INSERT INTO `counties` VALUES ('1580', '岳阳县', '191', '0', '0', '113.11987', '29.14314');
INSERT INTO `counties` VALUES ('1581', '汨罗市', '191', '0', '0', '113.06707', '28.80631');
INSERT INTO `counties` VALUES ('1582', '华容县', '191', '0', '0', '112.54089', '29.53019');
INSERT INTO `counties` VALUES ('1583', '临湘市', '191', '0', '0', '113.4501', '29.47701');
INSERT INTO `counties` VALUES ('1584', '云溪区', '191', '0', '0', '113.27713', '29.47357');
INSERT INTO `counties` VALUES ('1585', '石鼓区', '189', '0', '0', '112.61069', '26.90232');
INSERT INTO `counties` VALUES ('1586', '雁峰区', '189', '0', '0', '112.61654', '26.88866');
INSERT INTO `counties` VALUES ('1587', '蒸湘区', '189', '0', '0', '112.6033', '26.89651');
INSERT INTO `counties` VALUES ('1588', '珠晖区', '189', '0', '0', '112.62054', '26.89361');
INSERT INTO `counties` VALUES ('1589', '常宁市', '189', '0', '0', '112.4009', '26.40692');
INSERT INTO `counties` VALUES ('1590', '衡东县', '189', '0', '0', '112.94833', '27.08093');
INSERT INTO `counties` VALUES ('1591', '衡南县', '189', '0', '0', '112.67788', '26.73828');
INSERT INTO `counties` VALUES ('1592', '衡山县', '189', '0', '0', '112.86776', '27.23134');
INSERT INTO `counties` VALUES ('1593', '衡阳县', '189', '0', '0', '112.37088', '26.9706');
INSERT INTO `counties` VALUES ('1594', '南岳区', '189', '0', '0', '112.7384', '27.23262');
INSERT INTO `counties` VALUES ('1595', '祁东县', '189', '0', '0', '112.09039', '26.79964');
INSERT INTO `counties` VALUES ('1596', '耒阳市', '189', '0', '0', '112.85998', '26.42132');
INSERT INTO `counties` VALUES ('1597', '慈利县', '193', '0', '0', '111.13946', '29.42989');
INSERT INTO `counties` VALUES ('1598', '桑植县', '193', '0', '0', '110.16308', '29.39815');
INSERT INTO `counties` VALUES ('1599', '武陵源区', '193', '0', '0', '110.55026', '29.34574');
INSERT INTO `counties` VALUES ('1600', '永定区', '193', '0', '0', '116.73199', '24.72302');
INSERT INTO `counties` VALUES ('1601', '鼎城区', '192', '0', '0', '111.68078', '29.01859');
INSERT INTO `counties` VALUES ('1602', '汉寿县', '192', '0', '0', '111.96691', '28.90299');
INSERT INTO `counties` VALUES ('1603', '桃源县', '192', '0', '0', '111.48892', '28.90474');
INSERT INTO `counties` VALUES ('1604', '武陵区', '192', '0', '0', '111.69791', '29.02876');
INSERT INTO `counties` VALUES ('1605', '安乡县', '192', '0', '0', '112.16732', '29.41326');
INSERT INTO `counties` VALUES ('1606', '津市市', '192', '0', '0', '111.87756', '29.60563');
INSERT INTO `counties` VALUES ('1607', '临澧县', '192', '0', '0', '111.65161', '29.44163');
INSERT INTO `counties` VALUES ('1608', '石门县', '192', '0', '0', '111.37966', '29.58424');
INSERT INTO `counties` VALUES ('1609', '澧县', '192', '0', '0', '111.75866', '29.63317');
INSERT INTO `counties` VALUES ('1610', '赫山区', '194', '0', '0', '112.37265', '28.57425');
INSERT INTO `counties` VALUES ('1611', '安化县', '194', '0', '0', '111.21298', '28.37424');
INSERT INTO `counties` VALUES ('1612', '南县', '194', '0', '0', '112.3963', '29.36159');
INSERT INTO `counties` VALUES ('1613', '桃江县', '194', '0', '0', '112.1557', '28.51814');
INSERT INTO `counties` VALUES ('1614', '资阳区', '194', '0', '0', '112.32447', '28.59095');
INSERT INTO `counties` VALUES ('1615', '沅江市', '194', '0', '0', '112.35427', '28.84403');
INSERT INTO `counties` VALUES ('1616', '道县', '196', '0', '0', '111.60195', '25.52766');
INSERT INTO `counties` VALUES ('1617', '东安县', '196', '0', '0', '111.3164', '26.39202');
INSERT INTO `counties` VALUES ('1618', '江华瑶族自治县', '196', '0', '0', '111.58847', '25.1845');
INSERT INTO `counties` VALUES ('1619', '江永县', '196', '0', '0', '111.34082', '25.27233');
INSERT INTO `counties` VALUES ('1620', '蓝山县', '196', '0', '0', '112.19363', '25.36794');
INSERT INTO `counties` VALUES ('1621', '冷水滩区', '196', '0', '0', '111.59214', '26.46107');
INSERT INTO `counties` VALUES ('1622', '零陵区', '196', '0', '0', '111.62103', '26.22109');
INSERT INTO `counties` VALUES ('1623', '宁远县', '196', '0', '0', '111.94625', '25.56913');
INSERT INTO `counties` VALUES ('1624', '祁阳县', '196', '0', '0', '111.84011', '26.58009');
INSERT INTO `counties` VALUES ('1625', '双牌县', '196', '0', '0', '111.65927', '25.95988');
INSERT INTO `counties` VALUES ('1626', '新田县', '196', '0', '0', '112.22103', '25.9095');
INSERT INTO `counties` VALUES ('1627', '永兴县', '195', '0', '0', '113.11242', '26.12646');
INSERT INTO `counties` VALUES ('1628', '安仁县', '195', '0', '0', '113.26944', '26.70931');
INSERT INTO `counties` VALUES ('1629', '北湖区', '195', '0', '0', '113.01103', '25.78405');
INSERT INTO `counties` VALUES ('1630', '桂东县', '195', '0', '0', '113.9468', '26.07987');
INSERT INTO `counties` VALUES ('1631', '桂阳县', '195', '0', '0', '112.73364', '25.75406');
INSERT INTO `counties` VALUES ('1632', '嘉禾县', '195', '0', '0', '112.36935', '25.58795');
INSERT INTO `counties` VALUES ('1633', '临武县', '195', '0', '0', '112.56369', '25.27602');
INSERT INTO `counties` VALUES ('1634', '汝城县', '195', '0', '0', '113.68582', '25.55204');
INSERT INTO `counties` VALUES ('1635', '苏仙区', '195', '0', '0', '113.04226', '25.80045');
INSERT INTO `counties` VALUES ('1636', '宜章县', '195', '0', '0', '112.95147', '25.39931');
INSERT INTO `counties` VALUES ('1637', '资兴市', '195', '0', '0', '113.23724', '25.97668');
INSERT INTO `counties` VALUES ('1638', '冷水江市', '198', '0', '0', '111.43554', '27.68147');
INSERT INTO `counties` VALUES ('1639', '涟源市', '198', '0', '0', '111.67233', '27.68831');
INSERT INTO `counties` VALUES ('1640', '娄星区', '198', '0', '0', '112.00193', '27.72992');
INSERT INTO `counties` VALUES ('1641', '双峰县', '198', '0', '0', '112.19921', '27.45418');
INSERT INTO `counties` VALUES ('1642', '新化县', '198', '0', '0', '111.32739', '27.7266');
INSERT INTO `counties` VALUES ('1643', '辰溪县', '197', '0', '0', '110.18942', '28.00406');
INSERT INTO `counties` VALUES ('1644', '鹤城区', '197', '0', '0', '109.96509', '27.54942');
INSERT INTO `counties` VALUES ('1645', '洪江市', '197', '0', '0', '109.83651', '27.20922');
INSERT INTO `counties` VALUES ('1646', '会同县', '197', '0', '0', '109.73568', '26.88716');
INSERT INTO `counties` VALUES ('1647', '靖州苗族侗族自治县', '197', '0', '0', '109.69821', '26.57651');
INSERT INTO `counties` VALUES ('1648', '麻阳苗族自治县', '197', '0', '0', '109.80194', '27.866');
INSERT INTO `counties` VALUES ('1649', '通道侗族自治县', '197', '0', '0', '109.78515', '26.1571');
INSERT INTO `counties` VALUES ('1650', '新晃侗族自治县', '197', '0', '0', '109.17166', '27.35937');
INSERT INTO `counties` VALUES ('1651', '中方县', '197', '0', '0', '109.94497', '27.43988');
INSERT INTO `counties` VALUES ('1652', '芷江侗族自治县', '197', '0', '0', '109.6849', '27.44297');
INSERT INTO `counties` VALUES ('1653', '沅陵县', '197', '0', '0', '110.39633', '28.45548');
INSERT INTO `counties` VALUES ('1654', '溆浦县', '197', '0', '0', '110.59384', '27.90836');
INSERT INTO `counties` VALUES ('1655', '海珠区', '200', '0', '0', '113.26197', '23.10379');
INSERT INTO `counties` VALUES ('1656', '番禺区', '200', '0', '0', '113.38397', '22.93599');
INSERT INTO `counties` VALUES ('1657', '白云区', '200', '0', '0', '113.27307', '23.15787');
INSERT INTO `counties` VALUES ('1658', '从化市', '200', '0', '0', '113.58', '23.55');
INSERT INTO `counties` VALUES ('1659', '花都区', '200', '0', '0', '113.22033', '23.40358');
INSERT INTO `counties` VALUES ('1660', '黄埔区', '200', '0', '0', '113.45895', '23.10642');
INSERT INTO `counties` VALUES ('1661', '荔湾区', '200', '0', '0', '113.2442', '23.12592');
INSERT INTO `counties` VALUES ('1662', '萝岗区', '200', '0', '0', null, null);
INSERT INTO `counties` VALUES ('1663', '南沙区', '200', '0', '0', '113.60845', '22.77144');
INSERT INTO `counties` VALUES ('1664', '天河区', '200', '0', '0', '113.36112', '23.12467');
INSERT INTO `counties` VALUES ('1665', '越秀区', '200', '0', '0', '113.26683', '23.12897');
INSERT INTO `counties` VALUES ('1666', '增城市', '200', '0', '0', '113.83', '23.30');
INSERT INTO `counties` VALUES ('1667', '永顺县', '199', '0', '0', '109.85266', '29.00103');
INSERT INTO `counties` VALUES ('1668', '保靖县', '199', '0', '0', '109.66049', '28.69997');
INSERT INTO `counties` VALUES ('1669', '凤凰县', '199', '0', '0', '109.60156', '27.94822');
INSERT INTO `counties` VALUES ('1670', '古丈县', '199', '0', '0', '109.94812', '28.61944');
INSERT INTO `counties` VALUES ('1671', '花垣县', '199', '0', '0', '109.48217', '28.5721');
INSERT INTO `counties` VALUES ('1672', '吉首市', '199', '0', '0', '109.69799', '28.26247');
INSERT INTO `counties` VALUES ('1673', '龙山县', '199', '0', '0', '109.4432', '29.45693');
INSERT INTO `counties` VALUES ('1674', '泸溪县', '199', '0', '0', '110.21682', '28.2205');
INSERT INTO `counties` VALUES ('1675', '乐昌市', '201', '0', '0', '113.35653', '25.12799');
INSERT INTO `counties` VALUES ('1676', '南雄市', '201', '0', '0', '114.30966', '25.11706');
INSERT INTO `counties` VALUES ('1677', '曲江区', '201', '0', '0', '113.60165', '24.67915');
INSERT INTO `counties` VALUES ('1678', '仁化县', '201', '0', '0', '113.74737', '25.08742');
INSERT INTO `counties` VALUES ('1679', '乳源瑶族自治县', '201', '0', '0', '113.27734', '24.77803');
INSERT INTO `counties` VALUES ('1680', '始兴县', '201', '0', '0', '114.06799', '24.94759');
INSERT INTO `counties` VALUES ('1681', '翁源县', '201', '0', '0', '114.13385', '24.3495');
INSERT INTO `counties` VALUES ('1682', '武江区', '201', '0', '0', '113.58767', '24.79264');
INSERT INTO `counties` VALUES ('1683', '新丰县', '201', '0', '0', '114.20788', '24.05924');
INSERT INTO `counties` VALUES ('1684', '浈江区', '201', '0', '0', '113.61109', '24.80438');
INSERT INTO `counties` VALUES ('1685', '南山区', '202', '0', '0', '130.27676', '47.31404');
INSERT INTO `counties` VALUES ('1686', '盐田区', '202', '0', '0', '114.23733', '22.5578');
INSERT INTO `counties` VALUES ('1687', '宝安区', '202', '0', '0', '113.88311', '22.55371');
INSERT INTO `counties` VALUES ('1688', '福田区', '202', '0', '0', '114.05571', '22.52245');
INSERT INTO `counties` VALUES ('1689', '龙岗区', '202', '0', '0', '114.24771', '22.71986');
INSERT INTO `counties` VALUES ('1690', '罗湖区', '202', '0', '0', '114.13116', '22.54836');
INSERT INTO `counties` VALUES ('1691', '南澳县', '204', '0', '0', '117.01889', '23.4223');
INSERT INTO `counties` VALUES ('1692', '濠江区', '204', '0', '0', '116.72659', '23.28588');
INSERT INTO `counties` VALUES ('1693', '金平区', '204', '0', '0', '116.70364', '23.36637');
INSERT INTO `counties` VALUES ('1694', '龙湖区', '204', '0', '0', '116.71641', '23.37166');
INSERT INTO `counties` VALUES ('1695', '澄海区', '204', '0', '0', '116.75589', '23.46728');
INSERT INTO `counties` VALUES ('1696', '潮阳区', '204', '0', '0', '116.6015', '23.26485');
INSERT INTO `counties` VALUES ('1697', '潮南区', '204', '0', '0', '116.43188', '23.25');
INSERT INTO `counties` VALUES ('1698', '斗门区', '203', '0', '0', '113.29644', '22.20898');
INSERT INTO `counties` VALUES ('1699', '金湾区', '203', '0', '0', '113.36361', '22.14691');
INSERT INTO `counties` VALUES ('1700', '香洲区', '203', '0', '0', '113.5435', '22.26654');
INSERT INTO `counties` VALUES ('1701', '高明区', '205', '0', '0', '112.89254', '22.90022');
INSERT INTO `counties` VALUES ('1702', '南海区', '205', '0', '0', '113.14299', '23.02877');
INSERT INTO `counties` VALUES ('1703', '三水区', '205', '0', '0', '112.89703', '23.15564');
INSERT INTO `counties` VALUES ('1704', '顺德区', '205', '0', '0', '113.29394', '22.80452');
INSERT INTO `counties` VALUES ('1705', '禅城区', '205', '0', '0', '113.1228', '23.00842');
INSERT INTO `counties` VALUES ('1706', '江海区', '206', '0', '0', '113.11099', '22.56024');
INSERT INTO `counties` VALUES ('1707', '蓬江区', '206', '0', '0', '113.07849', '22.59515');
INSERT INTO `counties` VALUES ('1708', '台山市', '206', '0', '0', '112.79382', '22.2515');
INSERT INTO `counties` VALUES ('1709', '开平市', '206', '0', '0', '112.69842', '22.37622');
INSERT INTO `counties` VALUES ('1710', '恩平市', '206', '0', '0', '112.30496', '22.18288');
INSERT INTO `counties` VALUES ('1711', '鹤山市', '206', '0', '0', '112.96429', '22.76523');
INSERT INTO `counties` VALUES ('1712', '新会区', '206', '0', '0', '113.03225', '22.45876');
INSERT INTO `counties` VALUES ('1713', '赤坎区', '207', '0', '0', '110.36592', '21.26606');
INSERT INTO `counties` VALUES ('1714', '雷州市', '207', '0', '0', '110.10092', '20.91428');
INSERT INTO `counties` VALUES ('1715', '廉江市', '207', '0', '0', '110.28442', '21.60917');
INSERT INTO `counties` VALUES ('1716', '麻章区', '207', '0', '0', '110.3342', '21.26333');
INSERT INTO `counties` VALUES ('1717', '坡头区', '207', '0', '0', '110.45533', '21.24472');
INSERT INTO `counties` VALUES ('1718', '遂溪县', '207', '0', '0', '110.25003', '21.37721');
INSERT INTO `counties` VALUES ('1719', '吴川市', '207', '0', '0', '110.77703', '21.44584');
INSERT INTO `counties` VALUES ('1720', '霞山区', '207', '0', '0', '110.39822', '21.19181');
INSERT INTO `counties` VALUES ('1721', '徐闻县', '207', '0', '0', '110.17379', '20.32812');
INSERT INTO `counties` VALUES ('1722', '电白县', '208', '0', '0', '111.00', '21.50');
INSERT INTO `counties` VALUES ('1723', '高州市', '208', '0', '0', '110.85519', '21.92057');
INSERT INTO `counties` VALUES ('1724', '化州市', '208', '0', '0', '110.63949', '21.66394');
INSERT INTO `counties` VALUES ('1725', '茂港区', '208', '0', '0', '111.02', '21.47');
INSERT INTO `counties` VALUES ('1726', '茂南区', '208', '0', '0', '110.9187', '21.64103');
INSERT INTO `counties` VALUES ('1727', '信宜市', '208', '0', '0', '110.94647', '22.35351');
INSERT INTO `counties` VALUES ('1728', '博罗县', '210', '0', '0', '114.28964', '23.17307');
INSERT INTO `counties` VALUES ('1729', '惠城区', '210', '0', '0', '114.3828', '23.08377');
INSERT INTO `counties` VALUES ('1730', '惠东县', '210', '0', '0', '114.72009', '22.98484');
INSERT INTO `counties` VALUES ('1731', '惠阳区', '210', '0', '0', '114.45639', '22.78845');
INSERT INTO `counties` VALUES ('1732', '龙门县', '210', '0', '0', '114.25479', '23.72758');
INSERT INTO `counties` VALUES ('1733', '德庆县', '209', '0', '0', '111.78555', '23.14371');
INSERT INTO `counties` VALUES ('1734', '鼎湖区', '209', '0', '0', '112.56643', '23.15846');
INSERT INTO `counties` VALUES ('1735', '端州区', '209', '0', '0', '112.48495', '23.0519');
INSERT INTO `counties` VALUES ('1736', '封开县', '209', '0', '0', '111.50332', '23.43571');
INSERT INTO `counties` VALUES ('1737', '高要市', '209', '0', '0', '112.45834', '23.02577');
INSERT INTO `counties` VALUES ('1738', '广宁县', '209', '0', '0', '112.44064', '23.6346');
INSERT INTO `counties` VALUES ('1739', '怀集县', '209', '0', '0', '112.18396', '23.90918');
INSERT INTO `counties` VALUES ('1740', '四会市', '209', '0', '0', '112.73416', '23.32686');
INSERT INTO `counties` VALUES ('1741', '海丰县', '212', '0', '0', '115.32336', '22.96653');
INSERT INTO `counties` VALUES ('1742', '陆丰市', '212', '0', '0', '115.64813', '22.94335');
INSERT INTO `counties` VALUES ('1743', '陆河县', '212', '0', '0', '115.65597', '23.30365');
INSERT INTO `counties` VALUES ('1744', '城区', '212', '0', '0', '113.298', '40.07566');
INSERT INTO `counties` VALUES ('1745', '丰顺县', '211', '0', '0', '116.18219', '23.74094');
INSERT INTO `counties` VALUES ('1746', '蕉岭县', '211', '0', '0', '116.17089', '24.65732');
INSERT INTO `counties` VALUES ('1747', '梅江区', '211', '0', '0', '116.11663', '24.31062');
INSERT INTO `counties` VALUES ('1748', '梅县', '211', '0', '0', '116.05', '24.28');
INSERT INTO `counties` VALUES ('1749', '大埔县', '211', '0', '0', '116.69662', '24.35325');
INSERT INTO `counties` VALUES ('1750', '平远县', '211', '0', '0', '115.89556', '24.57116');
INSERT INTO `counties` VALUES ('1751', '五华县', '211', '0', '0', '115.77893', '23.92417');
INSERT INTO `counties` VALUES ('1752', '兴宁市', '211', '0', '0', '115.73141', '24.14001');
INSERT INTO `counties` VALUES ('1753', '阳春市', '214', '0', '0', '111.78854', '22.17232');
INSERT INTO `counties` VALUES ('1754', '阳东县', '214', '0', '0', '112.02', '21.88');
INSERT INTO `counties` VALUES ('1755', '江城区', '214', '0', '0', '111.95488', '21.86193');
INSERT INTO `counties` VALUES ('1756', '阳西县', '214', '0', '0', '111.61785', '21.75234');
INSERT INTO `counties` VALUES ('1757', '紫金县', '213', '0', '0', '115.18365', '23.63867');
INSERT INTO `counties` VALUES ('1758', '东源县', '213', '0', '0', '114.74633', '23.78835');
INSERT INTO `counties` VALUES ('1759', '和平县', '213', '0', '0', '114.93841', '24.44319');
INSERT INTO `counties` VALUES ('1760', '连平县', '213', '0', '0', '114.49026', '24.37156');
INSERT INTO `counties` VALUES ('1761', '龙川县', '213', '0', '0', '115.26025', '24.10142');
INSERT INTO `counties` VALUES ('1762', '源城区', '213', '0', '0', '114.70242', '23.7341');
INSERT INTO `counties` VALUES ('1763', '东莞市', '216', '0', '0', '113.760234', '23.048884');
INSERT INTO `counties` VALUES ('1764', '佛冈县', '215', '0', '0', '113.53286', '23.87231');
INSERT INTO `counties` VALUES ('1765', '连南瑶族自治县', '215', '0', '0', '112.28842', '24.71726');
INSERT INTO `counties` VALUES ('1766', '连山壮族瑶族自治县', '215', '0', '0', '112.0802', '24.56807');
INSERT INTO `counties` VALUES ('1767', '连州市', '215', '0', '0', '112.38153', '24.77913');
INSERT INTO `counties` VALUES ('1768', '清城区', '215', '0', '0', '113.06265', '23.69784');
INSERT INTO `counties` VALUES ('1769', '清新县', '215', '0', '0', '112.98', '23.73');
INSERT INTO `counties` VALUES ('1770', '阳山县', '215', '0', '0', '112.64129', '24.46516');
INSERT INTO `counties` VALUES ('1771', '英德市', '215', '0', '0', '113.415', '24.18571');
INSERT INTO `counties` VALUES ('1772', '中山市', '217', '0', '0', '113.382391', '22.521113');
INSERT INTO `counties` VALUES ('1773', '潮安县', '218', '0', '0', '116.68', '23.45');
INSERT INTO `counties` VALUES ('1774', '饶平县', '218', '0', '0', '117.00692', '23.66994');
INSERT INTO `counties` VALUES ('1775', '湘桥区', '218', '0', '0', '116.62805', '23.67451');
INSERT INTO `counties` VALUES ('1776', '罗定市', '220', '0', '0', '111.56979', '22.76967');
INSERT INTO `counties` VALUES ('1777', '新兴县', '220', '0', '0', '112.23019', '22.69734');
INSERT INTO `counties` VALUES ('1778', '郁南县', '220', '0', '0', '111.53387', '23.23307');
INSERT INTO `counties` VALUES ('1779', '云安县', '220', '0', '0', '112.00', '23.08');
INSERT INTO `counties` VALUES ('1780', '云城区', '220', '0', '0', '112.03908', '22.92996');
INSERT INTO `counties` VALUES ('1781', '宾阳县', '221', '0', '0', '108.81185', '23.2196');
INSERT INTO `counties` VALUES ('1782', '横县', '221', '0', '0', '109.26608', '22.68448');
INSERT INTO `counties` VALUES ('1783', '江南区', '221', '0', '0', '108.27325', '22.78127');
INSERT INTO `counties` VALUES ('1784', '良庆区', '221', '0', '0', '108.41284', '22.74914');
INSERT INTO `counties` VALUES ('1785', '隆安县', '221', '0', '0', '107.69192', '23.17336');
INSERT INTO `counties` VALUES ('1786', '马山县', '221', '0', '0', '108.17697', '23.70931');
INSERT INTO `counties` VALUES ('1787', '青秀区', '221', '0', '0', '108.49545', '22.78511');
INSERT INTO `counties` VALUES ('1788', '上林县', '221', '0', '0', '108.60522', '23.432');
INSERT INTO `counties` VALUES ('1789', '武鸣县', '221', '0', '0', '108.27719', '23.15643');
INSERT INTO `counties` VALUES ('1790', '西乡塘区', '221', '0', '0', '108.31347', '22.83386');
INSERT INTO `counties` VALUES ('1791', '兴宁区', '221', '0', '0', '108.36694', '22.85355');
INSERT INTO `counties` VALUES ('1792', '邕宁区', '221', '0', '0', '108.48684', '22.75628');
INSERT INTO `counties` VALUES ('1793', '榕城区', '219', '0', '0', '116.3671', '23.52508');
INSERT INTO `counties` VALUES ('1794', '惠来县', '219', '0', '0', '116.29599', '23.03289');
INSERT INTO `counties` VALUES ('1795', '揭东县', '219', '0', '0', '116.42', '23.57');
INSERT INTO `counties` VALUES ('1796', '揭西县', '219', '0', '0', '115.83883', '23.42714');
INSERT INTO `counties` VALUES ('1797', '普宁市', '219', '0', '0', '116.16564', '23.29732');
INSERT INTO `counties` VALUES ('1798', '城中区', '222', '0', '0', '109.41082', '24.31543');
INSERT INTO `counties` VALUES ('1799', '柳北区', '222', '0', '0', '109.40202', '24.36267');
INSERT INTO `counties` VALUES ('1800', '柳城县', '222', '0', '0', '109.23877', '24.64951');
INSERT INTO `counties` VALUES ('1801', '柳江县', '222', '0', '0', '109.33273', '24.25596');
INSERT INTO `counties` VALUES ('1802', '柳南区', '222', '0', '0', '109.38548', '24.33599');
INSERT INTO `counties` VALUES ('1803', '鹿寨县', '222', '0', '0', '109.75177', '24.47306');
INSERT INTO `counties` VALUES ('1804', '融安县', '222', '0', '0', '109.39761', '25.22465');
INSERT INTO `counties` VALUES ('1805', '融水苗族自治县', '222', '0', '0', '109.25634', '25.06628');
INSERT INTO `counties` VALUES ('1806', '三江侗族自治县', '222', '0', '0', '109.60446', '25.78428');
INSERT INTO `counties` VALUES ('1807', '鱼峰区', '222', '0', '0', '109.4533', '24.31868');
INSERT INTO `counties` VALUES ('1808', '叠彩区', '223', '0', '0', '110.30195', '25.31381');
INSERT INTO `counties` VALUES ('1809', '恭城瑶族自治县', '223', '0', '0', '110.83035', '24.83286');
INSERT INTO `counties` VALUES ('1810', '灌阳县', '223', '0', '0', '111.15954', '25.48803');
INSERT INTO `counties` VALUES ('1811', '荔蒲县', '223', '0', '0', null, null);
INSERT INTO `counties` VALUES ('1812', '临桂县', '223', '0', '0', '110.20', '25.23');
INSERT INTO `counties` VALUES ('1813', '灵川县', '223', '0', '0', '110.32949', '25.41292');
INSERT INTO `counties` VALUES ('1814', '龙胜各族自治县', '223', '0', '0', '110.01226', '25.79614');
INSERT INTO `counties` VALUES ('1815', '平乐县', '223', '0', '0', '110.64175', '24.63242');
INSERT INTO `counties` VALUES ('1816', '七星区', '223', '0', '0', '110.31793', '25.2525');
INSERT INTO `counties` VALUES ('1817', '全州县', '223', '0', '0', '111.07211', '25.92799');
INSERT INTO `counties` VALUES ('1818', '象山区', '223', '0', '0', '110.28108', '25.26168');
INSERT INTO `counties` VALUES ('1819', '兴安县', '223', '0', '0', '110.67144', '25.61167');
INSERT INTO `counties` VALUES ('1820', '秀峰区', '223', '0', '0', '110.28915', '25.28249');
INSERT INTO `counties` VALUES ('1821', '雁山区', '223', '0', '0', '110.30911', '25.06038');
INSERT INTO `counties` VALUES ('1822', '阳朔县', '223', '0', '0', '110.49475', '24.77579');
INSERT INTO `counties` VALUES ('1823', '永福县', '223', '0', '0', '109.98333', '24.98004');
INSERT INTO `counties` VALUES ('1824', '资源县', '223', '0', '0', '110.65255', '26.04237');
INSERT INTO `counties` VALUES ('1825', '长洲区', '224', '0', '0', '111.27494', '23.48573');
INSERT INTO `counties` VALUES ('1826', '蝶山区', '224', '0', '0', null, null);
INSERT INTO `counties` VALUES ('1827', '苍梧县', '224', '0', '0', '111.24533', '23.42049');
INSERT INTO `counties` VALUES ('1828', '蒙山县', '224', '0', '0', '110.52221', '24.20168');
INSERT INTO `counties` VALUES ('1829', '藤县', '224', '0', '0', '110.91418', '23.37605');
INSERT INTO `counties` VALUES ('1830', '万秀区', '224', '0', '0', '111.32052', '23.47298');
INSERT INTO `counties` VALUES ('1831', '岑溪市', '224', '0', '0', '110.99594', '22.9191');
INSERT INTO `counties` VALUES ('1832', '铁山港区', '225', '0', '0', '109.45578', '21.59661');
INSERT INTO `counties` VALUES ('1833', '海城区', '225', '0', '0', '109.11744', '21.47501');
INSERT INTO `counties` VALUES ('1834', '合浦县', '225', '0', '0', '109.20068', '21.66601');
INSERT INTO `counties` VALUES ('1835', '银海区', '225', '0', '0', '109.13029', '21.4783');
INSERT INTO `counties` VALUES ('1836', '东兴市', '226', '0', '0', '107.97204', '21.54713');
INSERT INTO `counties` VALUES ('1837', '防城区', '226', '0', '0', '108.35726', '21.76464');
INSERT INTO `counties` VALUES ('1838', '港口区', '226', '0', '0', '108.38022', '21.64342');
INSERT INTO `counties` VALUES ('1839', '上思县', '226', '0', '0', '107.9823', '22.14957');
INSERT INTO `counties` VALUES ('1840', '灵山县', '227', '0', '0', '109.29153', '22.4165');
INSERT INTO `counties` VALUES ('1841', '浦北县', '227', '0', '0', '109.55572', '22.26888');
INSERT INTO `counties` VALUES ('1842', '钦北区', '227', '0', '0', '108.63037', '21.95127');
INSERT INTO `counties` VALUES ('1843', '钦南区', '227', '0', '0', '108.61775', '21.95137');
INSERT INTO `counties` VALUES ('1844', '港北区', '228', '0', '0', '109.57224', '23.11153');
INSERT INTO `counties` VALUES ('1845', '港南区', '228', '0', '0', '109.60617', '23.07226');
INSERT INTO `counties` VALUES ('1846', '桂平市', '228', '0', '0', '110.08105', '23.39339');
INSERT INTO `counties` VALUES ('1847', '平南县', '228', '0', '0', '110.39062', '23.54201');
INSERT INTO `counties` VALUES ('1848', '覃塘区', '228', '0', '0', '109.44293', '23.12677');
INSERT INTO `counties` VALUES ('1849', '北流市', '229', '0', '0', '110.35302', '22.70817');
INSERT INTO `counties` VALUES ('1850', '玉州区', '229', '0', '0', '110.15114', '22.6281');
INSERT INTO `counties` VALUES ('1851', '博白县', '229', '0', '0', '109.97744', '22.27286');
INSERT INTO `counties` VALUES ('1852', '陆川县', '229', '0', '0', '110.26413', '22.32454');
INSERT INTO `counties` VALUES ('1853', '容县', '229', '0', '0', '110.55593', '22.85701');
INSERT INTO `counties` VALUES ('1854', '兴业县', '229', '0', '0', '109.87612', '22.74237');
INSERT INTO `counties` VALUES ('1855', '德保县', '230', '0', '0', '106.61917', '23.32515');
INSERT INTO `counties` VALUES ('1856', '靖西县', '230', '0', '0', '106.41766', '23.13425');
INSERT INTO `counties` VALUES ('1857', '乐业县', '230', '0', '0', '106.56124', '24.78295');
INSERT INTO `counties` VALUES ('1858', '凌云县', '230', '0', '0', '106.56155', '24.34747');
INSERT INTO `counties` VALUES ('1859', '隆林各族自治县', '230', '0', '0', '105.34295', '24.77036');
INSERT INTO `counties` VALUES ('1860', '那坡县', '230', '0', '0', '105.84191', '23.40649');
INSERT INTO `counties` VALUES ('1861', '平果县', '230', '0', '0', '107.59045', '23.32969');
INSERT INTO `counties` VALUES ('1862', '田东县', '230', '0', '0', '107.12432', '23.60003');
INSERT INTO `counties` VALUES ('1863', '田林县', '230', '0', '0', '106.22882', '24.29207');
INSERT INTO `counties` VALUES ('1864', '田阳县', '230', '0', '0', '106.91558', '23.73535');
INSERT INTO `counties` VALUES ('1865', '西林县', '230', '0', '0', '105.09722', '24.48966');
INSERT INTO `counties` VALUES ('1866', '右江区', '230', '0', '0', '106.61764', '23.9009');
INSERT INTO `counties` VALUES ('1867', '八步区', '231', '0', '0', '111.55225', '24.41179');
INSERT INTO `counties` VALUES ('1868', '富川瑶族自治县', '231', '0', '0', '111.27767', '24.81431');
INSERT INTO `counties` VALUES ('1869', '昭平县', '231', '0', '0', '110.81082', '24.1701');
INSERT INTO `counties` VALUES ('1870', '钟山县', '231', '0', '0', '111.30459', '24.52482');
INSERT INTO `counties` VALUES ('1871', '巴马瑶族自治县', '232', '0', '0', '107.25308', '24.14135');
INSERT INTO `counties` VALUES ('1872', '大化瑶族自治县', '232', '0', '0', '107.9985', '23.74487');
INSERT INTO `counties` VALUES ('1873', '东兰县', '232', '0', '0', '107.37527', '24.51053');
INSERT INTO `counties` VALUES ('1874', '都安瑶族自治县', '232', '0', '0', '108.10116', '23.93245');
INSERT INTO `counties` VALUES ('1875', '凤山县', '232', '0', '0', '107.04892', '24.54215');
INSERT INTO `counties` VALUES ('1876', '环江毛南族自治县', '232', '0', '0', '108.26055', '24.82916');
INSERT INTO `counties` VALUES ('1877', '金城江区', '232', '0', '0', '108.03727', '24.6897');
INSERT INTO `counties` VALUES ('1878', '罗城仫佬族自治县', '232', '0', '0', '108.90777', '24.77923');
INSERT INTO `counties` VALUES ('1879', '南丹县', '232', '0', '0', '107.54562', '24.9776');
INSERT INTO `counties` VALUES ('1880', '天峨县', '232', '0', '0', '107.17205', '24.99593');
INSERT INTO `counties` VALUES ('1881', '宜州市', '232', '0', '0', '108.65304', '24.49391');
INSERT INTO `counties` VALUES ('1882', '合山市', '233', '0', '0', '108.88586', '23.80619');
INSERT INTO `counties` VALUES ('1883', '金秀瑶族自治县', '233', '0', '0', '110.19079', '24.12929');
INSERT INTO `counties` VALUES ('1884', '武宣县', '233', '0', '0', '109.66284', '23.59474');
INSERT INTO `counties` VALUES ('1885', '象州县', '233', '0', '0', '109.6994', '23.97355');
INSERT INTO `counties` VALUES ('1886', '忻城县', '233', '0', '0', '108.66357', '24.06862');
INSERT INTO `counties` VALUES ('1887', '兴宾区', '233', '0', '0', '109.23471', '23.72731');
INSERT INTO `counties` VALUES ('1888', '龙华区', '235', '0', '0', '110.30194', '20.02866');
INSERT INTO `counties` VALUES ('1889', '美兰区', '235', '0', '0', '110.36908', '20.02864');
INSERT INTO `counties` VALUES ('1890', '琼山区', '235', '0', '0', '110.35418', '20.00321');
INSERT INTO `counties` VALUES ('1891', '秀英区', '235', '0', '0', '110.29345', '20.00752');
INSERT INTO `counties` VALUES ('1892', '大新县', '234', '0', '0', '107.19821', '22.83412');
INSERT INTO `counties` VALUES ('1893', '扶绥县', '234', '0', '0', '107.90405', '22.63413');
INSERT INTO `counties` VALUES ('1894', '江州区', '234', '0', '0', '107.34747', '22.41135');
INSERT INTO `counties` VALUES ('1895', '龙州县', '234', '0', '0', '106.85415', '22.33937');
INSERT INTO `counties` VALUES ('1896', '宁明县', '234', '0', '0', '107.07299', '22.13655');
INSERT INTO `counties` VALUES ('1897', '凭祥市', '234', '0', '0', '106.75534', '22.10573');
INSERT INTO `counties` VALUES ('1898', '天等县', '234', '0', '0', '107.13998', '23.077');
INSERT INTO `counties` VALUES ('1899', '三亚市', '236', '0', '0', '109.508268', '18.247872');
INSERT INTO `counties` VALUES ('1900', '白沙黎族自治县', '237', '0', '0', '109.452606', '19.224584');
INSERT INTO `counties` VALUES ('1901', '保亭黎族苗族自治县', '237', '0', '0', '109.70245', '18.636371');
INSERT INTO `counties` VALUES ('1902', '昌江黎族自治县', '237', '0', '0', '109.053351', '19.260968');
INSERT INTO `counties` VALUES ('1903', '澄迈县', '237', '0', '0', '110.007147', '19.737095');
INSERT INTO `counties` VALUES ('1904', '定安县', '237', '0', '0', '110.323959', '19.699211');
INSERT INTO `counties` VALUES ('1905', '东方市', '237', '0', '0', '108.653789', '19.10198');
INSERT INTO `counties` VALUES ('1906', '乐东黎族自治县', '237', '0', '0', '109.175444', '18.74758');
INSERT INTO `counties` VALUES ('1907', '临高县', '237', '0', '0', '109.687697', '19.908293');
INSERT INTO `counties` VALUES ('1908', '陵水黎族自治县', '237', '0', '0', '110.037218', '18.505006');
INSERT INTO `counties` VALUES ('1909', '琼海市', '237', '0', '0', '110.466785', '19.246011');
INSERT INTO `counties` VALUES ('1910', '琼中黎族苗族自治县', '237', '0', '0', '109.839996', '19.03557');
INSERT INTO `counties` VALUES ('1911', '屯昌县', '237', '0', '0', '110.102773', '19.362916');
INSERT INTO `counties` VALUES ('1912', '万宁市', '237', '0', '0', '110.388793', '18.796216');
INSERT INTO `counties` VALUES ('1913', '文昌市', '237', '0', '0', '110.753975', '19.612986');
INSERT INTO `counties` VALUES ('1914', '五指山市', '237', '0', '0', '109.516662', '18.776921');
INSERT INTO `counties` VALUES ('1915', '儋州市', '237', '0', '0', '109.576782', '19.517486');
INSERT INTO `counties` VALUES ('1919', '成华区', '241', '0', '0', '104.10193', '30.65993');
INSERT INTO `counties` VALUES ('1920', '崇州市', '241', '0', '0', '103.67285', '30.63014');
INSERT INTO `counties` VALUES ('1921', '大邑县', '241', '0', '0', '103.52075', '30.58738');
INSERT INTO `counties` VALUES ('1922', '都江堰市', '241', '0', '0', '103.61941', '30.99825');
INSERT INTO `counties` VALUES ('1923', '金牛区', '241', '0', '0', '104.05114', '30.69126');
INSERT INTO `counties` VALUES ('1924', '金堂县', '241', '0', '0', '104.41195', '30.86195');
INSERT INTO `counties` VALUES ('1925', '锦江区', '241', '0', '0', '104.08347', '30.65614');
INSERT INTO `counties` VALUES ('1926', '龙泉驿区', '241', '0', '0', '104.27462', '30.55658');
INSERT INTO `counties` VALUES ('1927', '彭州市', '241', '0', '0', '103.958', '30.99011');
INSERT INTO `counties` VALUES ('1928', '蒲江县', '241', '0', '0', '103.50616', '30.19667');
INSERT INTO `counties` VALUES ('1929', '青白江区', '241', '0', '0', '104.251', '30.87841');
INSERT INTO `counties` VALUES ('1930', '青羊区', '241', '0', '0', '104.06151', '30.67387');
INSERT INTO `counties` VALUES ('1931', '双流县', '241', '0', '0', '103.92373', '30.57444');
INSERT INTO `counties` VALUES ('1932', '温江区', '241', '0', '0', '103.84881', '30.68444');
INSERT INTO `counties` VALUES ('1933', '武侯区', '241', '0', '0', '104.04303', '30.64235');
INSERT INTO `counties` VALUES ('1934', '新都区', '241', '0', '0', '104.15921', '30.82314');
INSERT INTO `counties` VALUES ('1935', '新津县', '241', '0', '0', '103.8114', '30.40983');
INSERT INTO `counties` VALUES ('1936', '邛崃市', '241', '0', '0', '103.46283', '30.41489');
INSERT INTO `counties` VALUES ('1937', '郫县', '241', '0', '0', '103.88717', '30.81054');
INSERT INTO `counties` VALUES ('1938', '大安区', '242', '0', '0', '104.77383', '29.36364');
INSERT INTO `counties` VALUES ('1939', '富顺县', '242', '0', '0', '104.97491', '29.18123');
INSERT INTO `counties` VALUES ('1940', '贡井区', '242', '0', '0', '104.71536', '29.34576');
INSERT INTO `counties` VALUES ('1941', '荣县', '242', '0', '0', '104.4176', '29.44445');
INSERT INTO `counties` VALUES ('1942', '沿滩区', '242', '0', '0', '104.88012', '29.26611');
INSERT INTO `counties` VALUES ('1943', '自流井区', '242', '0', '0', '104.77719', '29.33745');
INSERT INTO `counties` VALUES ('1944', '西区', '243', '0', '0', '101.63058', '26.59753');
INSERT INTO `counties` VALUES ('1945', '盐边县', '243', '0', '0', '101.85446', '26.68847');
INSERT INTO `counties` VALUES ('1946', '东区', '243', '0', '0', '101.7052', '26.54677');
INSERT INTO `counties` VALUES ('1947', '米易县', '243', '0', '0', '102.11132', '26.88718');
INSERT INTO `counties` VALUES ('1948', '仁和区', '243', '0', '0', '101.73812', '26.49841');
INSERT INTO `counties` VALUES ('1949', '龙马潭区', '244', '0', '0', '105.43774', '28.91308');
INSERT INTO `counties` VALUES ('1950', '古蔺县', '244', '0', '0', '105.81347', '28.03867');
INSERT INTO `counties` VALUES ('1951', '合江县', '244', '0', '0', '105.8352', '28.81005');
INSERT INTO `counties` VALUES ('1952', '江阳区', '244', '0', '0', '105.45336', '28.88934');
INSERT INTO `counties` VALUES ('1953', '纳溪区', '244', '0', '0', '105.37255', '28.77343');
INSERT INTO `counties` VALUES ('1954', '叙永县', '244', '0', '0', '105.44473', '28.15586');
INSERT INTO `counties` VALUES ('1955', '泸县', '244', '0', '0', '105.38192', '29.15041');
INSERT INTO `counties` VALUES ('1956', '广汉市', '245', '0', '0', '104.28234', '30.97686');
INSERT INTO `counties` VALUES ('1957', '罗江县', '245', '0', '0', '104.51025', '31.31665');
INSERT INTO `counties` VALUES ('1958', '绵竹市', '245', '0', '0', '104.22076', '31.33772');
INSERT INTO `counties` VALUES ('1959', '什邡市', '245', '0', '0', '104.16754', '31.1264');
INSERT INTO `counties` VALUES ('1960', '中江县', '245', '0', '0', '104.67861', '31.03297');
INSERT INTO `counties` VALUES ('1961', '旌阳区', '245', '0', '0', '104.39367', '31.13906');
INSERT INTO `counties` VALUES ('1962', '安县', '246', '0', '0', '104.56738', '31.53487');
INSERT INTO `counties` VALUES ('1963', '北川羌族自治县', '246', '0', '0', '104.46408', '31.83286');
INSERT INTO `counties` VALUES ('1964', '涪城区', '246', '0', '0', '104.75719', '31.45522');
INSERT INTO `counties` VALUES ('1965', '江油市', '246', '0', '0', '104.74539', '31.77775');
INSERT INTO `counties` VALUES ('1966', '平武县', '246', '0', '0', '104.52862', '32.40791');
INSERT INTO `counties` VALUES ('1967', '三台县', '246', '0', '0', '105.09079', '31.09179');
INSERT INTO `counties` VALUES ('1968', '盐亭县', '246', '0', '0', '105.3898', '31.22176');
INSERT INTO `counties` VALUES ('1969', '游仙区', '246', '0', '0', '104.77092', '31.46574');
INSERT INTO `counties` VALUES ('1970', '梓潼县', '246', '0', '0', '105.16183', '31.6359');
INSERT INTO `counties` VALUES ('1971', '苍溪县', '247', '0', '0', '105.936', '31.73209');
INSERT INTO `counties` VALUES ('1972', '朝天区', '247', '0', '0', '105.89273', '32.64398');
INSERT INTO `counties` VALUES ('1973', '剑阁县', '247', '0', '0', '105.5252', '32.28845');
INSERT INTO `counties` VALUES ('1974', '利州区', '247', '0', '0', '105.826194', '32.432276');
INSERT INTO `counties` VALUES ('1975', '青川县', '247', '0', '0', '105.2391', '32.58563');
INSERT INTO `counties` VALUES ('1976', '旺苍县', '247', '0', '0', '106.29022', '32.22845');
INSERT INTO `counties` VALUES ('1977', '元坝区', '247', '0', '0', '105.97', '32.32');
INSERT INTO `counties` VALUES ('1978', '安居区', '248', '0', '0', '105.46402', '30.35778');
INSERT INTO `counties` VALUES ('1979', '船山区', '248', '0', '0', '105.5809', '30.49991');
INSERT INTO `counties` VALUES ('1980', '大英县', '248', '0', '0', '105.24346', '30.59434');
INSERT INTO `counties` VALUES ('1981', '蓬溪县', '248', '0', '0', '105.70752', '30.75775');
INSERT INTO `counties` VALUES ('1982', '射洪县', '248', '0', '0', '105.38922', '30.87203');
INSERT INTO `counties` VALUES ('1983', '隆昌县', '249', '0', '0', '105.28738', '29.33937');
INSERT INTO `counties` VALUES ('1984', '东兴区', '249', '0', '0', '105.07554', '29.59278');
INSERT INTO `counties` VALUES ('1985', '市中区', '249', '0', '0', '116.99741', '36.65101');
INSERT INTO `counties` VALUES ('1986', '威远县', '249', '0', '0', '104.66955', '29.52823');
INSERT INTO `counties` VALUES ('1987', '资中县', '249', '0', '0', '104.85205', '29.76409');
INSERT INTO `counties` VALUES ('1988', '峨边彝族自治县', '250', '0', '0', '103.26339', '29.23004');
INSERT INTO `counties` VALUES ('1989', '峨眉山市', '250', '0', '0', '103.4844', '29.60117');
INSERT INTO `counties` VALUES ('1990', '金口河区', '250', '0', '0', '103.07858', '29.24578');
INSERT INTO `counties` VALUES ('1991', '井研县', '250', '0', '0', '104.07019', '29.65228');
INSERT INTO `counties` VALUES ('1992', '马边彝族自治县', '250', '0', '0', '103.54617', '28.83593');
INSERT INTO `counties` VALUES ('1993', '沙湾区', '250', '0', '0', '103.54873', '29.41194');
INSERT INTO `counties` VALUES ('1994', '市中区', '250', '0', '0', '116.99741', '36.65101');
INSERT INTO `counties` VALUES ('1995', '五通桥区', '250', '0', '0', '103.82345', '29.40344');
INSERT INTO `counties` VALUES ('1996', '沐川县', '250', '0', '0', '103.90353', '28.95646');
INSERT INTO `counties` VALUES ('1997', '犍为县', '250', '0', '0', '103.94989', '29.20973');
INSERT INTO `counties` VALUES ('1998', '夹江县', '250', '0', '0', '103.57199', '29.73868');
INSERT INTO `counties` VALUES ('1999', '高坪区', '251', '0', '0', '106.11894', '30.78162');
INSERT INTO `counties` VALUES ('2000', '嘉陵区', '251', '0', '0', '106.07141', '30.75848');
INSERT INTO `counties` VALUES ('2001', '南部县', '251', '0', '0', '106.06738', '31.35451');
INSERT INTO `counties` VALUES ('2002', '蓬安县', '251', '0', '0', '106.41262', '31.02964');
INSERT INTO `counties` VALUES ('2003', '顺庆区', '251', '0', '0', '106.09216', '30.79642');
INSERT INTO `counties` VALUES ('2004', '西充县', '251', '0', '0', '105.89996', '30.9969');
INSERT INTO `counties` VALUES ('2005', '仪陇县', '251', '0', '0', '106.29974', '31.27628');
INSERT INTO `counties` VALUES ('2006', '营山县', '251', '0', '0', '106.56637', '31.07747');
INSERT INTO `counties` VALUES ('2007', '阆中市', '251', '0', '0', '106.00494', '31.55832');
INSERT INTO `counties` VALUES ('2008', '彭山县', '252', '0', '0', '103.87', '30.20');
INSERT INTO `counties` VALUES ('2009', '丹棱县', '252', '0', '0', '103.51339', '30.01562');
INSERT INTO `counties` VALUES ('2010', '东坡区', '252', '0', '0', '103.832', '30.04219');
INSERT INTO `counties` VALUES ('2011', '洪雅县', '252', '0', '0', '103.37313', '29.90661');
INSERT INTO `counties` VALUES ('2012', '青神县', '252', '0', '0', '103.84771', '29.83235');
INSERT INTO `counties` VALUES ('2013', '仁寿县', '252', '0', '0', '104.13412', '29.99599');
INSERT INTO `counties` VALUES ('2014', '广安区', '254', '0', '0', '106.64163', '30.47389');
INSERT INTO `counties` VALUES ('2015', '华蓥市', '254', '0', '0', '106.78466', '30.39007');
INSERT INTO `counties` VALUES ('2016', '邻水县', '254', '0', '0', '106.92968', '30.33449');
INSERT INTO `counties` VALUES ('2017', '武胜县', '254', '0', '0', '106.29592', '30.34932');
INSERT INTO `counties` VALUES ('2018', '岳池县', '254', '0', '0', '106.44079', '30.53918');
INSERT INTO `counties` VALUES ('2019', '长宁县', '253', '0', '0', '104.9252', '28.57777');
INSERT INTO `counties` VALUES ('2020', '翠屏区', '253', '0', '0', '104.61978', '28.76566');
INSERT INTO `counties` VALUES ('2021', '高县', '253', '0', '0', '104.51754', '28.43619');
INSERT INTO `counties` VALUES ('2022', '江安县', '253', '0', '0', '105.06683', '28.72385');
INSERT INTO `counties` VALUES ('2023', '南溪区', '253', '0', '0', '104.981133', '28.839806');
INSERT INTO `counties` VALUES ('2024', '屏山县', '253', '0', '0', '104.16293', '28.64369');
INSERT INTO `counties` VALUES ('2025', '兴文县', '253', '0', '0', '105.23675', '28.3044');
INSERT INTO `counties` VALUES ('2026', '宜宾县', '253', '0', '0', '104.53314', '28.68996');
INSERT INTO `counties` VALUES ('2027', '珙县', '253', '0', '0', '104.71398', '28.44512');
INSERT INTO `counties` VALUES ('2028', '筠连县', '253', '0', '0', '104.51217', '28.16495');
INSERT INTO `counties` VALUES ('2029', '达县', '255', '0', '0', '107.50', '31.20');
INSERT INTO `counties` VALUES ('2030', '大竹县', '255', '0', '0', '107.20855', '30.74147');
INSERT INTO `counties` VALUES ('2031', '开江县', '255', '0', '0', '107.86889', '31.0841');
INSERT INTO `counties` VALUES ('2032', '渠县', '255', '0', '0', '106.97381', '30.8376');
INSERT INTO `counties` VALUES ('2033', '通川区', '255', '0', '0', '107.50456', '31.21469');
INSERT INTO `counties` VALUES ('2034', '万源市', '255', '0', '0', '108.03598', '32.08091');
INSERT INTO `counties` VALUES ('2035', '宣汉县', '255', '0', '0', '107.72775', '31.35516');
INSERT INTO `counties` VALUES ('2036', '石棉县', '256', '0', '0', '102.35943', '29.22796');
INSERT INTO `counties` VALUES ('2037', '芦山县', '256', '0', '0', '102.92791', '30.14369');
INSERT INTO `counties` VALUES ('2038', '名山县', '256', '0', '0', '103.12', '30.08');
INSERT INTO `counties` VALUES ('2039', '汉源县', '256', '0', '0', '102.6784', '29.35168');
INSERT INTO `counties` VALUES ('2040', '天全县', '256', '0', '0', '102.75906', '30.06754');
INSERT INTO `counties` VALUES ('2041', '荥经县', '256', '0', '0', '102.84652', '29.79402');
INSERT INTO `counties` VALUES ('2042', '雨城区', '256', '0', '0', '103.03305', '30.00531');
INSERT INTO `counties` VALUES ('2043', '宝兴县', '256', '0', '0', '102.81555', '30.36836');
INSERT INTO `counties` VALUES ('2044', '巴州区', '257', '0', '0', '106.76889', '31.85125');
INSERT INTO `counties` VALUES ('2045', '南江县', '257', '0', '0', '106.84164', '32.35335');
INSERT INTO `counties` VALUES ('2046', '平昌县', '257', '0', '0', '107.10424', '31.5594');
INSERT INTO `counties` VALUES ('2047', '通江县', '257', '0', '0', '107.24398', '31.91294');
INSERT INTO `counties` VALUES ('2048', '简阳市', '258', '0', '0', '104.54864', '30.3904');
INSERT INTO `counties` VALUES ('2049', '乐至县', '258', '0', '0', '105.03207', '30.27227');
INSERT INTO `counties` VALUES ('2050', '安岳县', '258', '0', '0', '105.3363', '30.09786');
INSERT INTO `counties` VALUES ('2051', '雁江区', '258', '0', '0', '104.65216', '30.11525');
INSERT INTO `counties` VALUES ('2052', '阿坝县', '259', '0', '0', '101.70632', '32.90301');
INSERT INTO `counties` VALUES ('2053', '金川县', '259', '0', '0', '102.06555', '31.47623');
INSERT INTO `counties` VALUES ('2054', '马尔康县', '259', '0', '0', '102.20625', '31.90584');
INSERT INTO `counties` VALUES ('2055', '壤塘县', '259', '0', '0', '100.9783', '32.26578');
INSERT INTO `counties` VALUES ('2056', '九寨沟县', '259', '0', '0', '104.23672', '33.26318');
INSERT INTO `counties` VALUES ('2057', '茂县', '259', '0', '0', '103.85372', '31.682');
INSERT INTO `counties` VALUES ('2058', '汶川县', '259', '0', '0', '103.59079', '31.47326');
INSERT INTO `counties` VALUES ('2059', '黑水县', '259', '0', '0', '102.99176', '32.06184');
INSERT INTO `counties` VALUES ('2060', '红原县', '259', '0', '0', '102.54525', '32.78989');
INSERT INTO `counties` VALUES ('2061', '理县', '259', '0', '0', '103.17175', '31.43603');
INSERT INTO `counties` VALUES ('2062', '若尔盖县', '259', '0', '0', '102.9598', '33.57432');
INSERT INTO `counties` VALUES ('2063', '松潘县', '259', '0', '0', '103.59924', '32.63871');
INSERT INTO `counties` VALUES ('2064', '小金县', '259', '0', '0', '102.36499', '30.99934');
INSERT INTO `counties` VALUES ('2065', '白云区', '262', '0', '0', '113.27307', '23.15787');
INSERT INTO `counties` VALUES ('2066', '小河区', '262', '0', '0', '106.70', '26.53');
INSERT INTO `counties` VALUES ('2067', '花溪区', '262', '0', '0', '106.67688', '26.43343');
INSERT INTO `counties` VALUES ('2068', '开阳县', '262', '0', '0', '106.9692', '27.05533');
INSERT INTO `counties` VALUES ('2069', '南明区', '262', '0', '0', '106.7145', '26.56819');
INSERT INTO `counties` VALUES ('2070', '清镇市', '262', '0', '0', '106.46862', '26.55261');
INSERT INTO `counties` VALUES ('2071', '乌当区', '262', '0', '0', '106.7521', '26.6302');
INSERT INTO `counties` VALUES ('2072', '息烽县', '262', '0', '0', '106.738', '27.09346');
INSERT INTO `counties` VALUES ('2073', '修文县', '262', '0', '0', '106.59487', '26.83783');
INSERT INTO `counties` VALUES ('2074', '云岩区', '262', '0', '0', '106.72485', '26.60484');
INSERT INTO `counties` VALUES ('2075', '德昌县', '261', '0', '0', '102.18017', '27.40482');
INSERT INTO `counties` VALUES ('2076', '会理县', '261', '0', '0', '102.24539', '26.65627');
INSERT INTO `counties` VALUES ('2077', '冕宁县', '261', '0', '0', '102.17108', '28.55161');
INSERT INTO `counties` VALUES ('2078', '木里藏族自治县', '261', '0', '0', '101.2796', '27.92875');
INSERT INTO `counties` VALUES ('2079', '普格县', '261', '0', '0', '102.54055', '27.37485');
INSERT INTO `counties` VALUES ('2080', '西昌市', '261', '0', '0', '102.26413', '27.89524');
INSERT INTO `counties` VALUES ('2081', '喜德县', '261', '0', '0', '102.41336', '28.30739');
INSERT INTO `counties` VALUES ('2082', '盐源县', '261', '0', '0', '101.5097', '27.42177');
INSERT INTO `counties` VALUES ('2083', '金阳县', '261', '0', '0', '103.24774', '27.69698');
INSERT INTO `counties` VALUES ('2084', '雷波县', '261', '0', '0', '103.57287', '28.26407');
INSERT INTO `counties` VALUES ('2085', '美姑县', '261', '0', '0', '103.13116', '28.32596');
INSERT INTO `counties` VALUES ('2086', '布拖县', '261', '0', '0', '102.81234', '27.7079');
INSERT INTO `counties` VALUES ('2087', '甘洛县', '261', '0', '0', '102.77154', '28.96624');
INSERT INTO `counties` VALUES ('2088', '会东县', '261', '0', '0', '102.57815', '26.63429');
INSERT INTO `counties` VALUES ('2089', '宁南县', '261', '0', '0', '102.76116', '27.06567');
INSERT INTO `counties` VALUES ('2090', '越西县', '261', '0', '0', '102.5079', '28.64133');
INSERT INTO `counties` VALUES ('2091', '昭觉县', '261', '0', '0', '102.84661', '28.01155');
INSERT INTO `counties` VALUES ('2092', '六枝特区', '263', '0', '0', '105.48062', '26.20117');
INSERT INTO `counties` VALUES ('2093', '盘县', '263', '0', '0', '104.47061', '25.7136');
INSERT INTO `counties` VALUES ('2094', '水城县', '263', '0', '0', '104.95764', '26.54785');
INSERT INTO `counties` VALUES ('2095', '钟山区', '263', '0', '0', '104.87848', '26.57699');
INSERT INTO `counties` VALUES ('2096', '稻城县', '260', '0', '0', '100.29809', '29.0379');
INSERT INTO `counties` VALUES ('2097', '得荣县', '260', '0', '0', '99.28628', '28.71297');
INSERT INTO `counties` VALUES ('2098', '九龙县', '260', '0', '0', '101.50848', '29.00091');
INSERT INTO `counties` VALUES ('2099', '乡城县', '260', '0', '0', '99.79943', '28.93554');
INSERT INTO `counties` VALUES ('2100', '白玉县', '260', '0', '0', '98.82568', '31.20902');
INSERT INTO `counties` VALUES ('2101', '丹巴县', '260', '0', '0', '101.88424', '30.87656');
INSERT INTO `counties` VALUES ('2102', '道孚县', '260', '0', '0', '101.12554', '30.98046');
INSERT INTO `counties` VALUES ('2103', '德格县', '260', '0', '0', '98.58078', '31.80615');
INSERT INTO `counties` VALUES ('2104', '甘孜县', '260', '0', '0', '99.99307', '31.62672');
INSERT INTO `counties` VALUES ('2105', '炉霍县', '260', '0', '0', '100.67681', '31.3917');
INSERT INTO `counties` VALUES ('2106', '色达县', '260', '0', '0', '100.33224', '32.26839');
INSERT INTO `counties` VALUES ('2107', '石渠县', '260', '0', '0', '98.10156', '32.97884');
INSERT INTO `counties` VALUES ('2108', '新龙县', '260', '0', '0', '100.3125', '30.94067');
INSERT INTO `counties` VALUES ('2109', '巴塘县', '260', '0', '0', '99.10409', '30.00423');
INSERT INTO `counties` VALUES ('2110', '康定县', '260', '0', '0', '101.96487', '30.05532');
INSERT INTO `counties` VALUES ('2111', '理塘县', '260', '0', '0', '100.27005', '29.99674');
INSERT INTO `counties` VALUES ('2112', '雅江县', '260', '0', '0', '101.01492', '30.03281');
INSERT INTO `counties` VALUES ('2113', '泸定县', '260', '0', '0', '102.23507', '29.91475');
INSERT INTO `counties` VALUES ('2114', '赤水市', '264', '0', '0', '105.69845', '28.58921');
INSERT INTO `counties` VALUES ('2115', '道真仡佬族苗族自治县', '264', '0', '0', '107.61152', '28.864');
INSERT INTO `counties` VALUES ('2116', '凤冈县', '264', '0', '0', '107.71682', '27.95461');
INSERT INTO `counties` VALUES ('2117', '红花岗区', '264', '0', '0', '106.89404', '27.64471');
INSERT INTO `counties` VALUES ('2118', '汇川区', '264', '0', '0', '106.9393', '27.70625');
INSERT INTO `counties` VALUES ('2119', '仁怀市', '264', '0', '0', '106.40152', '27.79231');
INSERT INTO `counties` VALUES ('2120', '绥阳县', '264', '0', '0', '107.19064', '27.94702');
INSERT INTO `counties` VALUES ('2121', '桐梓县', '264', '0', '0', '106.82568', '28.13806');
INSERT INTO `counties` VALUES ('2122', '务川仡佬族苗族自治县', '264', '0', '0', '107.88935', '28.52227');
INSERT INTO `counties` VALUES ('2123', '习水县', '264', '0', '0', '106.21267', '28.31976');
INSERT INTO `counties` VALUES ('2124', '余庆县', '264', '0', '0', '107.88821', '27.22532');
INSERT INTO `counties` VALUES ('2125', '正安县', '264', '0', '0', '107.44357', '28.5512');
INSERT INTO `counties` VALUES ('2126', '遵义县', '264', '0', '0', '106.83331', '27.53772');
INSERT INTO `counties` VALUES ('2127', '湄潭县', '264', '0', '0', '107.48779', '27.76676');
INSERT INTO `counties` VALUES ('2128', '关岭布依族苗族自治县', '265', '0', '0', '105.61883', '25.94248');
INSERT INTO `counties` VALUES ('2129', '平坝县', '265', '0', '0', '106.25', '26.42');
INSERT INTO `counties` VALUES ('2130', '普定县', '265', '0', '0', '105.74285', '26.30141');
INSERT INTO `counties` VALUES ('2131', '西秀区', '265', '0', '0', '105.96585', '26.24491');
INSERT INTO `counties` VALUES ('2132', '镇宁布依族苗族自治县', '265', '0', '0', '105.76513', '26.05533');
INSERT INTO `counties` VALUES ('2133', '紫云苗族布依族自治县', '265', '0', '0', '106.08364', '25.75258');
INSERT INTO `counties` VALUES ('2134', '德江县', '266', '0', '0', '108.117317', '28.26094');
INSERT INTO `counties` VALUES ('2135', '江口县', '266', '0', '0', '108.848427', '27.691904');
INSERT INTO `counties` VALUES ('2136', '石阡县', '266', '0', '0', '108.229854', '27.519386');
INSERT INTO `counties` VALUES ('2137', '思南县', '266', '0', '0', '108.255827', '27.941331');
INSERT INTO `counties` VALUES ('2138', '松桃苗族自治县', '266', '0', '0', '109.202627', '28.165419');
INSERT INTO `counties` VALUES ('2139', '碧江区', '266', '0', '0', '109.191555', '27.718346');
INSERT INTO `counties` VALUES ('2140', '万山区', '266', '0', '0', '109.21199', '27.51903');
INSERT INTO `counties` VALUES ('2141', '沿河土家族自治县', '266', '0', '0', '108.495746', '28.560487');
INSERT INTO `counties` VALUES ('2142', '印江土家族苗族自治县', '266', '0', '0', '108.405517', '27.997976');
INSERT INTO `counties` VALUES ('2143', '玉屏侗族自治县', '266', '0', '0', '108.917882', '27.238024');
INSERT INTO `counties` VALUES ('2144', '从江县', '269', '0', '0', '108.90527', '25.75415');
INSERT INTO `counties` VALUES ('2145', '丹寨县', '269', '0', '0', '107.79718', '26.19816');
INSERT INTO `counties` VALUES ('2146', '黄平县', '269', '0', '0', '107.90179', '26.89573');
INSERT INTO `counties` VALUES ('2147', '剑河县', '269', '0', '0', '108.5913', '26.6525');
INSERT INTO `counties` VALUES ('2148', '锦屏县', '269', '0', '0', '109.19982', '26.67635');
INSERT INTO `counties` VALUES ('2149', '岑巩县', '269', '0', '0', '108.81884', '27.17539');
INSERT INTO `counties` VALUES ('2150', '凯里市', '269', '0', '0', '107.98132', '26.56689');
INSERT INTO `counties` VALUES ('2151', '雷山县', '269', '0', '0', '108.07745', '26.38385');
INSERT INTO `counties` VALUES ('2152', '黎平县', '269', '0', '0', '109.13607', '26.23114');
INSERT INTO `counties` VALUES ('2153', '麻江县', '269', '0', '0', '107.59155', '26.49235');
INSERT INTO `counties` VALUES ('2154', '三穗县', '269', '0', '0', '108.67132', '26.94765');
INSERT INTO `counties` VALUES ('2155', '施秉县', '269', '0', '0', '108.12597', '27.03495');
INSERT INTO `counties` VALUES ('2156', '台江县', '269', '0', '0', '108.31814', '26.66916');
INSERT INTO `counties` VALUES ('2157', '天柱县', '269', '0', '0', '109.20718', '26.90781');
INSERT INTO `counties` VALUES ('2158', '镇远县', '269', '0', '0', '108.42721', '27.04933');
INSERT INTO `counties` VALUES ('2159', '榕江县', '269', '0', '0', '108.52072', '25.92421');
INSERT INTO `counties` VALUES ('2160', '安龙县', '267', '0', '0', '105.44268', '25.09818');
INSERT INTO `counties` VALUES ('2161', '册亨县', '267', '0', '0', '105.8124', '24.98376');
INSERT INTO `counties` VALUES ('2162', '普安县', '267', '0', '0', '104.95529', '25.78603');
INSERT INTO `counties` VALUES ('2163', '晴隆县', '267', '0', '0', '105.2192', '25.83522');
INSERT INTO `counties` VALUES ('2164', '望谟县', '267', '0', '0', '106.09957', '25.17822');
INSERT INTO `counties` VALUES ('2165', '兴仁县', '267', '0', '0', '105.18652', '25.43282');
INSERT INTO `counties` VALUES ('2166', '兴义市', '267', '0', '0', '104.89548', '25.09205');
INSERT INTO `counties` VALUES ('2167', '贞丰县', '267', '0', '0', '105.65454', '25.38464');
INSERT INTO `counties` VALUES ('2168', '七星关区', '268', '0', '0', '104.9497', '27.153556');
INSERT INTO `counties` VALUES ('2169', '大方县', '268', '0', '0', '105.609254', '27.143521');
INSERT INTO `counties` VALUES ('2170', '赫章县', '268', '0', '0', '104.726438', '27.119243');
INSERT INTO `counties` VALUES ('2171', '金沙县', '268', '0', '0', '106.222103', '27.459693');
INSERT INTO `counties` VALUES ('2172', '纳雍县', '268', '0', '0', '105.375322', '26.769875');
INSERT INTO `counties` VALUES ('2173', '黔西县', '268', '0', '0', '106.038299', '27.024923');
INSERT INTO `counties` VALUES ('2174', '威宁彝族回族苗族自治县', '268', '0', '0', '104.286523', '26.859099');
INSERT INTO `counties` VALUES ('2175', '织金县', '268', '0', '0', '105.768997', '26.668497');
INSERT INTO `counties` VALUES ('2176', '安宁市', '271', '0', '0', '102.46972', '24.91652');
INSERT INTO `counties` VALUES ('2177', '富民县', '271', '0', '0', '102.4985', '25.22119');
INSERT INTO `counties` VALUES ('2178', '晋宁县', '271', '0', '0', '102.59393', '24.6665');
INSERT INTO `counties` VALUES ('2179', '盘龙区', '271', '0', '0', '102.71994', '25.04053');
INSERT INTO `counties` VALUES ('2180', '五华区', '271', '0', '0', '102.70786', '25.03521');
INSERT INTO `counties` VALUES ('2181', '西山区', '271', '0', '0', '102.66464', '25.03796');
INSERT INTO `counties` VALUES ('2182', '石林彝族自治县', '271', '0', '0', '103.27148', '24.75897');
INSERT INTO `counties` VALUES ('2183', '宜良县', '271', '0', '0', '103.14117', '24.91705');
INSERT INTO `counties` VALUES ('2184', '呈贡区', '271', '0', '0', '102.801382', '24.889275');
INSERT INTO `counties` VALUES ('2185', '东川区', '271', '0', '0', '103.18832', '26.083');
INSERT INTO `counties` VALUES ('2186', '官渡区', '271', '0', '0', '102.74362', '25.01497');
INSERT INTO `counties` VALUES ('2187', '禄劝彝族苗族自治县', '271', '0', '0', '102.4671', '25.55387');
INSERT INTO `counties` VALUES ('2188', '寻甸回族彝族自治县', '271', '0', '0', '103.2557', '25.55961');
INSERT INTO `counties` VALUES ('2189', '嵩明县', '271', '0', '0', '103.03729', '25.33986');
INSERT INTO `counties` VALUES ('2190', '福泉市', '270', '0', '0', '107.51715', '26.67989');
INSERT INTO `counties` VALUES ('2191', '长顺县', '270', '0', '0', '106.45217', '26.02299');
INSERT INTO `counties` VALUES ('2192', '都匀市', '270', '0', '0', '107.51872', '26.2594');
INSERT INTO `counties` VALUES ('2193', '独山县', '270', '0', '0', '107.54101', '25.8245');
INSERT INTO `counties` VALUES ('2194', '贵定县', '270', '0', '0', '107.23654', '26.57812');
INSERT INTO `counties` VALUES ('2195', '惠水县', '270', '0', '0', '106.65911', '26.13389');
INSERT INTO `counties` VALUES ('2196', '荔波县', '270', '0', '0', '107.88592', '25.4139');
INSERT INTO `counties` VALUES ('2197', '龙里县', '270', '0', '0', '106.97662', '26.45076');
INSERT INTO `counties` VALUES ('2198', '罗甸县', '270', '0', '0', '106.75186', '25.42586');
INSERT INTO `counties` VALUES ('2199', '平塘县', '270', '0', '0', '107.32428', '25.83294');
INSERT INTO `counties` VALUES ('2200', '三都水族自治县', '270', '0', '0', '107.87464', '25.98562');
INSERT INTO `counties` VALUES ('2201', '瓮安县', '270', '0', '0', '107.4757', '27.06813');
INSERT INTO `counties` VALUES ('2202', '海沧区', '119', '0', '0', '118.03289', '24.48461');
INSERT INTO `counties` VALUES ('2203', '湖里区', '119', '0', '0', '118.14621', '24.51253');
INSERT INTO `counties` VALUES ('2204', '集美区', '119', '0', '0', '118.09719', '24.57584');
INSERT INTO `counties` VALUES ('2205', '思明区', '119', '0', '0', '118.08233', '24.44543');
INSERT INTO `counties` VALUES ('2206', '同安区', '119', '0', '0', '118.15197', '24.72308');
INSERT INTO `counties` VALUES ('2207', '翔安区', '119', '0', '0', '118.24783', '24.61863');
INSERT INTO `counties` VALUES ('2208', '汉南区', '172', '0', '0', '114.08462', '30.30879');
INSERT INTO `counties` VALUES ('2209', '汉阳区', '172', '0', '0', '114.27478', '30.54915');
INSERT INTO `counties` VALUES ('2210', '东西湖区', '172', '0', '0', '114.13708', '30.61989');
INSERT INTO `counties` VALUES ('2211', '蔡甸区', '172', '0', '0', '114.02929', '30.58197');
INSERT INTO `counties` VALUES ('2212', '硚口区', '172', '0', '0', '114.26422', '30.56945');
INSERT INTO `counties` VALUES ('2213', '洪山区', '172', '0', '0', '114.34375', '30.49989');
INSERT INTO `counties` VALUES ('2214', '黄陂区', '172', '0', '0', '114.37512', '30.88151');
INSERT INTO `counties` VALUES ('2215', '江岸区', '172', '0', '0', '114.30943', '30.59982');
INSERT INTO `counties` VALUES ('2216', '江汉区', '172', '0', '0', '114.27093', '30.60146');
INSERT INTO `counties` VALUES ('2217', '江夏区', '172', '0', '0', '114.31301', '30.34653');
INSERT INTO `counties` VALUES ('2218', '青山区', '172', '0', '0', '109.90131', '40.64329');
INSERT INTO `counties` VALUES ('2219', '武昌区', '172', '0', '0', '114.31589', '30.55389');
INSERT INTO `counties` VALUES ('2220', '新洲区', '172', '0', '0', '114.80136', '30.84145');
INSERT INTO `counties` VALUES ('2221', '富源县', '272', '0', '0', '104.25387', '25.66587');
INSERT INTO `counties` VALUES ('2222', '会泽县', '272', '0', '0', '103.30017', '26.41076');
INSERT INTO `counties` VALUES ('2223', '陆良县', '272', '0', '0', '103.6665', '25.02335');
INSERT INTO `counties` VALUES ('2224', '罗平县', '272', '0', '0', '104.30859', '24.88444');
INSERT INTO `counties` VALUES ('2225', '马龙县', '272', '0', '0', '103.57873', '25.42521');
INSERT INTO `counties` VALUES ('2226', '师宗县', '272', '0', '0', '103.99084', '24.82822');
INSERT INTO `counties` VALUES ('2227', '宣威市', '272', '0', '0', '104.10409', '26.2173');
INSERT INTO `counties` VALUES ('2228', '沾益县', '272', '0', '0', '103.82135', '25.60715');
INSERT INTO `counties` VALUES ('2229', '麒麟区', '272', '0', '0', '103.80504', '25.49515');
INSERT INTO `counties` VALUES ('2230', '昌宁县', '274', '0', '0', '99.6036', '24.82763');
INSERT INTO `counties` VALUES ('2231', '龙陵县', '274', '0', '0', '98.69024', '24.58746');
INSERT INTO `counties` VALUES ('2232', '隆阳区', '274', '0', '0', '99.16334', '25.11163');
INSERT INTO `counties` VALUES ('2233', '施甸县', '274', '0', '0', '99.18768', '24.72418');
INSERT INTO `counties` VALUES ('2234', '腾冲县', '274', '0', '0', '98.49414', '25.02539');
INSERT INTO `counties` VALUES ('2235', '峨山彝族自治县', '273', '0', '0', '102.40576', '24.16904');
INSERT INTO `counties` VALUES ('2236', '红塔区', '273', '0', '0', '102.5449', '24.35411');
INSERT INTO `counties` VALUES ('2237', '江川县', '273', '0', '0', '102.75412', '24.28863');
INSERT INTO `counties` VALUES ('2238', '通海县', '273', '0', '0', '102.76641', '24.11362');
INSERT INTO `counties` VALUES ('2239', '新平彝族傣族自治县', '273', '0', '0', '101.98895', '24.06886');
INSERT INTO `counties` VALUES ('2240', '易门县', '273', '0', '0', '102.16354', '24.67122');
INSERT INTO `counties` VALUES ('2241', '元江哈尼族彝族傣族自治县', '273', '0', '0', '101.99812', '23.59655');
INSERT INTO `counties` VALUES ('2242', '华宁县', '273', '0', '0', '102.92831', '24.1926');
INSERT INTO `counties` VALUES ('2243', '澄江县', '273', '0', '0', '102.90817', '24.67376');
INSERT INTO `counties` VALUES ('2244', '大关县', '275', '0', '0', '103.89254', '27.7488');
INSERT INTO `counties` VALUES ('2245', '鲁甸县', '275', '0', '0', '103.54721', '27.19238');
INSERT INTO `counties` VALUES ('2246', '水富县', '275', '0', '0', '104.4158', '28.62986');
INSERT INTO `counties` VALUES ('2247', '绥江县', '275', '0', '0', '103.94937', '28.59661');
INSERT INTO `counties` VALUES ('2248', '威信县', '275', '0', '0', '105.04754', '27.84065');
INSERT INTO `counties` VALUES ('2249', '盐津县', '275', '0', '0', '104.23461', '28.10856');
INSERT INTO `counties` VALUES ('2250', '彝良县', '275', '0', '0', '104.04983', '27.62809');
INSERT INTO `counties` VALUES ('2251', '永善县', '275', '0', '0', '103.63504', '28.2279');
INSERT INTO `counties` VALUES ('2252', '昭阳区', '275', '0', '0', '103.70654', '27.31998');
INSERT INTO `counties` VALUES ('2253', '镇雄县', '275', '0', '0', '104.87258', '27.43981');
INSERT INTO `counties` VALUES ('2254', '巧家县', '275', '0', '0', '102.92416', '26.91237');
INSERT INTO `counties` VALUES ('2255', '古城区', '276', '0', '0', '100.2257', '26.87697');
INSERT INTO `counties` VALUES ('2256', '华坪县', '276', '0', '0', '101.26562', '26.62967');
INSERT INTO `counties` VALUES ('2257', '宁蒗彝族自治县', '276', '0', '0', '100.8507', '27.28179');
INSERT INTO `counties` VALUES ('2258', '永胜县', '276', '0', '0', '100.74667', '26.68591');
INSERT INTO `counties` VALUES ('2259', '玉龙纳西族自治县', '276', '0', '0', '100.2369', '26.82149');
INSERT INTO `counties` VALUES ('2260', '江城哈尼族彝族自治县', '277', '0', '0', '101.85788', '22.58424');
INSERT INTO `counties` VALUES ('2261', '景东彝族自治县', '277', '0', '0', '100.83599', '24.44791');
INSERT INTO `counties` VALUES ('2262', '景谷傣族彝族自治县', '277', '0', '0', '100.70251', '23.49705');
INSERT INTO `counties` VALUES ('2263', '澜沧拉祜族自治县', '277', '0', '0', '99.93591', '22.55474');
INSERT INTO `counties` VALUES ('2264', '孟连傣族拉祜族佤族自治县', '277', '0', '0', '99.58424', '22.32922');
INSERT INTO `counties` VALUES ('2265', '墨江哈尼族自治县', '277', '0', '0', '101.69171', '23.43214');
INSERT INTO `counties` VALUES ('2266', '宁洱哈尼族彝族自治县', '277', '0', '0', '101.04653', '23.06341');
INSERT INTO `counties` VALUES ('2267', '思茅区', '277', '0', '0', '100.97716', '22.78691');
INSERT INTO `counties` VALUES ('2268', '西盟佤族自治县', '277', '0', '0', '99.59869', '22.64774');
INSERT INTO `counties` VALUES ('2269', '镇沅彝族哈尼族拉祜族自治县', '277', '0', '0', '101.10675', '24.00557');
INSERT INTO `counties` VALUES ('2270', '楚雄市', '279', '0', '0', '101.54615', '25.0329');
INSERT INTO `counties` VALUES ('2271', '大姚县', '279', '0', '0', '101.32397', '25.72218');
INSERT INTO `counties` VALUES ('2272', '禄丰县', '279', '0', '0', '102.07797', '25.14815');
INSERT INTO `counties` VALUES ('2273', '牟定县', '279', '0', '0', '101.54', '25.31551');
INSERT INTO `counties` VALUES ('2274', '南华县', '279', '0', '0', '101.27313', '25.19293');
INSERT INTO `counties` VALUES ('2275', '双柏县', '279', '0', '0', '101.64205', '24.68882');
INSERT INTO `counties` VALUES ('2276', '武定县', '279', '0', '0', '102.4038', '25.5295');
INSERT INTO `counties` VALUES ('2277', '姚安县', '279', '0', '0', '101.24279', '25.50467');
INSERT INTO `counties` VALUES ('2278', '永仁县', '279', '0', '0', '101.6716', '26.05794');
INSERT INTO `counties` VALUES ('2279', '元谋县', '279', '0', '0', '101.87728', '25.70438');
INSERT INTO `counties` VALUES ('2280', '沧源佤族自治县', '278', '0', '0', '99.24545', '23.14821');
INSERT INTO `counties` VALUES ('2281', '凤庆县', '278', '0', '0', '99.92837', '24.58034');
INSERT INTO `counties` VALUES ('2282', '耿马傣族佤族自治县', '278', '0', '0', '99.39785', '23.53776');
INSERT INTO `counties` VALUES ('2283', '临翔区', '278', '0', '0', '100.08242', '23.89497');
INSERT INTO `counties` VALUES ('2284', '双江拉祜族佤族布朗族傣族自治县', '278', '0', '0', '99.82769', '23.47349');
INSERT INTO `counties` VALUES ('2285', '永德县', '278', '0', '0', '99.25326', '24.0276');
INSERT INTO `counties` VALUES ('2286', '云县', '278', '0', '0', '100.12808', '24.44675');
INSERT INTO `counties` VALUES ('2287', '镇康县', '278', '0', '0', '98.8255', '23.76241');
INSERT INTO `counties` VALUES ('2288', '绿春县', '280', '0', '0', '102.39672', '22.99371');
INSERT INTO `counties` VALUES ('2289', '红河县', '280', '0', '0', '102.42059', '23.36767');
INSERT INTO `counties` VALUES ('2290', '石屏县', '280', '0', '0', '102.49408', '23.71441');
INSERT INTO `counties` VALUES ('2291', '河口瑶族自治县', '280', '0', '0', '103.93936', '22.52929');
INSERT INTO `counties` VALUES ('2292', '开远市', '280', '0', '0', '103.26986', '23.71012');
INSERT INTO `counties` VALUES ('2293', '蒙自市', '280', '0', '0', '103.385005', '23.366843');
INSERT INTO `counties` VALUES ('2294', '弥勒县', '280', '0', '0', '103.43', '24.40');
INSERT INTO `counties` VALUES ('2295', '屏边苗族自治县', '280', '0', '0', '103.68554', '22.98425');
INSERT INTO `counties` VALUES ('2296', '泸西县', '280', '0', '0', '103.76373', '24.52854');
INSERT INTO `counties` VALUES ('2297', '个旧市', '280', '0', '0', '103.15966', '23.35894');
INSERT INTO `counties` VALUES ('2298', '建水县', '280', '0', '0', '102.82656', '23.63472');
INSERT INTO `counties` VALUES ('2299', '金平苗族瑶族傣族自治县', '280', '0', '0', '103.22651', '22.77959');
INSERT INTO `counties` VALUES ('2300', '元阳县', '280', '0', '0', '102.83261', '23.22281');
INSERT INTO `counties` VALUES ('2301', '富宁县', '281', '0', '0', '105.63085', '23.62536');
INSERT INTO `counties` VALUES ('2302', '广南县', '281', '0', '0', '105.05511', '24.0464');
INSERT INTO `counties` VALUES ('2303', '西畴县', '281', '0', '0', '104.67419', '23.43941');
INSERT INTO `counties` VALUES ('2304', '麻栗坡县', '281', '0', '0', '104.70132', '23.12028');
INSERT INTO `counties` VALUES ('2305', '马关县', '281', '0', '0', '104.39514', '23.01293');
INSERT INTO `counties` VALUES ('2306', '丘北县', '281', '0', '0', '104.19256', '24.03957');
INSERT INTO `counties` VALUES ('2307', '文山市', '281', '0', '0', '104.244277', '23.369216');
INSERT INTO `counties` VALUES ('2308', '砚山县', '281', '0', '0', '104.33306', '23.60723');
INSERT INTO `counties` VALUES ('2309', '宾川县', '283', '0', '0', '100.57666', '25.83144');
INSERT INTO `counties` VALUES ('2310', '大理市', '283', '0', '0', '100.22998', '25.59157');
INSERT INTO `counties` VALUES ('2311', '洱源县', '283', '0', '0', '99.94903', '26.10829');
INSERT INTO `counties` VALUES ('2312', '鹤庆县', '283', '0', '0', '100.17697', '26.55798');
INSERT INTO `counties` VALUES ('2313', '剑川县', '283', '0', '0', '99.90545', '26.53688');
INSERT INTO `counties` VALUES ('2314', '弥渡县', '283', '0', '0', '100.49075', '25.34179');
INSERT INTO `counties` VALUES ('2315', '南涧彝族自治县', '283', '0', '0', '100.50964', '25.04349');
INSERT INTO `counties` VALUES ('2316', '巍山彝族回族自治县', '283', '0', '0', '100.30612', '25.23197');
INSERT INTO `counties` VALUES ('2317', '祥云县', '283', '0', '0', '100.55761', '25.47342');
INSERT INTO `counties` VALUES ('2318', '漾濞彝族自治县', '283', '0', '0', '99.95474', '25.6652');
INSERT INTO `counties` VALUES ('2319', '永平县', '283', '0', '0', '99.54095', '25.46451');
INSERT INTO `counties` VALUES ('2320', '云龙县', '283', '0', '0', '99.37255', '25.88505');
INSERT INTO `counties` VALUES ('2321', '福贡县', '285', '0', '0', '98.86969', '26.90366');
INSERT INTO `counties` VALUES ('2322', '贡山独龙族怒族自治县', '285', '0', '0', '98.66583', '27.74088');
INSERT INTO `counties` VALUES ('2323', '兰坪白族普米族自治县', '285', '0', '0', '99.41891', '26.45251');
INSERT INTO `counties` VALUES ('2324', '泸水县', '285', '0', '0', '98.85534', '25.83772');
INSERT INTO `counties` VALUES ('2325', '梁河县', '284', '0', '0', '98.29705', '24.80658');
INSERT INTO `counties` VALUES ('2326', '陇川县', '284', '0', '0', '97.79199', '24.18302');
INSERT INTO `counties` VALUES ('2327', '芒市', '284', '0', '0', '98.588641', '24.433735');
INSERT INTO `counties` VALUES ('2328', '瑞丽市', '284', '0', '0', '97.85183', '24.01277');
INSERT INTO `counties` VALUES ('2329', '盈江县', '284', '0', '0', '97.93179', '24.70579');
INSERT INTO `counties` VALUES ('2330', '德钦县', '286', '0', '0', '98.91082', '28.4863');
INSERT INTO `counties` VALUES ('2331', '维西傈僳族自治县', '286', '0', '0', '99.28402', '27.1793');
INSERT INTO `counties` VALUES ('2332', '香格里拉县', '286', '0', '0', '99.70', '27.83');
INSERT INTO `counties` VALUES ('2333', '边坝县', '288', '0', '0', '94.70687', '30.93434');
INSERT INTO `counties` VALUES ('2334', '察雅县', '288', '0', '0', '97.56521', '30.65336');
INSERT INTO `counties` VALUES ('2335', '昌都县', '288', '0', '0', '97.18', '31.13');
INSERT INTO `counties` VALUES ('2336', '丁青县', '288', '0', '0', '95.59362', '31.41621');
INSERT INTO `counties` VALUES ('2337', '贡觉县', '288', '0', '0', '98.27163', '30.85941');
INSERT INTO `counties` VALUES ('2338', '江达县', '288', '0', '0', '98.21865', '31.50343');
INSERT INTO `counties` VALUES ('2339', '类乌齐县', '288', '0', '0', '96.60015', '31.21207');
INSERT INTO `counties` VALUES ('2340', '洛隆县', '288', '0', '0', '95.82644', '30.74049');
INSERT INTO `counties` VALUES ('2341', '八宿县', '288', '0', '0', '96.9176', '30.05346');
INSERT INTO `counties` VALUES ('2342', '芒康县', '288', '0', '0', '98.59378', '29.67946');
INSERT INTO `counties` VALUES ('2343', '左贡县', '288', '0', '0', '97.84429', '29.67108');
INSERT INTO `counties` VALUES ('2344', '景洪市', '282', '0', '0', '100.79977', '22.01071');
INSERT INTO `counties` VALUES ('2345', '勐海县', '282', '0', '0', '100.44931', '21.96175');
INSERT INTO `counties` VALUES ('2346', '勐腊县', '282', '0', '0', '101.56488', '21.48162');
INSERT INTO `counties` VALUES ('2347', '城关区', '287', '0', '0', '91.13859', '29.65312');
INSERT INTO `counties` VALUES ('2348', '达孜县', '287', '0', '0', '91.35757', '29.6722');
INSERT INTO `counties` VALUES ('2349', '当雄县', '287', '0', '0', '91.10076', '30.48309');
INSERT INTO `counties` VALUES ('2350', '堆龙德庆县', '287', '0', '0', '91.00033', '29.65002');
INSERT INTO `counties` VALUES ('2351', '林周县', '287', '0', '0', '91.2586', '29.89445');
INSERT INTO `counties` VALUES ('2352', '墨竹工卡县', '287', '0', '0', '91.72814', '29.83614');
INSERT INTO `counties` VALUES ('2353', '尼木县', '287', '0', '0', '90.16378', '29.43353');
INSERT INTO `counties` VALUES ('2354', '曲水县', '287', '0', '0', '90.73187', '29.35636');
INSERT INTO `counties` VALUES ('2355', '措美县', '289', '0', '0', '91.43237', '28.43794');
INSERT INTO `counties` VALUES ('2356', '错那县', '289', '0', '0', '91.95752', '27.99224');
INSERT INTO `counties` VALUES ('2357', '隆子县', '289', '0', '0', '92.46148', '28.40797');
INSERT INTO `counties` VALUES ('2358', '洛扎县', '289', '0', '0', '90.86035', '28.3872');
INSERT INTO `counties` VALUES ('2359', '加查县', '289', '0', '0', '92.57702', '29.13973');
INSERT INTO `counties` VALUES ('2360', '贡嘎县', '289', '0', '0', '90.98867', '29.29408');
INSERT INTO `counties` VALUES ('2361', '浪卡子县', '289', '0', '0', '90.40002', '28.96948');
INSERT INTO `counties` VALUES ('2362', '乃东县', '289', '0', '0', '91.76153', '29.2249');
INSERT INTO `counties` VALUES ('2363', '琼结县', '289', '0', '0', '91.68093', '29.02632');
INSERT INTO `counties` VALUES ('2364', '曲松县', '289', '0', '0', '92.20263', '29.06412');
INSERT INTO `counties` VALUES ('2365', '桑日县', '289', '0', '0', '92.02005', '29.26643');
INSERT INTO `counties` VALUES ('2366', '扎囊县', '289', '0', '0', '91.33288', '29.2399');
INSERT INTO `counties` VALUES ('2367', '昂仁县', '290', '0', '0', '87.23858', '29.29496');
INSERT INTO `counties` VALUES ('2368', '拉孜县', '290', '0', '0', '87.63412', '29.085');
INSERT INTO `counties` VALUES ('2369', '南木林县', '290', '0', '0', '89.09686', '29.68206');
INSERT INTO `counties` VALUES ('2370', '日喀则市', '290', '0', '0', '88.884874', '29.263792');
INSERT INTO `counties` VALUES ('2371', '萨嘎县', '290', '0', '0', '85.23413', '29.32936');
INSERT INTO `counties` VALUES ('2372', '岗巴县', '290', '0', '0', '88.52069', '28.27504');
INSERT INTO `counties` VALUES ('2373', '康马县', '290', '0', '0', '89.68527', '28.5567');
INSERT INTO `counties` VALUES ('2374', '谢通门县', '290', '0', '0', '88.26242', '29.43337');
INSERT INTO `counties` VALUES ('2375', '亚东县', '290', '0', '0', '88.90802', '27.4839');
INSERT INTO `counties` VALUES ('2376', '仲巴县', '290', '0', '0', '84.02951', '29.76595');
INSERT INTO `counties` VALUES ('2377', '白朗县', '290', '0', '0', '89.26205', '29.10553');
INSERT INTO `counties` VALUES ('2378', '定结县', '290', '0', '0', '87.77255', '28.36403');
INSERT INTO `counties` VALUES ('2379', '定日县', '290', '0', '0', '87.12176', '28.66129');
INSERT INTO `counties` VALUES ('2380', '吉隆县', '290', '0', '0', '85.29846', '28.85382');
INSERT INTO `counties` VALUES ('2381', '江孜县', '290', '0', '0', '89.60263', '28.91744');
INSERT INTO `counties` VALUES ('2382', '聂拉木县', '290', '0', '0', '85.97998', '28.15645');
INSERT INTO `counties` VALUES ('2383', '仁布县', '290', '0', '0', '89.84228', '29.2301');
INSERT INTO `counties` VALUES ('2384', '萨迦县', '290', '0', '0', '88.02191', '28.90299');
INSERT INTO `counties` VALUES ('2385', '索县', '291', '0', '0', '93.78295', '31.88427');
INSERT INTO `counties` VALUES ('2386', '安多县', '291', '0', '0', '91.6795', '32.26125');
INSERT INTO `counties` VALUES ('2387', '巴青县', '291', '0', '0', '94.05316', '31.91833');
INSERT INTO `counties` VALUES ('2388', '班戈县', '291', '0', '0', '90.01907', '31.36149');
INSERT INTO `counties` VALUES ('2389', '比如县', '291', '0', '0', '93.68685', '31.4779');
INSERT INTO `counties` VALUES ('2390', '嘉黎县', '291', '0', '0', '93.24987', '30.64233');
INSERT INTO `counties` VALUES ('2391', '那曲县', '291', '0', '0', '92.0535', '31.46964');
INSERT INTO `counties` VALUES ('2392', '尼玛县', '291', '0', '0', '87.25256', '31.79654');
INSERT INTO `counties` VALUES ('2393', '聂荣县', '291', '0', '0', '92.29574', '32.11193');
INSERT INTO `counties` VALUES ('2394', '申扎县', '291', '0', '0', '88.70776', '30.92995');
INSERT INTO `counties` VALUES ('2395', '察隅县', '293', '0', '0', '97.46679', '28.6618');
INSERT INTO `counties` VALUES ('2396', '工布江达县', '293', '0', '0', '93.2452', '29.88576');
INSERT INTO `counties` VALUES ('2397', '波密县', '293', '0', '0', '95.77096', '29.85907');
INSERT INTO `counties` VALUES ('2398', '朗县', '293', '0', '0', '93.0754', '29.04549');
INSERT INTO `counties` VALUES ('2399', '林芝县', '293', '0', '0', '94.48391', '29.57562');
INSERT INTO `counties` VALUES ('2400', '米林县', '293', '0', '0', '94.21316', '29.21535');
INSERT INTO `counties` VALUES ('2401', '墨脱县', '293', '0', '0', '95.3316', '29.32698');
INSERT INTO `counties` VALUES ('2402', '碑林区', '294', '0', '0', '108.93426', '34.2304');
INSERT INTO `counties` VALUES ('2403', '长安区', '294', '0', '0', '114.53906', '38.03665');
INSERT INTO `counties` VALUES ('2404', '高陵县', '294', '0', '0', '109.08', '34.53');
INSERT INTO `counties` VALUES ('2405', '户县', '294', '0', '0', '108.60513', '34.10856');
INSERT INTO `counties` VALUES ('2406', '蓝田县', '294', '0', '0', '109.32339', '34.15128');
INSERT INTO `counties` VALUES ('2407', '莲湖区', '294', '0', '0', '108.9401', '34.26709');
INSERT INTO `counties` VALUES ('2408', '临潼区', '294', '0', '0', '109.21417', '34.36665');
INSERT INTO `counties` VALUES ('2409', '未央区', '294', '0', '0', '108.94683', '34.29296');
INSERT INTO `counties` VALUES ('2410', '新城区', '294', '0', '0', '111.66554', '40.85828');
INSERT INTO `counties` VALUES ('2411', '阎良区', '294', '0', '0', '109.22616', '34.66221');
INSERT INTO `counties` VALUES ('2412', '雁塔区', '294', '0', '0', '108.94866', '34.22245');
INSERT INTO `counties` VALUES ('2413', '周至县', '294', '0', '0', '108.22207', '34.16337');
INSERT INTO `counties` VALUES ('2414', '灞桥区', '294', '0', '0', '109.06451', '34.27264');
INSERT INTO `counties` VALUES ('2415', '眉县', '296', '0', '0', '107.75079', '34.27569');
INSERT INTO `counties` VALUES ('2416', '陈仓区', '296', '0', '0', '107.38742', '34.35451');
INSERT INTO `counties` VALUES ('2417', '凤县', '296', '0', '0', '106.52356', '33.91172');
INSERT INTO `counties` VALUES ('2418', '凤翔县', '296', '0', '0', '107.39645', '34.52321');
INSERT INTO `counties` VALUES ('2419', '扶风县', '296', '0', '0', '107.90017', '34.37524');
INSERT INTO `counties` VALUES ('2420', '金台区', '296', '0', '0', '107.14691', '34.37612');
INSERT INTO `counties` VALUES ('2421', '陇县', '296', '0', '0', '106.85946', '34.89404');
INSERT INTO `counties` VALUES ('2422', '千阳县', '296', '0', '0', '107.13043', '34.64219');
INSERT INTO `counties` VALUES ('2423', '太白县', '296', '0', '0', '107.31646', '34.06207');
INSERT INTO `counties` VALUES ('2424', '渭滨区', '296', '0', '0', '107.14991', '34.37116');
INSERT INTO `counties` VALUES ('2425', '岐山县', '296', '0', '0', '107.62173', '34.44378');
INSERT INTO `counties` VALUES ('2426', '麟游县', '296', '0', '0', '107.79623', '34.67844');
INSERT INTO `counties` VALUES ('2427', '措勤县', '292', '0', '0', '85.16616', '31.02095');
INSERT INTO `counties` VALUES ('2428', '噶尔县', '292', '0', '0', '80.09579', '32.50024');
INSERT INTO `counties` VALUES ('2429', '改则县', '292', '0', '0', '84.06295', '32.30446');
INSERT INTO `counties` VALUES ('2430', '革吉县', '292', '0', '0', '81.151', '32.3964');
INSERT INTO `counties` VALUES ('2431', '普兰县', '292', '0', '0', '81.177', '30.30002');
INSERT INTO `counties` VALUES ('2432', '日土县', '292', '0', '0', '79.7131', '33.38741');
INSERT INTO `counties` VALUES ('2433', '札达县', '292', '0', '0', '79.80255', '31.48345');
INSERT INTO `counties` VALUES ('2434', '王益区', '295', '0', '0', '109.07564', '35.06896');
INSERT INTO `counties` VALUES ('2435', '耀州区', '295', '0', '0', '108.98556', '34.91308');
INSERT INTO `counties` VALUES ('2436', '宜君县', '295', '0', '0', '109.11813', '35.40108');
INSERT INTO `counties` VALUES ('2437', '印台区', '295', '0', '0', '109.10208', '35.1169');
INSERT INTO `counties` VALUES ('2438', '白水县', '298', '0', '0', '109.59286', '35.17863');
INSERT INTO `counties` VALUES ('2439', '澄城县', '298', '0', '0', '109.93444', '35.18396');
INSERT INTO `counties` VALUES ('2440', '大荔县', '298', '0', '0', '109.94216', '34.79565');
INSERT INTO `counties` VALUES ('2441', '富平县', '298', '0', '0', '109.1802', '34.75109');
INSERT INTO `counties` VALUES ('2442', '韩城市', '298', '0', '0', '110.44238', '35.47926');
INSERT INTO `counties` VALUES ('2443', '合阳县', '298', '0', '0', '110.14862', '35.23805');
INSERT INTO `counties` VALUES ('2444', '华县', '298', '0', '0', '109.77185', '34.51255');
INSERT INTO `counties` VALUES ('2445', '华阴市', '298', '0', '0', '110.08752', '34.56608');
INSERT INTO `counties` VALUES ('2446', '临渭区', '298', '0', '0', '109.49296', '34.49822');
INSERT INTO `counties` VALUES ('2447', '蒲城县', '298', '0', '0', '109.5903', '34.9568');
INSERT INTO `counties` VALUES ('2448', '潼关县', '298', '0', '0', '110.24362', '34.54284');
INSERT INTO `counties` VALUES ('2449', '渭城区', '297', '0', '0', '108.72227', '34.33198');
INSERT INTO `counties` VALUES ('2450', '三原县', '297', '0', '0', '108.93194', '34.61556');
INSERT INTO `counties` VALUES ('2451', '彬县', '297', '0', '0', '108.08468', '35.0342');
INSERT INTO `counties` VALUES ('2452', '长武县', '297', '0', '0', '107.7951', '35.2067');
INSERT INTO `counties` VALUES ('2453', '淳化县', '297', '0', '0', '108.58026', '34.79886');
INSERT INTO `counties` VALUES ('2454', '礼泉县', '297', '0', '0', '108.4263', '34.48455');
INSERT INTO `counties` VALUES ('2455', '乾县', '297', '0', '0', '108.24231', '34.52946');
INSERT INTO `counties` VALUES ('2456', '秦都区', '297', '0', '0', '108.71493', '34.33804');
INSERT INTO `counties` VALUES ('2457', '武功县', '297', '0', '0', '108.20434', '34.26003');
INSERT INTO `counties` VALUES ('2458', '兴平市', '297', '0', '0', '108.49057', '34.29785');
INSERT INTO `counties` VALUES ('2459', '旬邑县', '297', '0', '0', '108.3341', '35.11338');
INSERT INTO `counties` VALUES ('2460', '杨陵区', '297', '0', '0', '108.083481', '34.270434');
INSERT INTO `counties` VALUES ('2461', '永寿县', '297', '0', '0', '108.14474', '34.69081');
INSERT INTO `counties` VALUES ('2462', '泾阳县', '297', '0', '0', '108.84259', '34.52705');
INSERT INTO `counties` VALUES ('2463', '定边县', '301', '0', '0', '107.59793', '37.59037');
INSERT INTO `counties` VALUES ('2464', '府谷县', '301', '0', '0', '111.06723', '39.02805');
INSERT INTO `counties` VALUES ('2465', '横山县', '301', '0', '0', '109.29568', '37.958');
INSERT INTO `counties` VALUES ('2466', '佳县', '301', '0', '0', '110.49362', '38.02248');
INSERT INTO `counties` VALUES ('2467', '靖边县', '301', '0', '0', '108.79412', '37.59938');
INSERT INTO `counties` VALUES ('2468', '米脂县', '301', '0', '0', '110.18417', '37.75529');
INSERT INTO `counties` VALUES ('2469', '清涧县', '301', '0', '0', '110.12173', '37.08854');
INSERT INTO `counties` VALUES ('2470', '神木县', '301', '0', '0', '110.4989', '38.84234');
INSERT INTO `counties` VALUES ('2471', '绥德县', '301', '0', '0', '110.26126', '37.49778');
INSERT INTO `counties` VALUES ('2472', '吴堡县', '301', '0', '0', '110.74533', '37.45709');
INSERT INTO `counties` VALUES ('2473', '榆阳区', '301', '0', '0', '109.73473', '38.27843');
INSERT INTO `counties` VALUES ('2474', '子洲县', '301', '0', '0', '110.03488', '37.61238');
INSERT INTO `counties` VALUES ('2475', '安塞县', '299', '0', '0', '109.32708', '36.86507');
INSERT INTO `counties` VALUES ('2476', '宝塔区', '299', '0', '0', '109.49336', '36.59154');
INSERT INTO `counties` VALUES ('2477', '富县', '299', '0', '0', '109.37927', '35.98803');
INSERT INTO `counties` VALUES ('2478', '甘泉县', '299', '0', '0', '109.35012', '36.27754');
INSERT INTO `counties` VALUES ('2479', '黄陵县', '299', '0', '0', '109.26333', '35.58357');
INSERT INTO `counties` VALUES ('2480', '黄龙县', '299', '0', '0', '109.84259', '35.58349');
INSERT INTO `counties` VALUES ('2481', '洛川县', '299', '0', '0', '109.43286', '35.76076');
INSERT INTO `counties` VALUES ('2482', '吴起县', '299', '0', '0', '108.17611', '36.92785');
INSERT INTO `counties` VALUES ('2483', '延长县', '299', '0', '0', '110.01083', '36.57904');
INSERT INTO `counties` VALUES ('2484', '延川县', '299', '0', '0', '110.19415', '36.87817');
INSERT INTO `counties` VALUES ('2485', '宜川县', '299', '0', '0', '110.17196', '36.04732');
INSERT INTO `counties` VALUES ('2486', '志丹县', '299', '0', '0', '108.76815', '36.82177');
INSERT INTO `counties` VALUES ('2487', '子长县', '299', '0', '0', '109.67532', '37.14253');
INSERT INTO `counties` VALUES ('2488', '城固县', '300', '0', '0', '107.33367', '33.15661');
INSERT INTO `counties` VALUES ('2489', '佛坪县', '300', '0', '0', '107.98974', '33.52496');
INSERT INTO `counties` VALUES ('2490', '汉台区', '300', '0', '0', '107.03187', '33.06774');
INSERT INTO `counties` VALUES ('2491', '留坝县', '300', '0', '0', '106.92233', '33.61606');
INSERT INTO `counties` VALUES ('2492', '略阳县', '300', '0', '0', '106.15399', '33.33009');
INSERT INTO `counties` VALUES ('2493', '勉县', '300', '0', '0', '106.67584', '33.15273');
INSERT INTO `counties` VALUES ('2494', '南郑县', '300', '0', '0', '106.94024', '33.00299');
INSERT INTO `counties` VALUES ('2495', '宁强县', '300', '0', '0', '106.25958', '32.82881');
INSERT INTO `counties` VALUES ('2496', '西乡县', '300', '0', '0', '107.76867', '32.98411');
INSERT INTO `counties` VALUES ('2497', '洋县', '300', '0', '0', '107.54672', '33.22102');
INSERT INTO `counties` VALUES ('2498', '镇巴县', '300', '0', '0', '107.89648', '32.53487');
INSERT INTO `counties` VALUES ('2499', '白河县', '302', '0', '0', '110.11315', '32.80955');
INSERT INTO `counties` VALUES ('2500', '汉滨区', '302', '0', '0', '109.02683', '32.69517');
INSERT INTO `counties` VALUES ('2501', '汉阴县', '302', '0', '0', '108.51098', '32.89129');
INSERT INTO `counties` VALUES ('2502', '宁陕县', '302', '0', '0', '108.31515', '33.31726');
INSERT INTO `counties` VALUES ('2503', '平利县', '302', '0', '0', '109.35775', '32.39111');
INSERT INTO `counties` VALUES ('2504', '石泉县', '302', '0', '0', '108.24755', '33.03971');
INSERT INTO `counties` VALUES ('2505', '旬阳县', '302', '0', '0', '109.3619', '32.83207');
INSERT INTO `counties` VALUES ('2506', '镇坪县', '302', '0', '0', '109.52456', '31.8833');
INSERT INTO `counties` VALUES ('2507', '紫阳县', '302', '0', '0', '108.5368', '32.52115');
INSERT INTO `counties` VALUES ('2508', '岚皋县', '302', '0', '0', '108.90289', '32.30794');
INSERT INTO `counties` VALUES ('2509', '安宁区', '304', '0', '0', '103.7189', '36.10384');
INSERT INTO `counties` VALUES ('2510', '城关区', '304', '0', '0', '91.13859', '29.65312');
INSERT INTO `counties` VALUES ('2511', '皋兰县', '304', '0', '0', '103.94506', '36.33215');
INSERT INTO `counties` VALUES ('2512', '红古区', '304', '0', '0', '102.85955', '36.34537');
INSERT INTO `counties` VALUES ('2513', '七里河区', '304', '0', '0', '103.78564', '36.06585');
INSERT INTO `counties` VALUES ('2514', '西固区', '304', '0', '0', '103.62811', '36.08858');
INSERT INTO `counties` VALUES ('2515', '榆中县', '304', '0', '0', '104.1145', '35.84415');
INSERT INTO `counties` VALUES ('2516', '永登县', '304', '0', '0', '103.26055', '36.73522');
INSERT INTO `counties` VALUES ('2517', '丹凤县', '303', '0', '0', '110.33486', '33.69468');
INSERT INTO `counties` VALUES ('2518', '洛南县', '303', '0', '0', '110.14645', '34.08994');
INSERT INTO `counties` VALUES ('2519', '山阳县', '303', '0', '0', '109.88784', '33.52931');
INSERT INTO `counties` VALUES ('2520', '商南县', '303', '0', '0', '110.88375', '33.52581');
INSERT INTO `counties` VALUES ('2521', '商州区', '303', '0', '0', '109.94126', '33.8627');
INSERT INTO `counties` VALUES ('2522', '镇安县', '303', '0', '0', '109.15374', '33.42366');
INSERT INTO `counties` VALUES ('2523', '柞水县', '303', '0', '0', '109.11105', '33.6831');
INSERT INTO `counties` VALUES ('2524', '市辖区', '305', '0', '0', null, null);
INSERT INTO `counties` VALUES ('2525', '白银区', '307', '0', '0', '104.17355', '36.54411');
INSERT INTO `counties` VALUES ('2526', '会宁县', '307', '0', '0', '105.05297', '35.69626');
INSERT INTO `counties` VALUES ('2527', '景泰县', '307', '0', '0', '104.06295', '37.18359');
INSERT INTO `counties` VALUES ('2528', '靖远县', '307', '0', '0', '104.68325', '36.56602');
INSERT INTO `counties` VALUES ('2529', '平川区', '307', '0', '0', '104.82498', '36.7277');
INSERT INTO `counties` VALUES ('2530', '金川区', '306', '0', '0', '102.19376', '38.52101');
INSERT INTO `counties` VALUES ('2531', '永昌县', '306', '0', '0', '101.97222', '38.24711');
INSERT INTO `counties` VALUES ('2532', '古浪县', '309', '0', '0', '102.89154', '37.46508');
INSERT INTO `counties` VALUES ('2533', '凉州区', '309', '0', '0', '102.64203', '37.92832');
INSERT INTO `counties` VALUES ('2534', '民勤县', '309', '0', '0', '103.09011', '38.62487');
INSERT INTO `counties` VALUES ('2535', '天祝藏族自治县', '309', '0', '0', '103.1361', '36.97715');
INSERT INTO `counties` VALUES ('2536', '甘谷县', '308', '0', '0', '105.33291', '34.73665');
INSERT INTO `counties` VALUES ('2537', '麦积区', '308', '0', '0', '105.89013', '34.57069');
INSERT INTO `counties` VALUES ('2538', '秦安县', '308', '0', '0', '105.66955', '34.85894');
INSERT INTO `counties` VALUES ('2539', '秦州区', '308', '0', '0', '105.72421', '34.58089');
INSERT INTO `counties` VALUES ('2540', '清水县', '308', '0', '0', '106.13671', '34.75032');
INSERT INTO `counties` VALUES ('2541', '武山县', '308', '0', '0', '104.88382', '34.72123');
INSERT INTO `counties` VALUES ('2542', '张家川回族自治县', '308', '0', '0', '106.21582', '34.99582');
INSERT INTO `counties` VALUES ('2543', '甘州区', '310', '0', '0', '100.4527', '38.92947');
INSERT INTO `counties` VALUES ('2544', '高台县', '310', '0', '0', '99.81918', '39.37829');
INSERT INTO `counties` VALUES ('2545', '临泽县', '310', '0', '0', '100.16445', '39.15252');
INSERT INTO `counties` VALUES ('2546', '民乐县', '310', '0', '0', '100.81091', '38.43479');
INSERT INTO `counties` VALUES ('2547', '肃南裕固族自治县', '310', '0', '0', '99.61407', '38.83776');
INSERT INTO `counties` VALUES ('2548', '山丹县', '310', '0', '0', '101.09359', '38.78468');
INSERT INTO `counties` VALUES ('2549', '崇信县', '311', '0', '0', '107.03738', '35.30344');
INSERT INTO `counties` VALUES ('2550', '华亭县', '311', '0', '0', '106.65463', '35.2183');
INSERT INTO `counties` VALUES ('2551', '静宁县', '311', '0', '0', '105.72723', '35.51991');
INSERT INTO `counties` VALUES ('2552', '灵台县', '311', '0', '0', '107.6174', '35.06768');
INSERT INTO `counties` VALUES ('2553', '庄浪县', '311', '0', '0', '106.03662', '35.20235');
INSERT INTO `counties` VALUES ('2554', '崆峒区', '311', '0', '0', '106.67483', '35.54262');
INSERT INTO `counties` VALUES ('2555', '泾川县', '311', '0', '0', '107.36581', '35.33223');
INSERT INTO `counties` VALUES ('2556', '阿克塞哈萨克族自治县', '312', '0', '0', '94.34097', '39.63435');
INSERT INTO `counties` VALUES ('2557', '敦煌市', '312', '0', '0', '94.66159', '40.14211');
INSERT INTO `counties` VALUES ('2558', '瓜州县', '312', '0', '0', '95.78271', '40.51548');
INSERT INTO `counties` VALUES ('2559', '金塔县', '312', '0', '0', '98.90002', '39.97733');
INSERT INTO `counties` VALUES ('2560', '肃北蒙古族自治县', '312', '0', '0', '94.87649', '39.51214');
INSERT INTO `counties` VALUES ('2561', '肃州区', '312', '0', '0', '98.50775', '39.74506');
INSERT INTO `counties` VALUES ('2562', '玉门市', '312', '0', '0', '97.04538', '40.29172');
INSERT INTO `counties` VALUES ('2563', '合水县', '313', '0', '0', '108.02032', '35.81911');
INSERT INTO `counties` VALUES ('2564', '华池县', '313', '0', '0', '107.9891', '36.46108');
INSERT INTO `counties` VALUES ('2565', '环县', '313', '0', '0', '107.30835', '36.56846');
INSERT INTO `counties` VALUES ('2566', '宁县', '313', '0', '0', '107.92517', '35.50164');
INSERT INTO `counties` VALUES ('2567', '庆城县', '313', '0', '0', '107.88272', '36.01507');
INSERT INTO `counties` VALUES ('2568', '西峰区', '313', '0', '0', '107.65107', '35.73065');
INSERT INTO `counties` VALUES ('2569', '镇原县', '313', '0', '0', '107.199', '35.67712');
INSERT INTO `counties` VALUES ('2570', '正宁县', '313', '0', '0', '108.36007', '35.49174');
INSERT INTO `counties` VALUES ('2571', '安定区', '314', '0', '0', '104.6106', '35.58066');
INSERT INTO `counties` VALUES ('2572', '临洮县', '314', '0', '0', '103.86196', '35.3751');
INSERT INTO `counties` VALUES ('2573', '陇西县', '314', '0', '0', '104.63446', '35.00238');
INSERT INTO `counties` VALUES ('2574', '通渭县', '314', '0', '0', '105.24224', '35.21101');
INSERT INTO `counties` VALUES ('2575', '渭源县', '314', '0', '0', '104.21435', '35.13649');
INSERT INTO `counties` VALUES ('2576', '漳县', '314', '0', '0', '104.46704', '34.84977');
INSERT INTO `counties` VALUES ('2577', '岷县', '314', '0', '0', '104.03772', '34.43444');
INSERT INTO `counties` VALUES ('2578', '成县', '315', '0', '0', '105.72586', '33.73925');
INSERT INTO `counties` VALUES ('2579', '徽县', '315', '0', '0', '106.08529', '33.76898');
INSERT INTO `counties` VALUES ('2580', '康县', '315', '0', '0', '105.60711', '33.32912');
INSERT INTO `counties` VALUES ('2581', '礼县', '315', '0', '0', '105.17785', '34.18935');
INSERT INTO `counties` VALUES ('2582', '两当县', '315', '0', '0', '106.30484', '33.9096');
INSERT INTO `counties` VALUES ('2583', '文县', '315', '0', '0', '104.68362', '32.94337');
INSERT INTO `counties` VALUES ('2584', '武都区', '315', '0', '0', '104.92652', '33.39239');
INSERT INTO `counties` VALUES ('2585', '西和县', '315', '0', '0', '105.30099', '34.01432');
INSERT INTO `counties` VALUES ('2586', '宕昌县', '315', '0', '0', '104.39349', '34.04732');
INSERT INTO `counties` VALUES ('2587', '城北区', '318', '0', '0', '101.7662', '36.65014');
INSERT INTO `counties` VALUES ('2588', '城东区', '318', '0', '0', '101.80373', '36.59969');
INSERT INTO `counties` VALUES ('2589', '城西区', '318', '0', '0', '101.76588', '36.62828');
INSERT INTO `counties` VALUES ('2590', '城中区', '318', '0', '0', '109.41082', '24.31543');
INSERT INTO `counties` VALUES ('2591', '大通回族土族自治县', '318', '0', '0', '101.70236', '36.93489');
INSERT INTO `counties` VALUES ('2592', '湟源县', '318', '0', '0', '101.25643', '36.68243');
INSERT INTO `counties` VALUES ('2593', '湟中县', '318', '0', '0', '101.57159', '36.50083');
INSERT INTO `counties` VALUES ('2594', '东乡族自治县', '316', '0', '0', '103.39477', '35.66471');
INSERT INTO `counties` VALUES ('2595', '广河县', '316', '0', '0', '103.56933', '35.48097');
INSERT INTO `counties` VALUES ('2596', '积石山保安族东乡族撒拉族自治县', '316', '0', '0', '102.87374', '35.7182');
INSERT INTO `counties` VALUES ('2597', '临夏市', '316', '0', '0', '103.21', '35.59916');
INSERT INTO `counties` VALUES ('2598', '永靖县', '316', '0', '0', '103.32043', '35.93835');
INSERT INTO `counties` VALUES ('2599', '康乐县', '316', '0', '0', '103.71093', '35.37219');
INSERT INTO `counties` VALUES ('2600', '和政县', '316', '0', '0', '103.34936', '35.42592');
INSERT INTO `counties` VALUES ('2601', '临夏县', '316', '0', '0', '102.9938', '35.49519');
INSERT INTO `counties` VALUES ('2602', '玛曲县', '317', '0', '0', '102.0754', '33.997');
INSERT INTO `counties` VALUES ('2603', '迭部县', '317', '0', '0', '103.22274', '34.05623');
INSERT INTO `counties` VALUES ('2604', '合作市', '317', '0', '0', '102.91082', '35.00016');
INSERT INTO `counties` VALUES ('2605', '舟曲县', '317', '0', '0', '104.37155', '33.78468');
INSERT INTO `counties` VALUES ('2606', '卓尼县', '317', '0', '0', '103.50811', '34.58919');
INSERT INTO `counties` VALUES ('2607', '临潭县', '317', '0', '0', '103.35287', '34.69515');
INSERT INTO `counties` VALUES ('2608', '碌曲县', '317', '0', '0', '102.49176', '34.58872');
INSERT INTO `counties` VALUES ('2609', '夏河县', '317', '0', '0', '102.52215', '35.20487');
INSERT INTO `counties` VALUES ('2610', '刚察县', '320', '0', '0', '100.14675', '37.32161');
INSERT INTO `counties` VALUES ('2611', '海晏县', '320', '0', '0', '100.9927', '36.89902');
INSERT INTO `counties` VALUES ('2612', '祁连县', '320', '0', '0', '100.24618', '38.17901');
INSERT INTO `counties` VALUES ('2613', '门源回族自治县', '320', '0', '0', '101.62228', '37.37611');
INSERT INTO `counties` VALUES ('2614', '平安县', '319', '0', '0', '102.104295', '36.502714');
INSERT INTO `counties` VALUES ('2615', '民和回族土族自治县', '319', '0', '0', '102.804209', '36.329451');
INSERT INTO `counties` VALUES ('2616', '循化撒拉族自治县', '319', '0', '0', '102.486534', '35.847247');
INSERT INTO `counties` VALUES ('2617', '互助土族自治县', '319', '0', '0', '101.956734', '36.83994');
INSERT INTO `counties` VALUES ('2618', '化隆回族自治县', '319', '0', '0', '102.262329', '36.098322');
INSERT INTO `counties` VALUES ('2619', '乐都县', '319', '0', '0', '102.40', '36.48');
INSERT INTO `counties` VALUES ('2620', '河南蒙古族自治县', '321', '0', '0', '101.60864', '34.73476');
INSERT INTO `counties` VALUES ('2621', '尖扎县', '321', '0', '0', '102.03411', '35.93947');
INSERT INTO `counties` VALUES ('2622', '同仁县', '321', '0', '0', '102.0184', '35.51603');
INSERT INTO `counties` VALUES ('2623', '泽库县', '321', '0', '0', '101.46444', '35.03519');
INSERT INTO `counties` VALUES ('2624', '班玛县', '323', '0', '0', '100.73745', '32.93253');
INSERT INTO `counties` VALUES ('2625', '达日县', '323', '0', '0', '99.65179', '33.75193');
INSERT INTO `counties` VALUES ('2626', '甘德县', '323', '0', '0', '99.90246', '33.96838');
INSERT INTO `counties` VALUES ('2627', '久治县', '323', '0', '0', '101.48342', '33.42989');
INSERT INTO `counties` VALUES ('2628', '玛多县', '323', '0', '0', '98.20996', '34.91567');
INSERT INTO `counties` VALUES ('2629', '玛沁县', '323', '0', '0', '100.23901', '34.47746');
INSERT INTO `counties` VALUES ('2630', '贵德县', '322', '0', '0', '101.432', '36.044');
INSERT INTO `counties` VALUES ('2631', '贵南县', '322', '0', '0', '100.74716', '35.58667');
INSERT INTO `counties` VALUES ('2632', '同德县', '322', '0', '0', '100.57159', '35.25488');
INSERT INTO `counties` VALUES ('2633', '兴海县', '322', '0', '0', '99.98846', '35.59031');
INSERT INTO `counties` VALUES ('2634', '共和县', '322', '0', '0', '100.62003', '36.2841');
INSERT INTO `counties` VALUES ('2635', '德令哈市', '325', '0', '0', '97.36084', '37.36946');
INSERT INTO `counties` VALUES ('2636', '都兰县', '325', '0', '0', '98.09228', '36.30135');
INSERT INTO `counties` VALUES ('2637', '格尔木市', '325', '0', '0', '94.90329', '36.40236');
INSERT INTO `counties` VALUES ('2638', '天峻县', '325', '0', '0', '99.02453', '37.30326');
INSERT INTO `counties` VALUES ('2639', '乌兰县', '325', '0', '0', '98.48196', '36.93471');
INSERT INTO `counties` VALUES ('2640', '海西蒙古族藏族自治州直辖', '325', '0', '0', '97.37', '37.37');
INSERT INTO `counties` VALUES ('2641', '贺兰县', '326', '0', '0', '106.34982', '38.5544');
INSERT INTO `counties` VALUES ('2642', '金凤区', '326', '0', '0', '106.24261', '38.47294');
INSERT INTO `counties` VALUES ('2643', '灵武市', '326', '0', '0', '106.33999', '38.10266');
INSERT INTO `counties` VALUES ('2644', '西夏区', '326', '0', '0', '106.15023', '38.49137');
INSERT INTO `counties` VALUES ('2645', '兴庆区', '326', '0', '0', '106.28872', '38.47392');
INSERT INTO `counties` VALUES ('2646', '永宁县', '326', '0', '0', '106.2517', '38.27559');
INSERT INTO `counties` VALUES ('2647', '称多县', '324', '0', '0', '97.10788', '33.36899');
INSERT INTO `counties` VALUES ('2648', '囊谦县', '324', '0', '0', '96.47753', '32.20359');
INSERT INTO `counties` VALUES ('2649', '曲麻莱县', '324', '0', '0', '95.79757', '34.12609');
INSERT INTO `counties` VALUES ('2650', '玉树县', '324', '0', '0', '97.02', '33.00');
INSERT INTO `counties` VALUES ('2651', '杂多县', '324', '0', '0', '95.29864', '32.89318');
INSERT INTO `counties` VALUES ('2652', '治多县', '324', '0', '0', '95.61572', '33.8528');
INSERT INTO `counties` VALUES ('2653', '大武口区', '327', '0', '0', '106.37717', '39.01226');
INSERT INTO `counties` VALUES ('2654', '惠农区', '327', '0', '0', '106.71145', '39.13193');
INSERT INTO `counties` VALUES ('2655', '平罗县', '327', '0', '0', '106.54538', '38.90429');
INSERT INTO `counties` VALUES ('2656', '红寺堡区', '328', '0', '0', '106.19822', '37.99747');
INSERT INTO `counties` VALUES ('2657', '利通区', '328', '0', '0', '106.20311', '37.98512');
INSERT INTO `counties` VALUES ('2658', '青铜峡市', '328', '0', '0', '106.07489', '38.02004');
INSERT INTO `counties` VALUES ('2659', '同心县', '328', '0', '0', '105.91418', '36.98116');
INSERT INTO `counties` VALUES ('2660', '盐池县', '328', '0', '0', '107.40707', '37.7833');
INSERT INTO `counties` VALUES ('2661', '隆德县', '329', '0', '0', '106.12426', '35.61718');
INSERT INTO `counties` VALUES ('2662', '彭阳县', '329', '0', '0', '106.64462', '35.85076');
INSERT INTO `counties` VALUES ('2663', '西吉县', '329', '0', '0', '105.73107', '35.96616');
INSERT INTO `counties` VALUES ('2664', '原州区', '329', '0', '0', '106.28778', '36.00374');
INSERT INTO `counties` VALUES ('2665', '泾源县', '329', '0', '0', '106.33902', '35.49072');
INSERT INTO `counties` VALUES ('2666', '海原县', '330', '0', '0', '105.64712', '36.56498');
INSERT INTO `counties` VALUES ('2667', '沙坡头区', '330', '0', '0', '105.18962', '37.51044');
INSERT INTO `counties` VALUES ('2668', '中宁县', '330', '0', '0', '105.68515', '37.49149');
INSERT INTO `counties` VALUES ('2669', '水磨沟区', '331', '0', '0', '87.64249', '43.83247');
INSERT INTO `counties` VALUES ('2670', '天山区', '331', '0', '0', '87.63167', '43.79439');
INSERT INTO `counties` VALUES ('2671', '头屯河区', '331', '0', '0', '87.29138', '43.85487');
INSERT INTO `counties` VALUES ('2672', '乌鲁木齐县', '331', '0', '0', '87.40939', '43.47125');
INSERT INTO `counties` VALUES ('2673', '新市区', '331', '0', '0', '87.57406', '43.84348');
INSERT INTO `counties` VALUES ('2674', '达坂城区', '331', '0', '0', '88.30697', '43.35797');
INSERT INTO `counties` VALUES ('2675', '米东区', '331', '0', '0', '87.68583', '43.94739');
INSERT INTO `counties` VALUES ('2676', '沙依巴克区', '331', '0', '0', '87.59788', '43.80118');
INSERT INTO `counties` VALUES ('2677', '白碱滩区', '332', '0', '0', '85.13244', '45.68768');
INSERT INTO `counties` VALUES ('2678', '独山子区', '332', '0', '0', '84.88671', '44.32867');
INSERT INTO `counties` VALUES ('2679', '克拉玛依区', '332', '0', '0', '84.86225', '45.59089');
INSERT INTO `counties` VALUES ('2680', '乌尔禾区', '332', '0', '0', '85.69143', '46.09006');
INSERT INTO `counties` VALUES ('2681', '吐鲁番市', '333', '0', '0', '89.18579', '42.93505');
INSERT INTO `counties` VALUES ('2682', '托克逊县', '333', '0', '0', '88.65823', '42.79231');
INSERT INTO `counties` VALUES ('2683', '鄯善县', '333', '0', '0', '90.21402', '42.8635');
INSERT INTO `counties` VALUES ('2684', '巴里坤哈萨克自治县', '334', '0', '0', '93.01236', '43.59993');
INSERT INTO `counties` VALUES ('2685', '哈密市', '334', '0', '0', '93.51452', '42.82699');
INSERT INTO `counties` VALUES ('2686', '伊吾县', '334', '0', '0', '94.69403', '43.2537');
INSERT INTO `counties` VALUES ('2687', '博乐市', '336', '0', '0', '82.0713', '44.90052');
INSERT INTO `counties` VALUES ('2688', '精河县', '336', '0', '0', '82.89419', '44.60774');
INSERT INTO `counties` VALUES ('2689', '温泉县', '336', '0', '0', '81.03134', '44.97373');
INSERT INTO `counties` VALUES ('2690', '乌恰县', '339', '0', '0', '75.25839', '39.71984');
INSERT INTO `counties` VALUES ('2691', '阿合奇县', '339', '0', '0', '78.44848', '40.93947');
INSERT INTO `counties` VALUES ('2692', '阿克陶县', '339', '0', '0', '75.94692', '39.14892');
INSERT INTO `counties` VALUES ('2693', '阿图什市', '339', '0', '0', '76.16827', '39.71615');
INSERT INTO `counties` VALUES ('2694', '玛纳斯县', '335', '0', '0', '86.2145', '44.30438');
INSERT INTO `counties` VALUES ('2695', '木垒哈萨克自治县', '335', '0', '0', '90.28897', '43.83508');
INSERT INTO `counties` VALUES ('2696', '奇台县', '335', '0', '0', '89.5932', '44.02221');
INSERT INTO `counties` VALUES ('2697', '昌吉市', '335', '0', '0', '87.30249', '44.01267');
INSERT INTO `counties` VALUES ('2698', '阜康市', '335', '0', '0', '87.98529', '44.1584');
INSERT INTO `counties` VALUES ('2699', '呼图壁县', '335', '0', '0', '86.89892', '44.18977');
INSERT INTO `counties` VALUES ('2700', '吉木萨尔县', '335', '0', '0', '89.18078', '44.00048');
INSERT INTO `counties` VALUES ('2701', '博湖县', '337', '0', '0', '86.63333', '41.98014');
INSERT INTO `counties` VALUES ('2702', '和静县', '337', '0', '0', '86.39611', '42.31838');
INSERT INTO `counties` VALUES ('2703', '和硕县', '337', '0', '0', '86.86392', '42.26814');
INSERT INTO `counties` VALUES ('2704', '库尔勒市', '337', '0', '0', '86.15528', '41.76602');
INSERT INTO `counties` VALUES ('2705', '轮台县', '337', '0', '0', '84.26101', '41.77642');
INSERT INTO `counties` VALUES ('2706', '且末县', '337', '0', '0', '85.52975', '38.14534');
INSERT INTO `counties` VALUES ('2707', '若羌县', '337', '0', '0', '88.16812', '39.0179');
INSERT INTO `counties` VALUES ('2708', '尉犁县', '337', '0', '0', '86.25903', '41.33632');
INSERT INTO `counties` VALUES ('2709', '焉耆回族自治县', '337', '0', '0', '86.5744', '42.059');
INSERT INTO `counties` VALUES ('2710', '阿克苏市', '338', '0', '0', '80.26338', '41.16754');
INSERT INTO `counties` VALUES ('2711', '阿瓦提县', '338', '0', '0', '80.38336', '40.63926');
INSERT INTO `counties` VALUES ('2712', '拜城县', '338', '0', '0', '81.87564', '41.79801');
INSERT INTO `counties` VALUES ('2713', '柯坪县', '338', '0', '0', '79.04751', '40.50585');
INSERT INTO `counties` VALUES ('2714', '库车县', '338', '0', '0', '82.96209', '41.71793');
INSERT INTO `counties` VALUES ('2715', '沙雅县', '338', '0', '0', '82.78131', '41.22497');
INSERT INTO `counties` VALUES ('2716', '温宿县', '338', '0', '0', '80.24173', '41.27679');
INSERT INTO `counties` VALUES ('2717', '乌什县', '338', '0', '0', '79.22937', '41.21569');
INSERT INTO `counties` VALUES ('2718', '新和县', '338', '0', '0', '82.61053', '41.54964');
INSERT INTO `counties` VALUES ('2719', '察布查尔锡伯自治县', '342', '0', '0', '81.14956', '43.84023');
INSERT INTO `counties` VALUES ('2720', '巩留县', '342', '0', '0', '82.22851', '43.48429');
INSERT INTO `counties` VALUES ('2721', '霍城县', '342', '0', '0', '80.87826', '44.0533');
INSERT INTO `counties` VALUES ('2722', '奎屯市', '342', '0', '0', '84.90228', '44.425');
INSERT INTO `counties` VALUES ('2723', '尼勒克县', '342', '0', '0', '82.51184', '43.79901');
INSERT INTO `counties` VALUES ('2724', '特克斯县', '342', '0', '0', '81.84005', '43.21938');
INSERT INTO `counties` VALUES ('2725', '新源县', '342', '0', '0', '83.26095', '43.4284');
INSERT INTO `counties` VALUES ('2726', '伊宁市', '342', '0', '0', '81.32932', '43.91294');
INSERT INTO `counties` VALUES ('2727', '伊宁县', '342', '0', '0', '81.52764', '43.97863');
INSERT INTO `counties` VALUES ('2728', '昭苏县', '342', '0', '0', '81.1307', '43.15828');
INSERT INTO `counties` VALUES ('2729', '巴楚县', '340', '0', '0', '78.54888', '39.7855');
INSERT INTO `counties` VALUES ('2730', '喀什市', '340', '0', '0', '75.99379', '39.46768');
INSERT INTO `counties` VALUES ('2731', '麦盖提县', '340', '0', '0', '77.64224', '38.89662');
INSERT INTO `counties` VALUES ('2732', '莎车县', '340', '0', '0', '77.24316', '38.41601');
INSERT INTO `counties` VALUES ('2733', '疏附县', '340', '0', '0', '75.86029', '39.37534');
INSERT INTO `counties` VALUES ('2734', '疏勒县', '340', '0', '0', '76.05398', '39.40625');
INSERT INTO `counties` VALUES ('2735', '塔什库尔干塔吉克自治县', '340', '0', '0', '75.23196', '37.77893');
INSERT INTO `counties` VALUES ('2736', '叶城县', '340', '0', '0', '77.41659', '37.88324');
INSERT INTO `counties` VALUES ('2737', '英吉沙县', '340', '0', '0', '76.17565', '38.92968');
INSERT INTO `counties` VALUES ('2738', '岳普湖县', '340', '0', '0', '76.77233', '39.23561');
INSERT INTO `counties` VALUES ('2739', '泽普县', '340', '0', '0', '77.27145', '38.18935');
INSERT INTO `counties` VALUES ('2740', '伽师县', '340', '0', '0', '76.72372', '39.48801');
INSERT INTO `counties` VALUES ('2741', '额敏县', '343', '0', '0', '83.62872', '46.5284');
INSERT INTO `counties` VALUES ('2742', '和布克赛尔蒙古自治县', '343', '0', '0', '85.72662', '46.79362');
INSERT INTO `counties` VALUES ('2743', '沙湾县', '343', '0', '0', '85.61932', '44.33144');
INSERT INTO `counties` VALUES ('2744', '塔城市', '343', '0', '0', '82.97892', '46.74852');
INSERT INTO `counties` VALUES ('2745', '托里县', '343', '0', '0', '83.60592', '45.93623');
INSERT INTO `counties` VALUES ('2746', '乌苏市', '343', '0', '0', '84.68258', '44.43729');
INSERT INTO `counties` VALUES ('2747', '裕民县', '343', '0', '0', '82.99002', '46.20377');
INSERT INTO `counties` VALUES ('2748', '石河子市', '345', '0', '0', '86.041075', '44.305886');
INSERT INTO `counties` VALUES ('2749', '五家渠市', '345', '0', '0', '87.526884', '44.167401');
INSERT INTO `counties` VALUES ('2750', '阿拉尔市', '345', '0', '0', '81.285884', '40.541914');
INSERT INTO `counties` VALUES ('2751', '图木舒克市', '345', '0', '0', '79.077978', '39.867316');
INSERT INTO `counties` VALUES ('2752', '北屯市', '345', '0', '0', '87.808456', '47.362308');
INSERT INTO `counties` VALUES ('2753', '墨玉县', '341', '0', '0', '79.74035', '37.27248');
INSERT INTO `counties` VALUES ('2754', '皮山县', '341', '0', '0', '78.28125', '37.62007');
INSERT INTO `counties` VALUES ('2755', '于田县', '341', '0', '0', '81.66717', '36.854');
INSERT INTO `counties` VALUES ('2756', '策勒县', '341', '0', '0', '80.80999', '36.99843');
INSERT INTO `counties` VALUES ('2757', '和田市', '341', '0', '0', '79.91353', '37.11214');
INSERT INTO `counties` VALUES ('2758', '和田县', '341', '0', '0', '79.82874', '37.08922');
INSERT INTO `counties` VALUES ('2759', '洛浦县', '341', '0', '0', '80.18536', '37.07364');
INSERT INTO `counties` VALUES ('2760', '民丰县', '341', '0', '0', '82.68444', '37.06577');
INSERT INTO `counties` VALUES ('2761', '哈巴河县', '344', '0', '0', '86.42092', '48.06046');
INSERT INTO `counties` VALUES ('2762', '布尔津县', '344', '0', '0', '86.85751', '47.70062');
INSERT INTO `counties` VALUES ('2763', '富蕴县', '344', '0', '0', '89.52679', '46.99444');
INSERT INTO `counties` VALUES ('2764', '吉木乃县', '344', '0', '0', '85.87814', '47.43359');
INSERT INTO `counties` VALUES ('2765', '青河县', '344', '0', '0', '90.38305', '46.67382');
INSERT INTO `counties` VALUES ('2766', '福海县', '344', '0', '0', '87.49508', '47.11065');
INSERT INTO `counties` VALUES ('2767', '阿勒泰市', '344', '0', '0', '88.13913', '47.8317');

-- ----------------------------
-- Table structure for countries
-- ----------------------------
DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  `country_id` int(11) NOT NULL COMMENT '国家id',
  `country_code` varchar(32) NOT NULL COMMENT '国家编码',
  `country_name` varchar(32) NOT NULL COMMENT '国家名称',
  `have_map` int(11) NOT NULL DEFAULT '1',
  `have_child_map` int(11) NOT NULL DEFAULT '1',
  `longitude` varchar(16) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(16) DEFAULT NULL COMMENT '纬度',
  `planet_id` int(11) DEFAULT '1',
  PRIMARY KEY (`country_id`),
  UNIQUE KEY `uk_countryCode` (`country_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of countries
-- ----------------------------
INSERT INTO `countries` VALUES ('1', 'china', '中国', '1', '1', '116.405285', '39.904989', '1');
INSERT INTO `countries` VALUES ('2', 'Singapore Rep.', '新加坡', '0', '0', '103.51', '01.16', '1');
INSERT INTO `countries` VALUES ('3', 'Dominican Rep.', '多米尼加', '0', '0', '-61.24', '15.20', '1');
INSERT INTO `countries` VALUES ('4', 'Palestine', '巴勒斯坦', '0', '0', null, null, '1');
INSERT INTO `countries` VALUES ('5', 'Bahamas', '巴哈马', '0', '0', '-77.20', '25.05', '1');
INSERT INTO `countries` VALUES ('6', 'Timor-Leste', '东帝汶', '0', '0', '125.34', '-8.29', '1');
INSERT INTO `countries` VALUES ('7', 'Afghanistan', '阿富汗', '0', '0', '69.11', '34.28', '1');
INSERT INTO `countries` VALUES ('8', 'Guinea-Bissau', '几内亚比绍', '0', '0', '-15.45', '11.45', '1');
INSERT INTO `countries` VALUES ('9', 'Côte d\'Ivoire', '科特迪瓦', '0', '0', '-5.17', '6.49', '1');
INSERT INTO `countries` VALUES ('10', 'Siachen Glacier', '锡亚琴冰川', '0', '0', null, null, '1');
INSERT INTO `countries` VALUES ('11', 'Br. Indian Ocean Ter.', '英属印度洋领土', '0', '0', null, null, '1');
INSERT INTO `countries` VALUES ('12', 'Angola', '安哥拉', '0', '0', '13.15', '-8.50', '1');
INSERT INTO `countries` VALUES ('13', 'Albania', '阿尔巴尼亚', '0', '0', '19.49', '41.18', '1');
INSERT INTO `countries` VALUES ('14', 'United Arab Emirates', '阿联酋', '0', '0', '54.22', '24.28', '1');
INSERT INTO `countries` VALUES ('15', 'Argentina', '阿根廷', '0', '0', '-60.00', '-36.30', '1');
INSERT INTO `countries` VALUES ('16', 'Armenia', '亚美尼亚', '0', '0', '44.31', '40.10', '1');
INSERT INTO `countries` VALUES ('17', 'Austria', '奥地利', '0', '0', '16.22', '48.12', '1');
INSERT INTO `countries` VALUES ('18', 'Azerbaijan', '阿塞拜疆', '0', '0', '49.56', '40.29', '1');
INSERT INTO `countries` VALUES ('19', 'Burundi', '布隆迪', '0', '0', '29.18', '-3.16', '1');
INSERT INTO `countries` VALUES ('20', 'Belgium', '比利时', '0', '0', '4.21', '50.51', '1');
INSERT INTO `countries` VALUES ('21', 'Benin', '贝宁', '0', '0', '2.42', '6.23', '1');
INSERT INTO `countries` VALUES ('22', 'Burkina Faso', '布基纳法索', '0', '0', '-1.30', '12.15', '1');
INSERT INTO `countries` VALUES ('23', 'Bangladesh', '孟加拉国', '0', '0', '90.26', '23.43', '1');
INSERT INTO `countries` VALUES ('24', 'Bulgaria', '保加利亚', '0', '0', '23.20', '42.45', '1');
INSERT INTO `countries` VALUES ('25', 'Bosnia and Herz.', '波斯尼亚和黑塞哥维那', '0', '0', '18.26', '43.52', '1');
INSERT INTO `countries` VALUES ('26', 'Belarus', '白俄罗斯', '0', '0', '27.30', '53.52', '1');
INSERT INTO `countries` VALUES ('27', 'Belize', '伯利兹', '0', '0', '-88.30', '17.18', '1');
INSERT INTO `countries` VALUES ('28', 'Bermuda', '百慕大', '0', '0', '-64.75737', '32.321384', '1');
INSERT INTO `countries` VALUES ('29', 'Bolivia', '玻利维亚', '0', '0', '-68.10', '-16.20', '1');
INSERT INTO `countries` VALUES ('30', 'Brazil', '巴西', '0', '0', '-47.55', '-15.47', '1');
INSERT INTO `countries` VALUES ('31', 'Brunei', '文莱', '0', '0', '115.00', '4.52', '1');
INSERT INTO `countries` VALUES ('32', 'Bhutan', '不丹', '0', '0', '89.45', '27.31', '1');
INSERT INTO `countries` VALUES ('33', 'Botswana', '博茨瓦纳', '0', '0', '25.57', '-24.45', '1');
INSERT INTO `countries` VALUES ('34', 'Central African Rep.', '中非', '0', '0', '20.939444', '6.611111', '1');
INSERT INTO `countries` VALUES ('35', 'Canada', '加拿大', '0', '0', '-75.42', '45.27', '1');
INSERT INTO `countries` VALUES ('36', 'Switzerland', '瑞士', '0', '0', '7.28', '46.57', '1');
INSERT INTO `countries` VALUES ('37', 'Chile', '智利', '0', '0', '-70.40', '-33.24', '1');
INSERT INTO `countries` VALUES ('38', 'Cameroon', '喀麦隆', '0', '0', '11.35', '3.50', '1');
INSERT INTO `countries` VALUES ('39', 'Dem. Rep. Congo', '刚果民主共和国', '0', '0', '', '', '1');
INSERT INTO `countries` VALUES ('40', 'Congo', '刚果', '0', '0', '15.12', '-4.09', '1');
INSERT INTO `countries` VALUES ('41', 'Colombia', '哥伦比亚', '0', '0', '-74.00', '4.34', '1');
INSERT INTO `countries` VALUES ('42', 'Costa Rica', '哥斯达黎加', '0', '0', '-84.02', '9.55', '1');
INSERT INTO `countries` VALUES ('43', 'Cuba', '古巴', '0', '0', '-82.22', '23.08', '1');
INSERT INTO `countries` VALUES ('44', 'N. Cyprus', '北塞浦路斯', '0', '0', null, null, '1');
INSERT INTO `countries` VALUES ('45', 'Cyprus', '塞浦路斯', '0', '0', '33.25', '35.10', '1');
INSERT INTO `countries` VALUES ('46', 'Czech Rep.', '捷克', '0', '0', '15.472962', '49.817492', '1');
INSERT INTO `countries` VALUES ('47', 'Germany', '德国', '0', '0', '13.25', '52.30', '1');
INSERT INTO `countries` VALUES ('48', 'Djibouti', '吉布提', '0', '0', '42.20', '11.08', '1');
INSERT INTO `countries` VALUES ('49', 'Denmark', '丹麦', '0', '0', '12.34', '55.41', '1');
INSERT INTO `countries` VALUES ('50', 'Algeria', '阿尔及利亚', '0', '0', '3.08', '36.42', '1');
INSERT INTO `countries` VALUES ('51', 'Ecuador', '厄瓜多尔', '0', '0', '-78.35', '-0.15', '1');
INSERT INTO `countries` VALUES ('52', 'Egypt', '埃及', '0', '0', '31.14', '30.01', '1');
INSERT INTO `countries` VALUES ('53', 'Eritrea', '厄立特里亚', '0', '0', '38.55', '15.19', '1');
INSERT INTO `countries` VALUES ('54', 'Spain', '西班牙', '0', '0', '-3.45', '40.25', '1');
INSERT INTO `countries` VALUES ('55', 'Estonia', '爱沙尼亚', '0', '0', '24.48', '59.22', '1');
INSERT INTO `countries` VALUES ('56', 'Ethiopia', '埃塞俄比亚', '0', '0', '38.42', '9.02', '1');
INSERT INTO `countries` VALUES ('57', 'Finland', '芬兰', '0', '0', '25.03', '60.15', '1');
INSERT INTO `countries` VALUES ('58', 'Fiji', '斐济', '0', '0', '178.30', '-18.06', '1');
INSERT INTO `countries` VALUES ('59', 'France', '法国', '0', '0', '2.20', '48.50', '1');
INSERT INTO `countries` VALUES ('60', 'Gabon', '加蓬', '0', '0', '9.26', '0.25', '1');
INSERT INTO `countries` VALUES ('61', 'United Kingdom', '英国', '0', '0', '-0.05', '51.36', '1');
INSERT INTO `countries` VALUES ('62', 'Georgia', '格鲁吉亚', '0', '0', '44.50', '41.43', '1');
INSERT INTO `countries` VALUES ('63', 'Ghana', '加纳', '0', '0', '-0.06', '5.35', '1');
INSERT INTO `countries` VALUES ('64', 'Guinea', '几内亚', '0', '0', '-13.49', '9.29', '1');
INSERT INTO `countries` VALUES ('65', 'Gambia', '冈比亚', '0', '0', '-16.40', '13.28', '1');
INSERT INTO `countries` VALUES ('66', 'Eq. Guinea', '赤道几内亚', '0', '0', '8.50', '3.45', '1');
INSERT INTO `countries` VALUES ('67', 'Greece', '希腊', '0', '0', '23.46', '37.58', '1');
INSERT INTO `countries` VALUES ('68', 'Greenland', '格陵兰', '0', '0', '-51.35', '64.10', '1');
INSERT INTO `countries` VALUES ('69', 'Guatemala', '危地马拉', '0', '0', '-90.22', '14.40', '1');
INSERT INTO `countries` VALUES ('70', 'Guyana', '圭亚那', '0', '0', '-58.12', '6.50', '1');
INSERT INTO `countries` VALUES ('71', 'Honduras', '洪都拉斯', '0', '0', '-87.14', '14.05', '1');
INSERT INTO `countries` VALUES ('72', 'Croatia', '克罗地亚', '0', '0', '15.58', '45.50', '1');
INSERT INTO `countries` VALUES ('73', 'Haiti', '海地', '0', '0', '-72.20', '18.40', '1');
INSERT INTO `countries` VALUES ('74', 'Hungary', '匈牙利', '0', '0', '19.05', '47.29', '1');
INSERT INTO `countries` VALUES ('75', 'Indonesia', '印度尼西亚', '0', '0', '106.49', '-6.09', '1');
INSERT INTO `countries` VALUES ('76', 'India', '印度', '0', '0', '77.13', '28.37', '1');
INSERT INTO `countries` VALUES ('77', 'Ireland', '爱尔兰', '0', '0', '-6.15', '53.21', '1');
INSERT INTO `countries` VALUES ('78', 'Iran', '伊朗', '0', '0', '51.30', '35.44', '1');
INSERT INTO `countries` VALUES ('79', 'Iraq', '伊拉克', '0', '0', '44.30', '33.20', '1');
INSERT INTO `countries` VALUES ('80', 'Iceland', '冰岛', '0', '0', '-21.57', '64.10', '1');
INSERT INTO `countries` VALUES ('81', 'Israel', '以色列', '0', '0', '35.12', '31.47', '1');
INSERT INTO `countries` VALUES ('82', 'Italy', '意大利', '0', '0', '12.29', '41.54', '1');
INSERT INTO `countries` VALUES ('83', 'Jamaica', '牙买加', '0', '0', '-76.50', '18.00', '1');
INSERT INTO `countries` VALUES ('84', 'Jordan', '约旦', '0', '0', '35.52', '31.57', '1');
INSERT INTO `countries` VALUES ('85', 'Japan', '日本', '0', '0', '139.69', '35.70', '1');
INSERT INTO `countries` VALUES ('86', 'Kazakhstan', '哈萨克斯坦', '0', '0', '71.30', '51.10', '1');
INSERT INTO `countries` VALUES ('87', 'Kenya', '肯尼亚', '0', '0', '36.48', '-1.17', '1');
INSERT INTO `countries` VALUES ('88', 'Kyrgyzstan', '吉尔吉斯斯坦', '0', '0', '74.46', '42.54', '1');
INSERT INTO `countries` VALUES ('89', 'Cambodia', '柬埔寨', '0', '0', '104.55', '11.33', '1');
INSERT INTO `countries` VALUES ('90', 'Korea', '韩国', '0', '0', '126.58', '37.31', '1');
INSERT INTO `countries` VALUES ('91', 'Kuwait', '科威特', '0', '0', '48.00', '29.30', '1');
INSERT INTO `countries` VALUES ('92', 'Lao PDR', '老挝', '0', '0', '102.36', '17.58', '1');
INSERT INTO `countries` VALUES ('93', 'Lebanon', '黎巴嫩', '0', '0', '35.31', '33.53', '1');
INSERT INTO `countries` VALUES ('94', 'Liberia', '利比里亚', '0', '0', '-10.47', '6.18', '1');
INSERT INTO `countries` VALUES ('95', 'Libya', '利比亚', '0', '0', '17.228331', '26.3351', '1');
INSERT INTO `countries` VALUES ('96', 'Sri Lanka', '斯里兰卡', '0', '0', '80.771797', '7.873054', '1');
INSERT INTO `countries` VALUES ('97', 'Lesotho', '莱索托', '0', '0', '27.30', '-29.18', '1');
INSERT INTO `countries` VALUES ('98', 'Lithuania', '立陶宛', '0', '0', '25.19', '54.38', '1');
INSERT INTO `countries` VALUES ('99', 'Luxembourg', '卢森堡', '0', '0', '6.09', '49.37', '1');
INSERT INTO `countries` VALUES ('100', 'Latvia', '拉脱维亚', '0', '0', '24.08', '56.53', '1');
INSERT INTO `countries` VALUES ('101', 'Morocco', '摩洛哥', '0', '0', '-7.09262', '31.791702', '1');
INSERT INTO `countries` VALUES ('102', 'Moldova', '摩尔多瓦', '0', '0', '28.50', '47.02', '1');
INSERT INTO `countries` VALUES ('103', 'Madagascar', '马达加斯加', '0', '0', '47.31', '-18.55', '1');
INSERT INTO `countries` VALUES ('104', 'Mexico', '墨西哥', '0', '0', '-99.10', '19.20', '1');
INSERT INTO `countries` VALUES ('105', 'Macedonia', '马其顿', '0', '0', '21.26', '42.01', '1');
INSERT INTO `countries` VALUES ('106', 'Mali', '马里', '0', '0', '-7.55', '12.34', '1');
INSERT INTO `countries` VALUES ('107', 'Myanmar', '缅甸', '0', '0', '96.20', '16.45', '1');
INSERT INTO `countries` VALUES ('108', 'Montenegro', '黑山', '0', '0', '19.37439', '42.708678', '1');
INSERT INTO `countries` VALUES ('109', 'Mongolia', '蒙古', '0', '0', '103.846656', '46.862496', '1');
INSERT INTO `countries` VALUES ('110', 'Mozambique', '莫桑比克', '0', '0', '32.32', '-25.58', '1');
INSERT INTO `countries` VALUES ('111', 'Mauritania', '毛里塔尼亚', '0', '0', '57.30', '-20.10', '1');
INSERT INTO `countries` VALUES ('112', 'Malawi', '马拉维', '0', '0', '33.48', '-14.00', '1');
INSERT INTO `countries` VALUES ('113', 'Malaysia', '马来西亚', '0', '0', '101.41', '3.09', '1');
INSERT INTO `countries` VALUES ('114', 'Namibia', '纳米比亚', '0', '0', '17.04', '-22.35', '1');
INSERT INTO `countries` VALUES ('115', 'New Caledonia', '新喀里多尼亚', '0', '0', '166.30', '-22.17', '1');
INSERT INTO `countries` VALUES ('116', 'Niger', '尼日尔', '0', '0', '2.06', '13.27', '1');
INSERT INTO `countries` VALUES ('117', 'Nigeria', '尼日利亚', '0', '0', '7.32', '9.05', '1');
INSERT INTO `countries` VALUES ('118', 'Nicaragua', '尼加拉瓜', '0', '0', '-86.20', '12.06', '1');
INSERT INTO `countries` VALUES ('119', 'Netherlands', '荷兰', '0', '0', '04.54', '52.23', '1');
INSERT INTO `countries` VALUES ('120', 'Norway', '挪威', '0', '0', '10.45', '59.55', '1');
INSERT INTO `countries` VALUES ('121', 'Nepal', '尼泊尔', '0', '0', '85.20', '27.45', '1');
INSERT INTO `countries` VALUES ('122', 'New Zealand', '新西兰', '0', '0', '174.46', '-41.19', '1');
INSERT INTO `countries` VALUES ('123', 'Oman', '阿曼', '0', '0', '58.36', '23.37', '1');
INSERT INTO `countries` VALUES ('124', 'Pakistan', '巴基斯坦', '0', '0', '73.10', '33.40', '1');
INSERT INTO `countries` VALUES ('125', 'Panama', '巴拿马', '0', '0', '-79.25', '9.00', '1');
INSERT INTO `countries` VALUES ('126', 'Peru', '秘鲁', '0', '0', '-77.00', '-12.00', '1');
INSERT INTO `countries` VALUES ('127', 'Philippines', '菲律宾', '0', '0', '121.03', '14.40', '1');
INSERT INTO `countries` VALUES ('128', 'Papua New Guinea', '巴布亚新几内亚', '0', '0', '147.08', '-9.24', '1');
INSERT INTO `countries` VALUES ('129', 'Poland', '波兰', '0', '0', '21.00', '52.13', '1');
INSERT INTO `countries` VALUES ('130', 'Puerto Rico', '波多黎各', '0', '0', '-66.07', '18.28', '1');
INSERT INTO `countries` VALUES ('131', 'Dem. Rep. Korea', '朝鲜', '0', '0', '125.30', '39.09', '1');
INSERT INTO `countries` VALUES ('132', 'Portugal', '葡萄牙', '0', '0', '125.30', '39.09', '1');
INSERT INTO `countries` VALUES ('133', 'Paraguay', '巴拉圭', '0', '0', '-57.30', '-25.10', '1');
INSERT INTO `countries` VALUES ('134', 'Qatar', '卡塔尔', '0', '0', '51.35', '25.15', '1');
INSERT INTO `countries` VALUES ('135', 'Romania', '罗马尼亚', '0', '0', '26.10', '44.27', '1');
INSERT INTO `countries` VALUES ('136', 'Russia', '俄罗斯', '0', '0', '37.35', '55.45', '1');
INSERT INTO `countries` VALUES ('137', 'Rwanda', '卢旺达', '0', '0', '30.04', '-1.59', '1');
INSERT INTO `countries` VALUES ('138', 'W. Sahara', '西撒哈拉', '0', '0', '-12.885834', '24.215527', '1');
INSERT INTO `countries` VALUES ('139', 'Saudi Arabia', '沙特阿拉伯', '0', '0', '46.42', '24.41', '1');
INSERT INTO `countries` VALUES ('140', 'Sudan', '苏丹', '0', '0', '32.35', '15.31', '1');
INSERT INTO `countries` VALUES ('141', 'S. Sudan', '南苏丹', '0', '0', null, null, '1');
INSERT INTO `countries` VALUES ('142', 'Senegal', '塞内加尔', '0', '0', '-17.29', '14.34', '1');
INSERT INTO `countries` VALUES ('143', 'Solomon Is.', '所罗门群岛', '0', '0', '159.57', '-9.27', '1');
INSERT INTO `countries` VALUES ('144', 'Sierra Leone', '塞拉利昂', '0', '0', '-13.17', '8.30', '1');
INSERT INTO `countries` VALUES ('145', 'El Salvador', '萨尔瓦多', '0', '0', '-89.10', '13.40', '1');
INSERT INTO `countries` VALUES ('146', 'Somalia', '索马里', '0', '0', '45.25', '2.02', '1');
INSERT INTO `countries` VALUES ('147', 'Serbia', '塞尔维亚', '0', '0', '21.005859', '44.016521', '1');
INSERT INTO `countries` VALUES ('148', 'Suriname', '苏里南', '0', '0', '-55.10', '5.50', '1');
INSERT INTO `countries` VALUES ('149', 'Slovakia', '斯洛伐克', '0', '0', '17.07', '48.10', '1');
INSERT INTO `countries` VALUES ('150', 'Slovenia', '斯洛文尼亚', '0', '0', '14.33', '46.04', '1');
INSERT INTO `countries` VALUES ('151', 'Sweden', '瑞典', '0', '0', '18.03', '59.20', '1');
INSERT INTO `countries` VALUES ('152', 'Swaziland', '斯威士兰', '0', '0', '31.06', '-26.18', '1');
INSERT INTO `countries` VALUES ('153', 'Syria', '叙利亚', '0', '0', '38.996815', '34.802075', '1');
INSERT INTO `countries` VALUES ('154', 'Chad', '乍得', '0', '0', '14.59', '12.10', '1');
INSERT INTO `countries` VALUES ('155', 'Togo', '多哥', '0', '0', '1.20', '6.09', '1');
INSERT INTO `countries` VALUES ('156', 'Thailand', '泰国', '0', '0', '100.35', '13.45', '1');
INSERT INTO `countries` VALUES ('157', 'Tajikistan', '塔吉克斯坦', '0', '0', '68.48', '38.33', '1');
INSERT INTO `countries` VALUES ('158', 'Turkmenistan', '土库曼斯坦', '0', '0', '57.50', '38.00', '1');
INSERT INTO `countries` VALUES ('159', 'Trinidad and Tobago', '特里尼达和多巴哥', '0', '0', '-61.222503', '10.691803', '1');
INSERT INTO `countries` VALUES ('160', 'Tunisia', '突尼斯', '0', '0', '10.11', '36.50', '1');
INSERT INTO `countries` VALUES ('161', 'Turkey', '土耳其', '0', '0', '32.54', '39.57', '1');
INSERT INTO `countries` VALUES ('162', 'Tanzania', '坦桑尼亚', '0', '0', '35.45', '-6.08', '1');
INSERT INTO `countries` VALUES ('163', 'Uganda', '乌干达', '0', '0', '32.30', '0.20', '1');
INSERT INTO `countries` VALUES ('164', 'Ukraine', '乌克兰', '0', '0', '30.28', '50.30', '1');
INSERT INTO `countries` VALUES ('165', 'Uruguay', '乌拉圭', '0', '0', '-56.11', '-34.50', '1');
INSERT INTO `countries` VALUES ('166', 'United States', '美国', '0', '0', '-77.02', '39.91', '1');
INSERT INTO `countries` VALUES ('167', 'Uzbekistan', '乌兹别克斯坦', '0', '0', '69.10', '41.20', '1');
INSERT INTO `countries` VALUES ('168', 'Venezuela', '委内瑞拉', '0', '0', '-66.55', '10.30', '1');
INSERT INTO `countries` VALUES ('169', 'Vietnam', '越南', '0', '0', '105.55', '21.05', '1');
INSERT INTO `countries` VALUES ('170', 'Vanuatu', '瓦努阿图', '0', '0', '168.18', '-17.45', '1');
INSERT INTO `countries` VALUES ('171', 'Yemen', '也门', '0', '0', '48.516388', '15.552727', '1');
INSERT INTO `countries` VALUES ('172', 'South Africa', '南非', '0', '0', '22.937506', '-30.559482', '1');
INSERT INTO `countries` VALUES ('173', 'Zambia', '赞比亚', '0', '0', '28.16', '-15.28', '1');
INSERT INTO `countries` VALUES ('174', 'Zimbabwe', '津巴布韦', '0', '0', '31.02', '-17.43', '1');
INSERT INTO `countries` VALUES ('175', 'Liechtenstein', '列支敦士登', '0', '0', '9.31', '47.08', '1');
INSERT INTO `countries` VALUES ('176', 'Andorra', '安道尔', '0', '0', '1.601554', '42.546245', '1');
INSERT INTO `countries` VALUES ('177', 'American Samoa', '美属萨摩亚', '0', '0', '-170.43', '-14.16', '1');
INSERT INTO `countries` VALUES ('178', 'Fr. S. Antarctic Lands', '法属南方和南极领地', '0', '0', null, null, '1');
INSERT INTO `countries` VALUES ('179', 'Antigua and Barb.', '安提瓜和巴布达', '0', '0', '-61.48', '17.20', '1');
INSERT INTO `countries` VALUES ('180', 'Bahrain', '巴林', '0', '0', '50.30', '26.10', '1');
INSERT INTO `countries` VALUES ('181', 'Barbados', '巴巴多斯', '0', '0', '-59.30', '13.05', '1');
INSERT INTO `countries` VALUES ('182', 'Comoros', '科摩罗', '0', '0', '43.16', '-11.40', '1');
INSERT INTO `countries` VALUES ('183', 'Cape Verde', '佛得角', '0', '0', '-23.34', '15.02', '1');
INSERT INTO `countries` VALUES ('184', 'Curaçao', '库拉索岛', '0', '0', null, null, '1');
INSERT INTO `countries` VALUES ('185', 'Cayman Is.', '开曼群岛', '0', '0', '-81.24', '19.20', '1');
INSERT INTO `countries` VALUES ('186', 'Dominica', '多米尼克', '0', '0', '-61.370976', '15.414999', '1');
INSERT INTO `countries` VALUES ('187', 'Falkland Is.', '马尔维纳斯群岛', '0', '0', '-59.51', '-51.40', '1');
INSERT INTO `countries` VALUES ('188', 'Faeroe Is.', '法罗群岛', '0', '0', '-6.56', '62.05', '1');
INSERT INTO `countries` VALUES ('189', 'Micronesia', '密克罗尼西亚', '0', '0', '158.09', '6.55', '1');
INSERT INTO `countries` VALUES ('190', 'Grenada', '格林纳达', '0', '0', '-61.604171', '12.262776', '1');
INSERT INTO `countries` VALUES ('191', 'Guam', '关岛', '0', '0', '144.793731', '13.444304', '1');

-- ----------------------------
-- Table structure for data_sources
-- ----------------------------
DROP TABLE IF EXISTS `data_sources`;
CREATE TABLE `data_sources` (
  `data_source_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `data_source_name` varchar(64) NOT NULL,
  `data_source_type` int(11) NOT NULL COMMENT '数据源类型；0：数据库；1：Excel文件',
  `create_user_id` varchar(36) NOT NULL,
  `create_date` datetime NOT NULL,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`data_source_id`),
  UNIQUE KEY `uk_data_source_name` (`organization_id`,`data_source_name`,`data_source_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for database_links
-- ----------------------------
DROP TABLE IF EXISTS `database_links`;
CREATE TABLE `database_links` (
  `data_source_id` varchar(36) CHARACTER SET utf8 NOT NULL,
  `database_ip` varchar(128) CHARACTER SET utf8 DEFAULT NULL COMMENT '业务数据库IP',
  `database_port` varchar(8) CHARACTER SET utf8 DEFAULT NULL COMMENT '数据仓库端口',
  `database_type_name` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT '数据库类型',
  `database_name` varchar(32) CHARACTER SET utf8 DEFAULT NULL COMMENT '数据库名称',
  `user_name` varchar(32) CHARACTER SET utf8 DEFAULT NULL COMMENT '数据库登录账号',
  `password` varchar(128) CHARACTER SET utf8 DEFAULT NULL COMMENT '数据库登录密码',
  `service_type` int(11) NOT NULL DEFAULT '0' COMMENT '服务类型，0-普通数据库，1-数据中台',
  `get_tables_interface` varchar(128) CHARACTER SET utf8 DEFAULT NULL COMMENT '获取表集合接口',
  `get_fields_interface` varchar(128) CHARACTER SET utf8 DEFAULT NULL COMMENT '报表字段集合接口',
  `execute_sql_interface` varchar(128) CHARACTER SET utf8 DEFAULT NULL COMMENT '执行SQL语句接口',
  PRIMARY KEY (`data_source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='公司数据仓库表';
-- ----------------------------
-- Records of database_links
-- ----------------------------

-- ----------------------------
-- Table structure for database_types
-- ----------------------------
DROP TABLE IF EXISTS `database_types`;
CREATE TABLE `database_types` (
  `database_type_name` varchar(32) NOT NULL,
  PRIMARY KEY (`database_type_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of database_types
-- ----------------------------
INSERT INTO `database_types` VALUES ('Access');
INSERT INTO `database_types` VALUES ('SQLServer');
INSERT INTO `database_types` VALUES ('MySql');
INSERT INTO `database_types` VALUES ('Oracle');
INSERT INTO `database_types` VALUES ('DB2');
INSERT INTO `database_types` VALUES ('PostgreSQL');
INSERT INTO `database_types` VALUES ('Greenplum');
INSERT INTO `database_types` VALUES ('SAP HANA');
INSERT INTO `database_types` VALUES ('Hive');

-- ----------------------------
-- Table structure for device_types
-- ----------------------------
DROP TABLE IF EXISTS `device_types`;
CREATE TABLE `device_types` (
  `device_type_id` int(11) NOT NULL,
  `device_type_code` varchar(32) NOT NULL,
  `device_type_name` varchar(32) NOT NULL,
  PRIMARY KEY (`device_type_id`),
  UNIQUE KEY `uk_deviceCode` (`device_type_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of device_types
-- ----------------------------
INSERT INTO `device_types` VALUES ('0', 'Mobile', '手机');
INSERT INTO `device_types` VALUES ('1', 'Pad', '平板');
INSERT INTO `device_types` VALUES ('2', 'PC', '电脑');

-- ----------------------------
-- Table structure for excel_files
-- ----------------------------
DROP TABLE IF EXISTS `excel_files`;
CREATE TABLE `excel_files` (
  `data_source_id` varchar(36) NOT NULL,
  `excel_file_name` varchar(64) NOT NULL,
  `sheet_name` varchar(64) NOT NULL,
  `range_type` int(11) NOT NULL COMMENT '取值范围类型；0：全部，1：自定义',
  `range` varchar(16) DEFAULT NULL,
  `columns_json` longtext,
  PRIMARY KEY (`data_source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of excel_files
-- ----------------------------

-- ----------------------------
-- Table structure for excel_models
-- ----------------------------
DROP TABLE IF EXISTS `excel_models`;
CREATE TABLE `excel_models` (
  `business_model_id` varchar(36) NOT NULL,
  `business_objects_json` longtext,
  PRIMARY KEY (`business_model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of excel_models
-- ----------------------------

-- ----------------------------
-- Table structure for favorites
-- ----------------------------
DROP TABLE IF EXISTS `favorites`;
CREATE TABLE `favorites` (
  `user_id` varchar(36) NOT NULL,
  `report_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `create_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='报表收藏记录';

-- ----------------------------
-- Records of favorites
-- ----------------------------

-- ----------------------------
-- Table structure for geography_data_compares
-- ----------------------------
DROP TABLE IF EXISTS `geography_data_compares`;
CREATE TABLE `geography_data_compares` (
  `geo_data_compare_id` varchar(36) NOT NULL,
  `geo_object_compare_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `map_geo_name` varchar(64) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `object_geo_name` varchar(64) NOT NULL,
  `longitude` varchar(16) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(16) DEFAULT NULL COMMENT '纬度',
  PRIMARY KEY (`geo_data_compare_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of geography_data_compares
-- ----------------------------

-- ----------------------------
-- Table structure for geography_object_compares
-- ----------------------------
DROP TABLE IF EXISTS `geography_object_compares`;
CREATE TABLE `geography_object_compares` (
  `geo_object_compare_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `geo_level` int(11) NOT NULL,
  `business_model_type` int(11) NOT NULL,
  `business_model_id` varchar(36) NOT NULL,
  `business_object_id` varchar(36) NOT NULL,
  PRIMARY KEY (`geo_object_compare_id`),
  UNIQUE KEY `uk_geographyObjectCompare` (`geo_level`,`business_model_id`,`business_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Records of geography_object_compares
-- ----------------------------

-- ----------------------------
-- Table structure for group_business_models
-- ----------------------------
DROP TABLE IF EXISTS `group_business_models`;
CREATE TABLE `group_business_models` (
  `group_id` varchar(36) NOT NULL,
  `business_model_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`group_id`,`business_model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for group_data_sources
-- ----------------------------
DROP TABLE IF EXISTS `group_data_sources`;
CREATE TABLE `group_data_sources` (
  `group_id` varchar(36) NOT NULL,
  `data_source_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`group_id`,`data_source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for groups
-- ----------------------------
DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `group_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `group_name` varchar(32) NOT NULL,
  `group_code` varchar(64) DEFAULT NULL,
  `description` varchar(64) DEFAULT NULL,
  `preseted` int(11) NOT NULL DEFAULT '0' COMMENT '系统预设，0-否、1-是，预设的组不能删除及修改',
  `create_user_id` varchar(36) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `uk_group` (`organization_id`,`group_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of groups
-- ----------------------------
INSERT INTO `groups` VALUES ('0', '1', '数据探索组', null,'该组具有使用数据探索模块的权限', '1', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', NOW(), '', NOW());
INSERT INTO `groups` VALUES ('1', '1', '系统管理组', null,'该组具有使用系统管理模块的权限', '1', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', NOW(), '', NOW());
INSERT INTO `groups` VALUES ('2', '1', '业务建模组', null,'该组具有使用业务建模模块的权限', '1', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', NOW(), '', NOW());
INSERT INTO `groups` VALUES ('3', '1', '智能报表组', null,'该组具有使用智能报表模块的权限', '1', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', NOW(), '', NOW());
INSERT INTO `groups` VALUES ('4', '1', '数据整理组', null,'该组具有使用数据整理模块的权限', '1', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', NOW(), '', NOW());


-- ----------------------------
-- Table structure for group_modules
-- ----------------------------
DROP TABLE IF EXISTS `group_modules`;
CREATE TABLE `group_modules` (
  `group_id` varchar(36) NOT NULL,
  `module_id` int(11) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`group_id`,`module_id`,`organization_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of group_modules
-- ----------------------------
INSERT INTO `group_modules` VALUES ('0', '0', '1');
INSERT INTO `group_modules` VALUES ('1', '0', '1');
INSERT INTO `group_modules` VALUES ('1', '1', '1');
INSERT INTO `group_modules` VALUES ('1', '2', '1');
INSERT INTO `group_modules` VALUES ('1', '3', '1');
INSERT INTO `group_modules` VALUES ('1', '4', '1');
INSERT INTO `group_modules` VALUES ('2', '2', '1');
INSERT INTO `group_modules` VALUES ('3', '3', '1');
INSERT INTO `group_modules` VALUES ('4', '4', '1');

-- ----------------------------
-- Table structure for group_reports
-- ----------------------------
DROP TABLE IF EXISTS `group_reports`;
CREATE TABLE `group_reports` (
  `group_id` varchar(36) NOT NULL,
  `report_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`group_id`,`report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of group_reports
-- ----------------------------

-- ----------------------------
-- Table structure for group_upload_excel_templates
-- ----------------------------
DROP TABLE IF EXISTS `group_upload_excel_templates`;
CREATE TABLE `group_upload_excel_templates` (
  `group_id` varchar(36) NOT NULL,
  `template_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`group_id`,`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for group_users
-- ----------------------------
DROP TABLE IF EXISTS `group_users`;
CREATE TABLE `group_users` (
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`group_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of group_users
-- ----------------------------
INSERT INTO `group_users` VALUES ('1', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '1');

-- ----------------------------
-- Table structure for job_transforms
-- ----------------------------
DROP TABLE IF EXISTS `job_transforms`;
CREATE TABLE `job_transforms` (
  `job_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `transform_id` varchar(36) NOT NULL,
  `sequence` int(11) NOT NULL,
  PRIMARY KEY (`job_id`,`organization_id`,`transform_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for link_shares
-- ----------------------------
DROP TABLE IF EXISTS `link_shares`;
CREATE TABLE `link_shares` (
  `share_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) DEFAULT NULL,
  `report_id` varchar(36) NOT NULL,
  `share_type` int(11) NOT NULL COMMENT '链接分享类型；0：静态；1：动态',
  `restrict_date` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否限制分享日期',
  `share_days` int(11) DEFAULT '0' COMMENT '天数',
  `need_password` tinyint(1) DEFAULT '0' COMMENT '是否需要密码',
  `share_password` varchar(16) DEFAULT NULL,
  `report_view_json` longtext,
  `report_settings_json` text,
  `theme_id` int(11) DEFAULT '0' COMMENT '主题',
  `device_type_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `share_token` varchar(512) DEFAULT NULL COMMENT '用户取数的分享令牌',
  `share_user_id` varchar(36) NOT NULL,
  `share_date` datetime NOT NULL COMMENT '分享时间',
  PRIMARY KEY (`share_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for logins
-- ----------------------------
DROP TABLE IF EXISTS `logins`;
CREATE TABLE `logins` (
  `login_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `user_id` varchar(36) NOT NULL,
  `device_type_id` int(11) NOT NULL COMMENT '设备类型ID',
  `os_id` int(11) NOT NULL COMMENT '操作系统类型',
  `token_type` int(11) NOT NULL DEFAULT 0 COMMENT '令牌类型；0：常规；1：动态链接分享',
  `token` varchar(1024) NOT NULL,
  `login_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_operate_date` timestamp NULL DEFAULT NULL,
  `logout_date` timestamp NULL DEFAULT NULL,
  `logouted` int(11) NOT NULL DEFAULT '0',
  `logout_cause` varchar(128) DEFAULT NULL,
  `third_party_login` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否为第三方验证登录',
  `third_party_token` varchar(1024) DEFAULT NULL COMMENT '第三方令牌',
  `tp_tenant_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`login_id`),
  UNIQUE KEY `uk_login` (`organization_id`,`user_id`,`login_date`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of logins
-- ----------------------------

-- ----------------------------
-- Table structure for menus
-- ----------------------------
DROP TABLE IF EXISTS `menus`;
CREATE TABLE `menus`  (
  `menu_id` int(11) NOT NULL COMMENT '菜单ID',
  `menu_code` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '菜单code',
  `menu_name` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '菜单名称',
  `menu_image` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '菜单图标名称',
  `last_level` int(11) NULL DEFAULT 1 COMMENT '是否末级',
  `menu_parent_id` int(11) NULL DEFAULT NULL COMMENT '父菜单ID',
  `module_id` int(11) NOT NULL COMMENT '所属模块ID',
  `device_visibility` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '设备可见性',
  `menu_order` int(11) NOT NULL DEFAULT -1 COMMENT '按模块排序',
  PRIMARY KEY (`menu_id`) USING BTREE,
  UNIQUE INDEX `uk_menu`(`menu_code`, `module_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of menus
-- ----------------------------
INSERT INTO `menus` VALUES (1, '10000', '我的收藏', 'myFavorite', 1, -1, 0, '012', 1);
INSERT INTO `menus` VALUES (2, '20000', '组织分析', 'organizationAnalysis', 1, -1, 0, '012', 2);
INSERT INTO `menus` VALUES (3, '30000', '自助分析', 'selfAnalysis', 1, -1, 0, '012', 3);
INSERT INTO `menus` VALUES (4, '50000', '图表样例', 'chartSample', 1, -1, 0, '012', 4);
INSERT INTO `menus` VALUES (5, '11000', '用户和组', 'menuFolder', 0, -1, 1, '012', 1);
INSERT INTO `menus` VALUES (6, '11001', '用户', 'user', 1, 5, 1, '012', 2);
INSERT INTO `menus` VALUES (7, '11002', '组', 'group', 1, 5, 1, '012', 3);
INSERT INTO `menus` VALUES (8, '12000', '系统监控', 'menuFolder', 0, -1, 1, '012', 4);
INSERT INTO `menus` VALUES (9, '12001', '在线用户', 'onlineUser', 1, 8, 1, '012', 5);
INSERT INTO `menus` VALUES (10, '12002', '报表查询日志', 'reportQueryLog', 1, 8, 1, '012', 6);
INSERT INTO `menus` VALUES (11, '13000', '权限管理', 'menuFolder', 0, -1, 1, '012', 8);
INSERT INTO `menus` VALUES (12, '13100', '模块权限', 'menuFolder', 0, 11, 1, '012', 9);
INSERT INTO `menus` VALUES (13, '13101', '组模块权限', 'groupModulePermission', 1, 12, 1, '012', 10);
INSERT INTO `menus` VALUES (14, '13102', '用户模块权限', 'userModulePermission', 1, 12, 1, '012', 11);
INSERT INTO `menus` VALUES (15, '13200', '数据源权限', 'menuFolder', 0, 11, 1, '012', 15);
INSERT INTO `menus` VALUES (16, '13201', '组数据源权限', 'groupDataSourcePermission', 1, 15, 1, '012', 16);
INSERT INTO `menus` VALUES (17, '13202', '用户数据源权限', 'userDataSourcePermission', 1, 15, 1, '012', 17);
INSERT INTO `menus` VALUES (18, '13300', '业务模型权限', 'menuFolder', 0, 11, 1, '012', 18);
INSERT INTO `menus` VALUES (19, '13301', '组业务模型权限', 'groupBusinessModelPermission', 1, 18, 1, '012', 19);
INSERT INTO `menus` VALUES (20, '13302', '用户业务模型权限', 'userBusinessModelPermission', 1, 18, 1, '012', 20);
INSERT INTO `menus` VALUES (21, '13400', '报表权限', 'menuFolder', 0, 11, 1, '012', 21);
INSERT INTO `menus` VALUES (22, '13401', '组报表权限', 'groupReportPermission', 1, 21, 1, '012', 22);
INSERT INTO `menus` VALUES (23, '13402', '用户报表权限', 'userReportPermission', 1, 21, 1, '012', 23);
INSERT INTO `menus` VALUES (24, '13500', '数据权限', 'menuFolder', 0, 11, 1, '012', 24);
INSERT INTO `menus` VALUES (25, '13501', '行权限', 'rowRestriction', 1, 24, 1, '012', 25);
INSERT INTO `menus` VALUES (26, '13502', '列权限', 'rowRestriction', 1, 24, 1, '012', 26);
INSERT INTO `menus` VALUES (27, '14000', '对象管理', 'menuFolder', 0, -1, 1, '012', 27);
INSERT INTO `menus` VALUES (28, '14001', '数据源', 'dataSource', 1, 27, 1, '012', 28);
INSERT INTO `menus` VALUES (29, '14002', '业务模型', 'businessModel', 1, 27, 1, '012', 29);
INSERT INTO `menus` VALUES (30, '14003', '报表', 'report', 1, 27, 1, '012', 30);
INSERT INTO `menus` VALUES (31, '14004', '链接分享', 'linkShare', 1, 27, 1, '012', 31);
INSERT INTO `menus` VALUES (32, '32000', '地图', 'map', 1, -1, 3, '2', 2);
INSERT INTO `menus` VALUES (33, '33000', 'Office模板', 'officeTemplate', 1, -1, 3, '2', 3);
INSERT INTO `menus` VALUES (34, '34000', '公共图片', 'reportImage', 1, -1, 3, '2', 4);
INSERT INTO `menus` VALUES (35, '35000', '调色板', 'colorPalette', 1, -1, 3, '2', 5);
INSERT INTO `menus` VALUES (36, '21000', '数据源', 'menuFolder', 0, -1, 2, '012', 1);
INSERT INTO `menus` VALUES (37, '21001', '数据库连接', 'databaseLink', 1, 36, 2, '012', 2);
INSERT INTO `menus` VALUES (38, '21002', 'Excel文件', 'excelFile', 1, 36, 2, '012', 3);
INSERT INTO `menus` VALUES (39, '22000', '业务模型', 'menuFolder', 0, -1, 2, '012', 4);
INSERT INTO `menus` VALUES (40, '22001', '关系模型', 'relationModel', 1, 39, 2, '012', 5);
INSERT INTO `menus` VALUES (41, '22002', '数据表模型', 'tableModel', 1, 39, 2, '012', 6);
INSERT INTO `menus` VALUES (42, '22003', 'SQL模型', 'sqlModel', 1, 39, 2, '012', 7);
INSERT INTO `menus` VALUES (43, '22004', 'Excel模型', 'excelModel', 1, 39, 2, '012', 9);
INSERT INTO `menus` VALUES (44, '41000', '业务数据库设置', 'bizDBSetting', 1, -1, 4, '012', 1);
INSERT INTO `menus` VALUES (45, '42000', '转换', 'transform', 1, -1, 4, '012', 2);
INSERT INTO `menus` VALUES (46, '43000', '财务报表', 'financeReport', 1, -1, 4, '012', 3);
INSERT INTO `menus` VALUES (47, '44000', '财务指标', 'financeIndex', 1, -1, 4, '012', 4);
INSERT INTO `menus` VALUES (48, '45000', '作业', 'job', 1, -1, 4, '012', 5);
INSERT INTO `menus` VALUES (49, '46000', '转换日志', 'transformLog', 1, -1, 4, '012', 6);
INSERT INTO `menus` VALUES (50, '47000', 'Excel上报模板', 'uploadExcelTemplate', 1, -1, 4, '012', 7);
INSERT INTO `menus` VALUES (51, '60000', 'Excel上报', 'menuFolder', 0, -1, 0, '2', 5);
INSERT INTO `menus` VALUES (52, '61000', '数据上报', 'uploadExcelTemplate', 1, 51, 0, '2', 6);
INSERT INTO `menus` VALUES (53, '62000', '上报日志', 'uploadExcelLog', 1, 51, 0, '2', 7);
INSERT INTO `menus` VALUES (54, '13150', 'Excel上报模板权限', 'menuFolder', 0, 11, 1, '012', 12);
INSERT INTO `menus` VALUES (55, '13151', '组Excel上报模板权限', 'groupUETemplatePermission', 1, 54, 1, '012', 13);
INSERT INTO `menus` VALUES (56, '13152', '用户Excel上报模板权限', 'userUETemplatePermission', 1, 54, 1, '012', 14);
INSERT INTO `menus` VALUES (57, '14009', 'Excel上报模板', 'uploadExcelTemplate', 1, 27, 1, '012', 32);
INSERT INTO `menus` VALUES (58, '12003', 'Excel上报日志', 'uploadExcelLog', 1, 8, 1, '012', 7);
INSERT INTO `menus` VALUES (59, '36000', '资源文件', 'resourceFile', 1, -1, 3, '2', 6);
INSERT INTO `menus` VALUES (60, '22005', '存储过程模型', 'storedProcedureModel', 1, 39, 2, '012', 8);
INSERT INTO `menus` VALUES (61, '31000', '组织报表', 'organizationAnalysis', 1, -1, 3, '2', 1);

-- ----------------------------
-- Table structure for messages
-- ----------------------------
DROP TABLE IF EXISTS `messages`;
CREATE TABLE `messages` (
  `message_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `send_user_id` varchar(36) NOT NULL,
  `receive_user_Id` varchar(36) NOT NULL,
  `send_content` varchar(128) NOT NULL,
  `send_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `read_status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of messages
-- ----------------------------

-- ----------------------------
-- Table structure for model_reports
-- ----------------------------
DROP TABLE IF EXISTS `model_reports`;
CREATE TABLE `model_reports` (
  `model_id` varchar(36) NOT NULL,
  `report_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`model_id`,`report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of model_reports
-- ----------------------------

-- ----------------------------
-- Table structure for modules
-- ----------------------------
DROP TABLE IF EXISTS `modules`;
CREATE TABLE `modules` (
  `module_id` int(11) NOT NULL COMMENT '模块ID',
  `module_code` varchar(32) NOT NULL COMMENT '模块编码（英文名称）',
  `module_name` varchar(32) NOT NULL COMMENT '模块名称',
  `description` varchar(64) NOT NULL COMMENT '模块描述',
  PRIMARY KEY (`module_id`),
  UNIQUE KEY `uk_moduleCode` (`module_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of modules
-- ----------------------------
INSERT INTO `modules` VALUES ('0', 'iFind', '数据探索', '为用户提供探索及发现数据所表现的趋势');
INSERT INTO `modules` VALUES ('1', 'iControl', '系统管理', '组织应用的管理控制，比如设置组织的数据链接、用户权限等');
INSERT INTO `modules` VALUES ('2', 'iBusinessModel', '业务建模', '为用户智能创建的基于星型的数据仓库业务模型');
INSERT INTO `modules` VALUES ('3', 'iReport', '智能报表', '为非技术用户提供创建更具极至体验效果的响应式的可视化分析');
INSERT INTO `modules` VALUES ('4', 'iDataOrganize', '数据整理', '提供数据整理技术支持');

-- ----------------------------
-- Table structure for office_templates
-- ----------------------------
DROP TABLE IF EXISTS `office_templates`;
CREATE TABLE `office_templates` (
  `template_id` varchar(36) NOT NULL,
  `template_type` int(11) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `template_url` varchar(128) NOT NULL,
  `template_name` varchar(64) NOT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for operation_systems
-- ----------------------------
DROP TABLE IF EXISTS `operation_systems`;
CREATE TABLE `operation_systems` (
  `os_id` int(11) NOT NULL,
  `os_code` varchar(32) NOT NULL,
  `os_name` varchar(32) NOT NULL,
  PRIMARY KEY (`os_id`),
  KEY `uk_osCode` (`os_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of operation_systems
-- ----------------------------
INSERT INTO `operation_systems` VALUES ('0', 'Windows', 'Windows');
INSERT INTO `operation_systems` VALUES ('1', 'Apple', '苹果');
INSERT INTO `operation_systems` VALUES ('2', 'Android', '安卓');

-- ----------------------------
-- Table structure for organizations
-- ----------------------------
DROP TABLE IF EXISTS `organizations`;
CREATE TABLE `organizations`  (
  `organization_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '组织GUID',
  `tenant_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '-1' COMMENT '租户ID',
  `tp_tenant_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方租户ID',
  `organization_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '组织编码，由BDA指定',
  `organization_parent_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '-1' COMMENT '组织父ID',
  `organization_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '组织全称',
  `organization_short_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '组织简称',
  `system_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `contact_person` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '联系人',
  `mobile_number` varchar(24) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '手机号码',
  `telephone` varchar(24) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织固定电话',
  `email_address` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织邮箱',
  `country_id` int(11) NOT NULL COMMENT '国家ID',
  `province_id` int(11) NOT NULL COMMENT '省/区ID',
  `city_id` int(11) NULL DEFAULT NULL COMMENT '城市ID',
  `organization_logo` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织徽标URL',
  `create_user_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '创建者GUID',
  `create_date` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `last_modify_user_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '最后修改者GUID',
  `last_modify_date` timestamp(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '最后修改时间',
  `tp_organization_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方组织ID',
  `tp_organization_code` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方组织编码',
  `tp_organization_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方组织名称',
  `tp_organization_short_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方组织简称',
  PRIMARY KEY (`organization_id`) USING BTREE,
  UNIQUE INDEX `uk_organizationCode`(`organization_code`, `tenant_id`) USING BTREE,
  UNIQUE INDEX `uk_organizationName`(`organization_name`, `tenant_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Records of organizations
-- ----------------------------
INSERT INTO `organizations` VALUES ('1','','','10000008','-1', '新组织/平台', '新组织/平台', null, '', '', '', '', '1', '19', '202', '', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', NOW(), '', NOW(),'','','','');

-- ----------------------------
-- Table structure for organization_date_formats
-- ----------------------------
DROP TABLE IF EXISTS `organization_date_formats`;
CREATE TABLE `organization_date_formats` (
  `organization_id` varchar(36) NOT NULL,
  `date_code` varchar(32) NOT NULL,
  `date_name` varchar(16) NOT NULL,
  `format` varchar(32) NOT NULL,
  PRIMARY KEY (`organization_id`,`date_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of organization_date_formats
-- ----------------------------
INSERT INTO `organization_date_formats` VALUES ('1', 'day', '日', 'yyyy-MM-dd');
INSERT INTO `organization_date_formats` VALUES ('1', 'month', '月', 'yyyy-MM');
INSERT INTO `organization_date_formats` VALUES ('1', 'quarter', '季', 'yyyy-q');
INSERT INTO `organization_date_formats` VALUES ('1', 'week', '周', 'yyyy-ww');
INSERT INTO `organization_date_formats` VALUES ('1', 'year', '年', 'yyyy');

-- ----------------------------
-- Table structure for organization_system_settings
-- ----------------------------
DROP TABLE IF EXISTS `organization_system_settings`;
CREATE TABLE `organization_system_settings` (
  `system_setting_key` varchar(64) NOT NULL,
  `system_setting_value` varchar(64) DEFAULT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`system_setting_key`,`organization_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of organization_system_settings
-- ----------------------------
INSERT INTO `organization_system_settings` VALUES ('clickBlockToMaxForMobile', '0', '1');
INSERT INTO `organization_system_settings` VALUES ('enableMagnifyBlockAfterHierarchy', '1', '1');
INSERT INTO `organization_system_settings` VALUES ('queryTimeOut', '3', '1');
INSERT INTO `organization_system_settings` VALUES ('rowsOfQueryResult', '10000', '1');
INSERT INTO `organization_system_settings` VALUES ('defaultColorPaletteID', '238ecbdb-86aa-11e9-be0d-f8bc125d47d9', '1');
INSERT INTO `organization_system_settings` VALUES ('pageWidth', '1360', '1');
INSERT INTO `organization_system_settings` VALUES ('pageHeight', '765', '1');
INSERT INTO `organization_system_settings` VALUES ('customLayoutForMobile', '0', '1');
INSERT INTO `organization_system_settings` VALUES ('directShowDataInChartForMobile', '0', '1');
INSERT INTO `organization_system_settings` VALUES ('useNumericSymbols', '1', '1');
INSERT INTO `organization_system_settings` VALUES ('useCommentAsName', '0', '1');
-- ----------------------------
-- Table structure for organization_users
-- ----------------------------
DROP TABLE IF EXISTS `organization_users`;
CREATE TABLE `organization_users` (
  `organization_user_id` varchar(36) NOT NULL COMMENT '组织用户GUID',
  `organization_id` varchar(36) NOT NULL COMMENT '组织GUID',
  `user_id` varchar(36) NOT NULL COMMENT '用户GUID',
  `organization_user_forbidden` int(11) NOT NULL DEFAULT '0' COMMENT '禁用状态，0-可用，1-禁用，当用户账户有问题，管理员可设置该账户为禁用状态',
  `create_user_id` varchar(36) NOT NULL COMMENT '添加者GUID',
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `delete_user_id` varchar(36) DEFAULT NULL COMMENT '移除者GUID',
  `delete_date` timestamp NULL DEFAULT NULL COMMENT '移出时间',
  `deleted` int(11) NOT NULL DEFAULT '0' COMMENT '移除状态，0-非移，1-移除',
  `organization_user_settings_json` text,
  `tp_organization_user_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方组织用户ID',
  PRIMARY KEY (`organization_user_id`),
  UNIQUE KEY `uk_organizationUser` (`organization_id`,`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of organization_users
-- ----------------------------
INSERT INTO `organization_users` VALUES ('9bbb0472-68a3-11e8-a4f9-00ff2cff3a7d', '1', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '0', '8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', NOW(), '', null, '0','[{"settingKey":"homePageType","settingValue":"0"},{"settingKey":"pageURI","settingValue":"home.html"},{"settingKey":"showChartSample","settingValue":"1"},{"settingKey":"linkReportTarget","settingValue":"0"}]','');

-- ----------------------------
-- Table structure for parameters
-- ----------------------------
DROP TABLE IF EXISTS `parameters`;
CREATE TABLE `parameters` (
  `function_name` varchar(64) NOT NULL,
  `parameter_name` varchar(64) NOT NULL,
  `data_type` int(11) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `parameter_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`function_name`,`parameter_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of parameters
-- ----------------------------
INSERT INTO `parameters` VALUES ('Abs', 'numeric_expr', '2', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('Avg', 'measure', '2', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('CaseWhen', 'boolean_expr', '3', '布尔表达式', '0');
INSERT INTO `parameters` VALUES ('CaseWhen', 'value_if_false', '4', '为假时返回值', '2');
INSERT INTO `parameters` VALUES ('CaseWhen', 'value_if_true', '4', '为真时返回值', '1');
INSERT INTO `parameters` VALUES ('Ceiling', 'numeric_expr', '2', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('Concat', 'first_string_expr', '0', '第一个字符串表达式', '0');
INSERT INTO `parameters` VALUES ('Concat', 'second_string_expr', '0', '第二个字符串表达式', '1');
INSERT INTO `parameters` VALUES ('Cos', 'angle_expr', '2', '以弧度为单位的角度表达式', '0');
INSERT INTO `parameters` VALUES ('Count', 'object', '2', '维度或度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('DateDiff', 'first_date', '1', '第一个日期', '0');
INSERT INTO `parameters` VALUES ('DateDiff', 'last_date', '1', '第二个日期', '1');
INSERT INTO `parameters` VALUES ('Date_Add', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('Date_Add', 'days', '2', '天数', '1');
INSERT INTO `parameters` VALUES ('DayName', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('DayOfMonth', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('DayOfWeek', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('DayOfYear', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('Exp', 'numeric_expr', '2', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('Floor', 'numeric_expr', '2', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('FormatDate', 'date_to_format', '1', '需要格式化的日期', '0');
INSERT INTO `parameters` VALUES ('FormatDate', 'pattern', '0', '应用格式', '1');
INSERT INTO `parameters` VALUES ('FormatNumber', 'numeric_to_format', '2', '需要格式化的数值', '0');
INSERT INTO `parameters` VALUES ('FormatNumber', 'pattern', '0', '应用格式', '1');
INSERT INTO `parameters` VALUES ('IsBoolean', 'object_expr', '4', '任意类型的表达式', '0');
INSERT INTO `parameters` VALUES ('IsDate', 'object_expr', '4', '任意类型的表达式', '0');
INSERT INTO `parameters` VALUES ('IsNull', 'object_expr', '4', '任意类型的表达式', '0');
INSERT INTO `parameters` VALUES ('IsNumeric', 'object_expr', '4', '任意类型的表达式', '0');
INSERT INTO `parameters` VALUES ('IsString', 'object_expr', '4', '任意类型的表达式', '0');
INSERT INTO `parameters` VALUES ('Last_Day', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('Left', 'number_of_characters', '2', '从左侧开始提取的字符数', '1');
INSERT INTO `parameters` VALUES ('Left', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('Length', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('Ln', 'numeric_expr', '2', '数值表达式', '1');
INSERT INTO `parameters` VALUES ('Log', 'numeric_expr_1', '2', '底数，数值表达式', '0');
INSERT INTO `parameters` VALUES ('Log', 'numeric_expr_2', '2', '真数，数值表达式', '1');
INSERT INTO `parameters` VALUES ('Log10', 'numeric_expr', '2', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('Lookup', 'lookup_object', 0, '查找对象', 0);
INSERT INTO `parameters` VALUES ('Lookup', 'lookup_object_value', 0, '值，字符串及日期请使用单引号，日期使用yyyy-MM-dd格式', 1);
INSERT INTO `parameters` VALUES ('Lookup', 'return_object', 2, '返回对象', 2);
INSERT INTO `parameters` VALUES ('Lookup', 'sum', 2, '是否汇总，0：不汇总；1：汇总', 3);
INSERT INTO `parameters` VALUES ('Lookup', 'lookup_type', 2, ' 查找类型，0或省略为精确查找，1为模糊查找', 4);
INSERT INTO `parameters` VALUES ('Lower', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('LTrim', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('Max', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('Median', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('Min', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('Month', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('MonthName', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('Percentage', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('Power', 'numeric_expr', '2', '底数，数值表达式', '0');
INSERT INTO `parameters` VALUES ('Power', 'power_numeric', '2', '指数，数值表达式', '1');
INSERT INTO `parameters` VALUES ('Quarter', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('Rank', 'ASC | DESC', '0', '排名方向，升序或者降序，需加单引号，选填', '2');
INSERT INTO `parameters` VALUES ('Rank', 'group_dimension', '0', '分组维度，必须为查询生成，选填', '1');
INSERT INTO `parameters` VALUES ('Rank', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('Replace', 'replace_with', '0', '目标字符串', '2');
INSERT INTO `parameters` VALUES ('Replace', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('Replace', 'string_to_replace', '0', '字符串中要被替换的部分', '1');
INSERT INTO `parameters` VALUES ('Right', 'number_of_characters', '0', '从右侧开始提取的字符数', '1');
INSERT INTO `parameters` VALUES ('Right', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('Round', 'numeric_expr', '2', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('Round', 'scale', '2', '小数位数', '1');
INSERT INTO `parameters` VALUES ('RTrim', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('RunningSum', 'numeric_expr', '1', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('Sign', 'numeric_expr', '2', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('Sin', 'angle_expr', '2', '以弧度为单位的角度表达式', '1');
INSERT INTO `parameters` VALUES ('Sqrt', 'numeric_expr', '2', '数值表达式', '0');
INSERT INTO `parameters` VALUES ('StdDev_Pop', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('StdDev_Samp', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('Substring', 'length', '2', '提取的长度', '2');
INSERT INTO `parameters` VALUES ('Substring', 'start', '2', '开始提取的位置', '1');
INSERT INTO `parameters` VALUES ('Substring', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('Sum', 'measure', '1', '度量', '0');
INSERT INTO `parameters` VALUES ('Tan', 'angle_expr', '2', '以弧度为单位的角度表达式', '0');
INSERT INTO `parameters` VALUES ('Trim', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('Upper', 'string_expr', '0', '字符串表达式', '0');
INSERT INTO `parameters` VALUES ('URLCode', 'html', '0', 'html字符串', '0');
INSERT INTO `parameters` VALUES ('UserResponse', 'prompt', '0', '提示字符串', '0');
INSERT INTO `parameters` VALUES ('Var_Pop', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('Var_Samp', 'measure', '1', '度量，必须为查询生成', '0');
INSERT INTO `parameters` VALUES ('Week', 'date_expr', '1', '日期表达式', '0');
INSERT INTO `parameters` VALUES ('Year', 'date_expr', '1', '日期表达式', '0');

-- ----------------------------
-- Table structure for planets
-- ----------------------------
DROP TABLE IF EXISTS `planets`;
CREATE TABLE `planets` (
  `planet_id` int(11) NOT NULL,
  `planet_code` varchar(32) NOT NULL,
  `planet_name` varchar(32) NOT NULL,
  `have_map` int(11) NOT NULL DEFAULT '1',
  `have_child_map` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`planet_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of planets
-- ----------------------------
INSERT INTO `planets` VALUES ('1', 'world', '地球', '1', '1');


-- ----------------------------
-- Table structure for provinces
-- ----------------------------
DROP TABLE IF EXISTS `provinces`;
CREATE TABLE `provinces` (
  `province_id` int(11) NOT NULL COMMENT '省份id',
  `province_code` varchar(32) NOT NULL COMMENT '省份编码',
  `province_name` varchar(32) NOT NULL COMMENT '省份名称',
  `country_id` int(11) NOT NULL COMMENT '国家ID',
  `have_map` int(11) NOT NULL DEFAULT '1',
  `have_child_map` int(11) NOT NULL DEFAULT '1',
  `longitude` varchar(16) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(16) DEFAULT NULL COMMENT '纬度',
  PRIMARY KEY (`province_id`),
  UNIQUE KEY `uk_provinceCode` (`province_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of provinces
-- ----------------------------
INSERT INTO `provinces` VALUES ('1', '110000', '北京市', '1', '1', '0', '116.405285', '39.904989');
INSERT INTO `provinces` VALUES ('2', '120000', '天津市', '1', '1', '0', '117.190182', '39.125596');
INSERT INTO `provinces` VALUES ('3', '130000', '河北省', '1', '1', '1', '114.502461', '38.045474');
INSERT INTO `provinces` VALUES ('4', '140000', '山西省', '1', '1', '1', '112.549248', '37.857014');
INSERT INTO `provinces` VALUES ('5', '150000', '内蒙古自治区', '1', '1', '1', '111.670801', '40.818311');
INSERT INTO `provinces` VALUES ('6', '210000', '辽宁省', '1', '1', '1', '123.429096', '41.796767');
INSERT INTO `provinces` VALUES ('7', '220000', '吉林省', '1', '1', '1', '125.3245', '43.886841');
INSERT INTO `provinces` VALUES ('8', '230000', '黑龙江省', '1', '1', '1', '126.642464', '45.756967');
INSERT INTO `provinces` VALUES ('9', '310000', '上海市', '1', '1', '0', '121.472644', '31.231706');
INSERT INTO `provinces` VALUES ('10', '320000', '江苏省', '1', '1', '1', '118.767413', '32.041544');
INSERT INTO `provinces` VALUES ('11', '330000', '浙江省', '1', '1', '1', '120.153576', '30.287459');
INSERT INTO `provinces` VALUES ('12', '340000', '安徽省', '1', '1', '1', '117.283042', '31.86119');
INSERT INTO `provinces` VALUES ('13', '350000', '福建省', '1', '1', '1', '119.306239', '26.075302');
INSERT INTO `provinces` VALUES ('14', '360000', '江西省', '1', '1', '1', '115.892151', '28.676493');
INSERT INTO `provinces` VALUES ('15', '370000', '山东省', '1', '1', '1', '117.000923', '36.675807');
INSERT INTO `provinces` VALUES ('16', '410000', '河南省', '1', '1', '1', '113.665412', '34.757975');
INSERT INTO `provinces` VALUES ('17', '420000', '湖北省', '1', '1', '1', '114.298572', '30.584355');
INSERT INTO `provinces` VALUES ('18', '430000', '湖南省', '1', '1', '1', '112.982279', '28.19409');
INSERT INTO `provinces` VALUES ('19', '440000', '广东省', '1', '1', '1', '113.280637', '23.125178');
INSERT INTO `provinces` VALUES ('20', '450000', '广西壮族自治区', '1', '1', '1', '108.320004', '22.82402');
INSERT INTO `provinces` VALUES ('21', '460000', '海南省', '1', '1', '1', '110.33119', '20.031971');
INSERT INTO `provinces` VALUES ('22', '500000', '重庆市', '1', '1', '0', '106.504962', '29.533155');
INSERT INTO `provinces` VALUES ('23', '510000', '四川省', '1', '1', '1', '104.065735', '30.659462');
INSERT INTO `provinces` VALUES ('24', '520000', '贵州省', '1', '1', '1', '106.713478', '26.578343');
INSERT INTO `provinces` VALUES ('25', '530000', '云南省', '1', '1', '1', '102.712251', '25.040609');
INSERT INTO `provinces` VALUES ('26', '540000', '西藏自治区', '1', '1', '1', '91.132212', '29.660361');
INSERT INTO `provinces` VALUES ('27', '610000', '陕西省', '1', '1', '1', '108.948024', '34.263161');
INSERT INTO `provinces` VALUES ('28', '620000', '甘肃省', '1', '1', '1', '103.823557', '36.058039');
INSERT INTO `provinces` VALUES ('29', '630000', '青海省', '1', '1', '1', '101.778916', '36.623178');
INSERT INTO `provinces` VALUES ('30', '640000', '宁夏回族自治区', '1', '1', '1', '106.278179', '38.46637');
INSERT INTO `provinces` VALUES ('31', '650000', '新疆维吾尔自治区', '1', '1', '1', '87.617733', '43.792818');
INSERT INTO `provinces` VALUES ('32', '710000', '台湾省', '1', '1', '1', null, null);
INSERT INTO `provinces` VALUES ('33', '810000', '香港特别行政区', '1', '1', '1', '114.173355', '22.320048');
INSERT INTO `provinces` VALUES ('34', '820000', '澳门特别行政区', '1', '1', '1', '113.54909', '22.198951');

-- ----------------------------
-- Table structure for qor_apply_groups
-- ----------------------------
DROP TABLE IF EXISTS `qor_apply_groups`;
CREATE TABLE `qor_apply_groups` (
  `qor_apply_group_id` varchar(36) NOT NULL,
  `query_object_restriction_id` varchar(36) NOT NULL,
  `apply_group_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`qor_apply_group_id`),
  UNIQUE KEY `uk_qorApplyGroup` (`query_object_restriction_id`,`apply_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qor_apply_groups
-- ----------------------------

-- ----------------------------
-- Table structure for qor_apply_users
-- ----------------------------
DROP TABLE IF EXISTS `qor_apply_users`;
CREATE TABLE `qor_apply_users` (
  `qor_apply_user_id` varchar(36) NOT NULL,
  `query_object_restriction_id` varchar(36) NOT NULL,
  `apply_user_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`qor_apply_user_id`),
  UNIQUE KEY `uk_qorApplyUser` (`query_object_restriction_id`,`apply_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qor_apply_users
-- ----------------------------

-- ----------------------------
-- Table structure for qor_values
-- ----------------------------
DROP TABLE IF EXISTS `qor_values`;
CREATE TABLE `qor_values` (
  `qor_value_id` varchar(36) NOT NULL,
  `query_object_restriction_id` varchar(36) NOT NULL,
  `restriction_value` varchar(256) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`qor_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of qor_values
-- ----------------------------

-- ----------------------------
-- Table structure for query_object_restrictions
-- ----------------------------
DROP TABLE IF EXISTS `query_object_restrictions`;
CREATE TABLE `query_object_restrictions` (
  `query_object_restriction_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `business_model_type` int(11) NOT NULL DEFAULT '0',
  `business_model_id` varchar(36) NOT NULL,
  `business_object_id` varchar(36) NOT NULL,
  `operation` int(11) NOT NULL,
  PRIMARY KEY (`query_object_restriction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Records of query_object_restrictions
-- ----------------------------

-- ----------------------------
-- Table structure for reports
-- ----------------------------
DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `report_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `report_name` varchar(128) NOT NULL,
  `folder_id` varchar(36) NOT NULL,
  `create_source` int(11) NOT NULL COMMENT '创建来源：1—iFind，自助分析；0—iReport，组织报表',
  `thumbnail` varchar(256) DEFAULT NULL COMMENT '缩略图',
  `source_type` int(11) NOT NULL DEFAULT 0 COMMENT '来源类型；0本组织创建，1从其它组织订阅',
  `source_report_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源业务模型ID，本组织创建为本组织业务模型ID',
  `source_organization_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源组织，本组织创建为本组织ID',
  `publish_status` int(11) NOT NULL DEFAULT 0 COMMENT '-1：订阅；0：未发布；1：已发布；2：发布且停止',
  `create_user_id` varchar(36) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` timestamp NULL DEFAULT NULL COMMENT '由于上传缩略图不更新修改时间，所有不能根据当前时间戳更新',
  PRIMARY KEY (`report_id`,`organization_id`),
  UNIQUE KEY `uk_report` (`organization_id`,`report_name`,`folder_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='报表记录';

-- ----------------------------
-- Records of reports
-- ----------------------------

-- ----------------------------
-- Table structure for report_jsons
-- ----------------------------
DROP TABLE IF EXISTS `report_jsons`;
CREATE TABLE `report_jsons` (
  `report_id` varchar(36) NOT NULL,
  `report_design_json` longtext,
  `report_view_json` longtext,
  `report_settings_json` text,
  PRIMARY KEY (`report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for report_folders
-- ----------------------------
DROP TABLE IF EXISTS `report_folders`;
CREATE TABLE `report_folders` (
  `folder_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `folder_name` varchar(128) NOT NULL,
  `folder_parent_id` varchar(36) NOT NULL,
  `create_user_id` varchar(36) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`folder_id`),
  UNIQUE KEY `unique_key` (`organization_id`,`folder_name`,`folder_parent_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of report_folders
-- ----------------------------

-- ----------------------------
-- Table structure for report_images
-- ----------------------------
DROP TABLE IF EXISTS `report_images`;
CREATE TABLE `report_images` (
  `image_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `image_url` varchar(128) NOT NULL,
  `image_name` varchar(36) DEFAULT NULL,
  `create_user_id` varchar(36) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for report_query_logs
-- ----------------------------
DROP TABLE IF EXISTS `report_query_logs`;
CREATE TABLE `report_query_logs` (
  `log_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `user_id` varchar(36) NOT NULL,
  `device_type_id` int(11) NOT NULL COMMENT '设备类型ID',
  `os_id` int(11) NOT NULL COMMENT '操作系统类型',
  `report_id` varchar(36) DEFAULT NULL,
  `status_code` int(11) DEFAULT NULL,
  `message` varchar(10240) DEFAULT NULL,
  `access_start_date` datetime(3) NOT NULL DEFAULT '2018-01-01 00:00:00.000',
  `access_end_date` datetime(3) NOT NULL DEFAULT '2018-01-01 00:00:00.000',
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of report_query_logs
-- ----------------------------

-- ----------------------------
-- Table structure for report_visibilities
-- ----------------------------
DROP TABLE IF EXISTS `report_visibilities`;
CREATE TABLE `report_visibilities` (
  `report_id` varchar(36) CHARACTER SET utf8 NOT NULL,
  `organization_id` varchar(36) CHARACTER SET utf8 NOT NULL,
  `device_type_id` int(11) NOT NULL,
  PRIMARY KEY (`report_id`,`device_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_icelandic_ci;

-- ----------------------------
-- Records of report_visibilities
-- ----------------------------

DROP TABLE IF EXISTS `report_publishes`;
CREATE TABLE `report_publishes`  (
  `report_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报表ID',
  `organization_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '组织ID',
  `publish_type` int(11) NOT NULL COMMENT '发布类型；0所有组织可订阅，1指定可订阅组织',
  `publish_status` int(11) NOT NULL COMMENT '-1：订阅；0：未发布；1：已发布；2：发布且停止',
  `create_user_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `create_date` datetime(0) NOT NULL,
  `last_modify_user_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `last_modify_date` datetime(0) NULL DEFAULT NULL,
  PRIMARY KEY (`report_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


DROP TABLE IF EXISTS `rp_destination_organizations`;
CREATE TABLE `rp_destination_organizations`  (
  `report_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报表ID',
  `destination_organization_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模型发布目标组织ID',
  PRIMARY KEY (`report_id`, `destination_organization_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;


-- ----------------------------
-- Table structure for shares
-- ----------------------------
DROP TABLE IF EXISTS `shares`;
CREATE TABLE `shares` (
  `share_ID` varchar(36) NOT NULL,
  `report_ID` varchar(36) NOT NULL,
  `user_ID` varchar(36) NOT NULL,
  `share_Type` int(11) NOT NULL,
  `share_Date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '分享时间',
  PRIMARY KEY (`share_ID`),
  UNIQUE KEY `uk_share` (`report_ID`,`user_ID`,`share_Date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='报表评论记录表';

-- ----------------------------
-- Records of shares
-- ----------------------------

-- ----------------------------
-- Table structure for sql_models
-- ----------------------------
DROP TABLE IF EXISTS `sql_models`;
CREATE TABLE `sql_models` (
  `business_model_id` varchar(36) NOT NULL,
  `sql_text` text NOT NULL,
  `business_objects_json` longtext,
  PRIMARY KEY (`business_model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sql_models
-- ----------------------------

DROP TABLE IF EXISTS `stored_procedure_models`;
CREATE TABLE `stored_procedure_models`  (
  `business_model_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `stored_procedure_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '存储过程名称',
  `business_objects_json` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`business_model_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for system_settings
-- ----------------------------
DROP TABLE IF EXISTS `system_settings`;
CREATE TABLE `system_settings` (
  `system_setting_key` varchar(64) NOT NULL,
  `system_setting_value` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`system_setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of system_settings
-- ----------------------------
INSERT INTO `system_settings` VALUES ('autoPublishToSuperior', '1');
INSERT INTO `system_settings` VALUES ('reportURL', 'report_front_end/jsp/report.jsp');
INSERT INTO `system_settings` VALUES ('selfAnalysisURL', 'app/selfAnalysis/selfAnalysis.jsp');
INSERT INTO `system_settings` VALUES ('selfAnalysisURLforPC', 'app/selfAnalysis/selfAnalysisPC.jsp');
INSERT INTO `system_settings` VALUES ('cloudReportTemplateURL', 'http://sales.yunzhisuan.com/SalesManagement');
INSERT INTO `system_settings` VALUES ('cloudPackageURL', 'http://sales.yunzhisuan.com/SalesManagement');

-- ----------------------------
-- Table structure for system_versions
-- ----------------------------
DROP TABLE IF EXISTS `system_versions`;
CREATE TABLE `system_versions` (
  `module_id` int(11) NOT NULL,
  `device_type_id` int(11) NOT NULL,
  `os_id` int(11) NOT NULL,
  `version` varchar(16) NOT NULL,
  `update_content` varchar(256) DEFAULT NULL,
  `package_path` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`module_id`,`device_type_id`,`os_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of system_versions
-- ----------------------------
INSERT INTO `system_versions` VALUES ('0', '0', '1', '3.0.8', '检测到云智算新的版本，您需要更新至最新版本才可继续使用。', '');
INSERT INTO `system_versions` VALUES ('0', '0', '2', '3.0.6', '检测到云智算新的版本，您需要更新至最新版本才可继续使用。您轻触“确定”系统将直接从云智算官网下载更新；如果更新失败，请您直接到应用市场进行更新。', 'http://www.yunzhisuan.com/download/Client/android/yunzhisuan_3.0.6.apk');
INSERT INTO `system_versions` VALUES ('0', '1', '1', '3.0.8', '检测到云智算新的版本，您需要更新至最新版本才可继续使用。', '');
INSERT INTO `system_versions` VALUES ('0', '1', '2', '3.0.6', '检测到云智算新的版本，您需要更新至最新版本才可继续使用。您轻触“确定”系统将直接从云智算官网下载更新；如果更新失败，请您直接到应用市场进行更新。', 'http://www.yunzhisuan.com/download/Client/android/yunzhisuan_3.0.6.apk');
INSERT INTO `system_versions` VALUES ('0', '2', '1', '2.2.1', '检测到云智算新的版本，您需要更新至最新版本才可继续使用。', '');
INSERT INTO `system_versions` VALUES ('1', '2', '0', '3.5.1.0510', '修复一些已知问题，提升用户体验。', 'app/client/Yunzhisuan%20Windows%20Client.zip');

-- ----------------------------
-- Table structure for table_models
-- ----------------------------
DROP TABLE IF EXISTS `table_models`;
CREATE TABLE `table_models` (
  `business_model_id` varchar(36) NOT NULL,
  `schema_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `table_name` varchar(64) NOT NULL,
  `business_objects_json` longtext,
  PRIMARY KEY (`business_model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of table_models
-- ----------------------------

DROP TABLE IF EXISTS `tenants`;
CREATE TABLE `tenants`  (
  `tenant_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `tenant_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `tenant_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `tenant_short_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tp_tenant_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tp_tenant_code` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tp_tenant_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tp_tenant_short_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`tenant_id`) USING BTREE,
  UNIQUE INDEX `uk_tenant_code`(`tenant_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for topics
-- ----------------------------
DROP TABLE IF EXISTS `topics`;
CREATE TABLE `topics` (
  `topic_id` varchar(36) NOT NULL,
  `topic_name` varchar(64) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`topic_id`),
  UNIQUE KEY `unique_key` (`topic_name`,`organization_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of topics
-- ----------------------------

-- ----------------------------
-- Table structure for transform_logs
-- ----------------------------
DROP TABLE IF EXISTS `transform_logs`;
CREATE TABLE `transform_logs` (
  `transform_log_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `transform_id` varchar(36) NOT NULL,
  `start_date` datetime(3) NOT NULL,
  `end_date` datetime(3) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '状态：0：失败；1：成功',
  `message` text,
  PRIMARY KEY (`transform_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for transforms
-- ----------------------------
DROP TABLE IF EXISTS `transforms`;
CREATE TABLE `transforms` (
  `transform_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `transform_name` varchar(32) NOT NULL,
  `transform_type` int(11) NOT NULL DEFAULT '0' COMMENT '转换类型：0：维表；1：事实表',
  `target_table` varchar(32) NOT NULL,
  `target_table_description` varchar(64) DEFAULT NULL,
  `source_table` varchar(64) NOT NULL,
  `source_table_description` varchar(64) DEFAULT NULL,
  `transform_logic_type` int(11) NOT NULL DEFAULT '0',
  `transform_logic` text,
  `preseted` tinyint(11) NOT NULL DEFAULT '0',
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  `last_execute_date` datetime DEFAULT NULL,
  `create_user_id` varchar(36) NOT NULL,
  `create_date` datetime NOT NULL,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`transform_id`),
  UNIQUE KEY `uk_transform_name` (`organization_id`,`transform_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for upload_excel_logs
-- ----------------------------
DROP TABLE IF EXISTS `upload_excel_logs`;
CREATE TABLE `upload_excel_logs` (
  `upload_excel_log_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `template_id` varchar(36) NOT NULL,
  `start_date` datetime(3) NOT NULL,
  `end_date` datetime(3) NOT NULL,
  `message` text,
  `upload_user_ID` varchar(36) NOT NULL,
  PRIMARY KEY (`upload_excel_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for upload_excel_templates
-- ----------------------------
DROP TABLE IF EXISTS `upload_excel_templates`;
CREATE TABLE `upload_excel_templates` (
  `template_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  `template_name` varchar(64) NOT NULL,
  `template_url` varchar(128) DEFAULT NULL,
  `excel_file_name` varchar(64) NOT NULL,
  `sheet_name` varchar(64) NOT NULL,
  `range_type` int(11) NOT NULL DEFAULT '0' COMMENT '取值范围类型；0：全部，1：自定义',
  `range` varchar(16) DEFAULT NULL,
  `columns_json` longtext NOT NULL,
  `target_table` varchar(64) NOT NULL,
  `upload_method` int(11) NOT NULL DEFAULT '0',
  `mappings_json` longtext NOT NULL,
  `identity_json` longtext NOT NULL,
  `create_user_id` varchar(36) NOT NULL,
  `create_date` datetime NOT NULL,
  `last_modify_user_id` varchar(36) DEFAULT NULL,
  `last_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `uk_template_name` (`organization_id`,`template_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for user_business_models
-- ----------------------------
DROP TABLE IF EXISTS `user_business_models`;
CREATE TABLE `user_business_models` (
  `user_id` varchar(36) NOT NULL,
  `business_model_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`user_id`,`business_model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for user_data_sources
-- ----------------------------
DROP TABLE IF EXISTS `user_data_sources`;
CREATE TABLE `user_data_sources` (
  `user_id` varchar(36) NOT NULL,
  `data_source_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`user_id`,`data_source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` varchar(36) NOT NULL COMMENT '用户GUID',
  `user_name` varchar(32) NOT NULL COMMENT '默认账号。当用户本人注册时为其注册时使用的手机号或邮箱地址；若管理员新增，则手机号不为空为手机号，否则为邮箱地址',
  `register_method` int(11) NOT NULL DEFAULT '2' COMMENT '注册方式：0、手机注册，1、邮箱注册，2、管理员新增',
  `mobile_number` varchar(16) DEFAULT NULL COMMENT '手机号',
  `email_address` varchar(32) DEFAULT NULL COMMENT '邮箱地址',
  `full_name` varchar(32) NOT NULL COMMENT '全名',
  `password` varchar(64) NOT NULL COMMENT '密码',
  `portrait` varchar(128) DEFAULT NULL COMMENT '头像URL',
  `default_organization_id` varchar(36) NOT NULL COMMENT '缺省登录组织GUID',
  `user_forbidden` int(11) NOT NULL DEFAULT '0',
  `deleted` int(11) NOT NULL DEFAULT '0',
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_modify_date` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `tp_user_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方用户ID',
  `tp_user_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方用户名',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `uk_userName` (`user_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', 'Administrator', '2', '', '', 'Administrator', 'fEqNCco3Yq9h5ZUglD3CZJT4lBs=', '', '1', '0','0', NOW(), NOW(),'','');

-- ----------------------------
-- Table structure for user_modules
-- ----------------------------
DROP TABLE IF EXISTS `user_modules`;
CREATE TABLE `user_modules` (
  `user_id` varchar(36) NOT NULL,
  `module_id` int(11) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`user_id`,`module_id`,`organization_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of user_modules
-- ----------------------------
INSERT INTO `user_modules` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '0', '1');
INSERT INTO `user_modules` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '1', '1');
INSERT INTO `user_modules` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '2', '1');
INSERT INTO `user_modules` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '3', '1');
INSERT INTO `user_modules` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '4', '1');
-- ----------------------------
-- Table structure for user_reports
-- ----------------------------
DROP TABLE IF EXISTS `user_reports`;
CREATE TABLE `user_reports` (
  `user_id` varchar(36) NOT NULL,
  `report_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`user_id`,`report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of user_reports
-- ----------------------------

-- ----------------------------
-- Table structure for user_themes
-- ----------------------------
DROP TABLE IF EXISTS `user_themes`;
CREATE TABLE `user_themes` (
  `user_id` varchar(36) NOT NULL,
  `device_type_id` int(11) NOT NULL,
  `theme_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`device_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of user_themes
-- ----------------------------
INSERT INTO `user_themes` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '0', '0');
INSERT INTO `user_themes` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '1', '0');
INSERT INTO `user_themes` VALUES ('8fec7b24-2c45-11e8-ae15-00ff2cff3a7d', '2', '0');

-- ----------------------------
-- Table structure for user_upload_excel_templates
-- ----------------------------
DROP TABLE IF EXISTS `user_upload_excel_templates`;
CREATE TABLE `user_upload_excel_templates` (
  `user_id` varchar(36) NOT NULL,
  `template_id` varchar(36) NOT NULL,
  `organization_id` varchar(36) NOT NULL,
  PRIMARY KEY (`user_id`,`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for web_open_clients
-- ----------------------------
DROP TABLE IF EXISTS `web_open_clients`;
CREATE TABLE `web_open_clients` (
  `id` varchar(36) NOT NULL,
  `token` varchar(512) NOT NULL,
  `web_guid` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of web_open_clients
-- ----------------------------

-- ----------------------------
-- Table structure for platform_users
-- ----------------------------
DROP TABLE IF EXISTS `platform_users`;
CREATE TABLE `platform_users`  (
  `user_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户名',
  `password` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '密码',
  PRIMARY KEY (`user_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of platform_users
-- ----------------------------
INSERT INTO `platform_users` VALUES ('System', 'fEqNCco3Yq9h5ZUglD3CZJT4lBs=');


delimiter $$ 
drop function if exists get_child_organization_ids$$ 
create function get_child_organization_ids(in_id varchar(36)) returns text 
begin 
 declare ids text default ''; 
 declare tempids text; 
 
 set tempids = in_id; 
 while tempids is not null do 
	If in_id <> tempids then
		set ids = CONCAT_WS(',',ids,tempids); 
	end if;
  select GROUP_CONCAT(organization_id) into tempids from organizations where FIND_IN_SET(organization_parent_id,tempids)>0;  
 end while; 
 return ids; 
end  
$$ 
delimiter ;
